/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TemporalConverter;
import org.eclipse.jpt.jpa.core.context.TemporalType;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkIdMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkMutable;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkConvertAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkMutableAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkJavaIdMappingTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithIdMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvert() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "org.eclipse.persistence.annotations.Convert"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@Convert(\"class-instance\")").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithMutableId() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "org.eclipse.persistence.annotations.Mutable"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@Mutable").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithMutableIdDate() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "org.eclipse.persistence.annotations.Mutable", "java.util.Date"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("    @Mutable").append(CR);
                sb.append("    private Date myDate;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    public EclipseLinkJavaIdMappingTests(String name) {
        super(name);
    }

    public void testGetConvert() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation("org.eclipse.persistence.annotations.Convert");
        this.getJpaProject().synchronizeContextModel();
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        EclipseLinkJavaIdMappingTests.assertEquals(EclipseLinkConvert.class, (Object)idMapping.getConverter().getType());
    }

    public void testGetConvert2() throws Exception {
        this.createTestEntityWithConvert();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        EclipseLinkJavaIdMappingTests.assertEquals(EclipseLinkConvert.class, (Object)idMapping.getConverter().getType());
        EclipseLinkJavaIdMappingTests.assertEquals((String)"class-instance", (String)((EclipseLinkConvert)idMapping.getConverter()).getConverterName());
    }

    public void testSetConvert() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        EclipseLinkJavaIdMappingTests.assertNull((Object)idMapping.getConverter().getType());
        idMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(TemporalType.TIME);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        TemporalAnnotation temporal = (TemporalAnnotation)attributeResource.getAnnotation("javax.persistence.Temporal");
        EclipseLinkJavaIdMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.java.TemporalType.TIME, (Object)temporal.getValue());
        idMapping.setConverter(null);
        EclipseLinkJavaIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Temporal"));
    }

    public void testGetConvertUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        IdMapping idMapping = (IdMapping)persistentAttribute.getMapping();
        EclipseLinkJavaIdMappingTests.assertNull((Object)idMapping.getConverter().getType());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkConvertAnnotation convert = (EclipseLinkConvertAnnotation)attributeResource.addAnnotation("org.eclipse.persistence.annotations.Convert");
        convert.setValue("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaIdMappingTests.assertEquals(EclipseLinkConvert.class, (Object)idMapping.getConverter().getType());
        EclipseLinkJavaIdMappingTests.assertEquals((String)"foo", (String)((EclipseLinkConvert)idMapping.getConverter()).getConverterName());
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.Convert");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaIdMappingTests.assertNull((Object)idMapping.getConverter().getType());
        EclipseLinkJavaIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        EclipseLinkJavaIdMappingTests.assertSame((Object)idMapping, (Object)persistentAttribute.getMapping());
    }

    public void testGetSpecifiedMutable() throws Exception {
        this.createTestEntityWithMutableId();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkIdMapping idMapping = (EclipseLinkIdMapping)persistentAttribute.getMapping();
        EclipseLinkMutable mutable = idMapping.getMutable();
        EclipseLinkJavaIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkMutableAnnotation mutableAnnotation = (EclipseLinkMutableAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        mutableAnnotation.setValue(Boolean.TRUE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        mutableAnnotation.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        mutableAnnotation.setValue(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaIdMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mutable.getSpecifiedMutable());
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.Mutable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaIdMappingTests.assertEquals(null, (Object)mutable.getSpecifiedMutable());
        attributeResource.addAnnotation("org.eclipse.persistence.annotations.Mutable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
    }

    public void testSetSpecifiedMutable() throws Exception {
        this.createTestEntityWithMutableId();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkIdMapping idMapping = (EclipseLinkIdMapping)persistentAttribute.getMapping();
        EclipseLinkMutable mutable = idMapping.getMutable();
        EclipseLinkJavaIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutable.getSpecifiedMutable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        EclipseLinkMutableAnnotation mutableAnnotation = (EclipseLinkMutableAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaIdMappingTests.assertEquals(null, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaIdMappingTests.assertEquals(null, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(null);
        mutableAnnotation = (EclipseLinkMutableAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaIdMappingTests.assertEquals(null, (Object)mutableAnnotation);
        mutable.setSpecifiedMutable(Boolean.FALSE);
        mutableAnnotation = (EclipseLinkMutableAnnotation)attributeResource.getAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaIdMappingTests.assertEquals((Object)Boolean.FALSE, (Object)mutableAnnotation.getValue());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)mutableAnnotation.getValue());
    }

    public void testIsDefaultMutable() throws Exception {
        this.createTestEntityWithMutableId();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkIdMapping idMapping = (EclipseLinkIdMapping)persistentAttribute.getMapping();
        EclipseLinkMutable mutable = idMapping.getMutable();
        EclipseLinkJavaIdMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaIdMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        mutable.setSpecifiedMutable(Boolean.FALSE);
        EclipseLinkJavaIdMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(Boolean.FALSE);
        EclipseLinkJavaIdMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
    }

    public void testIsDefaultMutableForDate() throws Exception {
        this.createTestEntityWithMutableIdDate();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkIdMapping idMapping = (EclipseLinkIdMapping)persistentAttribute.getMapping();
        EclipseLinkMutable mutable = idMapping.getMutable();
        EclipseLinkJavaIdMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaIdMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaIdMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(Boolean.TRUE);
        EclipseLinkJavaIdMappingTests.assertTrue((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(Boolean.FALSE);
        EclipseLinkJavaIdMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(null);
        EclipseLinkJavaIdMappingTests.assertFalse((boolean)mutable.isDefaultMutable());
    }

    public void testIsMutable() throws Exception {
        this.createTestEntityWithMutableId();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EclipseLinkIdMapping idMapping = (EclipseLinkIdMapping)persistentAttribute.getMapping();
        EclipseLinkMutable mutable = idMapping.getMutable();
        EclipseLinkJavaIdMappingTests.assertTrue((boolean)mutable.isMutable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.removeAnnotation("org.eclipse.persistence.annotations.Mutable");
        EclipseLinkJavaIdMappingTests.assertTrue((boolean)mutable.isMutable());
        mutable.setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkJavaIdMappingTests.assertTrue((boolean)mutable.isMutable());
    }
}

