/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaIdMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmIdMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkBasicMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkIdMapping;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkIdMapping;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlId;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;

public class EclipseLinkOrmIdMappingTests
extends EclipseLinkOrmContextModelTestCase {
    public EclipseLinkOrmIdMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityWithIdMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithMutableIdDate() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "mutable", "java.util.Date"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("    @Mutable").append(CR);
                sb.append("    private Date myDate;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    public void testUpdateMutable() throws Exception {
        this.createTestEntityWithIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "id");
        OrmEclipseLinkIdMapping contextId = (OrmEclipseLinkIdMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlId resourceId = (XmlId)resourceEntity.getAttributes().getIds().get(0);
        EclipseLinkIdMapping javaIdMapping = (EclipseLinkIdMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmIdMappingTests.assertNull((Object)resourceId.getMutable());
        EclipseLinkOrmIdMappingTests.assertTrue((boolean)contextId.getMutable().isDefaultMutable());
        EclipseLinkOrmIdMappingTests.assertNull((Object)contextId.getMutable().getSpecifiedMutable());
        EclipseLinkOrmIdMappingTests.assertTrue((boolean)contextId.getMutable().isMutable());
        resourceId.setMutable(Boolean.FALSE);
        EclipseLinkOrmIdMappingTests.assertEquals((Object)Boolean.FALSE, (Object)resourceId.getMutable());
        EclipseLinkOrmIdMappingTests.assertTrue((boolean)contextId.getMutable().isDefaultMutable());
        EclipseLinkOrmIdMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextId.getMutable().getSpecifiedMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)contextId.getMutable().isMutable());
        resourceId.setMutable(Boolean.TRUE);
        EclipseLinkOrmIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceId.getMutable());
        EclipseLinkOrmIdMappingTests.assertTrue((boolean)contextId.getMutable().isDefaultMutable());
        EclipseLinkOrmIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextId.getMutable().getSpecifiedMutable());
        EclipseLinkOrmIdMappingTests.assertTrue((boolean)contextId.getMutable().isMutable());
        resourceId.setMutable(null);
        EclipseLinkOrmIdMappingTests.assertNull((Object)resourceId.getMutable());
        EclipseLinkOrmIdMappingTests.assertTrue((boolean)contextId.getMutable().isDefaultMutable());
        EclipseLinkOrmIdMappingTests.assertNull((Object)contextId.getMutable().getSpecifiedMutable());
        EclipseLinkOrmIdMappingTests.assertTrue((boolean)contextId.getMutable().isMutable());
        javaIdMapping.getMutable().setSpecifiedMutable(Boolean.FALSE);
        EclipseLinkOrmIdMappingTests.assertNull((Object)resourceId.getMutable());
        EclipseLinkOrmIdMappingTests.assertTrue((boolean)contextId.getMutable().isDefaultMutable());
        EclipseLinkOrmIdMappingTests.assertNull((Object)contextId.getMutable().getSpecifiedMutable());
        EclipseLinkOrmIdMappingTests.assertTrue((boolean)contextId.getMutable().isMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)javaIdMapping.getMutable().isMutable());
        ormPersistentAttribute.convertToVirtual();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("id");
        EclipseLinkIdMapping virtualIdMapping = (EclipseLinkIdMapping)ormPersistentAttribute2.getMapping();
        EclipseLinkOrmIdMappingTests.assertNull((Object)resourceId.getMutable());
        EclipseLinkOrmIdMappingTests.assertTrue((boolean)virtualIdMapping.getMutable().isDefaultMutable());
        EclipseLinkOrmIdMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualIdMapping.getMutable().getSpecifiedMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)virtualIdMapping.getMutable().isMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)javaIdMapping.getMutable().isMutable());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("id");
        EclipseLinkBasicMapping virtualBasicMapping = (EclipseLinkBasicMapping)ormPersistentAttribute2.getMapping();
        EclipseLinkOrmIdMappingTests.assertNull((Object)resourceId.getMutable());
        EclipseLinkOrmIdMappingTests.assertTrue((boolean)virtualBasicMapping.getMutable().isDefaultMutable());
        EclipseLinkOrmIdMappingTests.assertNull((Object)virtualBasicMapping.getMutable().getSpecifiedMutable());
        EclipseLinkOrmIdMappingTests.assertTrue((boolean)virtualBasicMapping.getMutable().isMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)javaIdMapping.getMutable().isMutable());
    }

    public void testUpdateMutableDate() throws Exception {
        this.createTestEntityWithMutableIdDate();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "myDate");
        OrmEclipseLinkIdMapping contextId = (OrmEclipseLinkIdMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlId resourceId = (XmlId)resourceEntity.getAttributes().getIds().get(0);
        EclipseLinkIdMapping javaIdMapping = (EclipseLinkIdMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("myDate").getMapping();
        EclipseLinkOrmIdMappingTests.assertNull((Object)resourceId.getMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)contextId.getMutable().isDefaultMutable());
        EclipseLinkOrmIdMappingTests.assertNull((Object)contextId.getMutable().getSpecifiedMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)contextId.getMutable().isMutable());
        resourceId.setMutable(Boolean.FALSE);
        EclipseLinkOrmIdMappingTests.assertEquals((Object)Boolean.FALSE, (Object)resourceId.getMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)contextId.getMutable().isDefaultMutable());
        EclipseLinkOrmIdMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextId.getMutable().getSpecifiedMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)contextId.getMutable().isMutable());
        resourceId.setMutable(Boolean.TRUE);
        EclipseLinkOrmIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceId.getMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)contextId.getMutable().isDefaultMutable());
        EclipseLinkOrmIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextId.getMutable().getSpecifiedMutable());
        EclipseLinkOrmIdMappingTests.assertTrue((boolean)contextId.getMutable().isMutable());
        resourceId.setMutable(null);
        EclipseLinkOrmIdMappingTests.assertNull((Object)resourceId.getMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)contextId.getMutable().isDefaultMutable());
        EclipseLinkOrmIdMappingTests.assertNull((Object)contextId.getMutable().getSpecifiedMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)contextId.getMutable().isMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(Boolean.TRUE);
        EclipseLinkOrmIdMappingTests.assertNull((Object)resourceId.getMutable());
        EclipseLinkOrmIdMappingTests.assertTrue((boolean)contextId.getMutable().isDefaultMutable());
        EclipseLinkOrmIdMappingTests.assertNull((Object)contextId.getMutable().getSpecifiedMutable());
        EclipseLinkOrmIdMappingTests.assertTrue((boolean)contextId.getMutable().isMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(Boolean.FALSE);
        EclipseLinkOrmIdMappingTests.assertNull((Object)resourceId.getMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)contextId.getMutable().isDefaultMutable());
        EclipseLinkOrmIdMappingTests.assertNull((Object)contextId.getMutable().getSpecifiedMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)contextId.getMutable().isMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(null);
        EclipseLinkOrmIdMappingTests.assertNull((Object)resourceId.getMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)contextId.getMutable().isDefaultMutable());
        EclipseLinkOrmIdMappingTests.assertNull((Object)contextId.getMutable().getSpecifiedMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)contextId.getMutable().isMutable());
        javaIdMapping.getMutable().setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkOrmIdMappingTests.assertNull((Object)resourceId.getMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)contextId.getMutable().isDefaultMutable());
        EclipseLinkOrmIdMappingTests.assertNull((Object)contextId.getMutable().getSpecifiedMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)contextId.getMutable().isMutable());
        EclipseLinkOrmIdMappingTests.assertTrue((boolean)javaIdMapping.getMutable().isMutable());
        ormPersistentAttribute.convertToVirtual();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("myDate");
        EclipseLinkIdMapping virtualIdMapping = (EclipseLinkIdMapping)ormPersistentAttribute2.getMapping();
        EclipseLinkOrmIdMappingTests.assertNull((Object)resourceId.getMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)virtualIdMapping.getMutable().isDefaultMutable());
        EclipseLinkOrmIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)virtualIdMapping.getMutable().getSpecifiedMutable());
        EclipseLinkOrmIdMappingTests.assertTrue((boolean)virtualIdMapping.getMutable().isMutable());
        EclipseLinkOrmIdMappingTests.assertTrue((boolean)javaIdMapping.getMutable().isMutable());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("myDate");
        EclipseLinkBasicMapping virtualBasicMapping = (EclipseLinkBasicMapping)ormPersistentAttribute2.getMapping();
        EclipseLinkOrmIdMappingTests.assertNull((Object)resourceId.getMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)virtualBasicMapping.getMutable().isDefaultMutable());
        EclipseLinkOrmIdMappingTests.assertNull((Object)virtualBasicMapping.getMutable().getSpecifiedMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)virtualBasicMapping.getMutable().isMutable());
        EclipseLinkOrmIdMappingTests.assertTrue((boolean)javaIdMapping.getMutable().isMutable());
    }

    public void testModifyMutable() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "basic");
        OrmEclipseLinkIdMapping contextId = (OrmEclipseLinkIdMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlId resourceId = (XmlId)resourceEntity.getAttributes().getIds().get(0);
        EclipseLinkOrmIdMappingTests.assertNull((Object)resourceId.getMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)contextId.getMutable().isDefaultMutable());
        EclipseLinkOrmIdMappingTests.assertNull((Object)contextId.getMutable().getSpecifiedMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)contextId.getMutable().isMutable());
        contextId.getMutable().setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkOrmIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceId.getMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)contextId.getMutable().isDefaultMutable());
        EclipseLinkOrmIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextId.getMutable().getSpecifiedMutable());
        EclipseLinkOrmIdMappingTests.assertTrue((boolean)contextId.getMutable().isMutable());
        contextId.getMutable().setSpecifiedMutable(Boolean.FALSE);
        EclipseLinkOrmIdMappingTests.assertEquals((Object)Boolean.FALSE, (Object)resourceId.getMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)contextId.getMutable().isDefaultMutable());
        EclipseLinkOrmIdMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextId.getMutable().getSpecifiedMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)contextId.getMutable().isMutable());
        contextId.getMutable().setSpecifiedMutable(null);
        EclipseLinkOrmIdMappingTests.assertNull((Object)resourceId.getMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)contextId.getMutable().isDefaultMutable());
        EclipseLinkOrmIdMappingTests.assertNull((Object)contextId.getMutable().getSpecifiedMutable());
        EclipseLinkOrmIdMappingTests.assertFalse((boolean)contextId.getMutable().isMutable());
    }

    public void testUpdateConvert() throws Exception {
        this.createTestEntityWithIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "id");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId basicResource = (XmlId)((org.eclipse.jpt.jpa.core.resource.orm.XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        JavaIdMapping javaIdMapping = (JavaIdMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmIdMappingTests.assertNull((Object)ormIdMapping.getConverter().getType());
        EclipseLinkOrmIdMappingTests.assertEquals(null, (String)basicResource.getConvert());
        basicResource.setConvert("myConvert");
        EclipseLinkOrmIdMappingTests.assertEquals(EclipseLinkConvert.class, (Object)ormIdMapping.getConverter().getType());
        EclipseLinkOrmIdMappingTests.assertEquals((String)"myConvert", (String)basicResource.getConvert());
        basicResource.setConvert(null);
        EclipseLinkOrmIdMappingTests.assertNull((Object)ormIdMapping.getConverter().getType());
        EclipseLinkOrmIdMappingTests.assertEquals(null, (String)basicResource.getConvert());
        javaIdMapping.setConverter(EclipseLinkConvert.class);
        ((EclipseLinkConvert)javaIdMapping.getConverter()).setSpecifiedConverterName("foo");
        EclipseLinkOrmIdMappingTests.assertNull((Object)ormIdMapping.getConverter().getType());
        EclipseLinkOrmIdMappingTests.assertEquals(null, (String)basicResource.getConvert());
        EclipseLinkOrmIdMappingTests.assertEquals((String)"foo", (String)((EclipseLinkConvert)javaIdMapping.getConverter()).getSpecifiedConverterName());
        ormPersistentAttribute.convertToVirtual();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("id");
        IdMapping virtualIdMapping = (IdMapping)ormPersistentAttribute2.getMapping();
        EclipseLinkOrmIdMappingTests.assertEquals(EclipseLinkConvert.class, (Object)virtualIdMapping.getConverter().getType());
        EclipseLinkOrmIdMappingTests.assertEquals((String)"foo", (String)((EclipseLinkConvert)virtualIdMapping.getConverter()).getSpecifiedConverterName());
        EclipseLinkOrmIdMappingTests.assertEquals(null, (String)basicResource.getConvert());
        EclipseLinkOrmIdMappingTests.assertEquals((String)"foo", (String)((EclipseLinkConvert)javaIdMapping.getConverter()).getSpecifiedConverterName());
        ((EclipseLinkConvert)javaIdMapping.getConverter()).setSpecifiedConverterName("bar");
        EclipseLinkOrmIdMappingTests.assertEquals(EclipseLinkConvert.class, (Object)virtualIdMapping.getConverter().getType());
        EclipseLinkOrmIdMappingTests.assertEquals((String)"bar", (String)((EclipseLinkConvert)virtualIdMapping.getConverter()).getSpecifiedConverterName());
        EclipseLinkOrmIdMappingTests.assertEquals(null, (String)basicResource.getConvert());
        EclipseLinkOrmIdMappingTests.assertEquals((String)"bar", (String)((EclipseLinkConvert)javaIdMapping.getConverter()).getSpecifiedConverterName());
        javaIdMapping.setConverter(null);
        EclipseLinkOrmIdMappingTests.assertNull((Object)virtualIdMapping.getConverter().getType());
        EclipseLinkOrmIdMappingTests.assertNull((Object)basicResource.getConvert());
        EclipseLinkOrmIdMappingTests.assertNull((Object)javaIdMapping.getConverter().getType());
    }

    public void testModifyConvert() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "basicMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId basicResource = (XmlId)((org.eclipse.jpt.jpa.core.resource.orm.XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        EclipseLinkOrmIdMappingTests.assertNull((Object)ormIdMapping.getConverter().getType());
        EclipseLinkOrmIdMappingTests.assertNull((Object)basicResource.getConvert());
        ormIdMapping.setConverter(EclipseLinkConvert.class);
        EclipseLinkOrmIdMappingTests.assertEquals((String)"", (String)basicResource.getConvert());
        EclipseLinkOrmIdMappingTests.assertEquals(EclipseLinkConvert.class, (Object)ormIdMapping.getConverter().getType());
        ((EclipseLinkConvert)ormIdMapping.getConverter()).setSpecifiedConverterName("bar");
        EclipseLinkOrmIdMappingTests.assertEquals((String)"bar", (String)basicResource.getConvert());
        EclipseLinkOrmIdMappingTests.assertEquals(EclipseLinkConvert.class, (Object)ormIdMapping.getConverter().getType());
        EclipseLinkOrmIdMappingTests.assertEquals((String)"bar", (String)((EclipseLinkConvert)ormIdMapping.getConverter()).getSpecifiedConverterName());
        ((EclipseLinkConvert)ormIdMapping.getConverter()).setSpecifiedConverterName(null);
        EclipseLinkOrmIdMappingTests.assertNull((Object)ormIdMapping.getConverter().getType());
        EclipseLinkOrmIdMappingTests.assertNull((Object)basicResource.getConvert());
        ormIdMapping.setConverter(null);
        EclipseLinkOrmIdMappingTests.assertNull((Object)ormIdMapping.getConverter().getType());
        EclipseLinkOrmIdMappingTests.assertNull((Object)basicResource.getConvert());
    }
}

