/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.Cascade;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmCascade;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetchMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkOneToOneMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkRelationshipMapping;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkOneToOneMapping;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlJoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm.EclipseLinkOrmContextModelTestCase;

public class EclipseLinkOrmOneToOneMappingTests
extends EclipseLinkOrmContextModelTestCase {
    public EclipseLinkOrmOneToOneMappingTests(String name) {
        super(name);
    }

    private void createTestDepartment() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("import ").append("javax.persistence.OneToOne").append(";");
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Department").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private Employee employee;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Department.java", sourceWriter);
    }

    private void createTestEmployee() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Entity").append(";");
                sb.append(CR);
                sb.append("import ").append("javax.persistence.Id").append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Employee").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int empId;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Employee.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.JoinColumn", "javax.persistence.FetchType", "javax.persistence.CascadeType", "org.eclipse.persistence.annotations.JoinFetch", "org.eclipse.persistence.annotations.JoinFetchType", "org.eclipse.persistence.annotations.PrivateOwned"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne(fetch=FetchType.LAZY, optional=false, targetEntity=Address.class, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH})");
                sb.append(CR);
                sb.append("    @JoinColumn(name=\"MY_COLUMN\", referencedColumnName=\"MY_REFERENCED_COLUMN\", unique=true, nullable=false, insertable=false, updatable=false, columnDefinition=\"COLUMN_DEFINITION\", table=\"MY_TABLE\")");
                sb.append(CR);
                sb.append("    @JoinFetch(JoinFetchType.INNER)");
                sb.append(CR);
                sb.append("    @PrivateOwned)");
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    public void testUpdatePrivateOwned() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOne");
        EclipseLinkOneToOneMapping contextOneToOne = (EclipseLinkOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlOneToOne resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)resourceOneToOne.isPrivateOwned());
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)contextOneToOne.getPrivateOwned().isPrivateOwned());
        resourceOneToOne.setPrivateOwned(true);
        EclipseLinkOrmOneToOneMappingTests.assertTrue((boolean)resourceOneToOne.isPrivateOwned());
        EclipseLinkOrmOneToOneMappingTests.assertTrue((boolean)contextOneToOne.getPrivateOwned().isPrivateOwned());
        resourceOneToOne.setPrivateOwned(false);
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)resourceOneToOne.isPrivateOwned());
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)contextOneToOne.getPrivateOwned().isPrivateOwned());
    }

    public void testModifyPrivateOwned() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOne");
        EclipseLinkOneToOneMapping contextOneToOne = (EclipseLinkOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlOneToOne resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)resourceOneToOne.isPrivateOwned());
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)contextOneToOne.getPrivateOwned().isPrivateOwned());
        contextOneToOne.getPrivateOwned().setPrivateOwned(true);
        EclipseLinkOrmOneToOneMappingTests.assertTrue((boolean)resourceOneToOne.isPrivateOwned());
        EclipseLinkOrmOneToOneMappingTests.assertTrue((boolean)contextOneToOne.getPrivateOwned().isPrivateOwned());
        contextOneToOne.getPrivateOwned().setPrivateOwned(false);
    }

    public void testUpdateJoinFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOne");
        EclipseLinkOneToOneMapping contextOneToOne = (EclipseLinkOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlOneToOne resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)contextOneToOne.getJoinFetch().getValue());
        resourceOneToOne.setJoinFetch(XmlJoinFetchType.INNER);
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)XmlJoinFetchType.INNER, (Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextOneToOne.getJoinFetch().getValue());
        resourceOneToOne.setJoinFetch(XmlJoinFetchType.OUTER);
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)XmlJoinFetchType.OUTER, (Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)contextOneToOne.getJoinFetch().getValue());
        resourceOneToOne.setJoinFetch(null);
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)contextOneToOne.getJoinFetch().getValue());
    }

    public void testModifyJoinFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOne");
        EclipseLinkOneToOneMapping contextOneToOne = (EclipseLinkOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlOneToOne resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)contextOneToOne.getJoinFetch().getValue());
        contextOneToOne.getJoinFetch().setValue(EclipseLinkJoinFetchType.INNER);
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)XmlJoinFetchType.INNER, (Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)contextOneToOne.getJoinFetch().getValue());
        contextOneToOne.getJoinFetch().setValue(EclipseLinkJoinFetchType.OUTER);
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)XmlJoinFetchType.OUTER, (Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)contextOneToOne.getJoinFetch().getValue());
        contextOneToOne.getJoinFetch().setValue(null);
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)resourceOneToOne.getJoinFetch());
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)contextOneToOne.getJoinFetch().getValue());
    }

    public void testJoinFetchDefaultFromJava() throws Exception {
        this.createTestEmployee();
        this.createTestDepartment();
        this.getEntityMappings().addPersistentType("entity", "test.Department");
        this.getEntityMappings().addPersistentType("entity", "test.Employee");
        OrmPersistentType departmentPersistentType = (OrmPersistentType)this.getEntityMappings().getPersistentTypes().iterator().next();
        EclipseLinkOneToOneMapping oneToOne = (EclipseLinkOneToOneMapping)departmentPersistentType.getAttributeNamed("employee").getMapping();
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)oneToOne.getJoinFetch().getValue());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        oneToOne = (EclipseLinkOneToOneMapping)departmentPersistentType.getAttributeNamed("employee").getMapping();
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)oneToOne.getJoinFetch().getValue());
        EclipseLinkRelationshipMapping javaRelationshipMapping = (EclipseLinkRelationshipMapping)departmentPersistentType.getJavaPersistentType().getAttributeNamed("employee").getMapping();
        javaRelationshipMapping.getJoinFetch().setValue(EclipseLinkJoinFetchType.OUTER);
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)oneToOne.getJoinFetch().getValue());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        oneToOne = (EclipseLinkOneToOneMapping)departmentPersistentType.getAttributeNamed("employee").getMapping();
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.OUTER, (Object)oneToOne.getJoinFetch().getValue());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityOneToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        EclipseLinkOrmOneToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute virtualPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OneToOneMapping virtualOneToOneMapping = (OneToOneMapping)virtualPersistentAttribute.getMapping();
        EclipseLinkOrmOneToOneMappingTests.assertEquals((String)"address", (String)virtualOneToOneMapping.getName());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)virtualOneToOneMapping.getSpecifiedFetch());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualOneToOneMapping.getSpecifiedOptional());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((String)"Address", (String)virtualOneToOneMapping.getSpecifiedTargetEntity());
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)virtualOneToOneMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        JoinColumn virtualJoinColumn = (JoinColumn)virtualOneToOneMapping.getRelationship().getJoinColumnStrategy().specifiedJoinColumns().next();
        EclipseLinkOrmOneToOneMappingTests.assertEquals((String)"MY_COLUMN", (String)virtualJoinColumn.getSpecifiedName());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((String)"MY_REFERENCED_COLUMN", (String)virtualJoinColumn.getSpecifiedReferencedColumnName());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)virtualJoinColumn.getSpecifiedUnique());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualJoinColumn.getSpecifiedNullable());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualJoinColumn.getSpecifiedInsertable());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualJoinColumn.getSpecifiedUpdatable());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualJoinColumn.getColumnDefinition());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((String)"MY_TABLE", (String)virtualJoinColumn.getSpecifiedTable());
        Cascade cascade = virtualOneToOneMapping.getCascade();
        EclipseLinkOrmOneToOneMappingTests.assertTrue((boolean)cascade.isAll());
        EclipseLinkOrmOneToOneMappingTests.assertTrue((boolean)cascade.isMerge());
        EclipseLinkOrmOneToOneMappingTests.assertTrue((boolean)cascade.isPersist());
        EclipseLinkOrmOneToOneMappingTests.assertTrue((boolean)cascade.isRemove());
        EclipseLinkOrmOneToOneMappingTests.assertTrue((boolean)cascade.isRefresh());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)((EclipseLinkJoinFetchMapping)virtualOneToOneMapping).getJoinFetch().getValue());
        EclipseLinkOrmOneToOneMappingTests.assertTrue((boolean)((EclipseLinkOneToOneMapping)virtualOneToOneMapping).getPrivateOwned().isPrivateOwned());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityOneToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        EclipseLinkOrmOneToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute virtualPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        EclipseLinkOrmOneToOneMappingTests.assertEquals((String)"oneToOne", (String)virtualPersistentAttribute.getMappingKey());
        EclipseLinkOrmOneToOneMappingTests.assertTrue((boolean)virtualPersistentAttribute.isVirtual());
        EclipseLinkOneToOneMapping ormOneToOneMapping = (EclipseLinkOneToOneMapping)virtualPersistentAttribute.getMapping();
        EclipseLinkOrmOneToOneMappingTests.assertEquals((String)"address", (String)ormOneToOneMapping.getName());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToOneMapping.getFetch());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((boolean)true, (boolean)ormOneToOneMapping.isOptional());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((String)"test.Address", (String)ormOneToOneMapping.getTargetEntity());
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        Cascade cascade = ormOneToOneMapping.getCascade();
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)cascade.isAll());
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)cascade.isMerge());
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)cascade.isPersist());
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)cascade.isRemove());
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)cascade.isRefresh());
        EclipseLinkOrmOneToOneMappingTests.assertEquals(null, (Object)ormOneToOneMapping.getJoinFetch().getValue());
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)ormOneToOneMapping.getPrivateOwned().isPrivateOwned());
    }

    public void testSpecifiedMapping() throws Exception {
        this.createTestEntityOneToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.addSpecifiedAttribute("oneToOne", "address");
        EclipseLinkOrmOneToOneMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmEclipseLinkOneToOneMapping ormOneToOneMapping = (OrmEclipseLinkOneToOneMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmOneToOneMappingTests.assertEquals((String)"address", (String)ormOneToOneMapping.getName());
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedFetch());
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedOptional());
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedTargetEntity());
        EclipseLinkOrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToOneMapping.getFetch());
        EclipseLinkOrmOneToOneMappingTests.assertEquals((boolean)true, (boolean)ormOneToOneMapping.isOptional());
        EclipseLinkOrmOneToOneMappingTests.assertTrue((ormOneToOneMapping.getRelationship().getJoinColumnStrategy().joinColumnsSize() > 0 ? 1 : 0) != 0);
        OrmCascade cascade = ormOneToOneMapping.getCascade();
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)cascade.isAll());
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)cascade.isMerge());
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)cascade.isPersist());
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)cascade.isRemove());
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)cascade.isRefresh());
        EclipseLinkOrmOneToOneMappingTests.assertEquals(null, (Object)ormOneToOneMapping.getJoinFetch().getValue());
        EclipseLinkOrmOneToOneMappingTests.assertFalse((boolean)ormOneToOneMapping.getPrivateOwned().isPrivateOwned());
    }
}

