/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.v2_0.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.jpa2.context.ManyToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.ManyToOneRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaManyToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOneToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapsId2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.v2_0.context.EclipseLink2_0ContextModelTestCase;

public class EclipseLink2_0JavaManyToOneMappingTests
extends EclipseLink2_0ContextModelTestCase {
    public EclipseLink2_0JavaManyToOneMappingTests(String name) {
        super(name);
    }

    private void createTestEntity() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne");
                sb.append(CR);
                sb.append("    private Address address;");
                sb.append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private ICompilationUnit createTestEntityWithIdDerivedIdentity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne @Id").append(CR);
                sb.append("    private AnnotationTestType manyToOne;").append(CR);
                sb.append(CR);
            }
        });
    }

    private void createTestEntityWithMapsIdDerivedIdentity() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.MapsId"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne @MapsId").append(CR);
                sb.append("    private AnnotationTestType manyToOne;").append(CR);
                sb.append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmReadOnlyPersistentAttribute each : CollectionTools.iterable((Iterator)ormPersistentType.attributes())) {
            each.convertToSpecified();
        }
    }

    public void testUpdateDerivedId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableAttributes().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        JavaManyToOneMapping2_0 contextMapping = (JavaManyToOneMapping2_0)contextAttribute.getMapping();
        EclipseLink2_0JavaManyToOneMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        EclipseLink2_0JavaManyToOneMappingTests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceAttribute.removeAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        EclipseLink2_0JavaManyToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceAttribute.addAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToOneMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        EclipseLink2_0JavaManyToOneMappingTests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testSetDerivedId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableAttributes().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        JavaManyToOneMapping2_0 contextMapping = (JavaManyToOneMapping2_0)contextAttribute.getMapping();
        EclipseLink2_0JavaManyToOneMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        EclipseLink2_0JavaManyToOneMappingTests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(false);
        EclipseLink2_0JavaManyToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        EclipseLink2_0JavaManyToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(true);
        EclipseLink2_0JavaManyToOneMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        EclipseLink2_0JavaManyToOneMappingTests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testUpdateMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableAttributes().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        JavaManyToOneMapping2_0 contextMapping = (JavaManyToOneMapping2_0)contextAttribute.getMapping();
        MapsId2_0Annotation annotation = (MapsId2_0Annotation)resourceAttribute.getAnnotation("javax.persistence.MapsId");
        annotation.setValue("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToOneMappingTests.assertEquals((String)"foo", (String)annotation.getValue());
        EclipseLink2_0JavaManyToOneMappingTests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        annotation.setValue("bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToOneMappingTests.assertEquals((String)"bar", (String)annotation.getValue());
        EclipseLink2_0JavaManyToOneMappingTests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        resourceAttribute.removeAnnotation("javax.persistence.MapsId");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        EclipseLink2_0JavaManyToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
    }

    public void testSetMapsId() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableAttributes().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("address");
        JavaManyToOneMapping2_0 contextMapping = (JavaManyToOneMapping2_0)contextAttribute.getMapping();
        EclipseLink2_0JavaManyToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        EclipseLink2_0JavaManyToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue("foo");
        MapsId2_0Annotation annotation = (MapsId2_0Annotation)resourceAttribute.getAnnotation("javax.persistence.MapsId");
        EclipseLink2_0JavaManyToOneMappingTests.assertNotNull((Object)annotation);
        EclipseLink2_0JavaManyToOneMappingTests.assertEquals((String)"foo", (String)annotation.getValue());
        EclipseLink2_0JavaManyToOneMappingTests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue("bar");
        EclipseLink2_0JavaManyToOneMappingTests.assertEquals((String)"bar", (String)annotation.getValue());
        EclipseLink2_0JavaManyToOneMappingTests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue(null);
        EclipseLink2_0JavaManyToOneMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        EclipseLink2_0JavaManyToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
    }

    public void testMorphMapping() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableAttributes().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        ((MapsId2_0Annotation)resourceAttribute.getAnnotation("javax.persistence.MapsId")).setValue("foo");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        EclipseLink2_0JavaManyToOneMappingTests.assertFalse((boolean)((JavaManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        EclipseLink2_0JavaManyToOneMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        EclipseLink2_0JavaManyToOneMappingTests.assertEquals((String)"foo", (String)((MapsId2_0Annotation)resourceAttribute.getAnnotation("javax.persistence.MapsId")).getValue());
        EclipseLink2_0JavaManyToOneMappingTests.assertEquals((String)"foo", (String)((JavaManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextAttribute.setMappingKey("oneToOne");
        EclipseLink2_0JavaManyToOneMappingTests.assertFalse((boolean)((JavaOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        EclipseLink2_0JavaManyToOneMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        EclipseLink2_0JavaManyToOneMappingTests.assertEquals((String)"foo", (String)((MapsId2_0Annotation)resourceAttribute.getAnnotation("javax.persistence.MapsId")).getValue());
        EclipseLink2_0JavaManyToOneMappingTests.assertEquals((String)"foo", (String)((JavaOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextAttribute.setMappingKey("manyToOne");
        EclipseLink2_0JavaManyToOneMappingTests.assertFalse((boolean)((JavaManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        EclipseLink2_0JavaManyToOneMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        EclipseLink2_0JavaManyToOneMappingTests.assertEquals((String)"foo", (String)((MapsId2_0Annotation)resourceAttribute.getAnnotation("javax.persistence.MapsId")).getValue());
        EclipseLink2_0JavaManyToOneMappingTests.assertEquals((String)"foo", (String)((JavaManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping2_0 mapping = (ManyToOneMapping2_0)contextAttribute.getMapping();
        ManyToOneRelationship2_0 rel = (ManyToOneRelationship2_0)mapping.getRelationship();
        EclipseLink2_0JavaManyToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaManyToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinColumn();
        EclipseLink2_0JavaManyToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaManyToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinTable();
        EclipseLink2_0JavaManyToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaManyToOneMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinColumn();
        EclipseLink2_0JavaManyToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaManyToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        ManyToOneMapping2_0 mapping = (ManyToOneMapping2_0)contextAttribute.getMapping();
        ManyToOneRelationship2_0 rel = (ManyToOneRelationship2_0)mapping.getRelationship();
        EclipseLink2_0JavaManyToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaManyToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceAttribute.addAnnotation("javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToOneMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaManyToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceAttribute.addAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToOneMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaManyToOneMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        resourceAttribute.removeAnnotation("javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaManyToOneMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        resourceAttribute.removeAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_0JavaManyToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        EclipseLink2_0JavaManyToOneMappingTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        EclipseLink2_0JavaManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        EclipseLink2_0JavaManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
    }
}

