/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.v2_0.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinTable;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.jpa2.context.Cascade2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.ManyToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.ManyToOneRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaManyToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaManyToOneRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmManyToOneMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmManyToOneRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmOneToOneMapping2_0;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlManyToOne;
import org.eclipse.jpt.jpa.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.jpa.core.resource.orm.v2_0.XmlDerivedId_2_0;
import org.eclipse.jpt.jpa.core.resource.orm.v2_0.XmlMapsId_2_0;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetchMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.v2_0.context.orm.EclipseLink2_0OrmContextModelTestCase;

public class Eclipselink2_0OrmManyToOneMappingTests
extends EclipseLink2_0OrmContextModelTestCase {
    public Eclipselink2_0OrmManyToOneMappingTests(String name) {
        super(name);
    }

    private void createTestEntityWithIdDerivedIdentity() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne @Id").append(CR);
                sb.append("    private AnnotationTestType manyToOne;").append(CR);
                sb.append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmReadOnlyPersistentAttribute each : CollectionTools.iterable((Iterator)ormPersistentType.attributes())) {
            each.convertToSpecified();
        }
    }

    private void createTestEntityWithMapsIdDerivedIdentity() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.MapsId"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne @MapsId").append(CR);
                sb.append("    private AnnotationTestType manyToOne;").append(CR);
                sb.append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmReadOnlyPersistentAttribute each : CollectionTools.iterable((Iterator)ormPersistentType.attributes())) {
            each.convertToSpecified();
        }
    }

    private ICompilationUnit createTestEntityWithValidManyToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEntityWithManyToOneMapping() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToOne").append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmReadOnlyPersistentAttribute each : CollectionTools.iterable((Iterator)ormPersistentType.attributes())) {
            each.convertToSpecified();
        }
    }

    private ICompilationUnit createTestEntityManyToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.JoinColumn", "javax.persistence.FetchType", "javax.persistence.CascadeType", "org.eclipse.persistence.annotations.JoinFetch", "org.eclipse.persistence.annotations.JoinFetchType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne(fetch=FetchType.LAZY, optional=false, targetEntity=Address.class, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH, CascadeType.DETACH})");
                sb.append(CR);
                sb.append("    @JoinColumn(name=\"MY_COLUMN\", referencedColumnName=\"MY_REFERENCED_COLUMN\", unique=true, nullable=false, insertable=false, updatable=false, columnDefinition=\"COLUMN_DEFINITION\", table=\"MY_TABLE\")");
                sb.append(CR);
                sb.append("    @JoinFetch(JoinFetchType.INNER)");
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    public void testUpdateDerivedId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        OrmManyToOneMapping2_0 contextMapping = (OrmManyToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlDerivedId_2_0 resourceMapping = (XmlDerivedId_2_0)resourceEntity.getAttributes().getManyToOnes().get(0);
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getId());
        Eclipselink2_0OrmManyToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(Boolean.FALSE);
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)resourceMapping.getId());
        Eclipselink2_0OrmManyToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(Boolean.TRUE);
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceMapping.getId());
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceMapping.setId(null);
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getId());
        Eclipselink2_0OrmManyToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testSetDerivedId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        OrmManyToOneMapping2_0 contextMapping = (OrmManyToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlDerivedId_2_0 resourceMapping = (XmlDerivedId_2_0)resourceEntity.getAttributes().getManyToOnes().get(0);
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getId());
        Eclipselink2_0OrmManyToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(true);
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceMapping.getId());
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(false);
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getId());
        Eclipselink2_0OrmManyToOneMappingTests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testUpdateMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        OrmManyToOneMapping2_0 contextMapping = (OrmManyToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlMapsId_2_0 resourceMapping = (XmlMapsId_2_0)resourceEntity.getAttributes().getManyToOnes().get(0);
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getMapsId());
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        resourceMapping.setMapsId("foo");
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"foo", (String)resourceMapping.getMapsId());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        resourceMapping.setMapsId("bar");
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"bar", (String)resourceMapping.getMapsId());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        resourceMapping.setMapsId(null);
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getMapsId());
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
    }

    public void testSetMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("manyToOne");
        OrmManyToOneMapping2_0 contextMapping = (OrmManyToOneMapping2_0)contextAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlMapsId_2_0 resourceMapping = (XmlMapsId_2_0)resourceEntity.getAttributes().getManyToOnes().get(0);
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getMapsId());
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue("foo");
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"foo", (String)resourceMapping.getMapsId());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue("bar");
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"bar", (String)resourceMapping.getMapsId());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue(null);
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getMapsId());
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
    }

    public void testMorphMapping() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = (OrmPersistentAttribute)contextType.getAttributeNamed("manyToOne");
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlManyToOne resourceManyToOne = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        resourceManyToOne.setId(Boolean.TRUE);
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceManyToOne.getId());
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)((OrmManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)resourceManyToOne.getMapsId());
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)((OrmManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextAttribute.setMappingKey("oneToOne");
        XmlOneToOne resourceOneToOne = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceOneToOne.getId());
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)((OrmOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)resourceOneToOne.getMapsId());
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)((OrmOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextAttribute.setMappingKey("manyToOne");
        resourceManyToOne.setId(Boolean.TRUE);
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceManyToOne.getId());
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)((OrmManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)resourceManyToOne.getMapsId());
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)((OrmManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
    }

    public void testVirtualJoinTable() throws Exception {
        this.createTestEntityWithValidManyToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        JavaManyToOneMapping2_0 javaManyToOneMapping = (JavaManyToOneMapping2_0)ormPersistentAttribute.getJavaPersistentAttribute().getMapping();
        ManyToOneMapping2_0 virtualManyToOneMapping = (ManyToOneMapping2_0)ormPersistentAttribute.getMapping();
        ((ManyToOneRelationship2_0)javaManyToOneMapping.getRelationship()).setStrategyToJoinTable();
        JoinTable ormJoinTable = ((ManyToOneRelationship2_0)virtualManyToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals(null, (String)ormJoinTable.getSpecifiedName());
        this.createTestTargetEntityAddress();
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinTable.getName());
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)ormJoinTable.getSpecifiedCatalog());
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)ormJoinTable.getSpecifiedSchema());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((int)0, (int)ormJoinTable.specifiedJoinColumnsSize());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((int)0, (int)ormJoinTable.specifiedInverseJoinColumnsSize());
        JoinColumn ormJoinColumn = ormJoinTable.getDefaultJoinColumn();
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinColumn.getDefaultTable());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"AnnotationTestType_id", (String)ormJoinColumn.getDefaultName());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"id", (String)ormJoinColumn.getDefaultReferencedColumnName());
        JoinColumn inverseOrmJoinColumn = ormJoinTable.getDefaultInverseJoinColumn();
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)inverseOrmJoinColumn.getDefaultTable());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"address_id", (String)inverseOrmJoinColumn.getDefaultName());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"id", (String)inverseOrmJoinColumn.getDefaultReferencedColumnName());
        JavaJoinTable javaJoinTable = ((JavaManyToOneRelationship2_0)javaManyToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        javaJoinTable.setSpecifiedName("FOO");
        javaJoinTable.setSpecifiedCatalog("CATALOG");
        javaJoinTable.setSpecifiedSchema("SCHEMA");
        JavaJoinColumn javaJoinColumn = javaJoinTable.addSpecifiedJoinColumn(0);
        javaJoinColumn.setSpecifiedName("NAME");
        javaJoinColumn.setSpecifiedReferencedColumnName("REFERENCED_NAME");
        JavaJoinColumn inverseJavaJoinColumn = javaJoinTable.addSpecifiedInverseJoinColumn(0);
        inverseJavaJoinColumn.setSpecifiedName("INVERSE_NAME");
        inverseJavaJoinColumn.setSpecifiedReferencedColumnName("INVERSE_REFERENCED_NAME");
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"FOO", (String)ormJoinTable.getSpecifiedName());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"CATALOG", (String)ormJoinTable.getSpecifiedCatalog());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"SCHEMA", (String)ormJoinTable.getSpecifiedSchema());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((int)1, (int)ormJoinTable.specifiedJoinColumnsSize());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((int)1, (int)ormJoinTable.specifiedInverseJoinColumnsSize());
        ormJoinColumn = (JoinColumn)ormJoinTable.specifiedJoinColumns().next();
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"NAME", (String)ormJoinColumn.getSpecifiedName());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"REFERENCED_NAME", (String)ormJoinColumn.getSpecifiedReferencedColumnName());
        inverseOrmJoinColumn = (JoinColumn)ormJoinTable.specifiedInverseJoinColumns().next();
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"INVERSE_NAME", (String)inverseOrmJoinColumn.getSpecifiedName());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"INVERSE_REFERENCED_NAME", (String)inverseOrmJoinColumn.getSpecifiedReferencedColumnName());
    }

    public void testUpdateDefaultNameFromJavaTable() throws Exception {
        this.createTestEntityWithValidManyToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToOne", "address");
        OrmManyToOneMapping2_0 ormManyToOneMapping = (OrmManyToOneMapping2_0)ormPersistentAttribute.getMapping();
        ((ManyToOneRelationship2_0)ormManyToOneMapping.getRelationship()).setStrategyToJoinTable();
        OrmJoinTable ormJoinTable = ((OrmManyToOneRelationship2_0)ormManyToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals(null, (String)ormJoinTable.getDefaultName());
        this.createTestTargetEntityAddress();
        OrmPersistentType targetPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Address");
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinTable.getDefaultName());
        ((JavaEntity)targetPersistentType.getJavaPersistentType().getMapping()).getTable().setSpecifiedName("FOO");
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"AnnotationTestType_FOO", (String)ormJoinTable.getDefaultName());
        ((JavaEntity)ormPersistentType.getJavaPersistentType().getMapping()).getTable().setSpecifiedName("BAR");
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        JavaManyToOneMapping2_0 javaManyToOneMapping = (JavaManyToOneMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("address").getMapping();
        ((ManyToOneRelationship2_0)javaManyToOneMapping.getRelationship()).setStrategyToJoinTable();
        ((ManyToOneRelationship2_0)javaManyToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable().setSpecifiedName("JAVA_JOIN_TABLE");
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"AnnotationTestType_Address", (String)ormJoinTable.getDefaultName());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        ormPersistentAttribute.convertToVirtual();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("address");
        ManyToOneMapping2_0 virtualManyToOneMapping = (ManyToOneMapping2_0)ormPersistentAttribute2.getMapping();
        ormJoinTable = ((ManyToOneRelationship2_0)virtualManyToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)ormPersistentAttribute2.isVirtual());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"JAVA_JOIN_TABLE", (String)ormJoinTable.getSpecifiedName());
        ((ManyToOneRelationship2_0)javaManyToOneMapping.getRelationship()).getJoinTableStrategy().removeStrategy();
        ormJoinTable = ((ManyToOneRelationship2_0)virtualManyToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)ormJoinTable);
        ((ManyToOneRelationship2_0)javaManyToOneMapping.getRelationship()).setStrategyToJoinTable();
        ormJoinTable = ((ManyToOneRelationship2_0)virtualManyToOneMapping.getRelationship()).getJoinTableStrategy().getJoinTable();
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getName());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TABLE_NAME");
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"ORM_TABLE_NAME_FOO", (String)ormJoinTable.getDefaultName());
        ((OrmEntity)targetPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TARGET");
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"ORM_TABLE_NAME_ORM_TARGET", (String)ormJoinTable.getDefaultName());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmManyToOneMapping2_0 contextMapping = (OrmManyToOneMapping2_0)contextAttribute.getMapping();
        OrmManyToOneRelationship2_0 rel = (OrmManyToOneRelationship2_0)contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlManyToOne resourceMapping = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        Eclipselink2_0OrmManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinColumn();
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        Eclipselink2_0OrmManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinTable();
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        Eclipselink2_0OrmManyToOneMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        Eclipselink2_0OrmManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
        rel.setStrategyToJoinColumn();
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        Eclipselink2_0OrmManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmManyToOneMapping2_0 contextMapping = (OrmManyToOneMapping2_0)contextAttribute.getMapping();
        OrmManyToOneRelationship2_0 rel = (OrmManyToOneRelationship2_0)contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlManyToOne resourceMapping = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        Eclipselink2_0OrmManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        this.getJpaProject().synchronizeContextModel();
        Eclipselink2_0OrmManyToOneMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        Eclipselink2_0OrmManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.getJoinColumns().clear();
        this.getJpaProject().synchronizeContextModel();
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        Eclipselink2_0OrmManyToOneMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        Eclipselink2_0OrmManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinTable());
        resourceMapping.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        this.getJpaProject().synchronizeContextModel();
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        Eclipselink2_0OrmManyToOneMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        Eclipselink2_0OrmManyToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinTable());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityManyToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute virtualPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ManyToOneMapping2_0 virtualManyToOneMapping = (ManyToOneMapping2_0)virtualPersistentAttribute.getMapping();
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"address", (String)virtualManyToOneMapping.getName());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)virtualManyToOneMapping.getSpecifiedFetch());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualManyToOneMapping.getSpecifiedOptional());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"Address", (String)virtualManyToOneMapping.getSpecifiedTargetEntity());
        JoinColumn virtualJoinColumn = (JoinColumn)virtualManyToOneMapping.getRelationship().getJoinColumnStrategy().specifiedJoinColumns().next();
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"MY_COLUMN", (String)virtualJoinColumn.getSpecifiedName());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"MY_REFERENCED_COLUMN", (String)virtualJoinColumn.getSpecifiedReferencedColumnName());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)virtualJoinColumn.getSpecifiedUnique());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualJoinColumn.getSpecifiedNullable());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualJoinColumn.getSpecifiedInsertable());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualJoinColumn.getSpecifiedUpdatable());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualJoinColumn.getColumnDefinition());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"MY_TABLE", (String)virtualJoinColumn.getSpecifiedTable());
        Cascade2_0 cascade = (Cascade2_0)virtualManyToOneMapping.getCascade();
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)cascade.isAll());
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)cascade.isMerge());
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)cascade.isPersist());
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)cascade.isRemove());
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)cascade.isRefresh());
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)cascade.isDetach());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((Object)EclipseLinkJoinFetchType.INNER, (Object)((EclipseLinkJoinFetchMapping)virtualManyToOneMapping).getJoinFetch().getValue());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityManyToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute virtualPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"oneToOne", (String)virtualPersistentAttribute.getMappingKey());
        Eclipselink2_0OrmManyToOneMappingTests.assertTrue((boolean)virtualPersistentAttribute.isVirtual());
        virtualPersistentAttribute.convertToSpecified("manyToOne");
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmManyToOneMapping2_0 ormManyToOneMapping = (OrmManyToOneMapping2_0)ormPersistentAttribute.getMapping();
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"address", (String)ormManyToOneMapping.getName());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormManyToOneMapping.getDefaultFetch());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((boolean)true, (boolean)ormManyToOneMapping.isDefaultOptional());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals((String)"test.Address", (String)ormManyToOneMapping.getDefaultTargetEntity());
        Cascade2_0 cascade = (Cascade2_0)ormManyToOneMapping.getCascade();
        Eclipselink2_0OrmManyToOneMappingTests.assertFalse((boolean)cascade.isAll());
        Eclipselink2_0OrmManyToOneMappingTests.assertFalse((boolean)cascade.isMerge());
        Eclipselink2_0OrmManyToOneMappingTests.assertFalse((boolean)cascade.isPersist());
        Eclipselink2_0OrmManyToOneMappingTests.assertFalse((boolean)cascade.isRemove());
        Eclipselink2_0OrmManyToOneMappingTests.assertFalse((boolean)cascade.isRefresh());
        Eclipselink2_0OrmManyToOneMappingTests.assertFalse((boolean)cascade.isDetach());
        Eclipselink2_0OrmManyToOneMappingTests.assertEquals(null, (Object)((EclipseLinkJoinFetchMapping)ormManyToOneMapping).getJoinFetch().getValue());
    }
}

