/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceType;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessOrder;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessorOrderAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlAccessorOrderTypeAnnotationTests
extends JaxbJavaResourceModelTestCase {
    public XmlAccessorOrderTypeAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlAccessorOrder() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlAccessorOrder"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlAccessorOrder");
            }
        });
    }

    private ICompilationUnit createTestXmlAccessorOrderWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlAccessorOrder", "javax.xml.bind.annotation.XmlAccessOrder"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlAccessorOrder(value = XmlAccessOrder.ALPHABETICAL)");
            }
        });
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestXmlAccessorOrder();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlAccessorOrderAnnotation xmlAccessorOrderAnnotation = (XmlAccessorOrderAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlAccessorOrder");
        XmlAccessorOrderTypeAnnotationTests.assertTrue((xmlAccessorOrderAnnotation != null ? 1 : 0) != 0);
        XmlAccessorOrderTypeAnnotationTests.assertNull((Object)xmlAccessorOrderAnnotation.getValue());
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlAccessorOrderWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlAccessorOrderAnnotation xmlAccessorOrderAnnotation = (XmlAccessorOrderAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlAccessorOrder");
        XmlAccessorOrderTypeAnnotationTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)xmlAccessorOrderAnnotation.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlAccessorOrder();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlAccessorOrderAnnotation xmlAccessorOrderAnnotation = (XmlAccessorOrderAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlAccessorOrder");
        XmlAccessorOrderTypeAnnotationTests.assertEquals(null, (Object)xmlAccessorOrderAnnotation.getValue());
        xmlAccessorOrderAnnotation.setValue(XmlAccessOrder.UNDEFINED);
        XmlAccessorOrderTypeAnnotationTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)xmlAccessorOrderAnnotation.getValue());
        this.assertSourceContains("@XmlAccessorOrder(UNDEFINED)", cu);
    }

    public void testSetValueNull() throws Exception {
        ICompilationUnit cu = this.createTestXmlAccessorOrderWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlAccessorOrderAnnotation xmlAccessorOrderAnnotation = (XmlAccessorOrderAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlAccessorOrder");
        XmlAccessorOrderTypeAnnotationTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)xmlAccessorOrderAnnotation.getValue());
        xmlAccessorOrderAnnotation.setValue(null);
        XmlAccessorOrderTypeAnnotationTests.assertNull((Object)xmlAccessorOrderAnnotation.getValue());
    }
}

