/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.jaxb.core.resource.java.XmlEnumAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlEnumAnnotationTests
extends JaxbJavaResourceModelTestCase {
    private static final String XML_ENUM_JAVA_TYPE = "String";

    public XmlEnumAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlEnum() throws Exception {
        return this.createTestEnum((AnnotationTestCase.EnumAnnotationWriter)new AnnotationTestCase.DefaultEnumAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlEnum"});
            }

            public void appendEnumAnnotationTo(StringBuilder sb) {
                sb.append("@XmlEnum");
            }
        });
    }

    private ICompilationUnit createTestXmlEnumWithValue() throws Exception {
        return this.createTestEnum((AnnotationTestCase.EnumAnnotationWriter)new AnnotationTestCase.DefaultEnumAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.xml.bind.annotation.XmlEnum"});
            }

            public void appendEnumAnnotationTo(StringBuilder sb) {
                sb.append("@XmlEnum(value = String.class)");
            }
        });
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestXmlEnum();
        JavaResourceEnum resourceEnum = this.buildJavaResourceEnum(cu);
        XmlEnumAnnotation xmlEnumAnnotation = (XmlEnumAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlEnum");
        XmlEnumAnnotationTests.assertTrue((xmlEnumAnnotation != null ? 1 : 0) != 0);
        XmlEnumAnnotationTests.assertNull((Object)xmlEnumAnnotation.getValue());
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlEnumWithValue();
        JavaResourceEnum resourceEnum = this.buildJavaResourceEnum(cu);
        XmlEnumAnnotation xmlEnumAnnotation = (XmlEnumAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlEnum");
        XmlEnumAnnotationTests.assertTrue((xmlEnumAnnotation != null ? 1 : 0) != 0);
        XmlEnumAnnotationTests.assertEquals((String)XML_ENUM_JAVA_TYPE, (String)xmlEnumAnnotation.getValue());
        XmlEnumAnnotationTests.assertEquals((String)"java.lang.String", (String)xmlEnumAnnotation.getFullyQualifiedValueClassName());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlEnum();
        JavaResourceEnum resourceEnum = this.buildJavaResourceEnum(cu);
        XmlEnumAnnotation xmlEnumAnnotation = (XmlEnumAnnotation)resourceEnum.getAnnotation("javax.xml.bind.annotation.XmlEnum");
        XmlEnumAnnotationTests.assertNull((Object)xmlEnumAnnotation.getValue());
        xmlEnumAnnotation.setValue(XML_ENUM_JAVA_TYPE);
        XmlEnumAnnotationTests.assertEquals((String)XML_ENUM_JAVA_TYPE, (String)xmlEnumAnnotation.getValue());
        this.assertSourceContains("@XmlEnum(String.class)", cu);
        xmlEnumAnnotation.setValue(null);
        XmlEnumAnnotationTests.assertNull((Object)xmlEnumAnnotation.getValue());
        this.assertSourceContains("@XmlEnum", cu);
    }
}

