/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.jaxb.core.resource.java.XmlNsAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlNsForm;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSchemaAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlSchemaAnnotationTests
extends JaxbJavaResourceModelTestCase {
    private static final String TEST_LOCATION = "http://www.eclipse.org/test/schema.xsd";
    private static final String TEST_NAMESPACE = "http://www.eclipse.org/test/schema";
    private static final String TEST_PREFIX = "ts";
    private static final String TEST_NAMESPACE_2 = "http://www.eclipse.org/test/schema2";
    private static final String TEST_PREFIX_2 = "ts2";

    public XmlSchemaAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createPackageInfoWithSchemaAndAttributeFormDefault() throws CoreException {
        return this.createTestPackageInfo("@XmlSchema(attributeFormDefault = XmlNsForm.QUALIFIED)", new String[]{"javax.xml.bind.annotation.XmlSchema", "javax.xml.bind.annotation.XmlNsForm"});
    }

    private ICompilationUnit createPackageInfoWithSchemaAndElementFormDefault() throws CoreException {
        return this.createTestPackageInfo("@XmlSchema(elementFormDefault = XmlNsForm.QUALIFIED)", new String[]{"javax.xml.bind.annotation.XmlSchema", "javax.xml.bind.annotation.XmlNsForm"});
    }

    private ICompilationUnit createPackageInfoWithSchemaAndLocation() throws CoreException {
        return this.createTestPackageInfo("@XmlSchema(location = \"http://www.eclipse.org/test/schema.xsd\")", new String[]{"javax.xml.bind.annotation.XmlSchema"});
    }

    private ICompilationUnit createPackageInfoWithSchemaAndNamespace() throws CoreException {
        return this.createTestPackageInfo("@XmlSchema(namespace = \"http://www.eclipse.org/test/schema\")", new String[]{"javax.xml.bind.annotation.XmlSchema"});
    }

    private ICompilationUnit createPackageInfoWithSchemaAndXmlns() throws CoreException {
        return this.createTestPackageInfo("@XmlSchema(xmlns = @XmlNs)", new String[]{"javax.xml.bind.annotation.XmlSchema", "javax.xml.bind.annotation.XmlNs"});
    }

    private ICompilationUnit createPackageInfoWithSchemaAndXmlnsWithNamespace() throws CoreException {
        return this.createTestPackageInfo("@XmlSchema(xmlns = @XmlNs(namespaceURI = \"http://www.eclipse.org/test/schema\"))", new String[]{"javax.xml.bind.annotation.XmlSchema", "javax.xml.bind.annotation.XmlNs"});
    }

    private ICompilationUnit createPackageInfoWithSchemaAndXmlnsWithPrefix() throws CoreException {
        return this.createTestPackageInfo("@XmlSchema(xmlns = @XmlNs(prefix = \"ts\"))", new String[]{"javax.xml.bind.annotation.XmlSchema", "javax.xml.bind.annotation.XmlNs"});
    }

    public void testAttributeFormDefault() throws Exception {
        ICompilationUnit cu = this.createPackageInfoWithSchemaAndAttributeFormDefault();
        JavaResourcePackage packageResource = this.buildJavaResourcePackage(cu);
        XmlSchemaAnnotation schemaAnnotation = (XmlSchemaAnnotation)packageResource.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        XmlSchemaAnnotationTests.assertTrue((schemaAnnotation != null ? 1 : 0) != 0);
        XmlSchemaAnnotationTests.assertEquals((Object)XmlNsForm.QUALIFIED, (Object)schemaAnnotation.getAttributeFormDefault());
        this.assertSourceContains("@XmlSchema(attributeFormDefault = XmlNsForm.QUALIFIED)", cu);
        schemaAnnotation.setAttributeFormDefault(XmlNsForm.UNQUALIFIED);
        XmlSchemaAnnotationTests.assertEquals((Object)XmlNsForm.UNQUALIFIED, (Object)schemaAnnotation.getAttributeFormDefault());
        this.assertSourceContains("@XmlSchema(attributeFormDefault = UNQUALIFIED)", cu);
        schemaAnnotation.setAttributeFormDefault(XmlNsForm.UNSET);
        XmlSchemaAnnotationTests.assertEquals((Object)XmlNsForm.UNSET, (Object)schemaAnnotation.getAttributeFormDefault());
        this.assertSourceContains("@XmlSchema(attributeFormDefault = UNSET)", cu);
        schemaAnnotation.setAttributeFormDefault(null);
        schemaAnnotation = (XmlSchemaAnnotation)packageResource.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        XmlSchemaAnnotationTests.assertNull((Object)schemaAnnotation.getAttributeFormDefault());
        this.assertSourceDoesNotContain("@XmlSchema(", cu);
        schemaAnnotation = (XmlSchemaAnnotation)packageResource.addAnnotation("javax.xml.bind.annotation.XmlSchema");
        schemaAnnotation.setAttributeFormDefault(XmlNsForm.QUALIFIED);
        XmlSchemaAnnotationTests.assertEquals((Object)XmlNsForm.QUALIFIED, (Object)schemaAnnotation.getAttributeFormDefault());
        this.assertSourceContains("@XmlSchema(attributeFormDefault = QUALIFIED)", cu);
    }

    public void testElementFormDefault() throws Exception {
        ICompilationUnit cu = this.createPackageInfoWithSchemaAndElementFormDefault();
        JavaResourcePackage packageResource = this.buildJavaResourcePackage(cu);
        XmlSchemaAnnotation schemaAnnotation = (XmlSchemaAnnotation)packageResource.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        XmlSchemaAnnotationTests.assertTrue((schemaAnnotation != null ? 1 : 0) != 0);
        XmlSchemaAnnotationTests.assertEquals((Object)XmlNsForm.QUALIFIED, (Object)schemaAnnotation.getElementFormDefault());
        this.assertSourceContains("@XmlSchema(elementFormDefault = XmlNsForm.QUALIFIED)", cu);
        schemaAnnotation.setElementFormDefault(XmlNsForm.UNQUALIFIED);
        XmlSchemaAnnotationTests.assertEquals((Object)XmlNsForm.UNQUALIFIED, (Object)schemaAnnotation.getElementFormDefault());
        this.assertSourceContains("@XmlSchema(elementFormDefault = UNQUALIFIED)", cu);
        schemaAnnotation.setElementFormDefault(XmlNsForm.UNSET);
        XmlSchemaAnnotationTests.assertEquals((Object)XmlNsForm.UNSET, (Object)schemaAnnotation.getElementFormDefault());
        this.assertSourceContains("@XmlSchema(elementFormDefault = UNSET)", cu);
        schemaAnnotation.setElementFormDefault(null);
        schemaAnnotation = (XmlSchemaAnnotation)packageResource.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        XmlSchemaAnnotationTests.assertNull((Object)schemaAnnotation.getElementFormDefault());
        this.assertSourceDoesNotContain("@XmlSchema(", cu);
        schemaAnnotation = (XmlSchemaAnnotation)packageResource.addAnnotation("javax.xml.bind.annotation.XmlSchema");
        schemaAnnotation.setElementFormDefault(XmlNsForm.QUALIFIED);
        XmlSchemaAnnotationTests.assertEquals((Object)XmlNsForm.QUALIFIED, (Object)schemaAnnotation.getElementFormDefault());
        this.assertSourceContains("@XmlSchema(elementFormDefault = QUALIFIED)", cu);
    }

    public void testLocation() throws Exception {
        ICompilationUnit cu = this.createPackageInfoWithSchemaAndLocation();
        JavaResourcePackage packageResource = this.buildJavaResourcePackage(cu);
        XmlSchemaAnnotation schemaAnnotation = (XmlSchemaAnnotation)packageResource.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        XmlSchemaAnnotationTests.assertNotNull((Object)schemaAnnotation.getLocation());
        schemaAnnotation.setLocation(null);
        schemaAnnotation = (XmlSchemaAnnotation)packageResource.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        XmlSchemaAnnotationTests.assertNull((Object)schemaAnnotation.getLocation());
        this.assertSourceDoesNotContain("@XmlSchema(", cu);
        schemaAnnotation = (XmlSchemaAnnotation)packageResource.addAnnotation("javax.xml.bind.annotation.XmlSchema");
        schemaAnnotation.setLocation(TEST_LOCATION);
        XmlSchemaAnnotationTests.assertEquals((String)TEST_LOCATION, (String)schemaAnnotation.getLocation());
        this.assertSourceContains("@XmlSchema(location = \"http://www.eclipse.org/test/schema.xsd\")", cu);
    }

    public void testNamespace() throws Exception {
        ICompilationUnit cu = this.createPackageInfoWithSchemaAndNamespace();
        JavaResourcePackage packageResource = this.buildJavaResourcePackage(cu);
        XmlSchemaAnnotation schemaAnnotation = (XmlSchemaAnnotation)packageResource.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        XmlSchemaAnnotationTests.assertNotNull((Object)schemaAnnotation.getNamespace());
        schemaAnnotation.setNamespace(null);
        schemaAnnotation = (XmlSchemaAnnotation)packageResource.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        XmlSchemaAnnotationTests.assertNull((Object)schemaAnnotation.getNamespace());
        this.assertSourceDoesNotContain("@XmlSchema(", cu);
        schemaAnnotation = (XmlSchemaAnnotation)packageResource.addAnnotation("javax.xml.bind.annotation.XmlSchema");
        schemaAnnotation.setNamespace(TEST_NAMESPACE);
        XmlSchemaAnnotationTests.assertEquals((String)TEST_NAMESPACE, (String)schemaAnnotation.getNamespace());
        this.assertSourceContains("@XmlSchema(namespace = \"http://www.eclipse.org/test/schema\")", cu);
    }

    public void testXmlnsNamespace() throws Exception {
        ICompilationUnit cu = this.createPackageInfoWithSchemaAndXmlnsWithNamespace();
        JavaResourcePackage packageResource = this.buildJavaResourcePackage(cu);
        XmlSchemaAnnotation schemaAnnotation = (XmlSchemaAnnotation)packageResource.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        XmlNsAnnotation xmlnsAnnotation = schemaAnnotation.xmlnsAt(0);
        XmlSchemaAnnotationTests.assertNotNull((Object)xmlnsAnnotation.getNamespaceURI());
        xmlnsAnnotation.setNamespaceURI(null);
        XmlSchemaAnnotationTests.assertNull((Object)xmlnsAnnotation.getNamespaceURI());
        this.assertSourceContains("@XmlSchema(xmlns = @XmlNs)", cu);
        xmlnsAnnotation.setNamespaceURI(TEST_NAMESPACE_2);
        XmlSchemaAnnotationTests.assertEquals((String)TEST_NAMESPACE_2, (String)xmlnsAnnotation.getNamespaceURI());
        this.assertSourceContains("@XmlSchema(xmlns = @XmlNs(namespaceURI = \"http://www.eclipse.org/test/schema2\"))", cu);
    }

    public void testXmlnsPrefix() throws Exception {
        ICompilationUnit cu = this.createPackageInfoWithSchemaAndXmlnsWithPrefix();
        JavaResourcePackage packageResource = this.buildJavaResourcePackage(cu);
        XmlSchemaAnnotation schemaAnnotation = (XmlSchemaAnnotation)packageResource.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        XmlNsAnnotation xmlnsAnnotation = schemaAnnotation.xmlnsAt(0);
        XmlSchemaAnnotationTests.assertNotNull((Object)xmlnsAnnotation.getPrefix());
        xmlnsAnnotation.setPrefix(null);
        XmlSchemaAnnotationTests.assertNull((Object)xmlnsAnnotation.getPrefix());
        this.assertSourceContains("@XmlSchema(xmlns = @XmlNs)", cu);
        xmlnsAnnotation.setPrefix(TEST_PREFIX_2);
        XmlSchemaAnnotationTests.assertEquals((String)TEST_PREFIX_2, (String)xmlnsAnnotation.getPrefix());
        this.assertSourceContains("@XmlSchema(xmlns = @XmlNs(prefix = \"ts2\"))", cu);
    }

    public void testXmlns() throws Exception {
        ICompilationUnit cu = this.createPackageInfoWithSchemaAndXmlns();
        JavaResourcePackage packageResource = this.buildJavaResourcePackage(cu);
        XmlSchemaAnnotation schemaAnnotation = (XmlSchemaAnnotation)packageResource.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        XmlSchemaAnnotationTests.assertFalse((boolean)CollectionTools.isEmpty((Iterable)schemaAnnotation.getXmlns()));
        XmlSchemaAnnotationTests.assertEquals((int)1, (int)schemaAnnotation.getXmlnsSize());
        schemaAnnotation.addXmlns(1);
        XmlSchemaAnnotationTests.assertEquals((int)2, (int)schemaAnnotation.getXmlnsSize());
        this.assertSourceContains("@XmlSchema(xmlns = {@XmlNs,@XmlNs})", cu);
        XmlNsAnnotation xmlnsAnnotation1 = schemaAnnotation.xmlnsAt(0);
        xmlnsAnnotation1.setNamespaceURI(TEST_NAMESPACE);
        xmlnsAnnotation1.setPrefix(TEST_PREFIX);
        XmlNsAnnotation xmlnsAnnotation2 = schemaAnnotation.xmlnsAt(1);
        xmlnsAnnotation2.setNamespaceURI(TEST_NAMESPACE_2);
        xmlnsAnnotation2.setPrefix(TEST_PREFIX_2);
        this.assertSourceContains("@XmlSchema(xmlns = {@XmlNs(namespaceURI = \"http://www.eclipse.org/test/schema\", prefix = \"ts\"),@XmlNs(namespaceURI = \"http://www.eclipse.org/test/schema2\", prefix = \"ts2\")})", cu);
        schemaAnnotation.moveXmlns(0, 1);
        this.assertSourceContains("@XmlSchema(xmlns = {@XmlNs(namespaceURI = \"http://www.eclipse.org/test/schema2\", prefix = \"ts2\"),@XmlNs(namespaceURI = \"http://www.eclipse.org/test/schema\", prefix = \"ts\")})", cu);
        schemaAnnotation.removeXmlns(1);
        XmlSchemaAnnotationTests.assertEquals((int)1, (int)schemaAnnotation.getXmlnsSize());
        this.assertSourceContains("@XmlSchema(xmlns = @XmlNs(namespaceURI = \"http://www.eclipse.org/test/schema2\", prefix = \"ts2\"))", cu);
    }
}

