/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.formatter;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import junit.framework.Test;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.formatter.CodeFormatter;
import org.eclipse.wst.jsdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.wst.jsdt.core.tests.formatter.DecodeCodeFormatterPreferences;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.formatter.DefaultCodeFormatter;
import org.eclipse.wst.jsdt.internal.formatter.DefaultCodeFormatterOptions;

public class FormatterRegressionTests
extends AbstractJavaModelTests {
    public static final int UNKNOWN_KIND = 0;
    public static final String IN = "_in";
    public static final String OUT = "_out";
    public static final boolean DEBUG = false;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private long time;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.formatter.FormatterRegressionTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return FormatterRegressionTests.buildModelTestSuite(clazz);
    }

    public FormatterRegressionTests(String name) {
        super(name);
    }

    protected String getPluginDirectoryPath() {
        try {
            URL platformURL = Platform.getBundle((String)"org.eclipse.wst.jsdt.core.tests.model").getEntry("/");
            return new File(FileLocator.toFileURL((URL)platformURL).getFile()).getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getResource(String packageName, String resourceName) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = workspaceRoot.findMember((IPath)new Path("/Formatter/" + packageName + "/" + resourceName));
        FormatterRegressionTests.assertNotNull((String)"No resource found", (Object)resource);
        return resource.getLocation().toOSString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getZipEntryContents(String fileName, String zipEntryName) {
        ZipFile zipFile = null;
        BufferedInputStream inputStream = null;
        try {
            String string;
            try {
                zipFile = new ZipFile(fileName);
                ZipEntry zipEntry = zipFile.getEntry(zipEntryName);
                inputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                string = new String(org.eclipse.wst.jsdt.internal.compiler.util.Util.getInputStreamAsCharArray((InputStream)inputStream, (int)-1, null));
                Object var6_7 = null;
            }
            catch (IOException iOException) {}
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (zipFile == null) return string;
                zipFile.close();
                return string;
            }
            catch (IOException iOException) {}
            return string;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {}
            catch (IOException iOException) {}
            if (inputStream != null) {
                inputStream.close();
            }
            if (zipFile == null) throw throwable;
            zipFile.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return null;
        }
        if (inputStream != null) {
            inputStream.close();
        }
        if (zipFile == null) return null;
        zipFile.close();
        return null;
    }

    public String getSourceWorkspacePath() {
        return String.valueOf(this.getPluginDirectoryPath()) + File.separator + "workspace";
    }

    private String runFormatter(CodeFormatter codeFormatter, String source, int kind, int indentationLevel, int offset, int length, String lineSeparator) {
        TextEdit edit = codeFormatter.format(kind, source, offset, length, indentationLevel, lineSeparator);
        if (edit == null) {
            return null;
        }
        String result = org.eclipse.wst.jsdt.internal.core.util.Util.editedString((String)source, (TextEdit)edit);
        if (length == source.length()) {
            edit = codeFormatter.format(kind, result, 0, result.length(), indentationLevel, lineSeparator);
            if (edit == null) {
                return null;
            }
            String result2 = org.eclipse.wst.jsdt.internal.core.util.Util.editedString((String)result, (TextEdit)edit);
            if (!result.equals(result2)) {
                this.assertSourceEquals("Different reformatting", Util.convertToIndependantLineDelimiter((String)result), Util.convertToIndependantLineDelimiter((String)result2));
            }
        }
        return result;
    }

    public void setUpSuite() throws Exception {
        IWorkspaceDescription description = this.getWorkspace().getDescription();
        if (description.isAutoBuilding()) {
            description.setAutoBuilding(false);
            this.getWorkspace().setDescription(description);
        }
        this.setUpJavaProject("Formatter");
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject("Formatter");
        super.tearDown();
    }

    private String getIn(String compilationUnitName) {
        FormatterRegressionTests.assertNotNull((Object)compilationUnitName);
        int dotIndex = compilationUnitName.indexOf(46);
        FormatterRegressionTests.assertTrue((dotIndex != -1 ? 1 : 0) != 0);
        return String.valueOf(compilationUnitName.substring(0, dotIndex)) + IN + compilationUnitName.substring(dotIndex);
    }

    private String getOut(String compilationUnitName) {
        FormatterRegressionTests.assertNotNull((Object)compilationUnitName);
        int dotIndex = compilationUnitName.indexOf(46);
        FormatterRegressionTests.assertTrue((dotIndex != -1 ? 1 : 0) != 0);
        return String.valueOf(compilationUnitName.substring(0, dotIndex)) + OUT + compilationUnitName.substring(dotIndex);
    }

    private void assertLineEquals(String actualContents, String originalSource, String expectedContents, boolean checkNull) {
        if (actualContents == null) {
            FormatterRegressionTests.assertTrue((String)"actualContents is null", (boolean)checkNull);
            FormatterRegressionTests.assertEquals((String)expectedContents, (String)originalSource);
            return;
        }
        this.assertSourceEquals("Different number of length", Util.convertToIndependantLineDelimiter((String)expectedContents), actualContents);
    }

    private void runTest(String packageName, String compilationUnitName) {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, packageName, compilationUnitName, 8, 0);
    }

    private void runTest(CodeFormatter codeFormatter, String packageName, String compilationUnitName) {
        this.runTest(codeFormatter, packageName, compilationUnitName, 8, 0);
    }

    private void runTest(String packageName, String compilationUnitName, int kind) {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, packageName, compilationUnitName, kind, 0);
    }

    private void runTest(CodeFormatter codeFormatter, String packageName, String compilationUnitName, int kind) {
        this.runTest(codeFormatter, packageName, compilationUnitName, kind, 0, false, 0, -1);
    }

    private void runTest(CodeFormatter codeFormatter, String packageName, String compilationUnitName, int kind, boolean checkNull) {
        this.runTest(codeFormatter, packageName, compilationUnitName, kind, 0, checkNull, 0, -1);
    }

    private void runTest(CodeFormatter codeFormatter, String packageName, String compilationUnitName, int kind, int indentationLevel) {
        this.runTest(codeFormatter, packageName, compilationUnitName, kind, indentationLevel, false, 0, -1);
    }

    private void runTest(CodeFormatter codeFormatter, String packageName, String compilationUnitName, int kind, int indentationLevel, boolean checkNull, int offset, int length) {
        this.runTest(codeFormatter, packageName, compilationUnitName, kind, indentationLevel, checkNull, offset, length, null);
    }

    private void runTest(String input, String output, CodeFormatter codeFormatter, int kind, int indentationLevel, boolean checkNull, int offset, int length, String lineSeparator) {
        String result = length == -1 ? this.runFormatter(codeFormatter, input, kind, indentationLevel, offset, input.length(), lineSeparator) : this.runFormatter(codeFormatter, input, kind, indentationLevel, offset, length, lineSeparator);
        this.assertLineEquals(result, input, output, checkNull);
    }

    private void runTest(String source, String expectedResult, CodeFormatter codeFormatter, int kind, int indentationLevel, boolean checkNull, int offset, int length) {
        String result = length == -1 ? this.runFormatter(codeFormatter, source, kind, indentationLevel, offset, source.length(), null) : this.runFormatter(codeFormatter, source, kind, indentationLevel, offset, length, null);
        this.assertLineEquals(result, source, expectedResult, checkNull);
    }

    private void runTest(CodeFormatter codeFormatter, String packageName, String compilationUnitName, int kind, int indentationLevel, boolean checkNull, int offset, int length, String lineSeparator) {
        try {
            IJavaScriptUnit sourceUnit = this.getCompilationUnit("Formatter", "", packageName, this.getIn(compilationUnitName));
            String s = sourceUnit.getSource();
            FormatterRegressionTests.assertNotNull((Object)s);
            IJavaScriptUnit outputUnit = this.getCompilationUnit("Formatter", "", packageName, this.getOut(compilationUnitName));
            FormatterRegressionTests.assertNotNull((Object)outputUnit);
            String result = length == -1 ? this.runFormatter(codeFormatter, s, kind, indentationLevel, offset, s.length(), lineSeparator) : this.runFormatter(codeFormatter, s, kind, indentationLevel, offset, length, lineSeparator);
            this.assertLineEquals(result, s, outputUnit.getSource(), checkNull);
        }
        catch (JavaScriptModelException e) {
            e.printStackTrace();
            FormatterRegressionTests.assertTrue((boolean)false);
        }
    }

    String getSource(ASTNode astNode, char[] source) {
        String result = new String(CharOperation.subarray((char[])source, (int)(astNode.getStartPosition() + 1), (int)(astNode.getStartPosition() + astNode.getLength() - 1)));
        if (result.endsWith("\\n")) {
            return String.valueOf(result.substring(0, result.length() - 2)) + LINE_SEPARATOR;
        }
        return result;
    }

    public void _test000() {
        this.runTest("test002", "A.js");
    }

    public void test001() {
        this.runTest("test001", "A.js");
    }

    public void _test002() {
        this.runTest("test002", "A.js");
    }

    public void _test003() {
        this.runTest("test003", "A.js");
    }

    public void _test004() {
        this.runTest("test004", "A.js");
    }

    public void _test005() {
        this.runTest("test005", "A.js");
    }

    public void _test006() {
        this.runTest("test006", "A.js");
    }

    public void _test007() {
        this.runTest("test007", "A.js");
    }

    public void _test008() {
        this.runTest("test008", "A.js");
    }

    public void test009() {
        this.runTest("test009", "A.js");
    }

    public void test010() {
        this.runTest("test010", "A.js");
    }

    public void _test011() {
        this.runTest("test011", "A.js");
    }

    public void test012() {
        this.runTest("test012", "A.js");
    }

    public void _test013() {
        this.runTest("test013", "A.js");
    }

    public void _test014() {
        this.runTest("test014", "A.js");
    }

    public void _test015() {
        this.runTest("test015", "A.js");
    }

    public void _test016() {
        this.runTest("test016", "A.js");
    }

    public void _test017() {
        this.runTest("test017", "A.js");
    }

    public void _test018() {
        this.runTest("test018", "A.js");
    }

    public void _test019() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test019", "A_1.js");
        preferences.tab_char = 2;
        codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test019", "A_2.js");
    }

    public void _test020() {
        this.runTest("test020", "A.js");
    }

    public void _test021() {
        this.runTest("test021", "A.js");
    }

    public void _test022() {
        this.runTest("test022", "A.js");
    }

    public void _test023() {
        this.runTest("test023", "A.js");
    }

    public void _test024() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.keep_simple_if_on_one_line = true;
        preferences.keep_then_statement_on_same_line = true;
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test024", "A.js");
    }

    public void _test025() {
        this.runTest("test025", "A.js");
    }

    public void _test026() {
        this.runTest("test026", "A.js");
    }

    public void _test027() {
        this.runTest("test027", "A.js");
    }

    public void _test028() {
        this.runTest("test028", "A.js");
    }

    public void _test029() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.keep_simple_if_on_one_line = true;
        preferences.keep_then_statement_on_same_line = true;
        preferences.keep_guardian_clause_on_one_line = true;
        preferences.tab_char = 1;
        preferences.compact_else_if = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test029", "A.js");
    }

    public void _test030() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.keep_simple_if_on_one_line = true;
        preferences.keep_then_statement_on_same_line = true;
        preferences.keep_guardian_clause_on_one_line = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test030", "A.js");
    }

    public void _test031() {
        this.runTest("test031", "A.js");
    }

    public void _test032() {
        this.runTest("test032", "A.js");
    }

    public void _test033() {
        this.runTest("test033", "A.js");
    }

    public void _test034() {
        this.runTest("test034", "A.js");
    }

    public void _test035() {
        this.runTest("test035", "A.js");
    }

    public void _test036() {
        this.runTest("test036", "A.js");
    }

    public void _test037() {
        this.runTest("test037", "A.js");
    }

    public void _test038() {
        this.runTest("test038", "A.js");
    }

    public void _test039() {
        this.runTest("test039", "A.js");
    }

    public void _test040() {
        this.runTest("test040", "A.js");
    }

    public void _test041() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_new_line_in_empty_type_declaration = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test041", "A.js");
    }

    public void _test042() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.insert_new_line_in_empty_type_declaration = false;
        preferences.insert_space_before_opening_brace_in_block = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test042", "A.js");
    }

    public void _test043() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_new_line_in_empty_type_declaration = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test043", "A.js");
    }

    public void _test044() {
        this.runTest("test044", "A.js");
    }

    public void _test045() {
        this.runTest("test045", "A.js");
    }

    public void test046() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_assignment_operator = false;
        preferences.insert_space_before_assignment_operator = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test046", "A.js", 1);
    }

    public void test047() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_assignment_operator = true;
        preferences.insert_space_before_assignment_operator = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test047", "A.js", 2, 2);
    }

    public void test048() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_assignment_operator = true;
        preferences.insert_space_before_assignment_operator = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test048", "A.js", 2);
    }

    public void _test049() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_assignment_operator = true;
        preferences.insert_space_before_assignment_operator = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test049", "A.js", 4);
    }

    public void test050() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_binary_operator = false;
        preferences.insert_space_before_unary_operator = false;
        preferences.insert_space_after_unary_operator = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test050", "A.js", 1);
    }

    public void _test051() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_assignment_operator = true;
        preferences.insert_space_before_assignment_operator = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test051", "A.js", 4);
    }

    public void _test052() {
        this.runTest("test052", "A.js");
    }

    public void _test053() {
        this.runTest("test053", "A.js");
    }

    public void _test054() {
        this.runTest("test054", "A.js");
    }

    public void _test055() {
        this.runTest("test055", "A.js", 4);
    }

    public void test056() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.keep_simple_if_on_one_line = true;
        preferences.keep_then_statement_on_same_line = true;
        preferences.keep_else_statement_on_same_line = true;
        preferences.keep_guardian_clause_on_one_line = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test056", "A.js", 2);
    }

    public void _test057() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)1, (int)0));
        FormatterRegressionTests.assertEquals((boolean)false, (boolean)DefaultCodeFormatterConstants.getForceWrapping((String)((String)options.get("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer"))));
        FormatterRegressionTests.assertEquals((int)1, (int)DefaultCodeFormatterConstants.getWrappingStyle((String)((String)options.get("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer"))));
        FormatterRegressionTests.assertEquals((int)0, (int)DefaultCodeFormatterConstants.getIndentStyle((String)((String)options.get("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer"))));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.align_type_members_on_columns = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test057", "A.js");
    }

    public void _test058() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)1, (int)0));
        FormatterRegressionTests.assertEquals((boolean)false, (boolean)DefaultCodeFormatterConstants.getForceWrapping((String)((String)options.get("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer"))));
        FormatterRegressionTests.assertEquals((int)1, (int)DefaultCodeFormatterConstants.getWrappingStyle((String)((String)options.get("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer"))));
        FormatterRegressionTests.assertEquals((int)0, (int)DefaultCodeFormatterConstants.getIndentStyle((String)((String)options.get("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer"))));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.align_type_members_on_columns = true;
        preferences.tab_char = 2;
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.blank_lines_between_import_groups = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test058", "A.js");
    }

    public void _test059() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.align_type_members_on_columns = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test059", "Parser.js");
    }

    public void _test060() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.align_type_members_on_columns = false;
        preferences.tab_char = 2;
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.blank_lines_between_import_groups = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test060", "Parser.js");
    }

    public void _test061() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.blank_lines_between_import_groups = 0;
        preferences.align_type_members_on_columns = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test061", "Parser.js");
    }

    public void test062() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_assignment_operator = true;
        preferences.insert_space_before_assignment_operator = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test062", "A.js", 2);
    }

    public void _test063() {
        this.runTest("test063", "A.js");
    }

    public void _test064() {
        this.runTest("test064", "A.js");
    }

    public void _test065() {
        this.runTest("test065", "A.js");
    }

    public void _test066() {
        this.runTest("test066", "A.js");
    }

    public void _test067() {
        this.runTest("test067", "A.js");
    }

    public void _test068() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_arguments_in_allocation_expression", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)3, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test068", "A.js", 4);
    }

    public void _test069() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.blank_lines_before_first_class_body_declaration = 1;
        preferences.blank_lines_before_method = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test069", "A.js");
    }

    public void _test070() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 2;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test070", "A.js", 4);
    }

    public void _test071() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.indent_body_declarations_compare_to_type_header = false;
        preferences.brace_position_for_type_declaration = "next_line";
        preferences.align_type_members_on_columns = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test071", "A.js");
    }

    public void _test072() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.number_of_empty_lines_to_preserve = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test072", "A.js");
    }

    public void _test073() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.keep_simple_if_on_one_line = true;
        preferences.keep_then_statement_on_same_line = true;
        preferences.keep_guardian_clause_on_one_line = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test073", "A.js");
    }

    public void _test074() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.insert_new_line_before_catch_in_try_statement = true;
        preferences.insert_new_line_before_else_in_if_statement = true;
        preferences.insert_new_line_before_finally_in_try_statement = true;
        preferences.insert_new_line_before_while_in_do_statement = true;
        preferences.keep_simple_if_on_one_line = false;
        preferences.keep_then_statement_on_same_line = false;
        preferences.keep_else_statement_on_same_line = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test074", "A.js");
    }

    public void _test075() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_method_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)1));
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_constructor_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)1));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.page_width = 57;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test075", "A.js", 4);
    }

    public void _test076() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)3, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test076", "A.js", 2);
    }

    public void _test077() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_method_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)0));
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_constructor_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test077", "A.js", 4);
    }

    public void _test078() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.brace_position_for_type_declaration = "next_line";
        preferences.brace_position_for_block = "next_line";
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test078", "A.js");
    }

    public void _test079() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test079", "A.js", 2);
    }

    public void _test080() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_method_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)1, (int)0));
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_constructor_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)1, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.continuation_indentation = 2;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test080", "A.js", 4);
    }

    public void _test081() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)3, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test081", "A.js", 4);
    }

    public void _test082() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.number_of_empty_lines_to_preserve = 2;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test082", "A.js", 4);
    }

    public void _test083() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test083", "A.js", 4);
    }

    public void _test084() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.insert_space_before_opening_paren_in_if = false;
        preferences.insert_space_before_opening_paren_in_for = false;
        preferences.insert_space_before_opening_paren_in_while = false;
        preferences.keep_simple_if_on_one_line = true;
        preferences.keep_then_statement_on_same_line = true;
        preferences.keep_guardian_clause_on_one_line = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test084", "A.js");
    }

    public void _test085() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.insert_space_before_opening_paren_in_if = true;
        preferences.insert_space_before_opening_paren_in_for = true;
        preferences.insert_space_before_opening_paren_in_while = true;
        preferences.keep_simple_if_on_one_line = true;
        preferences.keep_then_statement_on_same_line = true;
        preferences.keep_guardian_clause_on_one_line = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test085", "A.js");
    }

    public void _test086() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_new_line_before_catch_in_try_statement = true;
        preferences.insert_new_line_before_else_in_if_statement = true;
        preferences.insert_new_line_before_finally_in_try_statement = true;
        preferences.insert_new_line_before_while_in_do_statement = true;
        preferences.brace_position_for_block = "next_line";
        preferences.brace_position_for_type_declaration = "next_line";
        preferences.brace_position_for_method_declaration = "next_line";
        preferences.insert_space_before_binary_operator = false;
        preferences.insert_space_after_binary_operator = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test086", "A.js");
    }

    public void test087() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.keep_simple_if_on_one_line = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test087", "A.js", 2);
    }

    public void test088() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.keep_simple_if_on_one_line = false;
        preferences.keep_guardian_clause_on_one_line = false;
        preferences.keep_then_statement_on_same_line = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test088", "A.js", 2);
    }

    public void test089() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_opening_paren_in_parenthesized_expression = true;
        preferences.insert_space_before_closing_paren_in_parenthesized_expression = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test089", "A.js", 2);
    }

    public void test090() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_opening_bracket_in_array_reference = true;
        preferences.insert_space_before_closing_bracket_in_array_reference = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test090", "A.js", 2);
    }

    public void _test091() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_assignment_operator = false;
        preferences.insert_space_before_assignment_operator = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test091", "A.js", 2);
    }

    public void test092() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_binary_operator = false;
        preferences.insert_space_before_binary_operator = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test092", "A.js", 2);
    }

    public void _test093() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_closing_paren_in_cast = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test093", "A.js", 2);
    }

    public void _test094() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_assignment_operator = false;
        preferences.insert_space_before_assignment_operator = false;
        preferences.insert_space_after_comma_in_method_invocation_arguments = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test094", "A.js", 2);
    }

    public void test095() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.brace_position_for_block = "next_line_shifted";
        preferences.indent_statements_compare_to_block = false;
        preferences.indent_statements_compare_to_body = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test095", "A.js", 2);
    }

    public void _test096() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test096", "A.js", 4);
    }

    public void _test097() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_opening_paren_in_method_invocation = true;
        preferences.insert_space_before_closing_paren_in_method_invocation = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test097", "A.js", 2);
    }

    public void _test098() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.brace_position_for_anonymous_type_declaration = "next_line";
        preferences.brace_position_for_method_declaration = "next_line";
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test098", "A.js", 2);
    }

    public void _test099() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_before_opening_paren_in_method_declaration = true;
        preferences.insert_space_before_opening_paren_in_for = true;
        preferences.insert_space_after_semicolon_in_for = false;
        preferences.put_empty_statement_on_new_line = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test099", "A.js", 4);
    }

    public void test100_B() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_before_assignment_operator = false;
        preferences.insert_space_after_assignment_operator = false;
        preferences.insert_space_after_comma_in_array_initializer = false;
        preferences.number_of_empty_lines_to_preserve = 1;
        preferences.insert_space_after_opening_brace_in_array_initializer = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test100", "B.js", 8);
    }

    public void test100_C() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_before_assignment_operator = false;
        preferences.insert_space_after_assignment_operator = false;
        preferences.insert_space_after_comma_in_array_initializer = false;
        preferences.number_of_empty_lines_to_preserve = 1;
        preferences.insert_space_before_closing_brace_in_array_initializer = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test100", "C.js", 8);
    }

    public void test100_D() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_before_assignment_operator = false;
        preferences.insert_space_after_assignment_operator = false;
        preferences.insert_space_after_comma_in_array_initializer = false;
        preferences.number_of_empty_lines_to_preserve = 1;
        preferences.insert_space_before_comma_in_array_initializer = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test100", "D.js", 8);
    }

    public void test100_E() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_before_assignment_operator = false;
        preferences.insert_space_after_assignment_operator = false;
        preferences.number_of_empty_lines_to_preserve = 1;
        preferences.insert_space_after_comma_in_array_initializer = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test100", "E.js", 8);
    }

    public void test100_F() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_before_assignment_operator = false;
        preferences.insert_space_after_assignment_operator = false;
        preferences.insert_space_after_comma_in_array_initializer = false;
        preferences.number_of_empty_lines_to_preserve = 1;
        preferences.insert_space_between_empty_braces_in_array_initializer = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test100", "F.js", 8);
    }

    public void test100_G() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_before_assignment_operator = false;
        preferences.insert_space_after_assignment_operator = false;
        preferences.number_of_empty_lines_to_preserve = 1;
        preferences.insert_space_after_opening_brace_in_array_initializer = true;
        preferences.insert_space_before_closing_brace_in_array_initializer = true;
        preferences.insert_space_before_comma_in_array_initializer = true;
        preferences.insert_space_after_comma_in_array_initializer = true;
        preferences.insert_space_between_empty_braces_in_array_initializer = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test100", "G.js", 8);
    }

    public void _test101() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test101", "A.js", 4);
    }

    public void _test102() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.number_of_empty_lines_to_preserve = 1;
        preferences.line_separator = "\n";
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test102", "A.js");
    }

    public void test103() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test103", "A.js", 2);
    }

    public void test104() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_opening_paren_in_if = true;
        preferences.insert_space_before_closing_paren_in_if = true;
        preferences.brace_position_for_block = "next_line_shifted";
        preferences.insert_new_line_before_catch_in_try_statement = true;
        preferences.insert_new_line_before_else_in_if_statement = true;
        preferences.insert_new_line_before_finally_in_try_statement = true;
        preferences.insert_new_line_before_while_in_do_statement = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test104", "A.js", 2);
    }

    public void _test105() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.brace_position_for_method_declaration = "next_line";
        preferences.brace_position_for_type_declaration = "next_line";
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test105", "A.js", 2);
    }

    public void _test106() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test106", "A.js", 2);
    }

    public void _test107() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.keep_then_statement_on_same_line = false;
        preferences.keep_simple_if_on_one_line = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test107", "A.js", 2);
    }

    public void _test108() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test108", "A.js");
    }

    public void _test109() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.blank_lines_before_package = 2;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test109", "A.js");
    }

    public void _test110() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.blank_lines_before_package = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test110", "A.js");
    }

    public void _test111() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.blank_lines_after_package = 1;
        preferences.blank_lines_before_first_class_body_declaration = 1;
        preferences.blank_lines_before_new_chunk = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test111", "A.js");
    }

    public void _test112() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.blank_lines_after_package = 1;
        preferences.blank_lines_before_first_class_body_declaration = 1;
        preferences.blank_lines_before_new_chunk = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test112", "A.js");
    }

    public void _test113() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_arguments_in_method_invocation", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)1));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test113", "A.js");
    }

    public void _test114() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_method_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)1));
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_constructor_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)1));
        FormatterRegressionTests.assertEquals((boolean)false, (boolean)DefaultCodeFormatterConstants.getForceWrapping((String)((String)options.get("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_constructor_declaration"))));
        FormatterRegressionTests.assertEquals((int)5, (int)DefaultCodeFormatterConstants.getWrappingStyle((String)((String)options.get("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_constructor_declaration"))));
        FormatterRegressionTests.assertEquals((int)1, (int)DefaultCodeFormatterConstants.getIndentStyle((String)((String)options.get("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_constructor_declaration"))));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 2;
        preferences.page_width = 57;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test114", "A.js", 4);
    }

    public void _test115() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_method_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)1));
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_constructor_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)1));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.page_width = 57;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test115", "A.js", 4);
    }

    public void _test116() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_method_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)1));
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_constructor_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)1));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.page_width = 57;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test116", "A.js", 4);
    }

    public void _test117() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test117", "A.js", 8);
    }

    public void _test118() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test118", "A.js");
    }

    public void _test119() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test119", "A.js", 2);
    }

    public void _test120() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test120", "A.js");
    }

    public void test121() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test121", "A.js", 2);
    }

    public void test122() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test122", "A.js", 0);
    }

    public void _test123() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test123", "A.js", 0);
    }

    public void _test124() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_method_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)1));
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_constructor_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)1));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.page_width = 57;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test124", "A.js", 0);
    }

    public void test125() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_binary_operator = false;
        preferences.insert_space_before_unary_operator = false;
        preferences.insert_space_after_unary_operator = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test125", "A.js", 0);
    }

    public void _test126() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test126", "A.js", 0, true);
    }

    public void _test127() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test127", "A.js", 0);
    }

    public void test128() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test128", "A.js", 0, true);
    }

    public void _test129() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test129", "A.js", 2, true);
    }

    public void _test130() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test130", "A.js", 8, true);
    }

    public void _test131() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test131", "A.js", 8, true);
    }

    public void _test132() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test132", "A.js", 4, true);
    }

    public void _test133() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.blank_lines_between_import_groups = 0;
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test133", "A.js", 8, true);
    }

    public void _test134() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test134", "A.js", 8, true);
    }

    public void _test135() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test135", "A.js", 2, true);
    }

    public void _test136() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test136", "A.js", 8, true);
    }

    public void _test137() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test137", "A.js", 8, true);
    }

    public void _test138() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test138", "A.js", 2, 2, true, 8, 37);
    }

    public void test139() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test139", "A.js", 2, 0, true, 0, 5);
    }

    public void _test140() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 2;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test140", "A.js", 8);
    }

    public void _test141() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 2;
        preferences.indent_switchstatements_compare_to_cases = false;
        preferences.indent_switchstatements_compare_to_switch = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test141", "A.js", 8);
    }

    public void _test142() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test142", "A.js", 4, 1);
    }

    public void _test143() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test143", "A.js", 4, 1);
    }

    public void _test144() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test144", "A.js", 4);
    }

    public void _test145() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test145", "A.js", 4);
    }

    public void _test146() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test146", "A.js", 4);
    }

    public void _test147() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_before_assignment_operator = false;
        preferences.number_of_empty_lines_to_preserve = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test147", "A.js", 8);
    }

    public void test148() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test148", "A.js", 2);
    }

    public void test149() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test149", "A.js", 2);
    }

    public void test150() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test150", "A.js", 2);
    }

    public void _test151() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test151", "A.js", 4);
    }

    public void _test152() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test152", "A.js", 2);
    }

    public void _test153() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.align_type_members_on_columns = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test153", "A.js");
    }

    public void _test154() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test154", "A.js");
    }

    public void _test155() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getJavaConventionsSettings());
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test155", "A.js", 2);
    }

    public void test156() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getJavaConventionsSettings());
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test156", "A.js", 2);
    }

    public void test157() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test157", "A.js", 2, 0, true, 11, 7);
    }

    public void test158() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test158", "A.js", 2, 0, true, 11, 8);
    }

    public void _test159() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test159", "A.js", 8);
    }

    public void _test160() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.insert_new_line_before_catch_in_try_statement = false;
        preferences.insert_new_line_before_else_in_if_statement = false;
        preferences.insert_new_line_before_finally_in_try_statement = false;
        preferences.insert_new_line_before_while_in_do_statement = false;
        preferences.compact_else_if = true;
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test160", "A.js", 4);
    }

    public void _test161() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.insert_new_line_before_catch_in_try_statement = false;
        preferences.insert_new_line_before_else_in_if_statement = false;
        preferences.insert_new_line_before_finally_in_try_statement = false;
        preferences.insert_new_line_before_while_in_do_statement = false;
        preferences.compact_else_if = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test161", "A.js", 4);
    }

    public void _test162() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.insert_new_line_before_catch_in_try_statement = true;
        preferences.insert_new_line_before_else_in_if_statement = true;
        preferences.insert_new_line_before_finally_in_try_statement = true;
        preferences.insert_new_line_before_while_in_do_statement = true;
        preferences.compact_else_if = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test162", "A.js", 4);
    }

    public void _test163() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.insert_new_line_before_catch_in_try_statement = true;
        preferences.insert_new_line_before_else_in_if_statement = true;
        preferences.insert_new_line_before_finally_in_try_statement = true;
        preferences.insert_new_line_before_while_in_do_statement = true;
        preferences.compact_else_if = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test163", "A.js", 4);
    }

    public void _test164() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test164", "A.js", 8);
    }

    public void _test165() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test165", "A.js", 8);
    }

    public void _test166() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test166", "A.js", 8);
    }

    public void _test167() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test167", "A.js", 8);
    }

    public void _test169() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test169", "A.js", 8);
    }

    public void _test170() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test170", "A.js", 8);
    }

    public void _test171() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        preferences.brace_position_for_anonymous_type_declaration = "end_of_line";
        preferences.brace_position_for_type_declaration = "end_of_line";
        preferences.brace_position_for_method_declaration = "end_of_line";
        preferences.brace_position_for_block = "end_of_line";
        preferences.brace_position_for_switch = "end_of_line";
        preferences.compact_else_if = false;
        preferences.insert_new_line_before_catch_in_try_statement = true;
        preferences.insert_new_line_before_else_in_if_statement = true;
        preferences.insert_new_line_before_finally_in_try_statement = true;
        preferences.insert_new_line_before_while_in_do_statement = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test171", "A.js", 4);
    }

    public void _test172() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.brace_position_for_anonymous_type_declaration = "end_of_line";
        preferences.brace_position_for_type_declaration = "end_of_line";
        preferences.brace_position_for_method_declaration = "end_of_line";
        preferences.brace_position_for_block = "end_of_line";
        preferences.brace_position_for_switch = "end_of_line";
        preferences.compact_else_if = false;
        preferences.insert_new_line_before_catch_in_try_statement = true;
        preferences.insert_new_line_before_else_in_if_statement = true;
        preferences.insert_new_line_before_finally_in_try_statement = true;
        preferences.insert_new_line_before_while_in_do_statement = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test172", "A.js", 4);
    }

    public void _test173() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        preferences.insert_new_line_in_empty_anonymous_type_declaration = false;
        preferences.insert_new_line_in_empty_type_declaration = false;
        preferences.insert_new_line_in_empty_method_body = false;
        preferences.insert_new_line_in_empty_block = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test173", "A.js", 4);
    }

    public void _test174() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_new_line_in_empty_anonymous_type_declaration = false;
        preferences.insert_new_line_in_empty_type_declaration = false;
        preferences.insert_new_line_in_empty_method_body = false;
        preferences.insert_new_line_in_empty_block = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test174", "A.js", 4);
    }

    public void _test175() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        preferences.insert_new_line_in_empty_anonymous_type_declaration = false;
        preferences.insert_new_line_in_empty_type_declaration = false;
        preferences.insert_new_line_in_empty_method_body = false;
        preferences.insert_new_line_in_empty_block = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test175", "A.js", 4);
    }

    public void _test176() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_new_line_in_empty_anonymous_type_declaration = false;
        preferences.insert_new_line_in_empty_type_declaration = false;
        preferences.insert_new_line_in_empty_method_body = true;
        preferences.insert_new_line_in_empty_block = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test176", "A.js", 4);
    }

    public void _test177() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_new_line_in_empty_anonymous_type_declaration = false;
        preferences.insert_new_line_in_empty_type_declaration = false;
        preferences.insert_new_line_in_empty_method_body = false;
        preferences.insert_new_line_in_empty_block = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test177", "A.js", 8);
    }

    public void _test178() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_new_line_in_empty_anonymous_type_declaration = false;
        preferences.insert_new_line_in_empty_type_declaration = true;
        preferences.insert_new_line_in_empty_method_body = false;
        preferences.insert_new_line_in_empty_block = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test178", "A.js", 8);
    }

    public void _test179() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_new_line_in_empty_anonymous_type_declaration = true;
        preferences.insert_new_line_in_empty_type_declaration = true;
        preferences.insert_new_line_in_empty_method_body = false;
        preferences.insert_new_line_in_empty_block = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test179", "A.js", 8);
    }

    public void _test180() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_new_line_in_empty_anonymous_type_declaration = false;
        preferences.insert_new_line_in_empty_type_declaration = false;
        preferences.insert_new_line_in_empty_method_body = false;
        preferences.insert_new_line_in_empty_block = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test180", "A.js", 8);
    }

    public void _test181() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test181", "A.js", 8);
    }

    public void _test182() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.number_of_empty_lines_to_preserve = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test182", "A.js", 8);
    }

    public void _test183() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.number_of_empty_lines_to_preserve = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test183", "A.js", 8);
    }

    public void _test184() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test184", "A.js", 8);
    }

    public void _test185() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test185", "A.js", 8);
    }

    public void _test186() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test186", "A.js", 8);
    }

    public void _test187() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.blank_lines_between_import_groups = 0;
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test187", "A.js", 8);
    }

    public void _test188() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test188", "A.js", 8);
    }

    public void _test189() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test189", "A.js", 8);
    }

    public void _test190() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test190", "A.js", 8);
    }

    public void _test191() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test191", "A.js", 8);
    }

    public void _test192() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)1, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.align_type_members_on_columns = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test192", "A.js");
    }

    public void _test193() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test193", "A.js", 2, true);
    }

    public void _test194() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test194", "A.js", 4, true);
    }

    public void _test195() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test195", "A.js", 4, true);
    }

    public void _test196() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test196", "A.js", 4, true);
    }

    public void _test197() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test197", "A.js", 4, true);
    }

    public void _test198() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test198", "A.js", 4, true);
    }

    public void _test199() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test199", "A.js", 4, true);
    }

    public void test201() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test201", "A.js", 2, true);
    }

    public void _test202() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test202", "A.js", 2, true);
    }

    public void _test203() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test203", "A.js", 2, true);
    }

    public void test204() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test204", "A.js", 2, true);
    }

    public void _test205() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "1");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test205", "A.js", 2, true);
    }

    public void _test206() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test206", "A.js", 2, true);
    }

    public void _test207() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test207", "A.js", 2, true);
    }

    public void _test208() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test208", "A.js", 4, true);
    }

    public void test209() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "1");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test209", "A.js", 4, true);
    }

    public void _test210() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "1");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test210", "A.js", 8, true);
    }

    public void _test211() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "1");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test211", "A.js", 8, 1);
    }

    public void _test212() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test212", "A.js", 4);
    }

    public void _test213() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test213", "A.js", 4);
    }

    public void _test214() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test214", "A.js", 2);
    }

    public void _test215() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test215", "A.js", 8);
    }

    public void _test216() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test216", "A.js", 8);
    }

    public void _test217() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test217", "A.js", 4);
    }

    public void _test218() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test218", "A.js", 4, 1);
    }

    public void _test219() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test219", "A.js", 4, 1);
    }

    public void _test220() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test220", "A.js", 4, 1);
    }

    public void _test221() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test221", "A.js", 4);
    }

    public void _test222() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test222", "A.js", 4);
    }

    public void _test223() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test223", "A.js", 2);
    }

    public void _test224() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test224", "A.js", 2);
    }

    public void _test225() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test225", "A.js", 2);
    }

    public void _test226() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test226", "A.js", 2);
    }

    public void _test227() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test227", "A.js", 2);
    }

    public void _test228() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test228", "A.js", 2);
    }

    public void _test229() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test229", "A.js", 2);
    }

    public void _test230() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test230", "A.js", 2);
    }

    public void _test231() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test231", "A.js", 4);
    }

    public void _test232() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test232", "A.js", 4);
    }

    public void _test233() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test233", "A.js", 4, 1);
    }

    public void _test234() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test234", "A.js", 8);
    }

    public void _test235() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test235", "A.js", 8);
    }

    public void _test236() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test236", "A.js", 8);
    }

    public void _test237() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test237", "A.js", 8);
    }

    public void _test238() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test238", "A.js", 4);
    }

    public void _test239() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test239", "A.js", 4);
    }

    public void _test240() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test240", "A.js", 4);
    }

    public void _test241() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test241", "A.js", 4);
    }

    public void _test242() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test242", "A.js", 4);
    }

    public void _test243() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test243", "A.js", 4);
    }

    public void _test244() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test244", "A.js", 4);
    }

    public void _test245() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test245", "A.js", 4);
    }

    public void _test246() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test246", "A.js", 4);
    }

    public void _test247() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test247", "A.js", 4);
    }

    public void _test248() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test248", "A.js", 4);
    }

    public void _test249() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test249", "A.js", 4);
    }

    public void _test250() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test250", "A.js", 4);
    }

    public void _test251() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test251", "A.js", 4);
    }

    public void _test252() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test252", "A.js", 4);
    }

    public void _test253() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test253", "A.js", 4);
    }

    public void _test254() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test254", "A.js", 4);
    }

    public void _test255() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test255", "A.js", 4);
    }

    public void test256() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test256", "A.js", 2);
    }

    public void test257() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test257", "A.js", 2);
    }

    public void _test258() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test258", "A.js", 8);
    }

    public void _test259() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test259", "A.js", 8);
    }

    public void _test260() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test260", "A.js", 8);
    }

    public void _test261() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test261", "A.js", 8);
    }

    public void _test262() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test262", "A.js", 8);
    }

    public void _test263() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test263", "A.js", 8);
    }

    public void _test264() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test264", "A.js", 8);
    }

    public void _test265() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test265", "A.js", 8);
    }

    public void test266() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test266", "A.js", 2);
    }

    public void test267() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test267", "A.js", 2);
    }

    public void _test268() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test268", "A.js", 4);
    }

    public void _test269() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test269", "A.js", 4);
    }

    public void _test270() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test270", "A.js", 8);
    }

    public void _test271() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test271", "A.js", 8);
    }

    public void _test272() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block_in_case", "next_line_shifted");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test272", "A.js", 8);
    }

    public void _test273() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block_in_case", "next_line_shifted");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test273", "A.js", 8);
    }

    public void _test274() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test274", "A.js", 4);
    }

    public void _test275() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test275", "A.js", 4);
    }

    public void _test276() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test276", "A.js", 2);
    }

    public void _test277() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test277", "A.js", 2);
    }

    public void _test278() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test278", "A.js", 4);
    }

    public void _test279() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test279", "A.js", 2);
    }

    public void _test280() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test280", "A.js", 8);
    }

    public void _test281() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test281", "A.js", 8);
    }

    public void _test282() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test282", "A.js", 8);
    }

    public void _test283() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test283", "A.js", 8);
    }

    public void _test284() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test284", "A.js", 8);
    }

    public void _test285() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test285", "A.js", 2);
    }

    public void _test286() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test286", "A.js", 2);
    }

    public void _test287() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test287", "A.js", 2);
    }

    public void _test288() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test288", "A.js", 2, 1);
    }

    public void _test289() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test289", "A.js", 2, 1);
    }

    public void _test290() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test290", "A.js", 4);
    }

    public void _test291() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test291", "A.js", 4);
    }

    public void _test292() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test292", "A.js", 4);
    }

    public void _test293() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test293", "A.js", 4);
    }

    public void _test294() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test294", "A.js", 4);
    }

    public void _test295() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test295", "A.js", 4);
    }

    public void _test296() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test296", "A.js", 4);
    }

    public void _test297() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "space");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.size", "4");
        options.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", "100");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test297", "A.js", 4);
    }

    public void _test298() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", "80");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test298", "A.js", 4);
    }

    public void _test299() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", "80");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test299", "A.js", 4);
    }

    public void test300() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test300", "A.js", 1, 2);
    }

    public void _test301() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_closing_paren_in_cast", "do not insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test301", "A.js", 2);
    }

    public void test302() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test302", "A.js", 2);
    }

    public void test303() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.indent_switchstatements_compare_to_cases = true;
        preferences.indent_switchstatements_compare_to_switch = true;
        preferences.indent_breaks_compare_to_cases = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test303", "A.js", 2);
    }

    public void test304() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        preferences.indent_switchstatements_compare_to_cases = true;
        preferences.indent_switchstatements_compare_to_switch = true;
        preferences.indent_breaks_compare_to_cases = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test304", "A.js", 2);
    }

    public void test305() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        preferences.indent_switchstatements_compare_to_cases = false;
        preferences.indent_switchstatements_compare_to_switch = true;
        preferences.indent_breaks_compare_to_cases = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test305", "A.js", 2);
    }

    public void test306() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.indent_switchstatements_compare_to_cases = true;
        preferences.indent_switchstatements_compare_to_switch = true;
        preferences.indent_breaks_compare_to_cases = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test306", "A.js", 2);
    }

    public void test307() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.indent_switchstatements_compare_to_cases = true;
        preferences.indent_switchstatements_compare_to_switch = true;
        preferences.indent_breaks_compare_to_cases = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test307", "A.js", 2);
    }

    public void test308() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        preferences.indent_switchstatements_compare_to_cases = false;
        preferences.indent_switchstatements_compare_to_switch = false;
        preferences.indent_breaks_compare_to_cases = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test308", "A.js", 2);
    }

    public void test309() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        preferences.indent_switchstatements_compare_to_cases = false;
        preferences.indent_switchstatements_compare_to_switch = false;
        preferences.indent_breaks_compare_to_cases = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test309", "A.js", 2);
    }

    public void _test310() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test310", "A.js", 2);
    }

    public void _test311() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test311", "A.js", 2);
    }

    public void _test312() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test312", "A.js", 2);
    }

    public void _test313() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test313", "A.js", 4);
    }

    public void test314() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test314", "A.js", 2);
    }

    public void _test315() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        String source = "public final void addDefinitelyAssignedVariables(Scope scope, int initStateIndex) {\n/*\n\t\n*/\n}";
        String expectedResult = "public final void addDefinitelyAssignedVariables(Scope scope, int initStateIndex) {\r\n\t/*\r\n\t \r\n\t */\r\n}";
        this.runTest(source, expectedResult, (CodeFormatter)codeFormatter, 4, 0, false, 0, -1);
    }

    public void _test316() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        String source = "public final void addDefinitelyAssignedVariables(Scope scope, int initStateIndex) {\r/*\r\t\r*/\r}";
        String expectedResult = "public final void addDefinitelyAssignedVariables(Scope scope, int initStateIndex) {\r\n\t/*\r\n\t \r\n\t */\r\n}";
        this.runTest(source, expectedResult, (CodeFormatter)codeFormatter, 4, 0, false, 0, -1);
    }

    public void _test317() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.line_separator = "\n";
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        String source = "public final void addDefinitelyAssignedVariables(Scope scope, int initStateIndex) {\r\n/*\r\n\t\r\n*/\r\n}";
        String expectedResult = "public final void addDefinitelyAssignedVariables(Scope scope, int initStateIndex) {\n\t/*\n\t \n\t */\n}";
        this.runTest(source, expectedResult, (CodeFormatter)codeFormatter, 4, 0, false, 0, -1);
    }

    public void _test318() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.line_separator = "\r";
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        String source = "public final void addDefinitelyAssignedVariables(Scope scope, int initStateIndex) {\r/*\r\t\r*/\r}";
        String expectedResult = "public final void addDefinitelyAssignedVariables(Scope scope, int initStateIndex) {\r\t/*\r\t \r\t */\r}";
        this.runTest(source, expectedResult, (CodeFormatter)codeFormatter, 4, 0, false, 0, -1);
    }

    public void _test319() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        preferences.insert_new_line_in_empty_anonymous_type_declaration = false;
        preferences.insert_new_line_in_empty_type_declaration = false;
        preferences.insert_new_line_in_empty_method_body = false;
        preferences.insert_new_line_in_empty_block = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test319", "A.js", 4);
    }

    public void _test320() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        preferences.insert_new_line_in_empty_anonymous_type_declaration = false;
        preferences.insert_new_line_in_empty_type_declaration = false;
        preferences.insert_new_line_in_empty_method_body = false;
        preferences.insert_new_line_in_empty_block = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test320", "A.js", 4);
    }

    public void _test321() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        preferences.insert_new_line_in_empty_anonymous_type_declaration = false;
        preferences.insert_new_line_in_empty_type_declaration = false;
        preferences.insert_new_line_in_empty_method_body = false;
        preferences.insert_new_line_in_empty_block = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test321", "A.js", 4);
    }

    public void _test322() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        preferences.insert_new_line_in_empty_anonymous_type_declaration = false;
        preferences.insert_new_line_in_empty_type_declaration = false;
        preferences.insert_new_line_in_empty_method_body = false;
        preferences.insert_new_line_in_empty_block = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test322", "A.js", 4);
    }

    public void _test323() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        preferences.insert_new_line_in_empty_anonymous_type_declaration = false;
        preferences.insert_new_line_in_empty_type_declaration = false;
        preferences.insert_new_line_in_empty_method_body = false;
        preferences.insert_new_line_in_empty_block = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test323", "A.js", 4);
    }

    public void _test324() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test324", "A.js", 8);
    }

    public void _test325() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test325", "A.js", 8);
    }

    public void _test326() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test326", "A.js", 8);
    }

    public void _test327() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test327", "A.js", 8);
    }

    public void _test328() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test328", "A.js", 8);
    }

    public void _test329() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test329", "A.js", 4);
    }

    public void _test330() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.keep_empty_array_initializer_on_one_line = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test330", "A.js", 8);
    }

    public void _test331() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test331", "A.js", 2);
    }

    public void _test332() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test332", "A.js", 2);
    }

    public void _test333() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.number_of_empty_lines_to_preserve = 5;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test333", "A.js", 2);
    }

    public void _test334() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.put_empty_statement_on_new_line = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test334", "A.js", 8);
    }

    public void _test335() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test335", "A.js", 8);
    }

    public void _test336() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test336", "A.js", 2, 8);
    }

    public void _test337() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test337", "A.js", 8);
    }

    public void _test338() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test338", "A.js", 8);
    }

    public void _test339() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test339", "A.js", 8);
    }

    public void _test340() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test340", "A.js", 8);
    }

    public void _test341() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_before_unary_operator = false;
        preferences.insert_space_after_assignment_operator = false;
        preferences.insert_space_after_binary_operator = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test341", "A.js", 8);
    }

    public void _test342() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_comma_in_multiple_local_declarations = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test342", "A.js", 8);
    }

    public void _test343() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_comma_in_multiple_field_declarations = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test343", "A.js", 8);
    }

    public void _test344() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_comma_in_multiple_field_declarations = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test344", "A.js", 8);
    }

    public void _test345() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_comma_in_multiple_local_declarations = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test345", "A.js", 8);
    }

    public void _test347() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_throws_clause_in_method_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)1));
        FormatterRegressionTests.assertEquals((int)5, (int)DefaultCodeFormatterConstants.getWrappingStyle((String)((String)options.get("org.eclipse.wst.jsdt.core.formatter.alignment_for_throws_clause_in_method_declaration"))));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 2;
        preferences.blank_lines_before_method = 1;
        preferences.blank_lines_before_first_class_body_declaration = 1;
        preferences.insert_new_line_in_empty_method_body = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test347", "A.js", 8);
    }

    public void _test348() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_throws_clause_in_method_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)1, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 2;
        preferences.blank_lines_before_method = 1;
        preferences.blank_lines_before_first_class_body_declaration = 1;
        preferences.insert_new_line_in_empty_method_body = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test348", "A.js", 8);
    }

    public void _test349() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getJavaConventionsSettings());
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        preferences.blank_lines_before_first_class_body_declaration = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test349", "A.js", 8);
    }

    public void _test350() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test350", "A.js", 2);
    }

    public void test351() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test351", "A.js", 2);
    }

    public void test352() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getJavaConventionsSettings());
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test352", "A.js", 2);
    }

    public void test353() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test353", "A.js", 2);
    }

    public void _test354() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.put_empty_statement_on_new_line", "false");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test354", "A.js", 8);
    }

    public void _test355() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.put_empty_statement_on_new_line", "true");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test355", "A.js", 8);
    }

    public void _test356() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_binary_expression", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)1, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test356", "A.js", 8);
    }

    public void test357() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_prefix_operator", "insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test357", "A.js", 1);
    }

    public void test358() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_prefix_operator", "do not insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test358", "A.js", 1);
    }

    public void _test359() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test359", "A.js", 8);
    }

    public void _test360() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "2");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test360", "A.js", 8);
    }

    public void _test361() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "1");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test361", "A.js", 8);
    }

    public void _test362() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_method_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)0));
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_constructor_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.page_width = 57;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test362", "A.js", 4);
    }

    public void _test363() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test363", "A.js", 4);
    }

    public void _test364() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_comma_in_for_inits = false;
        preferences.insert_space_after_comma_in_for_increments = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test364", "A.js", 4);
    }

    public void _test365() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_comma_in_for_inits = false;
        preferences.insert_space_after_comma_in_for_increments = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test365", "A.js", 4);
    }

    public void _test366() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_comma_in_for_inits = true;
        preferences.insert_space_before_comma_in_for_inits = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test366", "A.js", 4);
    }

    public void _test367() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_after_comma_in_for_inits = true;
        preferences.insert_space_before_comma_in_for_inits = true;
        preferences.insert_space_after_comma_in_multiple_local_declarations = false;
        preferences.insert_space_before_comma_in_multiple_local_declarations = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test367", "A.js", 4);
    }

    public void _test368() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_before_method", "0");
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(new DefaultCodeFormatterOptions(options));
        this.runTest((CodeFormatter)codeFormatter, "test368", "A.js", 4);
    }

    public void _test369() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "0");
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_before_method", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_before_first_class_body_declaration", "1");
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(new DefaultCodeFormatterOptions(options));
        this.runTest((CodeFormatter)codeFormatter, "test369", "A.js", 4);
    }

    public void _test370() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_before_method", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_before_first_class_body_declaration", "1");
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(new DefaultCodeFormatterOptions(options));
        this.runTest((CodeFormatter)codeFormatter, "test370", "A.js", 4);
    }

    public void _test371() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_before_method", "0");
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(new DefaultCodeFormatterOptions(options));
        this.runTest((CodeFormatter)codeFormatter, "test371", "A.js", 4);
    }

    public void _test372() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_before_method", "0");
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(new DefaultCodeFormatterOptions(options));
        this.runTest((CodeFormatter)codeFormatter, "test372", "A.js", 4);
    }

    public void _test373() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "0");
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_before_method", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_before_first_class_body_declaration", "1");
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(new DefaultCodeFormatterOptions(options));
        this.runTest((CodeFormatter)codeFormatter, "test373", "A.js", 4);
    }

    public void _test374() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_array_initializer", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.continuation_indentation_for_array_initializer", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_comma_in_array_initializer", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_after_opening_brace_in_array_initializer", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_closing_brace_in_array_initializer", "insert");
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(new DefaultCodeFormatterOptions(options));
        this.runTest((CodeFormatter)codeFormatter, "test374", "A.js", 4);
    }

    public void _test375() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_array_initializer", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.continuation_indentation_for_array_initializer", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_comma_in_array_initializer", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_after_opening_brace_in_array_initializer", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_closing_brace_in_array_initializer", "insert");
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(new DefaultCodeFormatterOptions(options));
        this.runTest((CodeFormatter)codeFormatter, "test375", "A.js", 4);
    }

    public void _test376() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_array_initializer", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.continuation_indentation_for_array_initializer", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_comma_in_array_initializer", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_after_opening_brace_in_array_initializer", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_closing_brace_in_array_initializer", "do not insert");
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(new DefaultCodeFormatterOptions(options));
        this.runTest((CodeFormatter)codeFormatter, "test376", "A.js", 4);
    }

    public void _test377() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_array_initializer", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.continuation_indentation_for_array_initializer", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_comma_in_array_initializer", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_after_opening_brace_in_array_initializer", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_closing_brace_in_array_initializer", "do not insert");
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(new DefaultCodeFormatterOptions(options));
        this.runTest((CodeFormatter)codeFormatter, "test377", "A.js", 4);
    }

    public void _test378() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_array_initializer", "end_of_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.continuation_indentation_for_array_initializer", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_comma_in_array_initializer", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_after_opening_brace_in_array_initializer", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_closing_brace_in_array_initializer", "insert");
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(new DefaultCodeFormatterOptions(options));
        this.runTest((CodeFormatter)codeFormatter, "test378", "A.js", 4);
    }

    public void _test379() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_array_initializer", "next_line_shifted");
        options.put("org.eclipse.wst.jsdt.core.formatter.continuation_indentation_for_array_initializer", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_comma_in_array_initializer", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_after_opening_brace_in_array_initializer", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_closing_brace_in_array_initializer", "insert");
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(new DefaultCodeFormatterOptions(options));
        this.runTest((CodeFormatter)codeFormatter, "test379", "A.js", 4);
    }

    public void _test380() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_before_first_class_body_declaration", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "space");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.size", "4");
        options.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", "100");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test380", "A.js", 4);
    }

    public void _test381() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "0");
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_before_method", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_before_first_class_body_declaration", "0");
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(new DefaultCodeFormatterOptions(options));
        this.runTest((CodeFormatter)codeFormatter, "test381", "A.js", 4);
    }

    public void _test382() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(new DefaultCodeFormatterOptions(options));
        this.runTest((CodeFormatter)codeFormatter, "test382", "A.js", 8);
    }

    public void _test383() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        preferences.blank_lines_before_first_class_body_declaration = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test383", "A.js", 8);
    }

    public void _test384() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_conditional_expression", DefaultCodeFormatterConstants.createAlignmentValue((boolean)true, (int)5, (int)1));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test384", "A.js", 8);
    }

    public void _test385() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_conditional_expression", DefaultCodeFormatterConstants.createAlignmentValue((boolean)true, (int)4, (int)0));
        FormatterRegressionTests.assertEquals((int)4, (int)DefaultCodeFormatterConstants.getWrappingStyle((String)((String)options.get("org.eclipse.wst.jsdt.core.formatter.alignment_for_conditional_expression"))));
        FormatterRegressionTests.assertTrue((5 != DefaultCodeFormatterConstants.getWrappingStyle((String)((String)options.get("org.eclipse.wst.jsdt.core.formatter.alignment_for_conditional_expression"))) ? 1 : 0) != 0);
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.blank_lines_before_first_class_body_declaration = 0;
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test385", "A.js", 8);
    }

    public void _test386() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_conditional_expression", DefaultCodeFormatterConstants.createAlignmentValue((boolean)true, (int)3, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.blank_lines_before_first_class_body_declaration = 0;
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test386", "A.js", 8);
    }

    public void _test387() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_conditional_expression", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)1, (int)1));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.page_width = 40;
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test387", "A.js", 8);
    }

    public void _test388() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)1));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.tab_size = 4;
        preferences.brace_position_for_array_initializer = "next_line";
        preferences.page_width = 40;
        preferences.insert_new_line_after_opening_brace_in_array_initializer = true;
        preferences.insert_new_line_before_closing_brace_in_array_initializer = true;
        preferences.blank_lines_before_first_class_body_declaration = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test388", "A.js", 8);
    }

    public void _test389() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer", DefaultCodeFormatterConstants.createAlignmentValue((boolean)true, (int)5, (int)1));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.continuation_indentation_for_array_initializer = 1;
        preferences.brace_position_for_array_initializer = "next_line";
        preferences.page_width = 40;
        preferences.insert_new_line_after_opening_brace_in_array_initializer = true;
        preferences.insert_new_line_before_closing_brace_in_array_initializer = true;
        preferences.blank_lines_before_first_class_body_declaration = 0;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test389", "A.js", 8);
    }

    public void _test390() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)2, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.continuation_indentation_for_array_initializer = 1;
        preferences.brace_position_for_array_initializer = "next_line";
        preferences.page_width = 40;
        preferences.insert_new_line_after_opening_brace_in_array_initializer = true;
        preferences.insert_new_line_before_closing_brace_in_array_initializer = true;
        preferences.blank_lines_before_first_class_body_declaration = 0;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test390", "A.js", 8);
    }

    public void _test391() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)1, (int)2));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.blank_lines_before_first_class_body_declaration = 0;
        preferences.tab_char = 1;
        preferences.continuation_indentation_for_array_initializer = 3;
        preferences.brace_position_for_array_initializer = "next_line";
        preferences.page_width = 40;
        preferences.insert_new_line_after_opening_brace_in_array_initializer = true;
        preferences.insert_new_line_before_closing_brace_in_array_initializer = true;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test391", "A.js", 8);
    }

    public void _test392() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)1, (int)2));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.blank_lines_before_first_class_body_declaration = 0;
        preferences.tab_char = 1;
        preferences.continuation_indentation_for_array_initializer = 3;
        preferences.brace_position_for_array_initializer = "next_line_shifted";
        preferences.page_width = 40;
        preferences.insert_new_line_after_opening_brace_in_array_initializer = true;
        preferences.insert_new_line_before_closing_brace_in_array_initializer = true;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test392", "A.js", 8);
    }

    public void _test393() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)1, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_size = 4;
        preferences.blank_lines_before_first_class_body_declaration = 0;
        preferences.tab_char = 1;
        preferences.continuation_indentation_for_array_initializer = 1;
        preferences.brace_position_for_array_initializer = "next_line_shifted";
        preferences.page_width = 40;
        preferences.insert_new_line_after_opening_brace_in_array_initializer = true;
        preferences.insert_new_line_before_closing_brace_in_array_initializer = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test393", "A.js", 8);
    }

    public void _test394() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test394", "A.js", 8);
    }

    public void _test395() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.insert_space_before_opening_paren_in_method_declaration = true;
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test395", "A.js", 8);
    }

    public void _test396() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.insert_space_before_semicolon_in_for = true;
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test396", "A.js", 8);
    }

    public void _test397() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.blank_lines_before_package = 2;
        preferences.blank_lines_after_package = 0;
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test397", "A.js", 8);
    }

    public void _test398() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.blank_lines_before_package = 0;
        preferences.blank_lines_after_package = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test398", "A.js", 8);
    }

    public void _test399() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.blank_lines_before_package = 1;
        preferences.blank_lines_after_package = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test399", "A.js", 8);
    }

    public void _test400() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_before_package", "2");
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_after_package", "2");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test400", "A.js", 8);
    }

    public void _test401() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_between_empty_braces_in_array_initializer", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.keep_empty_array_initializer_on_one_line", "true");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test401", "A.js", 8);
    }

    public void _test402() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.keep_empty_array_initializer_on_one_line", "true");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_between_empty_braces_in_array_initializer", "do not insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test402", "A.js", 8);
    }

    public void _test403() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_closing_paren_in_method_invocation", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_paren_in_method_invocation", "insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test403", "A.js", 8);
    }

    public void _test404() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_closing_paren_in_method_invocation", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_paren_in_method_invocation", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_between_empty_parens_in_method_invocation", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_between_empty_parens_in_method_declaration", "do not insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test404", "A.js", 8);
    }

    public void _test405() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_before_package", "10");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test405", "A.js", 8);
    }

    public void _test406() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_closing_paren_in_method_invocation", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_paren_in_method_invocation", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_between_empty_parens_in_method_invocation", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_between_empty_parens_in_method_declaration", "insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test406", "A.js", 8);
    }

    public void _test407() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_size = 4;
        preferences.tab_char = 2;
        preferences.blank_lines_before_first_class_body_declaration = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test407", "A.js", 4);
    }

    public void _test408() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_size = 4;
        preferences.tab_char = 2;
        preferences.blank_lines_before_first_class_body_declaration = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test408", "A.js", 4);
    }

    public void test409() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block_in_case", "next_line");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.indent_switchstatements_compare_to_cases = false;
        preferences.indent_switchstatements_compare_to_switch = true;
        preferences.brace_position_for_block = "next_line";
        preferences.brace_position_for_switch = "next_line";
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test409", "A.js", 2);
    }

    public void _test410() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.blank_lines_between_type_declarations = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test410", "A.js", 8);
    }

    public void _test411() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.blank_lines_between_type_declarations = 2;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test411", "A.js", 8);
    }

    public void _test412() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test412", "A.js", 8);
    }

    public void _test413() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.blank_lines_between_type_declarations = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test413", "A.js", 8);
    }

    public void _test414() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test414", "A.js", 8);
    }

    public void _test415() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.blank_lines_between_type_declarations = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test415", "A.js", 8);
    }

    public void _test416() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.blank_lines_between_type_declarations = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test416", "A.js", 8);
    }

    public void _test417() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_before_opening_paren_in_constructor_declaration = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test417", "A.js", 4);
    }

    public void _test418() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.insert_space_before_opening_paren_in_constructor_declaration = true;
        preferences.insert_space_before_opening_paren_in_method_declaration = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test418", "A.js", 4);
    }

    public void _test419() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_binary_expression", DefaultCodeFormatterConstants.createAlignmentValue((boolean)true, (int)3, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test419", "A.js", 8);
    }

    public void _test420() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        preferences.align_type_members_on_columns = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test420", "A.js", 8);
    }

    public void _test421() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_closing_paren_in_method_invocation", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_paren_in_method_invocation", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_between_empty_parens_in_method_invocation", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_between_empty_parens_in_method_declaration", "do not insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test421", "A.js", 8);
    }

    public void _test422() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_closing_paren_in_method_invocation", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_paren_in_method_invocation", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_between_empty_parens_in_method_invocation", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_between_empty_parens_in_method_declaration", "do not insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 2;
        preferences.blank_lines_before_first_class_body_declaration = 1;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test422", "A.js", 8);
    }

    public void _test423() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "end_of_line");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test423", "A.js", 8);
    }

    public void _test424() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line_on_wrap");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test424", "A.js", 8);
    }

    public void _test425() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line_on_wrap");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test425", "A.js", 8);
    }

    public void _test426() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line_on_wrap");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line_on_wrap");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test426", "A.js", 8);
    }

    public void _test427() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line_on_wrap");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line_on_wrap");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test427", "A.js", 8);
    }

    public void _test428() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line_on_wrap");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line_on_wrap");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test428", "A.js", 8);
    }

    public void _test429() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line_on_wrap");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test429", "A.js", 8);
    }

    public void _test430() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line_on_wrap");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test430", "A.js", 8);
    }

    public void _test431() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_semicolon_in_for", "insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test431", "A.js", 8);
    }

    public void _test432() {
        String resourcePath = this.getResource("test432", "formatter.xml");
        Map options = DecodeCodeFormatterPreferences.decodeCodeFormatterOptions(resourcePath, "AIS");
        FormatterRegressionTests.assertNotNull((String)"No preferences", (Object)options);
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test432", "A.js", 8);
    }

    public void _test433() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test433", "A.js", 8);
    }

    public void _test434() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_arguments_in_method_invocation", DefaultCodeFormatterConstants.createAlignmentValue((boolean)true, (int)5, (int)1));
        FormatterRegressionTests.assertEquals((boolean)true, (boolean)DefaultCodeFormatterConstants.getForceWrapping((String)((String)options.get("org.eclipse.wst.jsdt.core.formatter.alignment_for_arguments_in_method_invocation"))));
        FormatterRegressionTests.assertEquals((int)5, (int)DefaultCodeFormatterConstants.getWrappingStyle((String)((String)options.get("org.eclipse.wst.jsdt.core.formatter.alignment_for_arguments_in_method_invocation"))));
        FormatterRegressionTests.assertEquals((int)1, (int)DefaultCodeFormatterConstants.getIndentStyle((String)((String)options.get("org.eclipse.wst.jsdt.core.formatter.alignment_for_arguments_in_method_invocation"))));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_size = 3;
        preferences.tab_char = 2;
        preferences.insert_space_after_opening_paren_in_method_invocation = true;
        preferences.insert_space_before_closing_paren_in_method_invocation = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test434", "A.js", 8);
    }

    public void _test435() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.brace_position_for_type_declaration = "next_line";
        preferences.brace_position_for_method_declaration = "next_line";
        preferences.brace_position_for_block = "next_line";
        preferences.blank_lines_before_first_class_body_declaration = 1;
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test435", "A.js", 8);
    }

    public void _test436() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.brace_position_for_type_declaration = "next_line";
        preferences.brace_position_for_method_declaration = "next_line";
        preferences.brace_position_for_constructor_declaration = "next_line";
        preferences.brace_position_for_block = "next_line";
        preferences.blank_lines_before_first_class_body_declaration = 1;
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test436", "A.js", 8);
    }

    public void _test437() {
        String resourcePath = this.getResource("test437", "formatter.xml");
        Map options = DecodeCodeFormatterPreferences.decodeCodeFormatterOptions(resourcePath, "Felix");
        FormatterRegressionTests.assertNotNull((String)"No preferences", (Object)options);
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test437", "A.js", 8);
    }

    public void _test438() {
        String resourcePath = this.getResource("test438", "formatter.xml");
        Map options = DecodeCodeFormatterPreferences.decodeCodeFormatterOptions(resourcePath, "Felix");
        FormatterRegressionTests.assertNotNull((String)"No preferences", (Object)options);
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test438", "A.js", 8);
    }

    public void _test439() {
        String resourcePath = this.getResource("test439", "formatter.xml");
        Map options = DecodeCodeFormatterPreferences.decodeCodeFormatterOptions(resourcePath, "Felix");
        FormatterRegressionTests.assertNotNull((String)"No preferences", (Object)options);
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test439", "A.js", 8);
    }

    public void _test440() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.put_empty_statement_on_new_line", "false");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test440", "A.js", 8);
    }

    public void _test441() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.put_empty_statement_on_new_line", "false");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test441", "A.js", 8);
    }

    public void _test442() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.put_empty_statement_on_new_line", "false");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test442", "A.js", 8);
    }

    public void _test443() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.put_empty_statement_on_new_line", "false");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_catch_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_else_in_if_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_finally_in_try_statement", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_while_in_do_statement", "insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test443", "A.js", 8);
    }

    public void _test444() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.put_empty_statement_on_new_line", "false");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test444", "A.js", 8);
    }

    public void _test445() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.put_empty_statement_on_new_line", "false");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test445", "A.js", 8);
    }

    public void _test446() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test446", "A.js", 8);
    }

    public void _test447() {
        String resourcePath = this.getResource("test447", "test447.zip");
        Map options = DecodeCodeFormatterPreferences.decodeCodeFormatterOptions(resourcePath, "settings.xml", "Toms");
        FormatterRegressionTests.assertNotNull((String)"No preferences", (Object)options);
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        String input = this.getZipEntryContents(resourcePath, this.getIn("Format.js"));
        FormatterRegressionTests.assertNotNull((String)"No input", (Object)input);
        String output = this.getZipEntryContents(resourcePath, this.getOut("Format.js"));
        FormatterRegressionTests.assertNotNull((String)"No output", (Object)output);
        int start = input.indexOf("private");
        int end = input.indexOf(";");
        this.runTest(input, output, (CodeFormatter)codeFormatter, 8, 0, false, start, end - start + 1, "\r\n");
    }

    public void _test448() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.tab_char = 1;
        preferences.insert_space_before_opening_bracket_in_array_allocation_expression = true;
        preferences.insert_space_after_opening_bracket_in_array_allocation_expression = true;
        preferences.insert_space_before_closing_bracket_in_array_allocation_expression = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test448", "A.js", 8);
    }

    public void _test449() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.number_of_empty_lines_to_preserve = 0;
        preferences.insert_space_before_opening_bracket_in_array_allocation_expression = false;
        preferences.insert_space_after_opening_bracket_in_array_allocation_expression = true;
        preferences.insert_space_before_closing_bracket_in_array_allocation_expression = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test449", "A.js", 8);
    }

    public void test450() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test450", "A.js", 0, 0, false, 0, 0);
    }

    public void _test451() {
        String resourcePath = this.getResource("test451", "test451.zip");
        Map options = DecodeCodeFormatterPreferences.decodeCodeFormatterOptions(resourcePath, "settings.xml", "Toms");
        FormatterRegressionTests.assertNotNull((String)"No preferences", (Object)options);
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        String input = this.getZipEntryContents(resourcePath, this.getIn("Format.js"));
        FormatterRegressionTests.assertNotNull((String)"No input", (Object)input);
        String output = this.getZipEntryContents(resourcePath, this.getOut("Format.js"));
        FormatterRegressionTests.assertNotNull((String)"No output", (Object)output);
        int start = input.indexOf("private");
        int end = input.indexOf(";");
        this.runTest(input, output, (CodeFormatter)codeFormatter, 8, 0, false, start, end - start + 1, "\r\n");
    }

    public void _test452() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_before_package", "2");
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_after_package", "2");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test452", "A.js", 8);
    }

    public void _test453() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.blank_lines_before_first_class_body_declaration = 1;
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test453", "A.js", 8);
    }

    public void _test454() {
        String resourcePath = this.getResource("test454", "test454.zip");
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "1");
        FormatterRegressionTests.assertNotNull((String)"No preferences", (Object)options);
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        String input = this.getZipEntryContents(resourcePath, this.getIn("A.js"));
        FormatterRegressionTests.assertNotNull((String)"No input", (Object)input);
        String output = this.getZipEntryContents(resourcePath, this.getOut("A.js"));
        FormatterRegressionTests.assertNotNull((String)"No output", (Object)output);
        int start = input.indexOf("launch.setAttribute");
        int end = input.indexOf(";", start + 1);
        this.runTest(input, output, (CodeFormatter)codeFormatter, 8, 0, false, start, end - start + 1, "\r\n");
    }

    public void _test455() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "1");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test455", "A.js", 8);
    }

    public void _test456() {
        String resourcePath = this.getResource("test456", "test456.zip");
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        FormatterRegressionTests.assertNotNull((String)"No preferences", (Object)options);
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        String input = this.getZipEntryContents(resourcePath, this.getIn("A.js"));
        FormatterRegressionTests.assertNotNull((String)"No input", (Object)input);
        String output = this.getZipEntryContents(resourcePath, this.getOut("A.js"));
        FormatterRegressionTests.assertNotNull((String)"No output", (Object)output);
        int start = input.indexOf("launch.setAttribute");
        int end = input.indexOf(";", start + 1);
        this.runTest(input, output, (CodeFormatter)codeFormatter, 8, 0, false, start, end - start + 1, "\r\n");
    }

    public void _test457() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test457", "A.js", 8);
    }

    public void _test458() {
        CodeFormatter codeFormatter = ToolFactory.createCodeFormatter(null);
        this.runTest(codeFormatter, "test458", "A.js", 8);
    }

    public void test459() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_arguments_in_method_invocation", DefaultCodeFormatterConstants.createAlignmentValue((boolean)true, (int)3, (int)2));
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_binary_expression", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)3, (int)2));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test459", "A.js", 2);
    }

    public void _test460() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_binary_expression", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)1, (int)2));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test460", "A.js", 2);
    }

    public void _test461() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test461", "A.js", 8);
    }

    public void test462() {
        String resourcePath = this.getResource("test462", "formatter.xml");
        Map options = DecodeCodeFormatterPreferences.decodeCodeFormatterOptions(resourcePath, "neils");
        FormatterRegressionTests.assertNotNull((String)"No preferences", (Object)options);
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_arguments_in_method_invocation", DefaultCodeFormatterConstants.createAlignmentValue((boolean)true, (int)3, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test462", "A.js", 2);
    }

    public void _test463() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_selector_in_method_invocation", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)3, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test463", "A.js", 4);
    }

    public void _test464() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_paren_in_for", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_opening_paren_in_for", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_closing_paren_in_for", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_paren_in_method_declaration", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_closing_paren_in_method_declaration", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line_shifted");
        options.put("org.eclipse.wst.jsdt.core.formatter.indent_statements_compare_to_block", "false");
        options.put("org.eclipse.wst.jsdt.core.formatter.indent_statements_compare_to_body", "true");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_paren_in_method_invocation", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_closing_paren_in_method_invocation", "insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test464", "A.js", 4);
    }

    public void _test465() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_selector_in_method_invocation", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)3, (int)2));
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_arguments_in_method_invocation", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)3, (int)2));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test465", "A.js", 2);
    }

    public void _test466() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_selector_in_method_invocation", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)3, (int)2));
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_arguments_in_method_invocation", DefaultCodeFormatterConstants.createAlignmentValue((boolean)true, (int)3, (int)2));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test466", "A.js", 2);
    }

    public void _test467() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_selector_in_method_invocation", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)3, (int)2));
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_arguments_in_method_invocation", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)3, (int)2));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test467", "A.js", 2);
    }

    public void _test468() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "1");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test468", "A.js", 8);
    }

    public void _test469() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_closing_bracket_in_array_allocation_expression", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_bracket_in_array_allocation_expression", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_between_empty_brackets_in_array_allocation_expression", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.keep_empty_array_initializer_on_one_line", "true");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test469", "A.js", 8);
    }

    public void _test470() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.keep_simple_if_on_one_line = true;
        preferences.keep_guardian_clause_on_one_line = true;
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test470", "A.js", 8);
    }

    public void _test471() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_brace_in_array_initializer", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_closing_brace_in_array_initializer", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_between_empty_braces_in_array_initializer", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.keep_empty_array_initializer_on_one_line", "true");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test471", "A.js", 8);
    }

    public void _test472() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_brace_in_array_initializer", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_closing_brace_in_array_initializer", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_between_empty_braces_in_array_initializer", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.keep_empty_array_initializer_on_one_line", "true");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test472", "A.js", 8);
    }

    public void _test473() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_brace_in_array_initializer", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_closing_brace_in_array_initializer", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_between_empty_braces_in_array_initializer", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.keep_empty_array_initializer_on_one_line", "true");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test473", "A.js", 8);
    }

    public void _test474() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_brace_in_array_initializer", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_closing_brace_in_array_initializer", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_between_empty_braces_in_array_initializer", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.keep_empty_array_initializer_on_one_line", "true");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test474", "A.js", 8);
    }

    public void _test475() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_brace_in_array_initializer", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_closing_brace_in_array_initializer", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_before_closing_brace_in_array_initializer", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_between_empty_braces_in_array_initializer", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.keep_empty_array_initializer_on_one_line", "true");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test475", "A.js", 8);
    }

    public void _test476() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.indent_body_declarations_compare_to_type_header", "false");
        options.put("org.eclipse.wst.jsdt.core.formatter.indent_statements_compare_to_block", "false");
        options.put("org.eclipse.wst.jsdt.core.formatter.indent_statements_compare_to_body", "false");
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line_shifted");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line_shifted");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line_shifted");
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_after_imports", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_paren_in_method_invocation", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_closing_paren_in_method_invocation", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_paren_in_if", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_paren_in_if", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_closing_paren_in_if", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_opening_paren_in_for", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_paren_in_for", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_closing_paren_in_for", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_assignment_operator", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_assignment_operator", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_binary_operator", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_binary_operator", "insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test476", "A.js", 8);
    }

    public void test477() {
        String option = DefaultCodeFormatterConstants.createAlignmentValue((boolean)true, (int)0, (int)2);
        FormatterRegressionTests.assertTrue((String)"Wrong force setting", (boolean)DefaultCodeFormatterConstants.getForceWrapping((String)option));
        FormatterRegressionTests.assertEquals((String)"Wrong wrapping style", (int)0, (int)DefaultCodeFormatterConstants.getWrappingStyle((String)option));
        FormatterRegressionTests.assertEquals((String)"Wrong indent style", (int)2, (int)DefaultCodeFormatterConstants.getIndentStyle((String)option));
        option = DefaultCodeFormatterConstants.setForceWrapping((String)option, (boolean)false);
        FormatterRegressionTests.assertFalse((String)"Wrong force setting", (boolean)DefaultCodeFormatterConstants.getForceWrapping((String)option));
        FormatterRegressionTests.assertEquals((String)"Wrong wrapping style", (int)0, (int)DefaultCodeFormatterConstants.getWrappingStyle((String)option));
        FormatterRegressionTests.assertEquals((String)"Wrong indent style", (int)2, (int)DefaultCodeFormatterConstants.getIndentStyle((String)option));
        option = DefaultCodeFormatterConstants.setIndentStyle((String)option, (int)1);
        FormatterRegressionTests.assertFalse((String)"Wrong force setting", (boolean)DefaultCodeFormatterConstants.getForceWrapping((String)option));
        FormatterRegressionTests.assertEquals((String)"Wrong wrapping style", (int)0, (int)DefaultCodeFormatterConstants.getWrappingStyle((String)option));
        FormatterRegressionTests.assertEquals((String)"Wrong indent style", (int)1, (int)DefaultCodeFormatterConstants.getIndentStyle((String)option));
        option = DefaultCodeFormatterConstants.setIndentStyle((String)option, (int)0);
        FormatterRegressionTests.assertFalse((String)"Wrong force setting", (boolean)DefaultCodeFormatterConstants.getForceWrapping((String)option));
        FormatterRegressionTests.assertEquals((String)"Wrong wrapping style", (int)0, (int)DefaultCodeFormatterConstants.getWrappingStyle((String)option));
        FormatterRegressionTests.assertEquals((String)"Wrong indent style", (int)0, (int)DefaultCodeFormatterConstants.getIndentStyle((String)option));
        option = DefaultCodeFormatterConstants.setForceWrapping((String)option, (boolean)true);
        FormatterRegressionTests.assertTrue((String)"Wrong force setting", (boolean)DefaultCodeFormatterConstants.getForceWrapping((String)option));
        FormatterRegressionTests.assertEquals((String)"Wrong wrapping style", (int)0, (int)DefaultCodeFormatterConstants.getWrappingStyle((String)option));
        FormatterRegressionTests.assertEquals((String)"Wrong indent style", (int)0, (int)DefaultCodeFormatterConstants.getIndentStyle((String)option));
        option = DefaultCodeFormatterConstants.setWrappingStyle((String)option, (int)1);
        FormatterRegressionTests.assertTrue((String)"Wrong force setting", (boolean)DefaultCodeFormatterConstants.getForceWrapping((String)option));
        FormatterRegressionTests.assertEquals((String)"Wrong wrapping style", (int)1, (int)DefaultCodeFormatterConstants.getWrappingStyle((String)option));
        FormatterRegressionTests.assertEquals((String)"Wrong indent style", (int)0, (int)DefaultCodeFormatterConstants.getIndentStyle((String)option));
        option = DefaultCodeFormatterConstants.setWrappingStyle((String)option, (int)2);
        FormatterRegressionTests.assertTrue((String)"Wrong force setting", (boolean)DefaultCodeFormatterConstants.getForceWrapping((String)option));
        FormatterRegressionTests.assertEquals((String)"Wrong wrapping style", (int)2, (int)DefaultCodeFormatterConstants.getWrappingStyle((String)option));
        FormatterRegressionTests.assertEquals((String)"Wrong indent style", (int)0, (int)DefaultCodeFormatterConstants.getIndentStyle((String)option));
        option = DefaultCodeFormatterConstants.setWrappingStyle((String)option, (int)5);
        FormatterRegressionTests.assertTrue((String)"Wrong force setting", (boolean)DefaultCodeFormatterConstants.getForceWrapping((String)option));
        FormatterRegressionTests.assertEquals((String)"Wrong wrapping style", (int)5, (int)DefaultCodeFormatterConstants.getWrappingStyle((String)option));
        FormatterRegressionTests.assertEquals((String)"Wrong indent style", (int)0, (int)DefaultCodeFormatterConstants.getIndentStyle((String)option));
        option = DefaultCodeFormatterConstants.setWrappingStyle((String)option, (int)4);
        FormatterRegressionTests.assertTrue((String)"Wrong force setting", (boolean)DefaultCodeFormatterConstants.getForceWrapping((String)option));
        FormatterRegressionTests.assertEquals((String)"Wrong wrapping style", (int)4, (int)DefaultCodeFormatterConstants.getWrappingStyle((String)option));
        FormatterRegressionTests.assertEquals((String)"Wrong indent style", (int)0, (int)DefaultCodeFormatterConstants.getIndentStyle((String)option));
        option = DefaultCodeFormatterConstants.setWrappingStyle((String)option, (int)3);
        FormatterRegressionTests.assertTrue((String)"Wrong force setting", (boolean)DefaultCodeFormatterConstants.getForceWrapping((String)option));
        FormatterRegressionTests.assertEquals((String)"Wrong wrapping style", (int)3, (int)DefaultCodeFormatterConstants.getWrappingStyle((String)option));
        FormatterRegressionTests.assertEquals((String)"Wrong indent style", (int)0, (int)DefaultCodeFormatterConstants.getIndentStyle((String)option));
    }

    public void _test478() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.compiler.source", "1.4");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, options);
        this.runTest((CodeFormatter)codeFormatter, "test478", "A.js", 8);
    }

    public void _test479() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test479", "A.js", 8);
    }

    public void _test480() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test480", "A.js", 8);
    }

    public void _test481() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test481", "A.js", 8);
    }

    public void _test482() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_closing_brace_in_block", "do not insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test482", "A.js", 8);
    }

    public void _test483() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_closing_brace_in_block", "do not insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test483", "A.js", 8);
    }

    public void _test484() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "1");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test484", "A.js", 8);
    }

    public void _test485() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "1");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test485", "A.js", 8);
    }

    public void _test486() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_type_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_block", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_method_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_constructor_declaration", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_switch", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_anonymous_type_declaration", "next_line");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test486", "A.js", 8);
    }

    public void _test487() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test487", "A.js", 8, true);
    }

    public void _test488() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_colon_in_case", "do not insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test488", "A.js", 8, true);
    }

    public void _test489() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer", DefaultCodeFormatterConstants.createAlignmentValue((boolean)true, (int)3, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test489", "A.js", 8, true);
    }

    public void _test490() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.brace_position_for_array_initializer", "next_line");
        options.put("org.eclipse.wst.jsdt.core.formatter.keep_empty_array_initializer_on_one_line", "true");
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_expressions_in_array_initializer", DefaultCodeFormatterConstants.createAlignmentValue((boolean)true, (int)3, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test490", "A.js", 8, true);
    }

    public void _test491() {
        String resourcePath = this.getResource("test491", "formatter.xml");
        Map options = DecodeCodeFormatterPreferences.decodeCodeFormatterOptions(resourcePath, "DOI");
        FormatterRegressionTests.assertNotNull((String)"No preferences", (Object)options);
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test491", "BundleChain.js", 8);
    }

    public void _test492() {
        String resourcePath = this.getResource("test492", "core_formatting.xml");
        Map options = DecodeCodeFormatterPreferences.decodeCodeFormatterOptions(resourcePath, "core");
        FormatterRegressionTests.assertNotNull((String)"No preferences", (Object)options);
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.nonExternalizedStringLiteral", "error");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, options);
        this.runTest((CodeFormatter)codeFormatter, "test492", "Main.js", 8);
    }

    public void _test493() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_after_package", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_before_package", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_after_imports", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_before_imports", "1");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test493", "MyClass.js", 8);
    }

    public void _test494() {
        String resourcePath = this.getResource("test494", "format.xml");
        Map options = DecodeCodeFormatterPreferences.decodeCodeFormatterOptions(resourcePath, "AGPS default");
        FormatterRegressionTests.assertNotNull((String)"No preferences", (Object)options);
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, options);
        this.runTest((CodeFormatter)codeFormatter, "test494", "A.js", 8);
    }

    public void _test495() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.blank_lines_before_first_class_body_declaration = 1;
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test495", "A.js", 8, true);
    }

    public void _test496() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_size = 4;
        preferences.tab_char = 2;
        preferences.keep_simple_if_on_one_line = true;
        preferences.keep_guardian_clause_on_one_line = true;
        preferences.blank_lines_before_first_class_body_declaration = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test496", "A.js", 8, true);
    }

    public void _test497() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 2;
        preferences.blank_lines_before_first_class_body_declaration = 1;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test497", "A.js", 8, true);
    }

    public void _test498() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 2;
        preferences.keep_simple_if_on_one_line = true;
        preferences.keep_guardian_clause_on_one_line = true;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test498", "A.js", 8, true);
    }

    public void _test499() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.blank_lines_before_first_class_body_declaration = 1;
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test499", "A.js", 8, true);
    }

    public void _test500() {
        Map options = DefaultCodeFormatterConstants.getEclipse21Settings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test500", "A.js", 8, false);
    }

    public void _test501() {
        String resourcePath = this.getResource("test501", "formatter.xml");
        Map options = DecodeCodeFormatterPreferences.decodeCodeFormatterOptions(resourcePath, "GMTI");
        FormatterRegressionTests.assertNotNull((String)"No preferences", (Object)options);
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test501", "A.js", 8);
    }

    public void _test502() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_size = 4;
        preferences.tab_char = 2;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test502", "A.js", 8, false);
    }

    public void _test503() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_size = 4;
        preferences.tab_char = 1;
        HashMap<String, String> compilerOptions = new HashMap<String, String>();
        compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
        compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
        compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
        this.runTest((CodeFormatter)codeFormatter, "test503", "A.js", 8, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test504() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test504", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test505() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_size = 4;
        preferences.tab_char = 1;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test505", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test506() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_size = 4;
        preferences.tab_char = 1;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test506", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test507() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_size = 4;
        preferences.tab_char = 1;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test507", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test508() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test508", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    public void _test509() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.keep_simple_if_on_one_line = true;
        preferences.keep_then_statement_on_same_line = true;
        preferences.keep_guardian_clause_on_one_line = true;
        preferences.tab_char = 1;
        preferences.compact_else_if = true;
        preferences.insert_new_line_at_end_of_file_if_missing = true;
        preferences.number_of_empty_lines_to_preserve = 0;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test509", "A.js");
    }

    public void _test510() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.keep_simple_if_on_one_line = true;
        preferences.keep_then_statement_on_same_line = true;
        preferences.keep_guardian_clause_on_one_line = true;
        preferences.tab_char = 1;
        preferences.compact_else_if = true;
        preferences.insert_new_line_at_end_of_file_if_missing = false;
        preferences.number_of_empty_lines_to_preserve = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test510", "A.js");
    }

    public void _test511() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.keep_simple_if_on_one_line = true;
        preferences.keep_then_statement_on_same_line = true;
        preferences.keep_guardian_clause_on_one_line = true;
        preferences.tab_char = 1;
        preferences.compact_else_if = true;
        preferences.insert_new_line_at_end_of_file_if_missing = false;
        preferences.number_of_empty_lines_to_preserve = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test511", "A.js");
    }

    public void _test512() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipse21Settings());
        preferences.keep_simple_if_on_one_line = true;
        preferences.keep_then_statement_on_same_line = true;
        preferences.keep_guardian_clause_on_one_line = true;
        preferences.tab_char = 1;
        preferences.compact_else_if = true;
        preferences.insert_new_line_at_end_of_file_if_missing = true;
        preferences.number_of_empty_lines_to_preserve = 1;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test512", "A.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test513() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test513", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    public void _test514() {
        String resourcePath = this.getResource("test514", "formatter.xml");
        Map options = DecodeCodeFormatterPreferences.decodeCodeFormatterOptions(resourcePath, "core");
        FormatterRegressionTests.assertNotNull((String)"No preferences", (Object)options);
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.nonExternalizedStringLiteral", "error");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, options);
        this.runTest((CodeFormatter)codeFormatter, "test514", "A.js", 8);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test515() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_size = 4;
        preferences.tab_char = 1;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test515", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test516() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_ellipsis", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_ellipsis", "do not insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test516", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test517() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_ellipsis", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_ellipsis", "insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test517", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test518() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_ellipsis", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_ellipsis", "insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test518", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test519() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_ellipsis", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_ellipsis", "do not insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test519", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test520() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test520", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test521() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test521", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test522() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test522", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test523() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.insert_new_line_in_empty_type_declaration = true;
        preferences.insert_new_line_in_empty_enum_constant = false;
        preferences.insert_new_line_in_empty_enum_declaration = false;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test523", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test524() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.insert_new_line_in_empty_type_declaration = true;
        preferences.insert_new_line_in_empty_enum_constant = false;
        preferences.insert_new_line_in_empty_enum_declaration = true;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test524", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test525() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.insert_new_line_in_empty_type_declaration = true;
        preferences.insert_new_line_in_empty_enum_constant = true;
        preferences.insert_new_line_in_empty_enum_declaration = false;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test525", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test526() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.insert_new_line_in_empty_type_declaration = true;
        preferences.insert_new_line_in_empty_enum_constant = true;
        preferences.insert_new_line_in_empty_enum_declaration = true;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test526", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test527() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test527", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test528() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test528", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test529() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test529", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test530() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test530", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test531() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test531", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test532() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test532", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test533() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test533", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test534() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test534", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test535() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test535", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    public void _test538() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getJavaConventionsSettings());
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test538", "A.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test539() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test539", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test540() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test540", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test541() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test541", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    public void _test542() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getJavaConventionsSettings());
        preferences.tab_char = 1;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test542", "A.js", 8);
    }

    public void _test543() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getJavaConventionsSettings());
        preferences.tab_size = 4;
        preferences.tab_char = 2;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test543", "A.js", 8);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test544() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_size = 4;
        preferences.tab_char = 2;
        preferences.insert_space_after_closing_angle_bracket_in_type_parameters = true;
        preferences.brace_position_for_type_declaration = "next_line";
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test544", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test545() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_size = 4;
        preferences.tab_char = 2;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test545", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    public void _test546() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_size = 4;
        preferences.tab_char = 2;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test546", "A.js", 8, false);
    }

    public void test547() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test547", "A.js", 32, false);
        this.runTest((CodeFormatter)codeFormatter, "test547", "A.js", 0, false);
    }

    public void test548() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test548", "A.js", 64, false);
        this.runTest((CodeFormatter)codeFormatter, "test548", "A.js", 0, false);
    }

    public void _test549() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 4;
        preferences.indentation_size = 4;
        preferences.tab_size = 8;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test549", "A.js", 8, false);
    }

    public void _test550() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 4;
        preferences.indentation_size = 4;
        preferences.tab_size = 8;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test550", "A.js", 8, false);
    }

    public void _test551() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_method_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)1));
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_constructor_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)1));
        FormatterRegressionTests.assertEquals((boolean)false, (boolean)DefaultCodeFormatterConstants.getForceWrapping((String)((String)options.get("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_constructor_declaration"))));
        FormatterRegressionTests.assertEquals((int)5, (int)DefaultCodeFormatterConstants.getWrappingStyle((String)((String)options.get("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_constructor_declaration"))));
        FormatterRegressionTests.assertEquals((int)1, (int)DefaultCodeFormatterConstants.getIndentStyle((String)((String)options.get("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_constructor_declaration"))));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 4;
        preferences.indentation_size = 4;
        preferences.tab_size = 8;
        preferences.page_width = 57;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test551", "A.js", 4);
    }

    public void _test552() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_method_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)1));
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_constructor_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)1));
        FormatterRegressionTests.assertEquals((boolean)false, (boolean)DefaultCodeFormatterConstants.getForceWrapping((String)((String)options.get("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_constructor_declaration"))));
        FormatterRegressionTests.assertEquals((int)5, (int)DefaultCodeFormatterConstants.getWrappingStyle((String)((String)options.get("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_constructor_declaration"))));
        FormatterRegressionTests.assertEquals((int)1, (int)DefaultCodeFormatterConstants.getIndentStyle((String)((String)options.get("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_constructor_declaration"))));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 4;
        preferences.indentation_size = 4;
        preferences.tab_size = 8;
        preferences.page_width = 57;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test552", "A.js", 8);
    }

    public void test553() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test553", "A.js", 16, false);
        this.runTest((CodeFormatter)codeFormatter, "test553", "A.js", 0, false);
    }

    public void test554() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test554", "A.js", 16, false);
        this.runTest((CodeFormatter)codeFormatter, "test554", "A.js", 0, false);
    }

    public void _test555() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 4;
        preferences.indentation_size = 4;
        preferences.tab_size = 8;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test555", "A.js", 8, false);
    }

    public void _test556() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test556", "A.js", 8, false);
    }

    public void _test557() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_size = 4;
        preferences.tab_char = 2;
        preferences.keep_empty_array_initializer_on_one_line = true;
        preferences.insert_space_between_empty_braces_in_array_initializer = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test557", "A.js", 8, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test558() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_size = 4;
        preferences.tab_char = 2;
        preferences.insert_space_after_comma_in_enum_declarations = false;
        preferences.insert_new_line_after_annotation = false;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test558", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test559() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_size = 4;
        preferences.tab_char = 2;
        preferences.insert_space_after_comma_in_enum_declarations = true;
        preferences.insert_new_line_after_annotation = false;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test559", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    public void _test560() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_size = 4;
        preferences.tab_char = 2;
        preferences.brace_position_for_array_initializer = "next_line_shifted";
        preferences.brace_position_for_type_declaration = "next_line";
        preferences.brace_position_for_method_declaration = "next_line";
        preferences.brace_position_for_block = "next_line";
        preferences.keep_empty_array_initializer_on_one_line = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test560", "A.js", 8, false);
    }

    public void _test561() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        preferences.brace_position_for_array_initializer = "next_line_shifted";
        preferences.brace_position_for_type_declaration = "next_line";
        preferences.brace_position_for_method_declaration = "next_line";
        preferences.brace_position_for_block = "next_line";
        preferences.keep_empty_array_initializer_on_one_line = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test561", "A.js", 8, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test562() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        preferences.insert_space_after_closing_angle_bracket_in_type_arguments = false;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test562", "A.js", 4, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test563() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_size = 4;
        preferences.tab_size = 4;
        preferences.tab_char = 2;
        preferences.insert_space_after_closing_angle_bracket_in_type_arguments = true;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test563", "A.js", 4, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    public void _test564() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 2;
        preferences.tab_size = 4;
        preferences.brace_position_for_array_initializer = "next_line";
        preferences.brace_position_for_type_declaration = "next_line";
        preferences.brace_position_for_method_declaration = "next_line";
        preferences.brace_position_for_block = "next_line";
        preferences.keep_empty_array_initializer_on_one_line = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test564", "A.js", 8, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test566() {
        Map options = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_size = 4;
        preferences.tab_char = 2;
        preferences.brace_position_for_enum_constant = "next_line";
        preferences.brace_position_for_enum_declaration = "next_line";
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test566", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    public void _test567() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_method_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)1, (int)1));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.use_tabs_only_for_leading_indentations = true;
        preferences.page_width = 35;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test567", "A.js", 8, false);
    }

    public void _test568() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_method_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)1, (int)1));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.indentation_size = 4;
        preferences.tab_size = 4;
        preferences.tab_char = 4;
        preferences.use_tabs_only_for_leading_indentations = true;
        preferences.page_width = 35;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test568", "A.js", 8, false);
    }

    public void _test569() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_method_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)1, (int)1));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.indentation_size = 4;
        preferences.tab_size = 4;
        preferences.tab_char = 1;
        preferences.use_tabs_only_for_leading_indentations = false;
        preferences.page_width = 40;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test569", "A.js", 8, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test570() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_enum_constants", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)3, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test570", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test571() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_enum_constants", DefaultCodeFormatterConstants.createAlignmentValue((boolean)true, (int)3, (int)1));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test571", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    public void _test572() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.insert_space_after_opening_brace_in_array_initializer = false;
        preferences.insert_space_before_closing_brace_in_array_initializer = false;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test572", "A.js", 2, false);
    }

    public void _test573() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test573", "A.js", 2, false);
    }

    public void test574() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test574", "A.js", 64, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test575() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test575", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test576() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test576", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    public void _test577() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test577", "A.js", 0, false);
    }

    public void _test578() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test578", "A.js", 0, false);
    }

    public void _test579() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test579", "A.js", 8, false);
    }

    public void _test580() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test580", "A.js", 8, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test581() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test581", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test582() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.insert_space_after_closing_angle_bracket_in_type_arguments = false;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test582", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test583() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test583", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test584() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.use_tabs_only_for_leading_indentations", "true");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "mixed");
        options.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", "65");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.size", "4");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test584", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test585() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.use_tabs_only_for_leading_indentations", "true");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "mixed");
        options.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", "80");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.size", "4");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test585", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test586() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.use_tabs_only_for_leading_indentations", "true");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", "65");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.size", "4");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test586", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test587() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.use_tabs_only_for_leading_indentations", "true");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", "80");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.size", "4");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test587", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test588() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test588", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    public void _test589() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test589", "A.js", 8, false);
    }

    public void _test590() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.indent_empty_lines", "true");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test590", "A.js", 8, false);
    }

    public void _test591() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.indent_empty_lines", "false");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test591", "A.js", 8, false);
    }

    public void _test592() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_parameters_in_method_declaration", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)1));
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_paren_in_method_declaration", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_opening_paren_in_method_declaration", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", "60");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "space");
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_arguments_in_method_invocation", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)1));
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_opening_paren_in_method_invocation", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_paren_in_method_invocation", "insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test592", "A.js", 8, false);
    }

    public void _test593() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_assignment", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)3, (int)0));
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_arguments_in_allocation_expression", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)0, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test593", "A.js", 8, false);
    }

    public void _test594() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_assignment", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)1, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test594", "A.js", 8, false);
    }

    public void _test595() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_assignment", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)1, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test595", "A.js", 8, false);
    }

    public void _test596() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_assignment", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)1, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test596", "A.js", 8, false);
    }

    public void _test597() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_arguments_in_method_invocation", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)1));
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "mixed");
        options.put("org.eclipse.wst.jsdt.core.formatter.use_tabs_only_for_leading_indentations", "true");
        options.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", "60");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test597", "A.js", 8, false);
    }

    public void _test598() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_arguments_in_method_invocation", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)5, (int)1));
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.use_tabs_only_for_leading_indentations", "true");
        options.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", "60");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test598", "A.js", 8, false);
    }

    public void _test599() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_arguments_in_method_invocation", DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)3, (int)0));
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.continuation_indentation", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.use_tabs_only_for_leading_indentations", "true");
        options.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", "60");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test599", "A.js", 8, false);
    }

    public void _test600() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test600", "A.js", 8, false);
    }

    public void _test601() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_binary_expression", DefaultCodeFormatterConstants.createAlignmentValue((boolean)true, (int)3, (int)0));
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "tab");
        options.put("org.eclipse.wst.jsdt.core.formatter.use_tabs_only_for_leading_indentations", "true");
        options.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", "60");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test601", "A.js", 8, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test605() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_enum_constants", DefaultCodeFormatterConstants.createAlignmentValue((boolean)true, (int)5, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test605", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    public void _test606() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_parenthesized_expression_in_return", "do not insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test606", "A.js", 8, false);
    }

    public void _test607() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test607", "A.js", 8, false);
    }

    public void _test608() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test608", "A.js", 64, false);
    }

    public void _test609() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.indent_switchstatements_compare_to_cases = true;
        preferences.indent_switchstatements_compare_to_switch = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test609", "A.js", 8, false);
    }

    public void _test610() {
        String resourcePath = this.getResource("test610", "formatter.xml");
        Map options = DecodeCodeFormatterPreferences.decodeCodeFormatterOptions(resourcePath, "mhdk");
        FormatterRegressionTests.assertNotNull((String)"No preferences", (Object)options);
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test610", "A.js", 8);
    }

    public void test611() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.tab_size = 4;
        preferences.indentation_size = 4;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        FormatterRegressionTests.assertEquals((String)"Wrong indentation string", (String)"\t", (String)codeFormatter.createIndentationString(1));
        FormatterRegressionTests.assertEquals((String)"Wrong indentation string", (String)"\t\t", (String)codeFormatter.createIndentationString(2));
        FormatterRegressionTests.assertEquals((String)"Wrong indentation string", (String)"\t\t\t", (String)codeFormatter.createIndentationString(3));
        options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 1;
        preferences.tab_size = 8;
        preferences.indentation_size = 4;
        codeFormatter = new DefaultCodeFormatter(preferences);
        FormatterRegressionTests.assertEquals((String)"Wrong indentation string", (String)"\t", (String)codeFormatter.createIndentationString(1));
        FormatterRegressionTests.assertEquals((String)"Wrong indentation string", (String)"\t\t", (String)codeFormatter.createIndentationString(2));
        FormatterRegressionTests.assertEquals((String)"Wrong indentation string", (String)"\t\t\t", (String)codeFormatter.createIndentationString(3));
        options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 2;
        preferences.tab_size = 2;
        preferences.indentation_size = 4;
        codeFormatter = new DefaultCodeFormatter(preferences);
        FormatterRegressionTests.assertEquals((String)"Wrong indentation string", (String)"  ", (String)codeFormatter.createIndentationString(1));
        FormatterRegressionTests.assertEquals((String)"Wrong indentation string", (String)"    ", (String)codeFormatter.createIndentationString(2));
        FormatterRegressionTests.assertEquals((String)"Wrong indentation string", (String)"      ", (String)codeFormatter.createIndentationString(3));
        options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 4;
        preferences.tab_size = 2;
        preferences.indentation_size = 4;
        codeFormatter = new DefaultCodeFormatter(preferences);
        FormatterRegressionTests.assertEquals((String)"Wrong indentation string", (String)"\t\t", (String)codeFormatter.createIndentationString(1));
        FormatterRegressionTests.assertEquals((String)"Wrong indentation string", (String)"\t\t\t\t", (String)codeFormatter.createIndentationString(2));
        options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        preferences = new DefaultCodeFormatterOptions(options);
        preferences.tab_char = 4;
        preferences.tab_size = 4;
        preferences.indentation_size = 2;
        codeFormatter = new DefaultCodeFormatter(preferences);
        FormatterRegressionTests.assertEquals((String)"Wrong indentation string", (String)"  ", (String)codeFormatter.createIndentationString(1));
        FormatterRegressionTests.assertEquals((String)"Wrong indentation string", (String)"\t", (String)codeFormatter.createIndentationString(2));
        FormatterRegressionTests.assertEquals((String)"Wrong indentation string", (String)"\t  ", (String)codeFormatter.createIndentationString(3));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test612() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.indent_body_declarations_compare_to_annotation_declaration_header = false;
        preferences.indent_body_declarations_compare_to_type_header = true;
        preferences.insert_new_line_in_empty_annotation_declaration = false;
        preferences.insert_new_line_in_empty_type_declaration = true;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test612", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test613() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.indent_body_declarations_compare_to_annotation_declaration_header = true;
        preferences.indent_body_declarations_compare_to_type_header = false;
        preferences.insert_new_line_in_empty_annotation_declaration = true;
        preferences.insert_new_line_in_empty_type_declaration = false;
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test613", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    public void _test614() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test614", "A.js", 8, false);
    }

    public void _test615() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test615", "A.js", 8, false);
    }

    public void _test616() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test616", "A.js", 8, false);
    }

    public void _test617() {
        String resourcePath = this.getResource("test617", "formatter.xml");
        Map options = DecodeCodeFormatterPreferences.decodeCodeFormatterOptions(resourcePath, "JRK");
        FormatterRegressionTests.assertNotNull((String)"No preferences", (Object)options);
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_binary_expression", DefaultCodeFormatterConstants.createAlignmentValue((boolean)true, (int)3, (int)1));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test617", "A.js", 2);
    }

    public void _test618() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test618", "A.js", 8, false);
    }

    public void _test619() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test619", "A.js", 4, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test620() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_closing_angle_bracket_in_type_arguments", "do not insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test620", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test621() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_closing_angle_bracket_in_type_arguments", "do not insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test621", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test622() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test622", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test623() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test623", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test624() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test624", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    public void _test625() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.alignment_for_binary_expression", DefaultCodeFormatterConstants.createAlignmentValue((boolean)true, (int)3, (int)0));
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test625", "A.js", 8, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test626() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.6");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.6");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.6");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.6");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.6");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.6");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test626", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test627() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.brace_position_for_type_declaration = "next_line_on_wrap";
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test627", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test628() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.brace_position_for_type_declaration = "next_line_on_wrap";
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test628", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _test629() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        preferences.brace_position_for_type_declaration = "next_line_on_wrap";
        Hashtable javaCoreOptions = JavaScriptCore.getOptions();
        try {
            Hashtable newJavaCoreOptions = JavaScriptCore.getOptions();
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            newJavaCoreOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            JavaScriptCore.setOptions((Hashtable)newJavaCoreOptions);
            HashMap<String, String> compilerOptions = new HashMap<String, String>();
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
            compilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
            DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences, compilerOptions);
            this.runTest((CodeFormatter)codeFormatter, "test629", "A.js", 8, false);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        JavaScriptCore.setOptions((Hashtable)javaCoreOptions);
    }

    public void _test630() {
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getEclipseDefaultSettings());
        preferences.insert_space_after_opening_paren_in_parenthesized_expression = true;
        preferences.insert_space_before_closing_paren_in_parenthesized_expression = true;
        preferences.insert_space_before_parenthesized_expression_in_throw = true;
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test630", "A.js");
    }

    public void _test631() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_paren_in_parenthesized_expression", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_closing_paren_in_parenthesized_expression", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_parenthesized_expression_in_throw", "insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test631", "A.js");
    }

    public void _test632() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_after_opening_paren_in_parenthesized_expression", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_closing_paren_in_parenthesized_expression", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_parenthesized_expression_in_return", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_space_before_parenthesized_expression_in_throw", "do not insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test632", "A.js");
    }

    public void _test633() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_between_import_groups", "3");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test633", "A.js");
    }

    public void _test634() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_between_import_groups", "1");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test634", "A.js");
    }

    public void _test635() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_between_import_groups", "1");
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_after_imports", "0");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test635", "A.js");
    }

    public void _test636() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_between_import_groups", "3");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test636", "A.js");
    }

    public void _test637() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_between_import_groups", "2");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test637", "A.js");
    }

    public void _test638() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_between_import_groups", "1");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test638", "A.js");
    }

    public void _test639() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_between_import_groups", "2");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test639", "A.js");
    }

    public void _test640() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.blank_lines_between_import_groups", "1");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test640", "A.js");
    }

    public void _test641() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "mixed");
        options.put("org.eclipse.wst.jsdt.core.formatter.use_tabs_only_for_leading_indentations", "true");
        options.put("org.eclipse.wst.jsdt.core.formatter.lineSplit", "36");
        options.put("org.eclipse.wst.jsdt.core.formatter.indentation.size", "2");
        options.put("org.eclipse.wst.jsdt.core.formatter.tabulation.size", "4");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test641", "A.js");
    }

    public void _test642() {
        String resourcePath = this.getResource("test642", "formatter.xml");
        Map options = DecodeCodeFormatterPreferences.decodeCodeFormatterOptions(resourcePath, "Visionnaire");
        FormatterRegressionTests.assertNotNull((String)"No preferences", (Object)options);
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test642", "A.js", 8);
    }

    public void _test643() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_at_end_of_file_if_missing", "insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test643", "A.js");
    }

    public void _test644() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_at_end_of_file_if_missing", "insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test644", "A.js");
    }

    public void _test645() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_at_end_of_file_if_missing", "insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test645", "A.js");
    }

    public void _test646() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_at_end_of_file_if_missing", "do not insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test646", "A.js");
    }

    public void _test647() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_at_end_of_file_if_missing", "do not insert");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test647", "A.js");
    }

    public void _test648() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_at_end_of_file_if_missing", "do not insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "0");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test648", "A.js");
    }

    public void _test649() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("org.eclipse.wst.jsdt.core.formatter.insert_new_line_at_end_of_file_if_missing", "insert");
        options.put("org.eclipse.wst.jsdt.core.formatter.number_of_empty_lines_to_preserve", "0");
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test649", "A.js");
    }

    public void _test650() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test650", "A.js");
    }

    public void _test651() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test651", "A.js");
    }

    public void _test652() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test652", "A.js");
    }

    public void _test653() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test653", "A.js");
    }

    public void _test654() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test654", "A.js");
    }

    public void _test655() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        DefaultCodeFormatterOptions preferences = new DefaultCodeFormatterOptions(options);
        DefaultCodeFormatter codeFormatter = new DefaultCodeFormatter(preferences);
        this.runTest((CodeFormatter)codeFormatter, "test655", "A.js");
    }

    public void test656() {
        this.runTest("test656", "A.js");
    }
}

