/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.IOException;
import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchConstants;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeNameMatchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeNameRequestor;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaSearchTests;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.core.tests.model.SearchTests;

public class JavaSearchMultipleProjectsTests
extends ModifyingResourceTests
implements IJavaScriptSearchConstants {
    private static final int UI_DECLARATIONS = 48;
    static /* synthetic */ Class class$0;

    public JavaSearchMultipleProjectsTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.JavaSearchMultipleProjectsTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return JavaSearchMultipleProjectsTests.buildModelTestSuite(clazz);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testFieldOccurencesInWorkingCopies() throws CoreException {
        IJavaScriptUnit wc2;
        block6: {
            IJavaScriptUnit wc1 = null;
            wc2 = null;
            try {
                IJavaScriptProject p1 = this.createJavaProject("P1");
                this.createFolder("/P1/p1");
                this.createFile("/P1/p1/X.js", "package p1;\npublic class X {\n    public static int FOO;\n}");
                IJavaScriptProject p2 = this.createJavaProject("P2", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P1"});
                this.createFolder("/P2/p2");
                this.createFile("/P2/p2/Y.js", "package p2;\nimport p1.X;\npublic class Y {\n    int bar() {\n      return X.FOO;\n}");
                wc1 = this.getCompilationUnit("P1/p1/X.js").getWorkingCopy(null);
                wc1.getBuffer().setContents("package p1;\npublic class X {\n    public static int BAR;\n}");
                wc1.reconcile(0, false, null, null);
                wc2 = this.getCompilationUnit("P2/p2/Y.js").getWorkingCopy(null);
                wc2.getBuffer().setContents("package p2;\nimport p1.X;\npublic class Y {\n    int bar() {\n      return X.BAR;\n}");
                IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{p1, p2});
                AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
                resultCollector.showProject = true;
                IField field = wc1.getType("X").getField("BAR");
                SearchPattern pattern = SearchPattern.createPattern((IJavaScriptElement)field, (int)3);
                new SearchEngine(new IJavaScriptUnit[]{wc1, wc2}).search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)resultCollector, null);
                JavaSearchMultipleProjectsTests.assertEquals((String)"Unexpected occurences of field p1.X.BAR", (String)"p1/X.java [in P1] p1.X.BAR [BAR]\np2/Y.java [in P2] int p2.Y.bar() [BAR]", (String)resultCollector.toString());
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (wc1 != null) {
                    wc1.discardWorkingCopy();
                }
                if (wc2 != null) {
                    wc2.discardWorkingCopy();
                }
                this.deleteProject("P1");
                this.deleteProject("P2");
                throw throwable;
            }
            {
                Object var9_11 = null;
                if (wc1 == null) break block6;
            }
            wc1.discardWorkingCopy();
        }
        if (wc2 != null) {
            wc2.discardWorkingCopy();
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testHierarchyScope1() throws CoreException {
        try {
            this.createJavaProject("P1");
            this.createFolder("/P1/p");
            this.createFile("/P1/p/X.js", "package p;\npublic class X {\n\tprotected void foo() {\n\t}\n\tvoid bar() {\n\t\tfoo();\n\t}\n}");
            this.createJavaProject("P2", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P1"});
            this.createFile("/P2/Y.js", "import p.X;\npublic class Y extends X {\n\tprotected void foo() {\n\t}\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P2/Y.js");
            IType type = cu.getType("Y");
            IFunction method = type.getFunction("foo", new String[0]);
            IJavaScriptSearchScope scope = SearchEngine.createHierarchyScope((IType)type);
            AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            resultCollector.showProject = true;
            this.search((IJavaScriptElement)method, 2, scope, resultCollector);
            this.assertSearchResults("p/X.java [in P1] void p.X.bar() [foo()]", (Object)resultCollector);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testHierarchyScope2() throws CoreException {
        try {
            this.createJavaProject("P1");
            this.createFolder("/P1/p");
            this.createFile("/P1/p/X.js", "package p;\npublic class X {\n\tprotected void foo() {\n\t}\n\tvoid bar() {\n\t\tfoo();\n\t}\n}");
            this.createJavaProject("P2", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P1"});
            this.createFile("/P2/Y.js", "import p.X;\npublic class Y extends X {\n\tprotected void foo() {\n\t}\n}");
            this.createFile("/P2/Z.js", "public class Z extends Y {\n\tprotected void foo() {\n\t}\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P2/Z.js");
            IType type = cu.getType("Z");
            IFunction method = type.getFunction("foo", new String[0]);
            IJavaScriptSearchScope scope = SearchEngine.createHierarchyScope((IType)type);
            AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            resultCollector.showProject = true;
            this.search((IJavaScriptElement)method, 2, scope, resultCollector);
            this.assertSearchResults("p/X.java [in P1] void p.X.bar() [foo()]", (Object)resultCollector);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testHierarchyScope3() throws CoreException {
        try {
            this.createJavaProject("P1");
            this.createFolder("/P1/p");
            this.createFile("/P1/p/X.js", "package p;\npublic class X {\n\tprotected void foo() {\n\t}\n}");
            this.createJavaProject("P2", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P1"});
            this.createFolder("/P2/q");
            this.createFile("/P2/q/Y.js", "package q;\nimport p.X;\npublic class Y extends X {\n\tvoid bar() {\n\t\tfoo();\n\t}\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P1/p/X.js");
            IType type = cu.getType("X");
            IFunction method = type.getFunction("foo", new String[0]);
            IJavaScriptSearchScope scope = SearchEngine.createHierarchyScope((IType)type);
            AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            resultCollector.showProject = true;
            this.search((IJavaScriptElement)method, 2, scope, resultCollector);
            this.assertSearchResults("q/Y.java [in P2] void q.Y.bar() [foo()]", (Object)resultCollector);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testHierarchyScope4() throws CoreException {
        try {
            this.createJavaProject("P0");
            this.createFolder("/P0/p0");
            this.createFile("/P0/p0/X.js", "package p0;\npublic class X {\n  public static X TheX;\n\tpublic void foo() {\n\t}\n}");
            this.createJavaProject("P1", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P0"});
            this.createFolder("/P1/p1");
            this.createFile("/P1/p1/T.js", "package p1;\nimport p0.X;\npublic class T {\n\tpublic X zork() {\n\t\treturn X.TheX;\n\t}\n}");
            this.createJavaProject("P2", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P0", "/P1"});
            this.createFolder("/P2/p2");
            this.createFile("/P2/p2/Y.js", "package p2;\nimport p0.X;\nimport p1.T;\npublic class Y extends X {\n\tpublic void bar() {\n\t\tnew T().zork().foo();\n\t}\n}");
            this.createJavaProject("P3", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P0", "/P2"});
            this.createFolder("/P3/p3");
            this.createFile("/P3/p3/Z.js", "package p3;\nimport p0.X;\nimport p2.Y;\npublic class Z extends Y {\n\tstatic {\n\t\tX.TheX = new Z(); // zork() will actually answer an instance of Z\n\t}\n\tpublic void foo() {\n\t} // refs should find one in Y.bar()\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P3/p3/Z.js");
            IType type = cu.getType("Z");
            IFunction method = type.getFunction("foo", new String[0]);
            IJavaScriptSearchScope scope = SearchEngine.createHierarchyScope((IType)type);
            AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            resultCollector.showAccuracy = true;
            resultCollector.showProject = true;
            this.search((IJavaScriptElement)method, 2, scope, resultCollector);
            this.assertSearchResults("p2/Y.java [in P2] void p2.Y.bar() [foo()] EXACT_MATCH", (Object)resultCollector);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.deleteProjects(new String[]{"P0", "P1", "P2", "P3"});
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.deleteProjects(new String[]{"P0", "P1", "P2", "P3"});
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testMethodOccurences() throws CoreException {
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1");
            this.createFolder("/P1/p");
            this.createFile("/P1/p/I.js", "package p;\npublic interface I {\n    void method(Object o);\n}");
            this.createFile("/P1/p/C.js", "package p;\npublic class C implements I {\n    void method(Object o) {\n    }\n}");
            p1.getProject().copy((IPath)new Path("/P2"), false, null);
            IJavaScriptProject p2 = this.getJavaProject("P2");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{p1, p2});
            AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            resultCollector.showProject = true;
            IFunction method = this.getCompilationUnit("/P1/p/I.js").getType("I").getFunction("method", new String[]{"QObject;"});
            this.search((IJavaScriptElement)method, 3, scope, resultCollector);
            this.assertSearchResults("Unexpected occurences of method p.I.method(Object)", "p/C.java [in P1] void p.C.method(Object) [method]\np/I.java [in P1] void p.I.method(Object) [method]", (Object)resultCollector);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testPackageDeclaration() throws CoreException {
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1");
            this.createFolder("/P1/p");
            this.createFile("/P1/p/X.js", "package p;\npublic class X {\n}");
            p1.getProject().copy((IPath)new Path("/P2"), false, null);
            IJavaScriptProject p2 = this.getJavaProject("P2");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{p1, p2});
            AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            resultCollector.showProject = true;
            IPackageFragment pkg = this.getPackage("/P1/p");
            this.search((IJavaScriptElement)pkg, 0, scope, resultCollector);
            this.assertSearchResults("Unexpected package declarations", "p [in P1] p", (Object)resultCollector);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testPackageReference1() throws CoreException {
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1");
            this.createFolder("/P1/p");
            this.createFile("/P1/p/X.js", "package p;\npublic class X {\n}");
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P1"});
            this.createFolder("/P2/p");
            this.createFile("/P2/p/Y.js", "package p;\npublic class Y {\n}");
            this.createFolder("/P2/q");
            this.createFile("/P2/q/Z.js", "package q;\nimport p.X;\nimport p.Y;\npublic class Z {\n  X onlyHereForTheImport = null;\n  Y alsoOnlyHereForTheImport = null;\n  void foo(){\n    p.X x = (p.X)null;\n    p.Y y = (p.Y)null;\n  }\n}");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{p1, p2});
            AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            IPackageFragment pkg = this.getPackage("/P1/p");
            this.search((IJavaScriptElement)pkg, 2, scope, resultCollector);
            this.assertSearchResults("Unexpected package references", "q/Z.java [p]\nq/Z.java void q.Z.foo() [p]\nq/Z.java void q.Z.foo() [p]", (Object)resultCollector);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testPackageReference2() throws CoreException, IOException {
        try {
            IJavaScriptProject p1 = this.setUpJavaProject("JavaSearchMultipleProjects1");
            IJavaScriptProject p2 = this.setUpJavaProject("JavaSearchMultipleProjects2");
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{p1, p2});
            AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            IPackageFragment pkg = this.getPackage("/JavaSearchMultipleProjects1/lib/p");
            this.search((IJavaScriptElement)pkg, 2, scope, resultCollector);
            this.assertSearchResults("Unexpected package references", "src/q/Z.java [p]\nsrc/q/Z.java void q.Z.foo() [p]\nsrc/q/Z.java void q.Z.foo() [p]", (Object)resultCollector);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.deleteProject("JavaSearchMultipleProjects1");
            this.deleteProject("JavaSearchMultipleProjects2");
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.deleteProject("JavaSearchMultipleProjects1");
        this.deleteProject("JavaSearchMultipleProjects2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testReferenceInWorkingCopies() throws CoreException {
        IJavaScriptUnit workingCopy2;
        IJavaScriptUnit workingCopy1;
        block6: {
            workingCopy1 = null;
            workingCopy2 = null;
            try {
                IJavaScriptProject p1 = this.createJavaProject("P1");
                this.createFolder("/P1/p1");
                this.createFile("/P1/p1/X.js", "package p1;\npublic class X {\n  void foo() {\n  }\n}");
                this.createFile("/P1/p1/Test.js", "package p1;\npublic class Test {\n}");
                IJavaScriptProject p2 = this.createJavaProject("P2", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P1"});
                this.createFolder("/P2/p2");
                this.createFile("/P2/p2/Y.js", "package p2;\npublic class Y {\n}");
                this.createFile("/P2/p2/Z.js", "public class Z {\n  void bar(p1.Test test) {\n  }\n  void foo() {\n    bar(null);\n  }\n}");
                WorkingCopyOwner owner = new WorkingCopyOwner(){};
                workingCopy1 = this.getCompilationUnit("/P1/p1/X.js").getWorkingCopy(owner, null);
                workingCopy1.getBuffer().setContents("package p1;\npublic class X {\n  void bar(Test test) {\n  }\n}");
                workingCopy1.makeConsistent(null);
                workingCopy2 = this.getCompilationUnit("/P2/p2/Y.js").getWorkingCopy(owner, null);
                workingCopy2.getBuffer().setContents("package p2;\nimport p1.X;\npublic class Y {\n  void fred() {\n    new X().bar(null);\n  }\n}");
                workingCopy2.makeConsistent(null);
                IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{p1, p2});
                AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
                IFunction method = workingCopy1.getType("X").getFunction("bar", new String[]{"QTest;"});
                new SearchEngine(owner).search(SearchPattern.createPattern((IJavaScriptElement)method, (int)2), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)resultCollector, null);
                this.assertSearchResults("Unexpected package references", "p2/Y.java void p2.Y.fred() [bar(null)]", (Object)resultCollector);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (workingCopy1 != null) {
                    workingCopy1.discardWorkingCopy();
                }
                if (workingCopy2 != null) {
                    workingCopy1.discardWorkingCopy();
                }
                this.deleteProject("P1");
                this.deleteProject("P2");
                throw throwable;
            }
            {
                Object var9_11 = null;
                if (workingCopy1 == null) break block6;
            }
            workingCopy1.discardWorkingCopy();
        }
        if (workingCopy2 != null) {
            workingCopy1.discardWorkingCopy();
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testTypeDeclarationInJar() throws CoreException {
        try {
            IJavaScriptProject p1 = this.createJavaProject("P1", new String[0], new String[]{"JCL_LIB"});
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[0], new String[]{"JCL_LIB"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{p1});
            AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            resultCollector.showProject = true;
            this.search("Object", 0, 0, scope, (SearchRequestor)resultCollector);
            this.assertSearchResults("Unexpected result in scope of P1", String.valueOf(this.getSystemJsPathString()) + " [in P1] java.lang.Object", (Object)resultCollector);
            scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{p2});
            resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            resultCollector.showProject = true;
            this.search("Object", 0, 0, scope, (SearchRequestor)resultCollector);
            this.assertSearchResults("Unexpected result in scope of P2", String.valueOf(this.getSystemJsPathString()) + " [in P2] java.lang.Object", (Object)resultCollector);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug151189_Workspace() throws CoreException {
        try {
            this.createJavaProject("P1");
            this.createFolder("/P1/pack");
            this.createFile("/P1/pack/Declaration.js", "package pack;\npublic class Declaration implements Interface {\n\tpublic void doOperation(int val) {}\n}\n");
            this.createFile("/P1/pack/Interface.js", "package pack;\npublic interface Interface {\n\tvoid doOperation(int val);\n}\n");
            this.createJavaProject("P2", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P1"});
            this.createFolder("/P2/test");
            this.createFile("/P2/test/Declaration_bis.js", "package test;\nimport pack.Interface;\npublic class Declaration_bis implements Interface {\n\tpublic void doOperation(int val) {}\n}\n");
            IFunction method = this.getCompilationUnit("/P2/test/Declaration_bis.js").getType("Declaration_bis").getFunction("doOperation", new String[]{"I"});
            IJavaScriptSearchScope scope = SearchEngine.createWorkspaceScope();
            AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            resultCollector.showProject = true;
            this.search((IJavaScriptElement)method, 0, scope, resultCollector);
            this.assertSearchResults("Unexpected declarations of method test.Declaration_bis.doOperation(int)", "test/Declaration_bis.java [in P2] void test.Declaration_bis.doOperation(int) [doOperation]", (Object)resultCollector);
            resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            resultCollector.showProject = true;
            this.search((IJavaScriptElement)method, 48, scope, resultCollector);
            this.assertSearchResults("Unexpected declarations of method test.Declaration_bis.doOperation(int)", "pack/Declaration.java [in P1] void pack.Declaration.doOperation(int) [doOperation]\npack/Interface.java [in P1] void pack.Interface.doOperation(int) [doOperation]\ntest/Declaration_bis.java [in P2] void test.Declaration_bis.doOperation(int) [doOperation]", (Object)resultCollector);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug151189_Project() throws CoreException {
        try {
            this.createJavaProject("P1");
            this.createFolder("/P1/pack");
            this.createFile("/P1/pack/Declaration.js", "package pack;\npublic class Declaration implements Interface {\n\tpublic void doOperation(int val) {}\n}\n");
            this.createFile("/P1/pack/Interface.js", "package pack;\npublic interface Interface {\n\tvoid doOperation(int val);\n}\n");
            IJavaScriptProject p2 = this.createJavaProject("P2", new String[]{""}, new String[]{"JCL_LIB"}, new String[]{"/P1"});
            this.createFolder("/P2/test");
            this.createFile("/P2/test/Declaration_bis.js", "package test;\nimport pack.Interface;\npublic class Declaration_bis implements Interface {\n\tpublic void doOperation(int val) {}\n}\n");
            IFunction method = this.getCompilationUnit("/P2/test/Declaration_bis.js").getType("Declaration_bis").getFunction("doOperation", new String[]{"I"});
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{p2});
            AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            resultCollector.showProject = true;
            this.search((IJavaScriptElement)method, 48, scope, resultCollector);
            this.assertSearchResults("Unexpected declarations of method test.Declaration_bis.doOperation(int)", "pack/Declaration.java [in P1] void pack.Declaration.doOperation(int) [doOperation]\npack/Interface.java [in P1] void pack.Interface.doOperation(int) [doOperation]\ntest/Declaration_bis.java [in P2] void test.Declaration_bis.doOperation(int) [doOperation]", (Object)resultCollector);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug163072() throws CoreException {
        try {
            this.createJavaProject("P1");
            this.createFolder("/P1/test");
            this.createFile("/P1/test/Test.js", "package test;\npublic class Test {\n\tpublic Object getType() {\n\t\treturn null;\n\t}\n\tpublic void foo() {\n\t\tif (getType() == null) {\n\t\t\tSystem.out.println(\"null\");\n\t\t}\n\t}\n}\n");
            this.createJavaProject("P2", new String[]{""}, new String[]{"JCL15_LIB"}, new String[]{"/P1"}, "", "1.5");
            this.createFolder("/P2/pack");
            this.createFile("/P2/pack/FactoryContainer.js", "package pack;\npublic class FactoryContainer {\n\tpublic enum FactoryType { PLUGIN }\n\tpublic FactoryType getType() {\n\t\treturn FactoryType.PLUGIN;\n\t}\n}\n");
            this.createFile("/P2/pack/Reference.js", "package pack;\npublic class Reference {\n\tprivate final FactoryContainer _fc;\n\tpublic Reference() {\n\t\t_fc = new FactoryContainer();\n\t}\n\tboolean foo() {\n\t\treturn _fc.getType() == FactoryContainer.FactoryType.PLUGIN;\n\t}\n}\n");
            IFunction method = this.getCompilationUnit("/P1/test/Test.js").getType("Test").getFunction("getType", new String[0]);
            JavaSearchMultipleProjectsTests.assertTrue((String)"Method 'Test.getType()' should exist!", (boolean)method.exists());
            IJavaScriptSearchScope scope = SearchEngine.createWorkspaceScope();
            AbstractJavaSearchTests.JavaSearchResultCollector resultCollector = new AbstractJavaSearchTests.JavaSearchResultCollector();
            resultCollector.showProject = true;
            resultCollector.showAccuracy = true;
            this.search((IJavaScriptElement)method, 2, scope, resultCollector);
            this.assertSearchResults("Unexpected references of method Test.getType()", "test/Test.java [in P1] void test.Test.foo() [getType()] EXACT_MATCH", (Object)resultCollector);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.deleteProject("P1");
            this.deleteProject("P2");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.deleteProject("P1");
        this.deleteProject("P2");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testBug167743() throws CoreException {
        try {
            IJavaScriptProject p = this.createJavaProject("P");
            this.createFolder("/P/test");
            this.createFile("/P/test/TestClass.js", "package test;\npublic class Test {\n}\n");
            AbstractJavaSearchTests.TypeNameMatchCollector collector = new AbstractJavaSearchTests.TypeNameMatchCollector(){

                public String toString() {
                    return this.toFullyQualifiedNamesString();
                }
            };
            IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{p});
            new SearchEngine().searchAllTypeNames(null, 0, new char[]{'*'}, 2, 0, scope, (TypeNameMatchRequestor)collector, 3, null);
            SearchTests.SearchTypeNameRequestor requestor = new SearchTests.SearchTypeNameRequestor();
            new SearchEngine().searchAllTypeNames(null, 0, new char[]{'*'}, 2, 0, scope, (TypeNameRequestor)requestor, 3, null);
            JavaSearchMultipleProjectsTests.assertEquals((String)"Invalid number of types found!", (int)requestor.size(), (int)collector.size());
            JavaSearchMultipleProjectsTests.assertEquals((String)"Found types sounds not to be correct", (String)requestor.toString(), (String)collector.toString());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteProject("P");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteProject("P");
    }
}

