/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.File;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IImportContainer;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.core.tests.util.Util;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.LocalVariable;

public class MementoTests
extends ModifyingResourceTests {
    static /* synthetic */ Class class$0;

    public MementoTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.MementoTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return MementoTests.buildModelTestSuite(clazz);
    }

    protected void assertMemento(String expected, IJavaScriptElement element) {
        String actual = element.getHandleIdentifier();
        if (!expected.equals(actual)) {
            String escapedExternalJCL = this.getEscapedExternalJCLPath();
            int start = actual.indexOf(escapedExternalJCL);
            if (start != -1) {
                String firstPart = actual.substring(0, start);
                System.out.print(Util.displayString((String)firstPart, (int)2));
                System.out.print(" + getEscapedExternalJCLPath() + ");
                String secondPart = actual.substring(start + escapedExternalJCL.length());
                System.out.print(Util.displayString((String)secondPart, (int)0));
            } else {
                System.out.print(Util.displayString((String)actual, (int)2));
            }
            System.out.println(",");
        }
        MementoTests.assertEquals((String)("Unexpected memento for " + element), (String)expected, (String)actual);
        IJavaScriptElement restored = JavaScriptCore.create((String)actual);
        MementoTests.assertEquals((String)"Unexpected restored element", (Object)element, (Object)restored);
    }

    protected String getEscapedExternalJCLPath() {
        String path = this.getExternalJCLPath("").toString();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < path.length()) {
            char character = path.charAt(i);
            if (character == '/') {
                buffer.append('\\');
            }
            buffer.append(character);
            ++i;
        }
        return buffer.toString();
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.createJavaProject("P", new String[]{"src"}, new String[]{this.getSystemJsPathString(), "/P/lib", "/P/lib/myLib.jar", "/OtherProj/lib", "/OtherProj/lib/myLib.jar"});
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject("P");
        super.tearDownSuite();
    }

    public void testAnonymousTypeMemento1() {
        IType type = this.getCompilationUnit("/P/src/p/X.js").getType("X");
        IType anonymous = type.getInitializer(1).getType("", 1);
        this.assertMemento("=P/src<p{X.java[X|1[", (IJavaScriptElement)anonymous);
        anonymous = type.getInitializer(1).getType("", 2);
        this.assertMemento("=P/src<p{X.java[X|1[!2", (IJavaScriptElement)anonymous);
    }

    public void testAnonymousTypeMemento2() {
        IType type = this.getCompilationUnit("/P/src/p/X.js").getType("X");
        IType anonymous = type.getField("f").getType("", 1);
        this.assertMemento("=P/src<p{X.java[X^f[", (IJavaScriptElement)anonymous);
        anonymous = type.getField("f").getType("", 3);
        this.assertMemento("=P/src<p{X.java[X^f[!3", (IJavaScriptElement)anonymous);
    }

    public void testAnonymousTypeMemento3() {
        IType type = this.getCompilationUnit("/P/src/p/X.js").getType("X");
        IType anonymous = type.getFunction("foo", new String[0]).getType("", 1);
        this.assertMemento("=P/src<p{X.java[X~foo[", (IJavaScriptElement)anonymous);
        anonymous = type.getFunction("foo", new String[0]).getType("", 4);
        this.assertMemento("=P/src<p{X.java[X~foo[!4", (IJavaScriptElement)anonymous);
    }

    public void testBinaryFieldMemento() throws JavaScriptModelException {
        IField field = this.getClassFile("/P/lib/p/X.class").getType().getField("field");
        this.assertMemento("=P/lib<p(X.class[X^field", (IJavaScriptElement)field);
    }

    public void testBinaryInnerTypeMemento() throws JavaScriptModelException {
        IType type = this.getClassFile("/P/lib/p/X$Inner.class").getType();
        this.assertMemento("=P/lib<p(X$Inner.class[Inner", (IJavaScriptElement)type);
        IField innerField = type.getField("field");
        this.assertMemento("=P/lib<p(X$Inner.class[Inner^field", (IJavaScriptElement)innerField);
        IFunction innerMethod = type.getFunction("foo", new String[]{"I", "Ljava.lang.String;"});
        this.assertMemento("=P/lib<p(X$Inner.class[Inner~foo~I~Ljava.lang.String;", (IJavaScriptElement)innerMethod);
    }

    public void testBinaryMethodMemento1() throws JavaScriptModelException {
        IType type = this.getClassFile("/P/lib/p/X.class").getType();
        IFunction method = type.getFunction("foo", new String[]{"I", "Ljava.lang.String;"});
        this.assertMemento("=P/lib<p(X.class[X~foo~I~Ljava.lang.String;", (IJavaScriptElement)method);
    }

    public void testBinaryMethodMemento2() throws JavaScriptModelException {
        IType type = this.getClassFile("/P/lib/p/X.class").getType();
        IFunction method = type.getFunction("bar", new String[0]);
        this.assertMemento("=P/lib<p(X.class[X~bar", (IJavaScriptElement)method);
    }

    public void testBinaryMethodMemento3() throws JavaScriptModelException {
        IType type = this.getClassFile("/P/lib/p/X.class").getType();
        IFunction method = type.getFunction("fred", new String[]{"[Z"});
        this.assertMemento("=P/lib<p(X.class[X~fred~\\[Z", (IJavaScriptElement)method);
    }

    public void testBinaryMethodMemento4() throws JavaScriptModelException {
        IType type = this.getClassFile("/P/lib/p/X.class").getType();
        IFunction method = type.getFunction("foo", new String[]{"Ljava.util.Collection<*>;"});
        this.assertMemento("=P/lib<p(X.class[X~foo~Ljava.util.Collection\\<*>;", (IJavaScriptElement)method);
    }

    public void testBinaryTypeMemento() throws JavaScriptModelException {
        IType type = this.getClassFile("/P/lib/p/X.class").getType();
        this.assertMemento("=P/lib<p(X.class[X", (IJavaScriptElement)type);
    }

    public void testClassFileMemento() {
        IClassFile cf = this.getClassFile("/P/lib/p/X.class");
        this.assertMemento("=P/lib<p(X.class", (IJavaScriptElement)cf);
        cf = this.getClassFile("/P/lib/Y.class");
        this.assertMemento("=P/lib<(Y.class", (IJavaScriptElement)cf);
    }

    public void testCompilationUnitMemento() {
        IJavaScriptUnit cu = this.getCompilationUnit("/P/src/p/X.js");
        this.assertMemento("=P/src<p{X.js", (IJavaScriptElement)cu);
        cu = this.getCompilationUnit("/P/src/Y.js");
        this.assertMemento("=P/src<{Y.js", (IJavaScriptElement)cu);
    }

    public void testExternalJarBinaryFieldMemento() throws JavaScriptModelException {
        IType type = this.getClassFile("P", this.getSystemJsPathString(), "p", "X.class").getType();
        IField field = type.getField("field");
        this.assertMemento("=P/" + this.getEscapedExternalJCLPath() + "<p(X.class[X^field", (IJavaScriptElement)field);
    }

    public void testExternalJarBinaryInnerTypeMemento() throws JavaScriptModelException {
        IType type = this.getClassFile("P", this.getSystemJsPathString(), "p", "X$Inner.class").getType();
        this.assertMemento("=P/" + this.getEscapedExternalJCLPath() + "<p(X$Inner.class[Inner", (IJavaScriptElement)type);
    }

    public void testExternalJarBinaryMethodMemento() throws JavaScriptModelException {
        IType type = this.getClassFile("P", this.getSystemJsPathString(), "p", "X.class").getType();
        IFunction method = type.getFunction("foo", new String[]{"[Ljava.lang.String;"});
        this.assertMemento("=P/" + this.getEscapedExternalJCLPath() + "<p(X.class[X~foo~\\[Ljava.lang.String;", (IJavaScriptElement)method);
    }

    public void testExternalJarBinaryTypeMemento() throws JavaScriptModelException {
        IType type = this.getClassFile("P", this.getSystemJsPathString(), "p", "X.class").getType();
        this.assertMemento("=P/" + this.getEscapedExternalJCLPath() + "<p(X.class[X", (IJavaScriptElement)type);
    }

    public void testExternalJarClassFileMemento() throws JavaScriptModelException {
        char separator = File.separatorChar;
        String device = separator == '/' ? "" : "C:";
        IClassFile classFile = this.getClassFile("P", String.valueOf(device) + separator + "lib.jar", "p", "X.class");
        this.assertMemento("=P/" + device + "\\/lib.jar<p(X.class", (IJavaScriptElement)classFile);
    }

    public void testImportContainerMemento() {
        IImportContainer importContainer = this.getCompilationUnit("/P/src/p/X.js").getImportContainer();
        this.assertMemento("=P/src<p{X.java#", (IJavaScriptElement)importContainer);
    }

    public void testImportDeclarationMemento() {
        IImportDeclaration importDecl = this.getCompilationUnit("/P/src/p/X.js").getImport("java.io.Serializable");
        this.assertMemento("=P/src<p{X.java#java.io.Serializable", (IJavaScriptElement)importDecl);
        importDecl = this.getCompilationUnit("/P/src/p/X.js").getImport("java.util.*");
        this.assertMemento("=P/src<p{X.java#java.util.*", (IJavaScriptElement)importDecl);
    }

    public void testInvalidMemento() {
        IJavaScriptElement element = JavaScriptCore.create((String)"=P/src<p{");
        this.assertElementEquals("Unexpected element", "p [in src [in P]]", element);
    }

    public void testInitializerMemento() {
        IType type = this.getCompilationUnit("/P/src/p/X.js").getType("X");
        IInitializer initializer = type.getInitializer(1);
        this.assertMemento("=P/src<p{X.java[X|1", (IJavaScriptElement)initializer);
        initializer = type.getInitializer(2);
        this.assertMemento("=P/src<p{X.java[X|2", (IJavaScriptElement)initializer);
    }

    public void testInternalJarBinaryFieldMemento() throws JavaScriptModelException {
        IType type = this.getPackageFragmentRoot("/P/lib/myLib.jar").getPackageFragment("p").getClassFile("X.class").getType();
        IField field = type.getField("field");
        this.assertMemento("=P/lib\\/myLib.jar<p(X.class[X^field", (IJavaScriptElement)field);
    }

    public void testInternalJarBinaryInnerTypeMemento() throws JavaScriptModelException {
        IType type = this.getPackageFragmentRoot("/P/lib/myLib.jar").getPackageFragment("p").getClassFile("X$Inner.class").getType();
        this.assertMemento("=P/lib\\/myLib.jar<p(X$Inner.class[Inner", (IJavaScriptElement)type);
    }

    public void testInternalJarBinaryMethodMemento() throws JavaScriptModelException {
        IType type = this.getPackageFragmentRoot("/P/lib/myLib.jar").getPackageFragment("p").getClassFile("X.class").getType();
        IFunction method = type.getFunction("foo", new String[]{"[Ljava.lang.String;"});
        this.assertMemento("=P/lib\\/myLib.jar<p(X.class[X~foo~\\[Ljava.lang.String;", (IJavaScriptElement)method);
    }

    public void testInternalJarBinaryTypeMemento() throws JavaScriptModelException {
        IType type = this.getPackageFragmentRoot("/P/lib/myLib.jar").getPackageFragment("p").getClassFile("X.class").getType();
        this.assertMemento("=P/lib\\/myLib.jar<p(X.class[X", (IJavaScriptElement)type);
    }

    public void testLocalTypeMemento1() {
        IType type = this.getCompilationUnit("/P/src/p/X.js").getType("X");
        IType anonymous = type.getInitializer(1).getType("Y", 1);
        this.assertMemento("=P/src<p{X.java[X|1[Y", (IJavaScriptElement)anonymous);
        anonymous = type.getInitializer(1).getType("Y", 2);
        this.assertMemento("=P/src<p{X.java[X|1[Y!2", (IJavaScriptElement)anonymous);
    }

    public void testLocalTypeMemento2() {
        IType type = this.getCompilationUnit("/P/src/p/X.js").getType("X");
        IType anonymous = type.getFunction("foo", new String[0]).getType("Y", 1);
        this.assertMemento("=P/src<p{X.java[X~foo[Y", (IJavaScriptElement)anonymous);
        anonymous = type.getFunction("foo", new String[0]).getType("Y", 3);
        this.assertMemento("=P/src<p{X.java[X~foo[Y!3", (IJavaScriptElement)anonymous);
    }

    public void testLocalVariableMemento1() {
        IType type = this.getCompilationUnit("/P/src/p/X.js").getType("X");
        IFunction method = type.getFunction("foo", new String[0]);
        LocalVariable localVar = new LocalVariable((JavaElement)method, "var", 1, 2, 3, 4, "Z");
        this.assertMemento("=P/src<p{X.java[X~foo@var!1!2!3!4!Z", (IJavaScriptElement)localVar);
    }

    public void testLocalVariableMemento3() {
        IType type = this.getCompilationUnit("/P/src/p/X.js").getType("X");
        IInitializer initializer = type.getInitializer(1);
        LocalVariable localVar = new LocalVariable((JavaElement)initializer, "var", 1, 2, 3, 4, "Z");
        this.assertMemento("=P/src<p{X.java[X|1@var!1!2!3!4!Z", (IJavaScriptElement)localVar);
    }

    public void testLocalVariableMemento2() throws JavaScriptModelException {
        IType type = this.getClassFile("/P/src/p/X.class").getType();
        IFunction method = type.getFunction("foo", new String[]{"I"});
        LocalVariable localVar = new LocalVariable((JavaElement)method, "var", 1, 2, 3, 4, "Z");
        this.assertMemento("=P/src<p(X.class[X~foo~I@var!1!2!3!4!Z", (IJavaScriptElement)localVar);
    }

    public void testPackageFragmentMemento() {
        IPackageFragment pkg = this.getPackage("/P/src/p");
        this.assertMemento("=P/src<p", (IJavaScriptElement)pkg);
        pkg = this.getPackage("/P/src/p1/p2");
        this.assertMemento("=P/src<p1.p2", (IJavaScriptElement)pkg);
        pkg = this.getPackage("/P/src");
        this.assertMemento("=P/src<", (IJavaScriptElement)pkg);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testPackageFragmentMemento2() throws CoreException {
        try {
            this.createJavaProject("P1", new String[]{""});
            IPackageFragment pkg = this.getPackage("/P1/p");
            this.assertMemento("=P1/<p", (IJavaScriptElement)pkg);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteProject("P1");
    }

    public void testPackageFragmentRootMemento1() {
        IJavaScriptProject project = this.getJavaProject("P");
        IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)project.getProject().getFolder("src"));
        this.assertMemento("=P/src", (IJavaScriptElement)root);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testPackageFragmentRootMemento2() throws CoreException {
        try {
            IJavaScriptProject project = this.createJavaProject("P1", new String[]{""});
            IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)project.getProject());
            this.assertMemento("=P1/", (IJavaScriptElement)root);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.deleteProject("P1");
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.deleteProject("P1");
    }

    public void testPackageFragmentRootMemento3() {
        IJavaScriptProject project = this.getJavaProject("P");
        IFolder libFolder = project.getProject().getFolder("lib");
        IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)libFolder);
        this.assertMemento("=P/lib", (IJavaScriptElement)root);
    }

    public void testPackageFragmentRootMemento4() {
        IJavaScriptProject project = this.getJavaProject("P");
        IFolder otherLibFolder = this.getFolder("/OtherProj/lib");
        IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)otherLibFolder);
        this.assertMemento("=P/\\/OtherProj\\/lib", (IJavaScriptElement)root);
    }

    public void testPackageFragmentRootMemento5() {
        IJavaScriptProject project = this.getJavaProject("P");
        IFile jar = this.getFile("/P/lib/myLib.jar");
        IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)jar);
        this.assertMemento("=P/lib\\/myLib.jar", (IJavaScriptElement)root);
    }

    public void testPackageFragmentRootMemento6() {
        IJavaScriptProject project = this.getJavaProject("P");
        IFile jar = this.getFile("/OtherProj/lib/myLib.jar");
        IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)jar);
        this.assertMemento("=P/\\/OtherProj\\/lib\\/myLib.jar", (IJavaScriptElement)root);
    }

    public void testPackageFragmentRootMemento7() throws CoreException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot("P", this.getSystemJsPathString());
        this.assertMemento("=P/" + this.getEscapedExternalJCLPath(), (IJavaScriptElement)root);
    }

    public void testPackageFragmentRootMemento8() {
        IJavaScriptProject project = this.getJavaProject("P");
        IProject otherLibFolder = this.getProject("/OtherProj");
        IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)otherLibFolder);
        this.assertMemento("=P/\\/OtherProj", (IJavaScriptElement)root);
    }

    public void testProjectMemento() {
        IJavaScriptProject project = this.getJavaProject("P");
        this.assertMemento("=P", (IJavaScriptElement)project);
    }

    public void testProjectMemento2() {
        IJavaScriptProject project = this.getJavaProject("P (abc) ~");
        this.assertMemento("=P \\(abc) \\~", (IJavaScriptElement)project);
    }

    public void testProjectMemento3() {
        IJavaScriptProject project = this.getJavaProject("P[]");
        this.assertMemento("=P\\[\\]", (IJavaScriptElement)project);
    }

    public void testRestoreBogusMemento() {
        IJavaScriptElement restored = JavaScriptCore.create((String)"bogus");
        MementoTests.assertEquals((String)"should not be able to restore a bogus memento", null, (Object)restored);
    }

    public void testSourceFieldMemento() {
        IField field = this.getCompilationUnit("/P/src/p/X.js").getType("X").getField("field");
        this.assertMemento("=P/src<p{X.java[X^field", (IJavaScriptElement)field);
    }

    public void testSourceInnerTypeMemento() {
        IType innerType = this.getCompilationUnit("/P/src/p/X.js").getType("X").getType("Inner");
        this.assertMemento("=P/src<p{X.java[X[Inner", (IJavaScriptElement)innerType);
    }

    public void testSourceMethodMemento1() {
        IType type = this.getCompilationUnit("/P/src/p/X.js").getType("X");
        IFunction method = type.getFunction("foo", new String[]{"I", "Ljava.lang.String;"});
        this.assertMemento("=P/src<p{X.java[X~foo~I~Ljava.lang.String;", (IJavaScriptElement)method);
    }

    public void testSourceMethodMemento2() {
        IType type = this.getCompilationUnit("/P/src/p/X.js").getType("X");
        IFunction method = type.getFunction("bar", new String[0]);
        this.assertMemento("=P/src<p{X.java[X~bar", (IJavaScriptElement)method);
    }

    public void testSourceMethodMemento3() {
        IType type = this.getCompilationUnit("/P/src/p/X.js").getType("X");
        IFunction method = type.getFunction("fred", new String[]{"[Z"});
        this.assertMemento("=P/src<p{X.java[X~fred~\\[Z", (IJavaScriptElement)method);
    }

    public void testSourceTypeMemento() {
        IType type = this.getCompilationUnit("/P/src/p/X.js").getType("X");
        this.assertMemento("=P/src<p{X.java[X", (IJavaScriptElement)type);
    }
}

