/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaEmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaIdMapping;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class GenericJavaPersistentAttributeTests
extends ContextModelTestCase {
    private ICompilationUnit createTestEntityAnnotatedField() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedMethod() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    public GenericJavaPersistentAttributeTests(String name) {
        super(name);
    }

    public void testGetName() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getName());
    }

    public void testGetMapping() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof JavaIdMapping));
        persistentAttribute.setMappingKey(null);
        GenericJavaPersistentAttributeTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof JavaBasicMapping));
    }

    public void testGetSpecifiedMapping() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof JavaIdMapping));
        persistentAttribute.setMappingKey(null);
        GenericJavaPersistentAttributeTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
    }

    public void testGetSpecifiedMappingNull() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaPersistentAttributeTests.assertNotNull((Object)persistentAttribute.getMapping());
    }

    public void testMappingKey() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getMappingKey());
        persistentAttribute.setMappingKey(null);
        GenericJavaPersistentAttributeTests.assertEquals((String)"basic", (String)persistentAttribute.getMappingKey());
    }

    public void testDefaultMappingKey() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getMappingKey());
        GenericJavaPersistentAttributeTests.assertEquals((String)"basic", (String)persistentAttribute.getDefaultMappingKey());
    }

    public void testSetSpecifiedMappingKey() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        persistentAttribute.setMappingKey("embedded");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GenericJavaPersistentAttributeTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Embedded"));
        GenericJavaPersistentAttributeTests.assertEquals((String)"embedded", (String)persistentAttribute.getMappingKey());
        GenericJavaPersistentAttributeTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof JavaEmbeddedMapping));
    }

    public void testSetSpecifiedMappingKey2() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getMappingKey());
        persistentAttribute.setMappingKey("embedded");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GenericJavaPersistentAttributeTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Embedded"));
        GenericJavaPersistentAttributeTests.assertEquals((String)"embedded", (String)persistentAttribute.getMappingKey());
        GenericJavaPersistentAttributeTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof JavaEmbeddedMapping));
    }

    public void testSetSpecifiedMappingKeyNull() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getMappingKey());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GenericJavaPersistentAttributeTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Id"));
        GenericJavaPersistentAttributeTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
    }

    public void testGetMappingKeyMappingChangeInResourceModel() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getMappingKey());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.setPrimaryAnnotation("javax.persistence.Embedded", EmptyIterable.instance());
        this.getJpaProject().synchronizeContextModel();
        GenericJavaPersistentAttributeTests.assertEquals((String)"embedded", (String)persistentAttribute.getMappingKey());
    }

    public void testGetMappingKeyMappingChangeInResourceModel2() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.setPrimaryAnnotation("javax.persistence.Basic", EmptyIterable.instance());
        GenericJavaPersistentAttributeTests.assertEquals((String)"basic", (String)persistentAttribute.getMapping().getKey());
    }

    public void testGetAccessField() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)persistentAttribute.getAccess());
        GenericJavaPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)persistentAttribute.getDefaultAccess());
        GenericJavaPersistentAttributeTests.assertEquals(null, (Object)persistentAttribute.getSpecifiedAccess());
    }

    public void testGetAccessProperty() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        GenericJavaPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)persistentAttribute.getAccess());
        GenericJavaPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)persistentAttribute.getDefaultAccess());
        GenericJavaPersistentAttributeTests.assertEquals(null, (Object)persistentAttribute.getSpecifiedAccess());
    }
}

