/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.ReadOnlyAttributeOverride;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaEmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaEmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.GenericJavaNullAttributeMapping;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JavaEmbeddedIdMappingTests
extends ContextModelTestCase {
    public static final String EMBEDDABLE_TYPE_NAME = "MyEmbeddable";
    public static final String FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME = "test.MyEmbeddable";

    private ICompilationUnit createTestEntityWithEmbeddedIdMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.EmbeddedId"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@EmbeddedId").append(CR);
                sb.append(CR);
                sb.append("    private MyEmbeddable myEmbeddedId;").append(CR);
                sb.append(CR);
            }
        });
    }

    private void createEmbeddableType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append(JavaEmbeddedIdMappingTests.EMBEDDABLE_TYPE_NAME).append(" {");
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    ");
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "MyEmbeddable.java", sourceWriter);
    }

    public JavaEmbeddedIdMappingTests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey("basic");
        JavaEmbeddedIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        JavaEmbeddedIdMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.EmbeddedId"));
        JavaEmbeddedIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Basic"));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaEmbeddedIdMappingTests.assertTrue((boolean)((JavaEmbeddedMapping)persistentAttribute.getMapping()).getAttributeOverrideContainer().overrides().hasNext());
        JavaEmbeddedIdMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.EmbeddedId"));
        JavaEmbeddedIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testDefaultEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaEmbeddedIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof GenericJavaNullAttributeMapping));
        JavaEmbeddedIdMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        this.createEmbeddableType();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        JavaEmbeddedIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        JavaEmbeddedIdMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey("version");
        JavaEmbeddedIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof VersionMapping));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.EmbeddedId"));
        JavaEmbeddedIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Version"));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey("transient");
        JavaEmbeddedIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.EmbeddedId"));
        JavaEmbeddedIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Transient"));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey("id");
        JavaEmbeddedIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof IdMapping));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.EmbeddedId"));
        JavaEmbeddedIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Id"));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey("embedded");
        JavaEmbeddedIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.EmbeddedId"));
        JavaEmbeddedIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Embedded"));
        JavaEmbeddedIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey("oneToOne");
        JavaEmbeddedIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.EmbeddedId"));
        JavaEmbeddedIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.OneToOne"));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey("oneToMany");
        JavaEmbeddedIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.EmbeddedId"));
        JavaEmbeddedIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.OneToMany"));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey("manyToOne");
        JavaEmbeddedIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.EmbeddedId"));
        JavaEmbeddedIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToOne"));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey("manyToMany");
        JavaEmbeddedIdMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.EmbeddedId"));
        JavaEmbeddedIdMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToMany"));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
    }

    public void testSpecifiedAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        JavaEmbeddedIdMapping embeddedIdMapping = (JavaEmbeddedIdMapping)this.getJavaPersistentType().getAttributeNamed("myEmbeddedId").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = embeddedIdMapping.getAttributeOverrideContainer();
        ListIterator specifiedAttributeOverrides = attributeOverrideContainer.specifiedOverrides();
        JavaEmbeddedIdMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedOverrides();
        JavaEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedOverrides();
        JavaEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedOverrides();
        JavaEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeResource.moveAnnotation(1, 0, "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedOverrides();
        JavaEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedOverrides();
        JavaEmbeddedIdMappingTests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedOverrides();
        JavaEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)((JavaAttributeOverride)specifiedAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedOverrides();
        JavaEmbeddedIdMappingTests.assertFalse((boolean)specifiedAttributeOverrides.hasNext());
    }

    public void testVirtualAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        JavaEmbeddedIdMapping embeddedMapping = (JavaEmbeddedIdMapping)this.getJavaPersistentType().getAttributeNamed("myEmbeddedId").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaEmbeddedIdMappingTests.assertEquals((String)"myEmbeddedId", (String)attributeResource.getName());
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        JavaEmbeddedIdMappingTests.assertEquals((int)2, (int)attributeOverrideContainer.virtualOverridesSize());
        ReadOnlyAttributeOverride defaultAttributeOverride = (ReadOnlyAttributeOverride)attributeOverrideContainer.virtualOverrides().next();
        JavaEmbeddedIdMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"AnnotationTestType", (String)defaultAttributeOverride.getColumn().getTable());
        JavaEmbeddedIdMappingTests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        JavaEmbeddedIdMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        JavaEmbeddedIdMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        JavaEmbeddedIdMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        JavaEmbeddedIdMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        JavaEmbeddedIdMappingTests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        JavaEmbeddedIdMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        JavaEmbeddedIdMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        Embeddable embeddable = (Embeddable)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        BasicMapping cityMapping = (BasicMapping)embeddable.getPersistentType().getAttributeNamed("city").getMapping();
        cityMapping.getColumn().setSpecifiedName("FOO");
        cityMapping.getColumn().setSpecifiedTable("BAR");
        cityMapping.getColumn().setColumnDefinition("COLUMN_DEF");
        cityMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        cityMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        cityMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        cityMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        JavaEmbeddedIdMappingTests.assertEquals((String)"myEmbeddedId", (String)attributeResource.getName());
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
        JavaEmbeddedIdMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        JavaEmbeddedIdMappingTests.assertEquals((int)2, (int)attributeOverrideContainer.virtualOverridesSize());
        defaultAttributeOverride = (ReadOnlyAttributeOverride)attributeOverrideContainer.virtualOverrides().next();
        JavaEmbeddedIdMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"FOO", (String)defaultAttributeOverride.getColumn().getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"BAR", (String)defaultAttributeOverride.getColumn().getTable());
        JavaEmbeddedIdMappingTests.assertEquals((String)"COLUMN_DEF", (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        JavaEmbeddedIdMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        JavaEmbeddedIdMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        JavaEmbeddedIdMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUnique());
        JavaEmbeddedIdMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isNullable());
        JavaEmbeddedIdMappingTests.assertEquals((int)5, (int)defaultAttributeOverride.getColumn().getLength());
        JavaEmbeddedIdMappingTests.assertEquals((int)6, (int)defaultAttributeOverride.getColumn().getPrecision());
        JavaEmbeddedIdMappingTests.assertEquals((int)7, (int)defaultAttributeOverride.getColumn().getScale());
        cityMapping.getColumn().setSpecifiedName(null);
        cityMapping.getColumn().setSpecifiedTable(null);
        cityMapping.getColumn().setColumnDefinition(null);
        cityMapping.getColumn().setSpecifiedInsertable(null);
        cityMapping.getColumn().setSpecifiedUpdatable(null);
        cityMapping.getColumn().setSpecifiedUnique(null);
        cityMapping.getColumn().setSpecifiedNullable(null);
        cityMapping.getColumn().setSpecifiedLength(null);
        cityMapping.getColumn().setSpecifiedPrecision(null);
        cityMapping.getColumn().setSpecifiedScale(null);
        defaultAttributeOverride = (ReadOnlyAttributeOverride)attributeOverrideContainer.virtualOverrides().next();
        JavaEmbeddedIdMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"AnnotationTestType", (String)defaultAttributeOverride.getColumn().getTable());
        JavaEmbeddedIdMappingTests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        JavaEmbeddedIdMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        JavaEmbeddedIdMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        JavaEmbeddedIdMappingTests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        JavaEmbeddedIdMappingTests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        JavaEmbeddedIdMappingTests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        JavaEmbeddedIdMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        JavaEmbeddedIdMappingTests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        annotation.setName("city");
        this.getJpaProject().synchronizeContextModel();
        JavaEmbeddedIdMappingTests.assertEquals((int)1, (int)attributeOverrideContainer.virtualOverridesSize());
    }

    public void testSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)this.getJavaPersistentType().getAttributeNamed("myEmbeddedId").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = embeddedIdMapping.getAttributeOverrideContainer();
        JavaEmbeddedIdMappingTests.assertEquals((int)0, (int)attributeOverrideContainer.specifiedOverridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        JavaEmbeddedIdMappingTests.assertEquals((int)2, (int)attributeOverrideContainer.specifiedOverridesSize());
    }

    public void testAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)this.getJavaPersistentType().getAttributeNamed("myEmbeddedId").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = embeddedIdMapping.getAttributeOverrideContainer();
        JavaEmbeddedIdMappingTests.assertEquals((int)2, (int)attributeOverrideContainer.overridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("BAR");
        this.getJpaProject().synchronizeContextModel();
        JavaEmbeddedIdMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.overridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        JavaEmbeddedIdMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.overridesSize());
    }

    public void testVirtualAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        JavaEmbeddedIdMapping embeddedIdMapping = (JavaEmbeddedIdMapping)this.getJavaPersistentType().getAttributeNamed("myEmbeddedId").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = embeddedIdMapping.getAttributeOverrideContainer();
        JavaEmbeddedIdMappingTests.assertEquals((int)2, (int)attributeOverrideContainer.virtualOverridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        JavaEmbeddedIdMappingTests.assertEquals((int)2, (int)attributeOverrideContainer.virtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        JavaEmbeddedIdMappingTests.assertEquals((int)1, (int)attributeOverrideContainer.virtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("state");
        this.getJpaProject().synchronizeContextModel();
        JavaEmbeddedIdMappingTests.assertEquals((int)0, (int)attributeOverrideContainer.virtualOverridesSize());
    }

    public void testAttributeOverrideSetVirtual() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        JavaEmbeddedIdMapping embeddedIdMapping = (JavaEmbeddedIdMapping)this.getJavaPersistentType().getAttributeNamed("myEmbeddedId").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = embeddedIdMapping.getAttributeOverrideContainer();
        ((JavaVirtualAttributeOverride)attributeOverrideContainer.virtualOverrides().next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)attributeOverrideContainer.virtualOverrides().next()).convertToSpecified();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        Iterator attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        ((JavaAttributeOverride)attributeOverrideContainer.specifiedOverrides().next()).convertToVirtual();
        attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        JavaEmbeddedIdMappingTests.assertEquals((String)"city", (String)((JavaVirtualAttributeOverride)attributeOverrideContainer.virtualOverrides().next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((int)1, (int)attributeOverrideContainer.virtualOverridesSize());
        ((JavaAttributeOverride)attributeOverrideContainer.specifiedOverrides().next()).convertToVirtual();
        attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.virtualOverrides();
        JavaEmbeddedIdMappingTests.assertEquals((String)"city", (String)((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"state", (String)((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((int)2, (int)attributeOverrideContainer.virtualOverridesSize());
    }

    public void testAttributeOverrideSetVirtual2() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        JavaEmbeddedIdMapping embeddedIdMapping = (JavaEmbeddedIdMapping)this.getJavaPersistentType().getAttributeNamed("myEmbeddedId").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = embeddedIdMapping.getAttributeOverrideContainer();
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.virtualOverrides();
        virtualAttributeOverrides.next();
        ((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)attributeOverrideContainer.virtualOverrides().next()).convertToSpecified();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        Iterator attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        JavaEmbeddedIdMapping embeddedIdMapping = (JavaEmbeddedIdMapping)this.getJavaPersistentType().getAttributeNamed("myEmbeddedId").getMapping();
        JavaAttributeOverrideContainer attributeOverrideContainer = embeddedIdMapping.getAttributeOverrideContainer();
        ((JavaVirtualAttributeOverride)attributeOverrideContainer.virtualOverrides().next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)attributeOverrideContainer.virtualOverrides().next()).convertToSpecified();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.moveAnnotation(1, 0, "javax.persistence.AttributeOverrides");
        Iterator attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        JavaEmbeddedIdMappingTests.assertEquals((String)"state", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertEquals((String)"city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        JavaEmbeddedIdMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
    }
}

