/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.GeneratedValue;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.resource.java.GeneratedValueAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.GenerationType;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JavaGeneratedValueTests
extends ContextModelTestCase {
    private static final String GENERATOR = "MY_GENERATOR";

    private ICompilationUnit createTestEntityWithGeneratedValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.GeneratedValue", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@GeneratedValue(generator=\"MY_GENERATOR\")");
            }
        });
    }

    public JavaGeneratedValueTests(String name) {
        super(name);
    }

    public void testGetGenerator() throws Exception {
        this.createTestEntityWithGeneratedValue();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaGeneratedValueTests.assertEquals((String)GENERATOR, (String)idMapping.getGeneratedValue().getGenerator());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GeneratedValueAnnotation generatedValue = (GeneratedValueAnnotation)attributeResource.getAnnotation("javax.persistence.GeneratedValue");
        generatedValue.setGenerator("foo");
        this.getJpaProject().synchronizeContextModel();
        JavaGeneratedValueTests.assertEquals((String)"foo", (String)idMapping.getGeneratedValue().getGenerator());
    }

    public void testSetSpecifiedGenerator() throws Exception {
        this.createTestEntityWithGeneratedValue();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaGeneratedValueTests.assertEquals((String)GENERATOR, (String)idMapping.getGeneratedValue().getGenerator());
        idMapping.getGeneratedValue().setSpecifiedGenerator("foo");
        JavaGeneratedValueTests.assertEquals((String)"foo", (String)idMapping.getGeneratedValue().getGenerator());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GeneratedValueAnnotation generatedValue = (GeneratedValueAnnotation)attributeResource.getAnnotation("javax.persistence.GeneratedValue");
        JavaGeneratedValueTests.assertEquals((String)"foo", (String)generatedValue.getGenerator());
    }

    public void testSetSpecifiedNameNull() throws Exception {
        this.createTestEntityWithGeneratedValue();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaGeneratedValueTests.assertEquals((String)GENERATOR, (String)idMapping.getGeneratedValue().getGenerator());
        idMapping.getGeneratedValue().setSpecifiedGenerator(null);
        JavaGeneratedValueTests.assertNotNull((Object)idMapping.getGeneratedValue());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GeneratedValueAnnotation generatedValue = (GeneratedValueAnnotation)attributeResource.getAnnotation("javax.persistence.GeneratedValue");
        JavaGeneratedValueTests.assertNotNull((Object)generatedValue);
    }

    public void testGetStrategy() throws Exception {
        this.createTestEntityWithGeneratedValue();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaGeneratedValueTests.assertEquals((Object)GeneratedValue.DEFAULT_STRATEGY, (Object)idMapping.getGeneratedValue().getStrategy());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GeneratedValueAnnotation generatedValue = (GeneratedValueAnnotation)attributeResource.getAnnotation("javax.persistence.GeneratedValue");
        generatedValue.setStrategy(GenerationType.IDENTITY);
        this.getJpaProject().synchronizeContextModel();
        JavaGeneratedValueTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.GenerationType.IDENTITY, (Object)idMapping.getGeneratedValue().getStrategy());
        JavaGeneratedValueTests.assertEquals((Object)GeneratedValue.DEFAULT_STRATEGY, (Object)idMapping.getGeneratedValue().getDefaultStrategy());
    }

    public void testSetSpecifiedStrategy() throws Exception {
        this.createTestEntityWithGeneratedValue();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        JavaGeneratedValueTests.assertEquals((Object)GeneratedValue.DEFAULT_STRATEGY, (Object)idMapping.getGeneratedValue().getStrategy());
        idMapping.getGeneratedValue().setSpecifiedStrategy(org.eclipse.jpt.jpa.core.context.GenerationType.IDENTITY);
        JavaGeneratedValueTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.GenerationType.IDENTITY, (Object)idMapping.getGeneratedValue().getStrategy());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GeneratedValueAnnotation generatedValue = (GeneratedValueAnnotation)attributeResource.getAnnotation("javax.persistence.GeneratedValue");
        JavaGeneratedValueTests.assertEquals((Object)GenerationType.IDENTITY, (Object)generatedValue.getStrategy());
        idMapping.getGeneratedValue().setSpecifiedStrategy(null);
        JavaGeneratedValueTests.assertEquals((Object)GeneratedValue.DEFAULT_STRATEGY, (Object)idMapping.getGeneratedValue().getStrategy());
        generatedValue = (GeneratedValueAnnotation)attributeResource.getAnnotation("javax.persistence.GeneratedValue");
        JavaGeneratedValueTests.assertNotNull((Object)generatedValue);
        JavaGeneratedValueTests.assertNull((Object)generatedValue.getStrategy());
    }
}

