/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.UniqueConstraint;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinTable;
import org.eclipse.jpt.jpa.core.context.java.JavaManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaUniqueConstraint;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.JoinTableAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JavaJoinTableTests
extends ContextModelTestCase {
    public JavaJoinTableTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityWithManyToMany() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidManyToMany() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "java.util.Collection"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany").append(CR);
                sb.append("    private Collection<Project> projects;").append(CR);
            }
        });
    }

    private void createTargetEntity() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class Project {").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int proj_id;").append(CR);
                sb.append(CR);
                sb.append("}");
            }
        };
        this.javaProject.createCompilationUnit("test", "Project.java", sourceWriter);
    }

    private void createTargetEntityWithBackPointer() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToMany");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class Project {").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int proj_id;").append(CR);
                sb.append("    @ManyToMany(mappedBy=\"projects\"").append(CR);
                sb.append("    private java.util.Collection<AnnotationTestType> employees;").append(CR);
                sb.append(CR);
                sb.append("}");
            }
        };
        this.javaProject.createCompilationUnit("test", "Project.java", sourceWriter);
    }

    public void testUpdateSpecifiedName() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation javaJoinTable = (JoinTableAnnotation)attributeResource.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedName());
        JavaJoinTableTests.assertNull((Object)javaJoinTable);
        attributeResource.addAnnotation("javax.persistence.JoinTable");
        javaJoinTable = (JoinTableAnnotation)attributeResource.getAnnotation("javax.persistence.JoinTable");
        javaJoinTable.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTable.getSpecifiedName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)javaJoinTable.getName());
        javaJoinTable.setName(null);
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedName());
        JavaJoinTableTests.assertNull((Object)javaJoinTable.getName());
        javaJoinTable.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTable.getSpecifiedName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)javaJoinTable.getName());
        attributeResource.removeAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedName());
        JavaJoinTableTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
    }

    public void testModifySpecifiedName() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)attributeResource.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedName());
        JavaJoinTableTests.assertNull((Object)joinTableAnnotation);
        joinTable.setSpecifiedName("foo");
        joinTableAnnotation = (JoinTableAnnotation)attributeResource.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((String)"foo", (String)joinTable.getSpecifiedName());
        JavaJoinTableTests.assertEquals((String)"foo", (String)joinTableAnnotation.getName());
        joinTable.setSpecifiedName(null);
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedName());
        joinTableAnnotation = (JoinTableAnnotation)attributeResource.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTableAnnotation.getName());
    }

    public void testDefaultName() throws Exception {
        this.createTestEntityWithValidManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaJoinTableTests.assertNull((Object)joinTable.getDefaultName());
        this.createTargetEntity();
        this.addXmlClassRef("test.Project");
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_Project", (String)joinTable.getDefaultName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaJoinTableTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        manyToManyMapping.setSpecifiedTargetEntity("Foo");
        JavaJoinTableTests.assertNull((Object)joinTable.getDefaultName());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_Project", (String)joinTable.getDefaultName());
        attributeResource.addAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_Project", (String)joinTable.getDefaultName());
        JavaJoinTableTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        manyToManyMapping.getResolvedTargetEntity().getTable().setSpecifiedName("FOO");
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_FOO", (String)joinTable.getDefaultName());
        this.getJavaEntity().getTable().setSpecifiedName("BAR");
        JavaJoinTableTests.assertEquals((String)"BAR_FOO", (String)joinTable.getDefaultName());
    }

    public void testDefaultJoinColumns() throws Exception {
        this.createTestEntityWithValidManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JoinColumn joinColumn = (JoinColumn)joinTable.joinColumns().next();
        JoinColumn inverseJoinColumn = (JoinColumn)joinTable.inverseJoinColumns().next();
        JavaJoinTableTests.assertNull((Object)joinColumn.getDefaultName());
        JavaJoinTableTests.assertNull((Object)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultReferencedColumnName());
        this.createTargetEntity();
        this.addXmlClassRef("test.Project");
        JavaJoinTableTests.assertNull((Object)joinColumn.getDefaultName());
        JavaJoinTableTests.assertNull((Object)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        this.getJavaPersistentType().getAttributeNamed("id").setMappingKey("id");
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_id", (String)joinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"id", (String)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getColumn().setSpecifiedName("MY_ID");
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_MY_ID", (String)joinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaJoinTableTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        manyToManyMapping.setSpecifiedTargetEntity("Foo");
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_MY_ID", (String)joinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultReferencedColumnName());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_MY_ID", (String)joinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        attributeResource.addAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_MY_ID", (String)joinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
    }

    public void testDefaultJoinColumnsBidirectionalRelationship() throws Exception {
        this.createTestEntityWithValidManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JoinColumn joinColumn = (JoinColumn)joinTable.joinColumns().next();
        JoinColumn inverseJoinColumn = (JoinColumn)joinTable.inverseJoinColumns().next();
        JavaJoinTableTests.assertNull((Object)joinColumn.getDefaultName());
        JavaJoinTableTests.assertNull((Object)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultReferencedColumnName());
        this.createTargetEntityWithBackPointer();
        this.addXmlClassRef("test.Project");
        JavaJoinTableTests.assertNull((Object)joinColumn.getDefaultName());
        JavaJoinTableTests.assertNull((Object)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        this.getJavaPersistentType().getAttributeNamed("id").setMappingKey("id");
        JavaJoinTableTests.assertEquals((String)"employees_id", (String)joinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"id", (String)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        ((IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping()).getColumn().setSpecifiedName("MY_ID");
        JavaJoinTableTests.assertEquals((String)"employees_MY_ID", (String)joinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaJoinTableTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
        manyToManyMapping.setSpecifiedTargetEntity("Foo");
        JavaJoinTableTests.assertEquals((String)"AnnotationTestType_MY_ID", (String)joinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultReferencedColumnName());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        JavaJoinTableTests.assertEquals((String)"employees_MY_ID", (String)joinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        attributeResource.addAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((String)"employees_MY_ID", (String)joinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        JavaJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        JavaJoinTableTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
    }

    public void testUpdateSpecifiedSchema() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation javaJoinTable = (JoinTableAnnotation)attributeResource.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedSchema());
        JavaJoinTableTests.assertNull((Object)javaJoinTable);
        attributeResource.addAnnotation("javax.persistence.JoinTable");
        javaJoinTable = (JoinTableAnnotation)attributeResource.getAnnotation("javax.persistence.JoinTable");
        javaJoinTable.setSchema("FOO");
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTable.getSpecifiedSchema());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)javaJoinTable.getSchema());
        javaJoinTable.setSchema(null);
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedSchema());
        JavaJoinTableTests.assertNull((Object)javaJoinTable.getSchema());
        javaJoinTable.setSchema("FOO");
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTable.getSpecifiedSchema());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)javaJoinTable.getSchema());
        attributeResource.removeAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedSchema());
        JavaJoinTableTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
    }

    public void testModifySpecifiedSchema() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableAttributes().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)resourceAttribute.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedSchema());
        JavaJoinTableTests.assertNull((Object)joinTableAnnotation);
        joinTable.setSpecifiedSchema("foo");
        joinTableAnnotation = (JoinTableAnnotation)resourceAttribute.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((String)"foo", (String)joinTable.getSpecifiedSchema());
        JavaJoinTableTests.assertEquals((String)"foo", (String)joinTableAnnotation.getSchema());
        joinTable.setSpecifiedSchema(null);
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedSchema());
        joinTableAnnotation = (JoinTableAnnotation)resourceAttribute.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTableAnnotation.getSchema());
    }

    public void testUpdateSpecifiedCatalog() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation javaJoinTable = (JoinTableAnnotation)attributeResource.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedCatalog());
        JavaJoinTableTests.assertNull((Object)javaJoinTable);
        attributeResource.addAnnotation("javax.persistence.JoinTable");
        javaJoinTable = (JoinTableAnnotation)attributeResource.getAnnotation("javax.persistence.JoinTable");
        javaJoinTable.setCatalog("FOO");
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTable.getSpecifiedCatalog());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)javaJoinTable.getCatalog());
        javaJoinTable.setCatalog(null);
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedCatalog());
        JavaJoinTableTests.assertNull((Object)javaJoinTable.getCatalog());
        javaJoinTable.setCatalog("FOO");
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTable.getSpecifiedCatalog());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)javaJoinTable.getCatalog());
        attributeResource.removeAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedCatalog());
        JavaJoinTableTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.JoinTable"));
    }

    public void testModifySpecifiedCatalog() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableAttributes().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)resourceAttribute.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedCatalog());
        JavaJoinTableTests.assertNull((Object)joinTableAnnotation);
        joinTable.setSpecifiedCatalog("foo");
        joinTableAnnotation = (JoinTableAnnotation)resourceAttribute.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((String)"foo", (String)joinTable.getSpecifiedCatalog());
        JavaJoinTableTests.assertEquals((String)"foo", (String)joinTableAnnotation.getCatalog());
        joinTable.setSpecifiedCatalog(null);
        JavaJoinTableTests.assertNull((Object)joinTable.getSpecifiedCatalog());
        joinTableAnnotation = (JoinTableAnnotation)resourceAttribute.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertNull((Object)joinTableAnnotation.getCatalog());
    }

    public void testAddSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaJoinColumn joinColumn = joinTable.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        JoinTableAnnotation joinTableResource = (JoinTableAnnotation)attributeResource.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(0).getName());
        JavaJoinColumn joinColumn2 = joinTable.addSpecifiedJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(1).getName());
        JavaJoinColumn joinColumn3 = joinTable.addSpecifiedJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.joinColumnAt(1).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(2).getName());
        ListIterator joinColumns = joinTable.specifiedJoinColumns();
        JavaJoinTableTests.assertEquals((Object)joinColumn2, joinColumns.next());
        JavaJoinTableTests.assertEquals((Object)joinColumn3, joinColumns.next());
        JavaJoinTableTests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = joinTable.specifiedJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableAttributes().next();
        joinTable.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joinTable.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joinTable.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)resourceAttribute.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((int)3, (int)joinTableAnnotation.joinColumnsSize());
        joinTable.removeSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)2, (int)joinTableAnnotation.joinColumnsSize());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableAnnotation.joinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableAnnotation.joinColumnAt(1).getName());
        joinTable.removeSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTableAnnotation.joinColumnsSize());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableAnnotation.joinColumnAt(0).getName());
        joinTable.removeSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)0, (int)joinTableAnnotation.joinColumnsSize());
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        joinTable.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joinTable.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joinTable.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        JoinTableAnnotation joinTableResource = (JoinTableAnnotation)attributeResource.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((int)3, (int)joinTableResource.joinColumnsSize());
        joinTable.moveSpecifiedJoinColumn(2, 0);
        ListIterator joinColumns = joinTable.specifiedJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.joinColumnAt(1).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(2).getName());
        joinTable.moveSpecifiedJoinColumn(0, 1);
        joinColumns = joinTable.specifiedJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.joinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.joinColumnAt(1).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.joinColumnAt(2).getName());
    }

    public void testUpdateJoinColumns() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation joinTableResource = (JoinTableAnnotation)attributeResource.addAnnotation("javax.persistence.JoinTable");
        joinTableResource.addJoinColumn(0);
        joinTableResource.addJoinColumn(1);
        joinTableResource.addJoinColumn(2);
        joinTableResource.joinColumnAt(0).setName("FOO");
        joinTableResource.joinColumnAt(1).setName("BAR");
        joinTableResource.joinColumnAt(2).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator joinColumns = joinTable.specifiedJoinColumns();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.moveJoinColumn(2, 0);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joinTable.specifiedJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.moveJoinColumn(0, 1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joinTable.specifiedJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.removeJoinColumn(1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joinTable.specifiedJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.removeJoinColumn(1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joinTable.specifiedJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)joinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.removeJoinColumn(0);
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertFalse((boolean)joinTable.specifiedJoinColumns().hasNext());
    }

    public void testSpecifiedJoinColumnsSize() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaJoinTableTests.assertEquals((int)0, (int)joinTable.specifiedJoinColumnsSize());
        joinTable.addSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.specifiedJoinColumnsSize());
        joinTable.removeSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)0, (int)joinTable.specifiedJoinColumnsSize());
    }

    public void testJoinColumnsSize() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.joinColumnsSize());
        joinTable.addSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.joinColumnsSize());
        joinTable.addSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)2, (int)joinTable.joinColumnsSize());
        joinTable.removeSpecifiedJoinColumn(0);
        joinTable.removeSpecifiedJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.joinColumnsSize());
        JavaJoinTableTests.assertNotNull((Object)manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable());
        JavaResourcePersistentAttribute resAttribute = ((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getResourcePersistentAttribute();
        JavaJoinTableTests.assertNotNull((Object)resAttribute.getAnnotation("javax.persistence.JoinTable"));
        manyToManyMapping.getRelationship().getJoinTableStrategy().removeStrategy();
        JavaJoinTableTests.assertNotNull((Object)manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable());
        JavaJoinTableTests.assertNull((Object)resAttribute.getAnnotation("javax.persistence.JoinTable"));
        manyToManyMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("foo");
        JavaJoinTableTests.assertNull((Object)manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable());
    }

    public void testAddSpecifiedInverseJoinColumn() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaJoinColumn inverseJoinColumn = joinTable.addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("FOO");
        JoinTableAnnotation joinTableResource = (JoinTableAnnotation)attributeResource.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.inverseJoinColumnAt(0).getName());
        JavaJoinColumn inverseJoinColumn2 = joinTable.addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn2.setSpecifiedName("BAR");
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.inverseJoinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.inverseJoinColumnAt(1).getName());
        JavaJoinColumn inverseJoinColumn3 = joinTable.addSpecifiedInverseJoinColumn(1);
        inverseJoinColumn3.setSpecifiedName("BAZ");
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.inverseJoinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.inverseJoinColumnAt(1).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.inverseJoinColumnAt(2).getName());
        ListIterator inverseJoinColumns = joinTable.specifiedInverseJoinColumns();
        JavaJoinTableTests.assertEquals((Object)inverseJoinColumn2, inverseJoinColumns.next());
        JavaJoinTableTests.assertEquals((Object)inverseJoinColumn3, inverseJoinColumns.next());
        JavaJoinTableTests.assertEquals((Object)inverseJoinColumn, inverseJoinColumns.next());
        inverseJoinColumns = joinTable.specifiedInverseJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)inverseJoinColumns.next()).getName());
    }

    public void testRemoveSpecifiedInverseJoinColumn() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        joinTable.addSpecifiedInverseJoinColumn(0).setSpecifiedName("FOO");
        joinTable.addSpecifiedInverseJoinColumn(1).setSpecifiedName("BAR");
        joinTable.addSpecifiedInverseJoinColumn(2).setSpecifiedName("BAZ");
        JoinTableAnnotation joinTableResource = (JoinTableAnnotation)attributeResource.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((int)3, (int)joinTableResource.inverseJoinColumnsSize());
        joinTable.removeSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)2, (int)joinTableResource.inverseJoinColumnsSize());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.inverseJoinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.inverseJoinColumnAt(1).getName());
        joinTable.removeSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTableResource.inverseJoinColumnsSize());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.inverseJoinColumnAt(0).getName());
        joinTable.removeSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)0, (int)joinTableResource.inverseJoinColumnsSize());
    }

    public void testMoveSpecifiedInverseJoinColumn() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        joinTable.addSpecifiedInverseJoinColumn(0).setSpecifiedName("FOO");
        joinTable.addSpecifiedInverseJoinColumn(1).setSpecifiedName("BAR");
        joinTable.addSpecifiedInverseJoinColumn(2).setSpecifiedName("BAZ");
        JoinTableAnnotation joinTableResource = (JoinTableAnnotation)attributeResource.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((int)3, (int)joinTableResource.inverseJoinColumnsSize());
        joinTable.moveSpecifiedInverseJoinColumn(2, 0);
        ListIterator inverseJoinColumns = joinTable.specifiedInverseJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.inverseJoinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.inverseJoinColumnAt(1).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.inverseJoinColumnAt(2).getName());
        joinTable.moveSpecifiedInverseJoinColumn(0, 1);
        inverseJoinColumns = joinTable.specifiedInverseJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)joinTableResource.inverseJoinColumnAt(0).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)joinTableResource.inverseJoinColumnAt(1).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)joinTableResource.inverseJoinColumnAt(2).getName());
    }

    public void testUpdateInverseJoinColumns() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation joinTableResource = (JoinTableAnnotation)attributeResource.addAnnotation("javax.persistence.JoinTable");
        joinTableResource.addInverseJoinColumn(0);
        joinTableResource.addInverseJoinColumn(1);
        joinTableResource.addInverseJoinColumn(2);
        joinTableResource.inverseJoinColumnAt(0).setName("FOO");
        joinTableResource.inverseJoinColumnAt(1).setName("BAR");
        joinTableResource.inverseJoinColumnAt(2).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator inverseJoinColumns = joinTable.specifiedInverseJoinColumns();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)inverseJoinColumns.hasNext());
        joinTableResource.moveInverseJoinColumn(2, 0);
        this.getJpaProject().synchronizeContextModel();
        inverseJoinColumns = joinTable.specifiedInverseJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)inverseJoinColumns.hasNext());
        joinTableResource.moveInverseJoinColumn(0, 1);
        this.getJpaProject().synchronizeContextModel();
        inverseJoinColumns = joinTable.specifiedInverseJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((JavaJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)inverseJoinColumns.hasNext());
        joinTableResource.removeInverseJoinColumn(1);
        this.getJpaProject().synchronizeContextModel();
        inverseJoinColumns = joinTable.specifiedInverseJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((JavaJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)inverseJoinColumns.hasNext());
        joinTableResource.removeInverseJoinColumn(1);
        this.getJpaProject().synchronizeContextModel();
        inverseJoinColumns = joinTable.specifiedInverseJoinColumns();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((JavaJoinColumn)inverseJoinColumns.next()).getName());
        JavaJoinTableTests.assertFalse((boolean)inverseJoinColumns.hasNext());
        joinTableResource.removeInverseJoinColumn(0);
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertFalse((boolean)joinTable.specifiedInverseJoinColumns().hasNext());
    }

    public void testGetDefaultInverseJoinColumn() {
    }

    public void testSpecifiedInverseJoinColumnsSize() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaJoinTableTests.assertEquals((int)0, (int)joinTable.specifiedInverseJoinColumnsSize());
        joinTable.addSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.specifiedInverseJoinColumnsSize());
        joinTable.removeSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)0, (int)joinTable.specifiedInverseJoinColumnsSize());
    }

    public void testInverseJoinColumnsSize() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.inverseJoinColumnsSize());
        joinTable.addSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.inverseJoinColumnsSize());
        joinTable.addSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)2, (int)joinTable.inverseJoinColumnsSize());
        joinTable.removeSpecifiedInverseJoinColumn(0);
        joinTable.removeSpecifiedInverseJoinColumn(0);
        JavaJoinTableTests.assertEquals((int)1, (int)joinTable.inverseJoinColumnsSize());
        manyToManyMapping.getRelationship().setStrategyToMappedBy();
        JavaJoinTableTests.assertNull((Object)manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable());
    }

    public void testUniqueConstraints() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        ListIterator uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)attributeResource.addAnnotation("javax.persistence.JoinTable");
        joinTableAnnotation.addUniqueConstraint(0).addColumnName(0, "foo");
        joinTableAnnotation.addUniqueConstraint(0).addColumnName(0, "bar");
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertTrue((boolean)uniqueConstraints.hasNext());
        JavaJoinTableTests.assertEquals((String)"bar", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"foo", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsSize() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaJoinTableTests.assertEquals((int)0, (int)joinTable.uniqueConstraintsSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)attributeResource.addAnnotation("javax.persistence.JoinTable");
        joinTableAnnotation.addUniqueConstraint(0).addColumnName(0, "foo");
        joinTableAnnotation.addUniqueConstraint(1).addColumnName(0, "bar");
        this.getJpaProject().synchronizeContextModel();
        JavaJoinTableTests.assertEquals((int)2, (int)joinTable.uniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        joinTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        joinTable.addUniqueConstraint(0).addColumnName(0, "BAR");
        joinTable.addUniqueConstraint(0).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)attributeResource.getAnnotation("javax.persistence.JoinTable");
        ListIterator uniqueConstraints = joinTableAnnotation.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testAddUniqueConstraint2() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        joinTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        joinTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        joinTable.addUniqueConstraint(0).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)attributeResource.getAnnotation("javax.persistence.JoinTable");
        ListIterator uniqueConstraints = joinTableAnnotation.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraints.next()).columnNames().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testRemoveUniqueConstraint() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        joinTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        joinTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        joinTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)attributeResource.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((int)3, (int)joinTableAnnotation.uniqueConstraintsSize());
        joinTable.removeUniqueConstraint(1);
        ListIterator uniqueConstraintAnnotations = joinTableAnnotation.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        ListIterator uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTable.removeUniqueConstraint(1);
        uniqueConstraintAnnotations = joinTableAnnotation.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTable.removeUniqueConstraint(0);
        uniqueConstraintAnnotations = joinTableAnnotation.uniqueConstraints();
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraintAnnotations.hasNext());
        uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testMoveUniqueConstraint() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        joinTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        joinTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        joinTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)attributeResource.getAnnotation("javax.persistence.JoinTable");
        JavaJoinTableTests.assertEquals((int)3, (int)joinTableAnnotation.uniqueConstraintsSize());
        joinTable.moveUniqueConstraint(2, 0);
        ListIterator uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        ListIterator uniqueConstraintAnnotations = joinTableAnnotation.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        joinTable.moveUniqueConstraint(0, 1);
        uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        uniqueConstraintAnnotations = joinTableAnnotation.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraintAnnotation)uniqueConstraintAnnotations.next()).columnNames().next()));
    }

    public void testUpdateUniqueConstraints() throws Exception {
        this.createTestEntityWithManyToMany();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaManyToManyMapping manyToManyMapping = (JavaManyToManyMapping)((JavaPersistentAttribute)this.getJavaPersistentType().attributes().next()).getMapping();
        JavaJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JoinTableAnnotation joinTableAnnotation = (JoinTableAnnotation)attributeResource.addAnnotation("javax.persistence.JoinTable");
        joinTableAnnotation.addUniqueConstraint(0).addColumnName("FOO");
        joinTableAnnotation.addUniqueConstraint(1).addColumnName("BAR");
        joinTableAnnotation.addUniqueConstraint(2).addColumnName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.moveUniqueConstraint(2, 0);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.moveUniqueConstraint(0, 1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"BAR", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.removeUniqueConstraint(1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertEquals((String)"FOO", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.removeUniqueConstraint(1);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertEquals((String)"BAZ", (String)((String)((JavaUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableAnnotation.removeUniqueConstraint(0);
        this.getJpaProject().synchronizeContextModel();
        uniqueConstraints = joinTable.uniqueConstraints();
        JavaJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }
}

