/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JavaTransientMappingTests
extends ContextModelTestCase {
    private ICompilationUnit createTestEntityWithTransientMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Transient"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Transient").append(CR);
            }
        });
    }

    public JavaTransientMappingTests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        TransientMapping transientMapping = (TransientMapping)persistentAttribute.getMapping();
        JavaTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        persistentAttribute.setMappingKey("basic");
        JavaTransientMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        JavaTransientMappingTests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaTransientMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Transient"));
        JavaTransientMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Basic"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithTransientMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        TransientMapping transientMapping = (TransientMapping)persistentAttribute.getMapping();
        JavaTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaTransientMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        JavaTransientMappingTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaTransientMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Transient"));
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        TransientMapping transientMapping = (TransientMapping)persistentAttribute.getMapping();
        JavaTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        persistentAttribute.setMappingKey("version");
        JavaTransientMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof VersionMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaTransientMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Transient"));
        JavaTransientMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Version"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        TransientMapping transientMapping = (TransientMapping)persistentAttribute.getMapping();
        JavaTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        persistentAttribute.setMappingKey("embedded");
        JavaTransientMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaTransientMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Transient"));
        JavaTransientMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Embedded"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        TransientMapping transientMapping = (TransientMapping)persistentAttribute.getMapping();
        JavaTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        persistentAttribute.setMappingKey("id");
        JavaTransientMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof IdMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaTransientMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Transient"));
        JavaTransientMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.Id"));
    }

    public void testMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        TransientMapping transientMapping = (TransientMapping)persistentAttribute.getMapping();
        JavaTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        persistentAttribute.setMappingKey("embeddedId");
        JavaTransientMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaTransientMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Transient"));
        JavaTransientMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.EmbeddedId"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        TransientMapping transientMapping = (TransientMapping)persistentAttribute.getMapping();
        JavaTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        persistentAttribute.setMappingKey("oneToOne");
        JavaTransientMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaTransientMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Transient"));
        JavaTransientMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.OneToOne"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        TransientMapping transientMapping = (TransientMapping)persistentAttribute.getMapping();
        JavaTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        persistentAttribute.setMappingKey("oneToMany");
        JavaTransientMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaTransientMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Transient"));
        JavaTransientMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.OneToMany"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        TransientMapping transientMapping = (TransientMapping)persistentAttribute.getMapping();
        JavaTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        persistentAttribute.setMappingKey("manyToOne");
        JavaTransientMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaTransientMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Transient"));
        JavaTransientMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToOne"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        TransientMapping transientMapping = (TransientMapping)persistentAttribute.getMapping();
        JavaTransientMappingTests.assertFalse((boolean)transientMapping.isDefault());
        persistentAttribute.setMappingKey("manyToMany");
        JavaTransientMappingTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        JavaTransientMappingTests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.Transient"));
        JavaTransientMappingTests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.ManyToMany"));
    }

    public void testTransientMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        TransientMapping transientMapping = (TransientMapping)persistentAttribute.getMapping();
        JavaTransientMappingTests.assertNotNull((Object)transientMapping);
    }
}

