/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.GenericOrmIdMapping;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.GenericOrmOneToOneMapping;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class GenericOrmPersistentAttributeTests
extends ContextModelTestCase {
    public GenericOrmPersistentAttributeTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestTypeNullAttributeMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityIdMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append("@Column(name=\"FOO\")");
            }
        });
    }

    private ICompilationUnit createTestEntityOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne");
                sb.append("    private Address address;");
            }
        });
    }

    public void testMakeSpecified() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        ormPersistentAttribute.convertToSpecified();
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormPersistentAttribute.convertToSpecified();
        GenericOrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        ListIterator specifiedAttributes = ormPersistentType.specifiedAttributes();
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"name", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
    }

    public void testMakeSpecifiedMappingKey() throws Exception {
        this.createTestTypeNullAttributeMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        GenericOrmPersistentAttributeTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttributeTests.assertNull((Object)ormPersistentAttribute.getMapping().getKey());
        ormPersistentAttribute.convertToSpecified("oneToOne");
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"address", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        GenericOrmPersistentAttributeTests.assertTrue((boolean)(specifiedOrmPersistentAttribute.getMapping() instanceof GenericOrmOneToOneMapping));
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormPersistentAttribute.convertToSpecified("id");
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        ListIterator specifiedAttributes = ormPersistentType.specifiedAttributes();
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        GenericOrmPersistentAttributeTests.assertTrue((boolean)(specifiedOrmPersistentAttribute.getMapping() instanceof GenericOrmIdMapping));
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"address", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
    }

    public void testMakeVirtual() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        ((OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next()).convertToSpecified();
        ((OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next()).convertToSpecified();
        GenericOrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        specifiedOrmPersistentAttribute.convertToVirtual();
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        specifiedOrmPersistentAttribute.convertToVirtual();
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)0, (int)ormPersistentType.specifiedAttributesSize());
        ListIterator virtualAttributes = ormPersistentType.virtualAttributes();
        OrmReadOnlyPersistentAttribute virtualAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)virtualAttribute.getName());
        virtualAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"name", (String)virtualAttribute.getName());
    }

    public void testMakeVirtualNoUnderlyingJavaAttribute() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        ((OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next()).convertToSpecified();
        ((OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next()).convertToSpecified();
        ((OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next()).getMapping().setName("noJavaAttribute");
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        specifiedOrmPersistentAttribute.convertToVirtual();
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)((OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next()).getName());
        GenericOrmPersistentAttributeTests.assertEquals((String)"name", (String)((OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next()).getName());
    }

    public void testVirtualMappingTypeWhenMetadataComplete() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMappingKey());
        GenericOrmPersistentAttributeTests.assertEquals((String)"FOO", (String)((IdMapping)ormPersistentAttribute.getMapping()).getColumn().getName());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMappingKey());
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)((BasicMapping)ormPersistentAttribute.getMapping()).getColumn().getName());
    }

    public void testVirtualMappingTypeWhenMetadataComplete2() throws Exception {
        this.createTestEntityOneToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        GenericOrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMappingKey());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        GenericOrmPersistentAttributeTests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)ormPersistentAttribute.getMappingKey());
    }

    public void testGetJavaPersistentAttribute() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttributeTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        GenericOrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        JavaResourcePersistentAttribute javaResourcePersistentAttribute = ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute();
        GenericOrmPersistentAttributeTests.assertTrue((boolean)javaResourcePersistentAttribute.isField());
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)javaResourcePersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertEquals(javaPersistentType.getResourcePersistentType().persistableFields().next(), (Object)javaResourcePersistentAttribute);
        ormPersistentAttribute.convertToSpecified();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttributeTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        ((OrmPersistentAttribute)ormPersistentAttribute).convertToVirtual();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        GenericOrmPersistentAttributeTests.assertNotSame((Object)ormPersistentAttribute, (Object)ormPersistentType.getAttributeNamed("id"));
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttributeTests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        GenericOrmPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        GenericOrmPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getJavaPersistentAttribute().getAccess());
        javaResourcePersistentAttribute = ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute();
        GenericOrmPersistentAttributeTests.assertTrue((boolean)javaResourcePersistentAttribute.isProperty());
        GenericOrmPersistentAttributeTests.assertEquals((String)"id", (String)javaResourcePersistentAttribute.getName());
        GenericOrmPersistentAttributeTests.assertEquals(javaPersistentType.getResourcePersistentType().persistableProperties().next(), (Object)javaResourcePersistentAttribute);
        ormPersistentType.setSpecifiedAccess(null);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        OrmPersistentAttribute ormPersistentAttribute2 = ormPersistentAttribute.convertToSpecified();
        ormPersistentAttribute2.getMapping().setName("id2");
        GenericOrmPersistentAttributeTests.assertEquals(null, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
        ormPersistentAttribute2.getMapping().setName(null);
        GenericOrmPersistentAttributeTests.assertEquals(null, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
        ormPersistentAttribute2.getMapping().setName("id");
        GenericOrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmPersistentAttributeTests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
    }
}

