/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.EnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.LobConverter;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.TemporalConverter;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.orm.EnumType;
import org.eclipse.jpt.jpa.core.resource.orm.TemporalType;
import org.eclipse.jpt.jpa.core.resource.orm.XmlBasic;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class OrmBasicMappingTests
extends ContextModelTestCase {
    public OrmBasicMappingTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntityBasicMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "javax.persistence.FetchType", "javax.persistence.Column", "javax.persistence.Lob", "javax.persistence.Temporal", "javax.persistence.TemporalType", "javax.persistence.Enumerated", "javax.persistence.EnumType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic(fetch=FetchType.LAZY, optional=false)");
                sb.append(CR);
                sb.append("    @Column(name=\"MY_COLUMN\", unique=true, nullable=false, insertable=false, updatable=false, columnDefinition=\"COLUMN_DEFINITION\", table=\"MY_TABLE\", length=5, precision=6, scale=7)");
                sb.append(CR);
                sb.append("    @Lob");
                sb.append(CR);
                sb.append("    @Temporal(TemporalType.TIMESTAMP)");
                sb.append(CR);
                sb.append("    @Enumerated(EnumType.STRING)");
            }
        });
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertEquals((String)"basicMapping", (String)ormBasicMapping.getName());
        OrmBasicMappingTests.assertEquals((String)"basicMapping", (String)basicResource.getName());
        basicResource.setName("newName");
        OrmBasicMappingTests.assertEquals((String)"newName", (String)ormBasicMapping.getName());
        OrmBasicMappingTests.assertEquals((String)"newName", (String)basicResource.getName());
        basicResource.setName(null);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getName());
        OrmBasicMappingTests.assertNull((Object)basicResource.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertEquals((String)"basicMapping", (String)ormBasicMapping.getName());
        OrmBasicMappingTests.assertEquals((String)"basicMapping", (String)basicResource.getName());
        ormBasicMapping.setName("newName");
        OrmBasicMappingTests.assertEquals((String)"newName", (String)ormBasicMapping.getName());
        OrmBasicMappingTests.assertEquals((String)"newName", (String)basicResource.getName());
        ormBasicMapping.setName(null);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getName());
        OrmBasicMappingTests.assertNull((Object)basicResource.getName());
    }

    public void testUpdateSpecifiedFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedFetch());
        OrmBasicMappingTests.assertNull((Object)basicResource.getFetch());
        basicResource.setFetch(org.eclipse.jpt.jpa.core.resource.orm.FetchType.EAGER);
        OrmBasicMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormBasicMapping.getSpecifiedFetch());
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.EAGER, (Object)basicResource.getFetch());
        basicResource.setFetch(org.eclipse.jpt.jpa.core.resource.orm.FetchType.LAZY);
        OrmBasicMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormBasicMapping.getSpecifiedFetch());
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.LAZY, (Object)basicResource.getFetch());
        basicResource.setFetch(null);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedFetch());
        OrmBasicMappingTests.assertNull((Object)basicResource.getFetch());
    }

    public void testModifySpecifiedFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedFetch());
        OrmBasicMappingTests.assertNull((Object)basicResource.getFetch());
        ormBasicMapping.setSpecifiedFetch(FetchType.EAGER);
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.EAGER, (Object)basicResource.getFetch());
        OrmBasicMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormBasicMapping.getSpecifiedFetch());
        ormBasicMapping.setSpecifiedFetch(FetchType.LAZY);
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.LAZY, (Object)basicResource.getFetch());
        OrmBasicMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormBasicMapping.getSpecifiedFetch());
        ormBasicMapping.setSpecifiedFetch(null);
        OrmBasicMappingTests.assertNull((Object)basicResource.getFetch());
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedFetch());
    }

    public void testUpdateSpecifiedEnumerated() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getType());
        OrmBasicMappingTests.assertNull((Object)basicResource.getEnumerated());
        basicResource.setEnumerated(EnumType.ORDINAL);
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.EnumType.ORDINAL, (Object)((EnumeratedConverter)ormBasicMapping.getConverter()).getSpecifiedEnumType());
        OrmBasicMappingTests.assertEquals((Object)EnumType.ORDINAL, (Object)basicResource.getEnumerated());
        basicResource.setEnumerated(EnumType.STRING);
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.EnumType.STRING, (Object)((EnumeratedConverter)ormBasicMapping.getConverter()).getSpecifiedEnumType());
        OrmBasicMappingTests.assertEquals((Object)EnumType.STRING, (Object)basicResource.getEnumerated());
        basicResource.setEnumerated(null);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getType());
        OrmBasicMappingTests.assertNull((Object)basicResource.getEnumerated());
    }

    public void testModifySpecifiedEnumerated() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getType());
        OrmBasicMappingTests.assertNull((Object)basicResource.getEnumerated());
        ormBasicMapping.setConverter(EnumeratedConverter.class);
        ((EnumeratedConverter)ormBasicMapping.getConverter()).setSpecifiedEnumType(org.eclipse.jpt.jpa.core.context.EnumType.ORDINAL);
        OrmBasicMappingTests.assertEquals((Object)EnumType.ORDINAL, (Object)basicResource.getEnumerated());
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.EnumType.ORDINAL, (Object)((EnumeratedConverter)ormBasicMapping.getConverter()).getSpecifiedEnumType());
        ((EnumeratedConverter)ormBasicMapping.getConverter()).setSpecifiedEnumType(org.eclipse.jpt.jpa.core.context.EnumType.STRING);
        OrmBasicMappingTests.assertEquals((Object)EnumType.STRING, (Object)basicResource.getEnumerated());
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.EnumType.STRING, (Object)((EnumeratedConverter)ormBasicMapping.getConverter()).getSpecifiedEnumType());
        ormBasicMapping.setConverter(null);
        OrmBasicMappingTests.assertNull((Object)basicResource.getEnumerated());
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getType());
    }

    public void testUpdateSpecifiedOptional() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedOptional());
        OrmBasicMappingTests.assertNull((Object)basicResource.getOptional());
        basicResource.setOptional(Boolean.TRUE);
        OrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormBasicMapping.getSpecifiedOptional());
        OrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)basicResource.getOptional());
        basicResource.setOptional(Boolean.FALSE);
        OrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormBasicMapping.getSpecifiedOptional());
        OrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)basicResource.getOptional());
        basicResource.setOptional(null);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedOptional());
        OrmBasicMappingTests.assertNull((Object)basicResource.getOptional());
    }

    public void testModifySpecifiedOptional() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedOptional());
        OrmBasicMappingTests.assertNull((Object)basicResource.getOptional());
        ormBasicMapping.setSpecifiedOptional(Boolean.TRUE);
        OrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)basicResource.getOptional());
        OrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormBasicMapping.getSpecifiedOptional());
        ormBasicMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)basicResource.getOptional());
        OrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormBasicMapping.getSpecifiedOptional());
        ormBasicMapping.setSpecifiedOptional(null);
        OrmBasicMappingTests.assertNull((Object)basicResource.getOptional());
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedOptional());
    }

    public void testUpdateSpecifiedLob() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getType());
        OrmBasicMappingTests.assertFalse((boolean)basicResource.isLob());
        basicResource.setLob(true);
        OrmBasicMappingTests.assertEquals(LobConverter.class, (Object)ormBasicMapping.getConverter().getType());
        OrmBasicMappingTests.assertTrue((boolean)basicResource.isLob());
        basicResource.setLob(false);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getType());
        OrmBasicMappingTests.assertFalse((boolean)basicResource.isLob());
    }

    public void testModifySpecifiedLob() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getType());
        OrmBasicMappingTests.assertFalse((boolean)basicResource.isLob());
        ormBasicMapping.setConverter(LobConverter.class);
        OrmBasicMappingTests.assertTrue((boolean)basicResource.isLob());
        OrmBasicMappingTests.assertEquals(LobConverter.class, (Object)ormBasicMapping.getConverter().getType());
        ormBasicMapping.setConverter(null);
        OrmBasicMappingTests.assertFalse((boolean)basicResource.isLob());
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getType());
    }

    public void testUpdateTemporal() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getType());
        OrmBasicMappingTests.assertNull((Object)basicResource.getTemporal());
        basicResource.setTemporal(TemporalType.DATE);
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.DATE, (Object)((TemporalConverter)ormBasicMapping.getConverter()).getTemporalType());
        OrmBasicMappingTests.assertEquals((Object)TemporalType.DATE, (Object)basicResource.getTemporal());
        basicResource.setTemporal(TemporalType.TIME);
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((TemporalConverter)ormBasicMapping.getConverter()).getTemporalType());
        OrmBasicMappingTests.assertEquals((Object)TemporalType.TIME, (Object)basicResource.getTemporal());
        basicResource.setTemporal(TemporalType.TIMESTAMP);
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIMESTAMP, (Object)((TemporalConverter)ormBasicMapping.getConverter()).getTemporalType());
        OrmBasicMappingTests.assertEquals((Object)TemporalType.TIMESTAMP, (Object)basicResource.getTemporal());
        basicResource.setTemporal(null);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getType());
        OrmBasicMappingTests.assertNull((Object)basicResource.getTemporal());
    }

    public void testModifyTemporal() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getType());
        OrmBasicMappingTests.assertNull((Object)basicResource.getTemporal());
        ormBasicMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)ormBasicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.DATE);
        OrmBasicMappingTests.assertEquals((Object)TemporalType.DATE, (Object)basicResource.getTemporal());
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.DATE, (Object)((TemporalConverter)ormBasicMapping.getConverter()).getTemporalType());
        ((TemporalConverter)ormBasicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        OrmBasicMappingTests.assertEquals((Object)TemporalType.TIME, (Object)basicResource.getTemporal());
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((TemporalConverter)ormBasicMapping.getConverter()).getTemporalType());
        ((TemporalConverter)ormBasicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIMESTAMP);
        OrmBasicMappingTests.assertEquals((Object)TemporalType.TIMESTAMP, (Object)basicResource.getTemporal());
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIMESTAMP, (Object)((TemporalConverter)ormBasicMapping.getConverter()).getTemporalType());
        ormBasicMapping.setConverter(null);
        OrmBasicMappingTests.assertNull((Object)basicResource.getTemporal());
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getType());
    }

    public void testBasicMappingNoUnderylingJavaAttribute() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.addSpecifiedAttribute("basic", "foo");
        OrmBasicMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertEquals((String)"foo", (String)ormBasicMapping.getName());
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getType());
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedFetch());
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedOptional());
        OrmBasicMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormBasicMapping.getFetch());
        OrmBasicMappingTests.assertEquals((boolean)true, (boolean)ormBasicMapping.isOptional());
        OrmColumn ormColumn = ormBasicMapping.getColumn();
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedTable());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedScale());
        OrmBasicMappingTests.assertEquals((String)"foo", (String)ormColumn.getDefaultName());
        OrmBasicMappingTests.assertEquals((boolean)false, (boolean)ormColumn.isDefaultUnique());
        OrmBasicMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultNullable());
        OrmBasicMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultInsertable());
        OrmBasicMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultUpdatable());
        OrmBasicMappingTests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        OrmBasicMappingTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getDefaultTable());
        OrmBasicMappingTests.assertEquals((int)255, (int)ormColumn.getDefaultLength());
        OrmBasicMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultPrecision());
        OrmBasicMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultScale());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmBasicMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        BasicMapping basicMapping = (BasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertEquals((String)"id", (String)basicMapping.getName());
        OrmBasicMappingTests.assertEquals(EnumeratedConverter.class, (Object)basicMapping.getConverter().getType());
        OrmBasicMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.EnumType.STRING, (Object)((EnumeratedConverter)basicMapping.getConverter()).getEnumType());
        OrmBasicMappingTests.assertEquals((Object)FetchType.LAZY, (Object)basicMapping.getSpecifiedFetch());
        OrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)basicMapping.getSpecifiedOptional());
        Column column = basicMapping.getColumn();
        OrmBasicMappingTests.assertEquals((String)"MY_COLUMN", (String)column.getSpecifiedName());
        OrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)column.getSpecifiedUnique());
        OrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)column.getSpecifiedNullable());
        OrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)column.getSpecifiedInsertable());
        OrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)column.getSpecifiedUpdatable());
        OrmBasicMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)column.getColumnDefinition());
        OrmBasicMappingTests.assertEquals((String)"MY_TABLE", (String)column.getSpecifiedTable());
        OrmBasicMappingTests.assertEquals((Object)5, (Object)column.getSpecifiedLength());
        OrmBasicMappingTests.assertEquals((Object)6, (Object)column.getSpecifiedPrecision());
        OrmBasicMappingTests.assertEquals((Object)7, (Object)column.getSpecifiedScale());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmBasicMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        BasicMapping basicMapping = (BasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertEquals((String)"id", (String)basicMapping.getName());
        OrmBasicMappingTests.assertNull((Object)basicMapping.getConverter().getType());
        OrmBasicMappingTests.assertEquals((Object)FetchType.EAGER, (Object)basicMapping.getFetch());
        OrmBasicMappingTests.assertTrue((boolean)basicMapping.isOptional());
        Column column = basicMapping.getColumn();
        OrmBasicMappingTests.assertEquals((String)"id", (String)column.getName());
        OrmBasicMappingTests.assertFalse((boolean)column.isUnique());
        OrmBasicMappingTests.assertTrue((boolean)column.isNullable());
        OrmBasicMappingTests.assertTrue((boolean)column.isInsertable());
        OrmBasicMappingTests.assertTrue((boolean)column.isUpdatable());
        OrmBasicMappingTests.assertNull((Object)column.getColumnDefinition());
        OrmBasicMappingTests.assertEquals((String)"AnnotationTestType", (String)column.getTable());
        OrmBasicMappingTests.assertEquals((int)255, (int)column.getLength());
        OrmBasicMappingTests.assertEquals((int)0, (int)column.getPrecision());
        OrmBasicMappingTests.assertEquals((int)0, (int)column.getScale());
    }

    public void testSpecifiedMapping() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.addSpecifiedAttribute("basic", "id");
        OrmBasicMappingTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertEquals((String)"id", (String)ormBasicMapping.getName());
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getType());
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedFetch());
        OrmBasicMappingTests.assertNull((Object)ormBasicMapping.getSpecifiedOptional());
        OrmBasicMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormBasicMapping.getDefaultFetch());
        OrmBasicMappingTests.assertEquals((boolean)true, (boolean)ormBasicMapping.isDefaultOptional());
        OrmColumn ormColumn = ormBasicMapping.getColumn();
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedTable());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        OrmBasicMappingTests.assertNull((Object)ormColumn.getSpecifiedScale());
        OrmBasicMappingTests.assertEquals((String)"id", (String)ormColumn.getDefaultName());
        OrmBasicMappingTests.assertEquals((boolean)false, (boolean)ormColumn.isDefaultUnique());
        OrmBasicMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultNullable());
        OrmBasicMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultInsertable());
        OrmBasicMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultUpdatable());
        OrmBasicMappingTests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        OrmBasicMappingTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getDefaultTable());
        OrmBasicMappingTests.assertEquals((int)255, (int)ormColumn.getDefaultLength());
        OrmBasicMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultPrecision());
        OrmBasicMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultScale());
    }

    public void testBasicMorphToIdMapping() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basic");
        BasicMapping basicMapping = (BasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)basicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        ormPersistentAttribute.setMappingKey("id");
        OrmBasicMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmBasicMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmBasicMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof IdMapping));
        OrmBasicMappingTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getName());
        OrmBasicMappingTests.assertEquals((String)"FOO", (String)((IdMapping)ormPersistentAttribute.getMapping()).getColumn().getSpecifiedName());
    }

    public void testBasicMorphToVersionMapping() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basic");
        BasicMapping basicMapping = (BasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)basicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        ormPersistentAttribute.setMappingKey("version");
        OrmBasicMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmBasicMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmBasicMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof VersionMapping));
        OrmBasicMappingTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getName());
        OrmBasicMappingTests.assertEquals((String)"FOO", (String)((VersionMapping)ormPersistentAttribute.getMapping()).getColumn().getSpecifiedName());
    }

    public void testBasicMorphToTransientMapping() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basic");
        BasicMapping basicMapping = (BasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)basicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        ormPersistentAttribute.setMappingKey("transient");
        OrmBasicMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmBasicMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmBasicMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        OrmBasicMappingTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testBasicMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basic");
        BasicMapping basicMapping = (BasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)basicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        ormPersistentAttribute.setMappingKey("embedded");
        OrmBasicMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmBasicMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmBasicMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedMapping));
        OrmBasicMappingTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testBasicMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basic");
        BasicMapping basicMapping = (BasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)basicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        ormPersistentAttribute.setMappingKey("embeddedId");
        OrmBasicMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmBasicMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmBasicMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        OrmBasicMappingTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testBasicMorphToOneToOneMapping() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basic");
        BasicMapping basicMapping = (BasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)basicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        ormPersistentAttribute.setMappingKey("oneToOne");
        OrmBasicMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmBasicMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmBasicMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToOneMapping));
        OrmBasicMappingTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testBasicMorphToOneToManyMapping() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basic");
        BasicMapping basicMapping = (BasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)basicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        ormPersistentAttribute.setMappingKey("oneToMany");
        OrmBasicMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmBasicMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmBasicMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToManyMapping));
        OrmBasicMappingTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testBasicMorphToManyToOneMapping() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basic");
        BasicMapping basicMapping = (BasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)basicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToOne");
        OrmBasicMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmBasicMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmBasicMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        OrmBasicMappingTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testBasicMorphToManyToManyMapping() throws Exception {
        this.createTestEntityBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basic");
        BasicMapping basicMapping = (BasicMapping)ormPersistentAttribute.getMapping();
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        basicMapping.getColumn().setSpecifiedName("FOO");
        basicMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)basicMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        basicMapping.setSpecifiedFetch(FetchType.EAGER);
        basicMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmBasicMappingTests.assertFalse((boolean)basicMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToMany");
        OrmBasicMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmBasicMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmBasicMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToManyMapping));
        OrmBasicMappingTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMapping().getName());
    }
}

