/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.GeneratedValue;
import org.eclipse.jpt.jpa.core.context.GenerationType;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.SequenceGenerator;
import org.eclipse.jpt.jpa.core.context.TableGenerator;
import org.eclipse.jpt.jpa.core.context.TemporalConverter;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmIdMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.TemporalType;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlId;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class OrmIdMappingTests
extends ContextModelTestCase {
    public OrmIdMappingTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntityIdMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column", "javax.persistence.Temporal", "javax.persistence.TemporalType", "javax.persistence.GeneratedValue", "javax.persistence.GenerationType", "javax.persistence.TableGenerator", "javax.persistence.SequenceGenerator"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append(CR);
                sb.append("    @Column(name=\"MY_COLUMN\", unique=true, nullable=false, insertable=false, updatable=false, columnDefinition=\"COLUMN_DEFINITION\", table=\"MY_TABLE\", length=5, precision=6, scale=7)");
                sb.append(CR);
                sb.append("    @Temporal(TemporalType.TIMESTAMP)");
                sb.append(CR);
                sb.append("    @GeneratedValue(strategy=GenerationType.TABLE, generator=\"myTableGenerator\")");
                sb.append(CR);
                sb.append("    @TableGenerator(name=\"myTableGenerator\", table=\"myTable\", catalog=\"myCatalog\", schema=\"mySchema\", pkColumnName=\"myPkColumnName\", valueColumnName=\"myValueColumnName\", pkColumnValue=\"myPkColumnValue\", initialValue=1, allocationSize=1)");
                sb.append(CR);
                sb.append("    @SequenceGenerator(name=\"mySequenceGenerator\")");
            }
        });
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertEquals((String)"idMapping", (String)ormIdMapping.getName());
        OrmIdMappingTests.assertEquals((String)"idMapping", (String)idResource.getName());
        idResource.setName("newName");
        OrmIdMappingTests.assertEquals((String)"newName", (String)ormIdMapping.getName());
        OrmIdMappingTests.assertEquals((String)"newName", (String)idResource.getName());
        idResource.setName(null);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getName());
        OrmIdMappingTests.assertNull((Object)idResource.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertEquals((String)"idMapping", (String)ormIdMapping.getName());
        OrmIdMappingTests.assertEquals((String)"idMapping", (String)idResource.getName());
        ormIdMapping.setName("newName");
        OrmIdMappingTests.assertEquals((String)"newName", (String)ormIdMapping.getName());
        OrmIdMappingTests.assertEquals((String)"newName", (String)idResource.getName());
        ormIdMapping.setName(null);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getName());
        OrmIdMappingTests.assertNull((Object)idResource.getName());
    }

    public void testUpdateTemporal() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getConverter().getType());
        OrmIdMappingTests.assertNull((Object)idResource.getTemporal());
        idResource.setTemporal(TemporalType.DATE);
        OrmIdMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.DATE, (Object)((TemporalConverter)ormIdMapping.getConverter()).getTemporalType());
        OrmIdMappingTests.assertEquals((Object)TemporalType.DATE, (Object)idResource.getTemporal());
        idResource.setTemporal(TemporalType.TIME);
        OrmIdMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((TemporalConverter)ormIdMapping.getConverter()).getTemporalType());
        OrmIdMappingTests.assertEquals((Object)TemporalType.TIME, (Object)idResource.getTemporal());
        idResource.setTemporal(TemporalType.TIMESTAMP);
        OrmIdMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIMESTAMP, (Object)((TemporalConverter)ormIdMapping.getConverter()).getTemporalType());
        OrmIdMappingTests.assertEquals((Object)TemporalType.TIMESTAMP, (Object)idResource.getTemporal());
        idResource.setTemporal(null);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getConverter().getType());
        OrmIdMappingTests.assertNull((Object)idResource.getTemporal());
    }

    public void testModifyTemporal() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getConverter().getType());
        OrmIdMappingTests.assertNull((Object)idResource.getTemporal());
        ormIdMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)ormIdMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.DATE);
        OrmIdMappingTests.assertEquals((Object)TemporalType.DATE, (Object)idResource.getTemporal());
        OrmIdMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.DATE, (Object)((TemporalConverter)ormIdMapping.getConverter()).getTemporalType());
        ((TemporalConverter)ormIdMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        OrmIdMappingTests.assertEquals((Object)TemporalType.TIME, (Object)idResource.getTemporal());
        OrmIdMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((TemporalConverter)ormIdMapping.getConverter()).getTemporalType());
        ((TemporalConverter)ormIdMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIMESTAMP);
        OrmIdMappingTests.assertEquals((Object)TemporalType.TIMESTAMP, (Object)idResource.getTemporal());
        OrmIdMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIMESTAMP, (Object)((TemporalConverter)ormIdMapping.getConverter()).getTemporalType());
        ormIdMapping.setConverter(null);
        OrmIdMappingTests.assertNull((Object)idResource.getTemporal());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getConverter().getType());
    }

    public void testAddSequenceGenerator() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratorContainer().getSequenceGenerator());
        OrmIdMappingTests.assertNull((Object)idResource.getSequenceGenerator());
        ormIdMapping.getGeneratorContainer().addSequenceGenerator();
        OrmIdMappingTests.assertNotNull((Object)idResource.getSequenceGenerator());
        OrmIdMappingTests.assertNotNull((Object)ormIdMapping.getGeneratorContainer().getSequenceGenerator());
        try {
            ormIdMapping.getGeneratorContainer().addSequenceGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        OrmIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveSequenceGenerator() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratorContainer().getSequenceGenerator());
        OrmIdMappingTests.assertNull((Object)idResource.getSequenceGenerator());
        ormIdMapping.getGeneratorContainer().addSequenceGenerator();
        OrmIdMappingTests.assertNotNull((Object)idResource.getSequenceGenerator());
        OrmIdMappingTests.assertNotNull((Object)ormIdMapping.getGeneratorContainer().getSequenceGenerator());
        ormIdMapping.getGeneratorContainer().removeSequenceGenerator();
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratorContainer().getSequenceGenerator());
        OrmIdMappingTests.assertNull((Object)idResource.getSequenceGenerator());
        try {
            ormIdMapping.getGeneratorContainer().removeSequenceGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        OrmIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testUpdateSequenceGenerator() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratorContainer().getSequenceGenerator());
        OrmIdMappingTests.assertNull((Object)idResource.getSequenceGenerator());
        OrmIdMappingTests.assertEquals((int)0, (int)ormIdMapping.getPersistenceUnit().generatorsSize());
        idResource.setSequenceGenerator(OrmFactory.eINSTANCE.createXmlSequenceGenerator());
        OrmIdMappingTests.assertNotNull((Object)ormIdMapping.getGeneratorContainer().getSequenceGenerator());
        OrmIdMappingTests.assertNotNull((Object)idResource.getSequenceGenerator());
        OrmIdMappingTests.assertEquals((int)1, (int)ormIdMapping.getPersistenceUnit().generatorsSize());
        ormIdMapping.getGeneratorContainer().getSequenceGenerator().setName("foo");
        OrmIdMappingTests.assertEquals((int)1, (int)ormIdMapping.getPersistenceUnit().generatorsSize());
        idResource.setSequenceGenerator(null);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratorContainer().getSequenceGenerator());
        OrmIdMappingTests.assertNull((Object)idResource.getSequenceGenerator());
        OrmIdMappingTests.assertEquals((int)0, (int)ormIdMapping.getPersistenceUnit().generatorsSize());
    }

    public void testAddTableGenerator() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratorContainer().getTableGenerator());
        OrmIdMappingTests.assertNull((Object)idResource.getTableGenerator());
        ormIdMapping.getGeneratorContainer().addTableGenerator();
        OrmIdMappingTests.assertNotNull((Object)idResource.getTableGenerator());
        OrmIdMappingTests.assertNotNull((Object)ormIdMapping.getGeneratorContainer().getTableGenerator());
        try {
            ormIdMapping.getGeneratorContainer().addTableGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        OrmIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveTableGenerator() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratorContainer().getTableGenerator());
        OrmIdMappingTests.assertNull((Object)idResource.getTableGenerator());
        ormIdMapping.getGeneratorContainer().addTableGenerator();
        OrmIdMappingTests.assertNotNull((Object)idResource.getTableGenerator());
        OrmIdMappingTests.assertNotNull((Object)ormIdMapping.getGeneratorContainer().getTableGenerator());
        ormIdMapping.getGeneratorContainer().removeTableGenerator();
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratorContainer().getTableGenerator());
        OrmIdMappingTests.assertNull((Object)idResource.getTableGenerator());
        try {
            ormIdMapping.getGeneratorContainer().removeTableGenerator();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        OrmIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testUpdateTableGenerator() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratorContainer().getTableGenerator());
        OrmIdMappingTests.assertNull((Object)idResource.getTableGenerator());
        OrmIdMappingTests.assertEquals((int)0, (int)ormIdMapping.getPersistenceUnit().generatorsSize());
        idResource.setTableGenerator(OrmFactory.eINSTANCE.createXmlTableGenerator());
        OrmIdMappingTests.assertNotNull((Object)ormIdMapping.getGeneratorContainer().getTableGenerator());
        OrmIdMappingTests.assertNotNull((Object)idResource.getTableGenerator());
        OrmIdMappingTests.assertEquals((int)1, (int)ormIdMapping.getPersistenceUnit().generatorsSize());
        ormIdMapping.getGeneratorContainer().getTableGenerator().setName("foo");
        OrmIdMappingTests.assertEquals((int)1, (int)ormIdMapping.getGeneratorContainer().getPersistenceUnit().generatorsSize());
        idResource.setTableGenerator(null);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratorContainer().getTableGenerator());
        OrmIdMappingTests.assertNull((Object)idResource.getTableGenerator());
        OrmIdMappingTests.assertEquals((int)0, (int)ormIdMapping.getPersistenceUnit().generatorsSize());
    }

    public void testAddGeneratedValue() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratedValue());
        OrmIdMappingTests.assertNull((Object)idResource.getGeneratedValue());
        ormIdMapping.addGeneratedValue();
        OrmIdMappingTests.assertNotNull((Object)idResource.getGeneratedValue());
        OrmIdMappingTests.assertNotNull((Object)ormIdMapping.getGeneratedValue());
        try {
            ormIdMapping.addGeneratedValue();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        OrmIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testRemoveGeneratedValue() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratedValue());
        OrmIdMappingTests.assertNull((Object)idResource.getGeneratedValue());
        ormIdMapping.addGeneratedValue();
        OrmIdMappingTests.assertNotNull((Object)idResource.getGeneratedValue());
        OrmIdMappingTests.assertNotNull((Object)ormIdMapping.getGeneratedValue());
        ormIdMapping.removeGeneratedValue();
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratedValue());
        OrmIdMappingTests.assertNull((Object)idResource.getGeneratedValue());
        try {
            ormIdMapping.removeGeneratedValue();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        OrmIdMappingTests.fail((String)"IllegalStateException not thrown");
    }

    public void testUpdateGeneratedValue() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "idMapping");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        XmlId idResource = (XmlId)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getIds().get(0);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratedValue());
        OrmIdMappingTests.assertNull((Object)idResource.getGeneratedValue());
        idResource.setGeneratedValue(OrmFactory.eINSTANCE.createXmlGeneratedValue());
        OrmIdMappingTests.assertNotNull((Object)ormIdMapping.getGeneratedValue());
        OrmIdMappingTests.assertNotNull((Object)idResource.getGeneratedValue());
        idResource.setGeneratedValue(null);
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratedValue());
        OrmIdMappingTests.assertNull((Object)idResource.getGeneratedValue());
    }

    public void testIdMappingNoUnderylingJavaAttribute() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.addSpecifiedAttribute("id", "foo");
        OrmIdMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertEquals((String)"foo", (String)ormIdMapping.getName());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getConverter().getType());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratedValue());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratorContainer().getSequenceGenerator());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratorContainer().getTableGenerator());
        OrmColumn ormColumn = ormIdMapping.getColumn();
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmIdMappingTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedTable());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedScale());
        OrmIdMappingTests.assertEquals((String)"foo", (String)ormColumn.getDefaultName());
        OrmIdMappingTests.assertEquals((boolean)false, (boolean)ormColumn.isDefaultUnique());
        OrmIdMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultNullable());
        OrmIdMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultInsertable());
        OrmIdMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultUpdatable());
        OrmIdMappingTests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        OrmIdMappingTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getDefaultTable());
        OrmIdMappingTests.assertEquals((int)255, (int)ormColumn.getDefaultLength());
        OrmIdMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultPrecision());
        OrmIdMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultScale());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmIdMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        IdMapping idMapping = (IdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertEquals((String)"id", (String)idMapping.getName());
        OrmIdMappingTests.assertEquals(TemporalConverter.class, (Object)idMapping.getConverter().getType());
        OrmIdMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIMESTAMP, (Object)((TemporalConverter)idMapping.getConverter()).getTemporalType());
        Column column = idMapping.getColumn();
        OrmIdMappingTests.assertEquals((String)"MY_COLUMN", (String)column.getSpecifiedName());
        OrmIdMappingTests.assertEquals((Object)Boolean.TRUE, (Object)column.getSpecifiedUnique());
        OrmIdMappingTests.assertEquals((Object)Boolean.FALSE, (Object)column.getSpecifiedNullable());
        OrmIdMappingTests.assertEquals((Object)Boolean.FALSE, (Object)column.getSpecifiedInsertable());
        OrmIdMappingTests.assertEquals((Object)Boolean.FALSE, (Object)column.getSpecifiedUpdatable());
        OrmIdMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)column.getColumnDefinition());
        OrmIdMappingTests.assertEquals((String)"MY_TABLE", (String)column.getSpecifiedTable());
        OrmIdMappingTests.assertEquals((Object)5, (Object)column.getSpecifiedLength());
        OrmIdMappingTests.assertEquals((Object)6, (Object)column.getSpecifiedPrecision());
        OrmIdMappingTests.assertEquals((Object)7, (Object)column.getSpecifiedScale());
        GeneratedValue generatedValue = idMapping.getGeneratedValue();
        OrmIdMappingTests.assertEquals((String)"myTableGenerator", (String)generatedValue.getSpecifiedGenerator());
        OrmIdMappingTests.assertEquals((Object)GenerationType.TABLE, (Object)generatedValue.getSpecifiedStrategy());
        TableGenerator tableGenerator = idMapping.getGeneratorContainer().getTableGenerator();
        OrmIdMappingTests.assertNull((Object)tableGenerator);
        SequenceGenerator sequenceGenerator = idMapping.getGeneratorContainer().getSequenceGenerator();
        OrmIdMappingTests.assertNull((Object)sequenceGenerator);
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmIdMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        OrmIdMappingTests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMappingKey());
        ormPersistentAttribute.convertToSpecified("id");
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        OrmIdMappingTests.assertEquals((String)"id", (String)ormIdMapping.getName());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getConverter().getType());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratedValue());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratorContainer().getSequenceGenerator());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratorContainer().getTableGenerator());
        OrmColumn ormColumn = ormIdMapping.getColumn();
        OrmIdMappingTests.assertEquals((String)"id", (String)ormColumn.getName());
        OrmIdMappingTests.assertEquals((boolean)false, (boolean)ormColumn.isDefaultUnique());
        OrmIdMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultNullable());
        OrmIdMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultInsertable());
        OrmIdMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultUpdatable());
        OrmIdMappingTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmIdMappingTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getTable());
        OrmIdMappingTests.assertEquals((int)255, (int)ormColumn.getLength());
        OrmIdMappingTests.assertEquals((int)0, (int)ormColumn.getPrecision());
        OrmIdMappingTests.assertEquals((int)0, (int)ormColumn.getScale());
    }

    public void testSpecifiedMapping() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.addSpecifiedAttribute("id", "id");
        OrmIdMappingTests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmIdMapping ormIdMapping = (OrmIdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertEquals((String)"id", (String)ormIdMapping.getName());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getConverter().getType());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratedValue());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratorContainer().getSequenceGenerator());
        OrmIdMappingTests.assertNull((Object)ormIdMapping.getGeneratorContainer().getTableGenerator());
        OrmColumn ormColumn = ormIdMapping.getColumn();
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedName());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedUnique());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedNullable());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        OrmIdMappingTests.assertNull((Object)ormColumn.getColumnDefinition());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedTable());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedLength());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        OrmIdMappingTests.assertNull((Object)ormColumn.getSpecifiedScale());
        OrmIdMappingTests.assertEquals((String)"id", (String)ormColumn.getDefaultName());
        OrmIdMappingTests.assertEquals((boolean)false, (boolean)ormColumn.isDefaultUnique());
        OrmIdMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultNullable());
        OrmIdMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultInsertable());
        OrmIdMappingTests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultUpdatable());
        OrmIdMappingTests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        OrmIdMappingTests.assertEquals((String)"AnnotationTestType", (String)ormColumn.getDefaultTable());
        OrmIdMappingTests.assertEquals((int)255, (int)ormColumn.getDefaultLength());
        OrmIdMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultPrecision());
        OrmIdMappingTests.assertEquals((int)0, (int)ormColumn.getDefaultScale());
    }

    public void testIdMorphToBasicMapping() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "id");
        IdMapping idMapping = (IdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        ormPersistentAttribute.setMappingKey("basic");
        OrmIdMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof BasicMapping));
        OrmIdMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
        OrmIdMappingTests.assertEquals((String)"FOO", (String)((BasicMapping)ormPersistentAttribute.getMapping()).getColumn().getSpecifiedName());
    }

    public void testIdMorphToVersionMapping() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "id");
        IdMapping idMapping = (IdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        ormPersistentAttribute.setMappingKey("version");
        OrmIdMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof VersionMapping));
        OrmIdMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
        OrmIdMappingTests.assertEquals((String)"FOO", (String)((VersionMapping)ormPersistentAttribute.getMapping()).getColumn().getSpecifiedName());
    }

    public void testIdMorphToTransientMapping() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "id");
        IdMapping idMapping = (IdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        ormPersistentAttribute.setMappingKey("transient");
        OrmIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        OrmIdMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testIdMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "id");
        IdMapping idMapping = (IdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        ormPersistentAttribute.setMappingKey("embedded");
        OrmIdMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedMapping));
        OrmIdMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testIdMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "id");
        IdMapping idMapping = (IdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        ormPersistentAttribute.setMappingKey("embeddedId");
        OrmIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        OrmIdMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testIdMorphToOneToOneMapping() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "id");
        IdMapping idMapping = (IdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        ormPersistentAttribute.setMappingKey("oneToOne");
        OrmIdMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToOneMapping));
        OrmIdMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testIdMorphToOneToManyMapping() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "id");
        IdMapping idMapping = (IdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        ormPersistentAttribute.setMappingKey("oneToMany");
        OrmIdMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToManyMapping));
        OrmIdMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testIdMorphToManyToOneMapping() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "id");
        IdMapping idMapping = (IdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToOne");
        OrmIdMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        OrmIdMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testIdMorphToManyToManyMapping() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("id", "id");
        IdMapping idMapping = (IdMapping)ormPersistentAttribute.getMapping();
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        idMapping.getColumn().setSpecifiedName("FOO");
        idMapping.setConverter(TemporalConverter.class);
        ((TemporalConverter)idMapping.getConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        OrmIdMappingTests.assertFalse((boolean)idMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToMany");
        OrmIdMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmIdMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmIdMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToManyMapping));
        OrmIdMappingTests.assertEquals((String)"id", (String)ormPersistentAttribute.getMapping().getName());
    }
}

