/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.Cascade;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmCascade;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.orm.OrmManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmManyToOneRelationship;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlManyToOne;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class OrmManyToOneMappingTests
extends ContextModelTestCase {
    public OrmManyToOneMappingTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntityManyToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne", "javax.persistence.JoinColumn", "javax.persistence.FetchType", "javax.persistence.CascadeType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToOne(fetch=FetchType.LAZY, optional=false, targetEntity=Address.class, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH})");
                sb.append(CR);
                sb.append("    @JoinColumn(name=\"MY_COLUMN\", referencedColumnName=\"MY_REFERENCED_COLUMN\", unique=true, nullable=false, insertable=false, updatable=false, columnDefinition=\"COLUMN_DEFINITION\", table=\"MY_TABLE\")");
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createTestEntityWithManyToOneMapping() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToOne").append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmReadOnlyPersistentAttribute each : CollectionTools.iterable((Iterator)ormPersistentType.attributes())) {
            each.convertToSpecified();
        }
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToOne", "manyToOneMapping");
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        XmlManyToOne manyToOne = (XmlManyToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToOnes().get(0);
        OrmManyToOneMappingTests.assertEquals((String)"manyToOneMapping", (String)ormManyToOneMapping.getName());
        OrmManyToOneMappingTests.assertEquals((String)"manyToOneMapping", (String)manyToOne.getName());
        manyToOne.setName("newName");
        OrmManyToOneMappingTests.assertEquals((String)"newName", (String)ormManyToOneMapping.getName());
        OrmManyToOneMappingTests.assertEquals((String)"newName", (String)manyToOne.getName());
        manyToOne.setName(null);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getName());
        OrmManyToOneMappingTests.assertNull((Object)manyToOne.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToOne", "manyToOneMapping");
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        XmlManyToOne manyToOne = (XmlManyToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToOnes().get(0);
        OrmManyToOneMappingTests.assertEquals((String)"manyToOneMapping", (String)ormManyToOneMapping.getName());
        OrmManyToOneMappingTests.assertEquals((String)"manyToOneMapping", (String)manyToOne.getName());
        ormManyToOneMapping.setName("newName");
        OrmManyToOneMappingTests.assertEquals((String)"newName", (String)ormManyToOneMapping.getName());
        OrmManyToOneMappingTests.assertEquals((String)"newName", (String)manyToOne.getName());
        ormManyToOneMapping.setName(null);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getName());
        OrmManyToOneMappingTests.assertNull((Object)manyToOne.getName());
    }

    public void testUpdateTargetEntity() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToOne", "manyToOneMapping");
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        XmlManyToOne manyToOne = (XmlManyToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToOnes().get(0);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedTargetEntity());
        OrmManyToOneMappingTests.assertNull((Object)manyToOne.getTargetEntity());
        manyToOne.setTargetEntity("newTargetEntity");
        OrmManyToOneMappingTests.assertEquals((String)"newTargetEntity", (String)ormManyToOneMapping.getSpecifiedTargetEntity());
        OrmManyToOneMappingTests.assertEquals((String)"newTargetEntity", (String)manyToOne.getTargetEntity());
        manyToOne.setTargetEntity(null);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedTargetEntity());
        OrmManyToOneMappingTests.assertNull((Object)manyToOne.getTargetEntity());
    }

    public void testModifyTargetEntity() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToOne", "manyToOneMapping");
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        XmlManyToOne manyToOne = (XmlManyToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToOnes().get(0);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedTargetEntity());
        OrmManyToOneMappingTests.assertNull((Object)manyToOne.getTargetEntity());
        ormManyToOneMapping.setSpecifiedTargetEntity("newTargetEntity");
        OrmManyToOneMappingTests.assertEquals((String)"newTargetEntity", (String)ormManyToOneMapping.getSpecifiedTargetEntity());
        OrmManyToOneMappingTests.assertEquals((String)"newTargetEntity", (String)manyToOne.getTargetEntity());
        ormManyToOneMapping.setSpecifiedTargetEntity(null);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedTargetEntity());
        OrmManyToOneMappingTests.assertNull((Object)manyToOne.getTargetEntity());
    }

    public void testUpdateSpecifiedFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToOne", "manyToOneMapping");
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        XmlManyToOne manyToOneResource = (XmlManyToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToOnes().get(0);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedFetch());
        OrmManyToOneMappingTests.assertNull((Object)manyToOneResource.getFetch());
        manyToOneResource.setFetch(org.eclipse.jpt.jpa.core.resource.orm.FetchType.EAGER);
        OrmManyToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormManyToOneMapping.getSpecifiedFetch());
        OrmManyToOneMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.EAGER, (Object)manyToOneResource.getFetch());
        manyToOneResource.setFetch(org.eclipse.jpt.jpa.core.resource.orm.FetchType.LAZY);
        OrmManyToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormManyToOneMapping.getSpecifiedFetch());
        OrmManyToOneMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.LAZY, (Object)manyToOneResource.getFetch());
        manyToOneResource.setFetch(null);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedFetch());
        OrmManyToOneMappingTests.assertNull((Object)manyToOneResource.getFetch());
    }

    public void testModifySpecifiedFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToOne", "manyToOneMapping");
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        XmlManyToOne manyToOneResource = (XmlManyToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToOnes().get(0);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedFetch());
        OrmManyToOneMappingTests.assertNull((Object)manyToOneResource.getFetch());
        ormManyToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        OrmManyToOneMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.EAGER, (Object)manyToOneResource.getFetch());
        OrmManyToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormManyToOneMapping.getSpecifiedFetch());
        ormManyToOneMapping.setSpecifiedFetch(FetchType.LAZY);
        OrmManyToOneMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.LAZY, (Object)manyToOneResource.getFetch());
        OrmManyToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormManyToOneMapping.getSpecifiedFetch());
        ormManyToOneMapping.setSpecifiedFetch(null);
        OrmManyToOneMappingTests.assertNull((Object)manyToOneResource.getFetch());
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedFetch());
    }

    public void testUpdateSpecifiedOptional() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToOne", "manyToOneMapping");
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        XmlManyToOne manyToOneResource = (XmlManyToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToOnes().get(0);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedOptional());
        OrmManyToOneMappingTests.assertNull((Object)manyToOneResource.getOptional());
        manyToOneResource.setOptional(Boolean.TRUE);
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormManyToOneMapping.getSpecifiedOptional());
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)manyToOneResource.getOptional());
        manyToOneResource.setOptional(Boolean.FALSE);
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormManyToOneMapping.getSpecifiedOptional());
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)manyToOneResource.getOptional());
        manyToOneResource.setOptional(null);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedOptional());
        OrmManyToOneMappingTests.assertNull((Object)manyToOneResource.getOptional());
    }

    public void testModifySpecifiedOptional() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToOne", "manyToOneMapping");
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        XmlManyToOne manyToOneResource = (XmlManyToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToOnes().get(0);
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedOptional());
        OrmManyToOneMappingTests.assertNull((Object)manyToOneResource.getOptional());
        ormManyToOneMapping.setSpecifiedOptional(Boolean.TRUE);
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)manyToOneResource.getOptional());
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormManyToOneMapping.getSpecifiedOptional());
        ormManyToOneMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)manyToOneResource.getOptional());
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormManyToOneMapping.getSpecifiedOptional());
        ormManyToOneMapping.setSpecifiedOptional(null);
        OrmManyToOneMappingTests.assertNull((Object)manyToOneResource.getOptional());
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedOptional());
    }

    public void testAddSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToOne", "manyToOneMapping");
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        OrmJoinColumnRelationshipStrategy strategy = ormManyToOneMapping.getRelationship().getJoinColumnStrategy();
        XmlManyToOne manyToOneResource = (XmlManyToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToOnes().get(0);
        OrmJoinColumn joinColumn = strategy.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        OrmManyToOneMappingTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(0)).getName());
        OrmJoinColumn joinColumn2 = strategy.addSpecifiedJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        OrmManyToOneMappingTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(0)).getName());
        OrmManyToOneMappingTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(1)).getName());
        OrmJoinColumn joinColumn3 = strategy.addSpecifiedJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        OrmManyToOneMappingTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(0)).getName());
        OrmManyToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(1)).getName());
        OrmManyToOneMappingTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(2)).getName());
        ListIterator joinColumns = strategy.specifiedJoinColumns();
        OrmManyToOneMappingTests.assertEquals((Object)joinColumn2, joinColumns.next());
        OrmManyToOneMappingTests.assertEquals((Object)joinColumn3, joinColumns.next());
        OrmManyToOneMappingTests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = strategy.specifiedJoinColumns();
        OrmManyToOneMappingTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmManyToOneMappingTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmManyToOneMappingTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToOne", "manyToOneMapping");
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        OrmJoinColumnRelationshipStrategy strategy = ormManyToOneMapping.getRelationship().getJoinColumnStrategy();
        XmlManyToOne manyToOneResource = (XmlManyToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToOnes().get(0);
        strategy.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        strategy.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        strategy.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        OrmManyToOneMappingTests.assertEquals((int)3, (int)manyToOneResource.getJoinColumns().size());
        strategy.removeSpecifiedJoinColumn(0);
        OrmManyToOneMappingTests.assertEquals((int)2, (int)manyToOneResource.getJoinColumns().size());
        OrmManyToOneMappingTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(0)).getName());
        OrmManyToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(1)).getName());
        strategy.removeSpecifiedJoinColumn(0);
        OrmManyToOneMappingTests.assertEquals((int)1, (int)manyToOneResource.getJoinColumns().size());
        OrmManyToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(0)).getName());
        strategy.removeSpecifiedJoinColumn(0);
        OrmManyToOneMappingTests.assertEquals((int)0, (int)manyToOneResource.getJoinColumns().size());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmManyToOneMapping contextMapping = (OrmManyToOneMapping)contextAttribute.getMapping();
        OrmManyToOneRelationship rel = contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlManyToOne resourceMapping = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        OrmManyToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        OrmManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        rel.setStrategyToJoinColumn();
        OrmManyToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        OrmManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithManyToOneMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmManyToOneMapping contextMapping = (OrmManyToOneMapping)contextAttribute.getMapping();
        OrmManyToOneRelationship rel = contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlManyToOne resourceMapping = (XmlManyToOne)resourceEntity.getAttributes().getManyToOnes().get(0);
        OrmManyToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        OrmManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        resourceMapping.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        this.getJpaProject().synchronizeContextModel();
        OrmManyToOneMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        OrmManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        resourceMapping.getJoinColumns().clear();
        this.getJpaProject().synchronizeContextModel();
        OrmManyToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        OrmManyToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToOne", "manyToOneMapping");
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        OrmJoinColumnRelationshipStrategy strategy = ormManyToOneMapping.getRelationship().getJoinColumnStrategy();
        XmlManyToOne manyToOneResource = (XmlManyToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToOnes().get(0);
        strategy.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        strategy.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        strategy.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        OrmManyToOneMappingTests.assertEquals((int)3, (int)manyToOneResource.getJoinColumns().size());
        strategy.moveSpecifiedJoinColumn(2, 0);
        ListIterator joinColumns = strategy.specifiedJoinColumns();
        OrmManyToOneMappingTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmManyToOneMappingTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmManyToOneMappingTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmManyToOneMappingTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(0)).getName());
        OrmManyToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(1)).getName());
        OrmManyToOneMappingTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(2)).getName());
        strategy.moveSpecifiedJoinColumn(0, 1);
        joinColumns = strategy.specifiedJoinColumns();
        OrmManyToOneMappingTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmManyToOneMappingTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmManyToOneMappingTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmManyToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(0)).getName());
        OrmManyToOneMappingTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(1)).getName());
        OrmManyToOneMappingTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)manyToOneResource.getJoinColumns().get(2)).getName());
    }

    public void testManyToOneMappingNoUnderylingJavaAttribute() throws Exception {
        this.createTestEntityManyToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.addSpecifiedAttribute("manyToOne", "foo");
        OrmManyToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        OrmJoinColumnRelationshipStrategy strategy = ormManyToOneMapping.getRelationship().getJoinColumnStrategy();
        OrmManyToOneMappingTests.assertEquals((String)"foo", (String)ormManyToOneMapping.getName());
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedFetch());
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedOptional());
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedTargetEntity());
        OrmManyToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormManyToOneMapping.getFetch());
        OrmManyToOneMappingTests.assertEquals((boolean)true, (boolean)ormManyToOneMapping.isOptional());
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getTargetEntity());
        OrmManyToOneMappingTests.assertFalse((boolean)strategy.specifiedJoinColumns().hasNext());
        OrmCascade cascade = ormManyToOneMapping.getCascade();
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isAll());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isMerge());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isPersist());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isRemove());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isRefresh());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityManyToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmManyToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ManyToOneMapping manyToOneMapping = (ManyToOneMapping)ormPersistentAttribute.getMapping();
        OrmManyToOneMappingTests.assertEquals((String)"address", (String)manyToOneMapping.getName());
        OrmManyToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)manyToOneMapping.getSpecifiedFetch());
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)manyToOneMapping.getSpecifiedOptional());
        OrmManyToOneMappingTests.assertEquals((String)"Address", (String)manyToOneMapping.getSpecifiedTargetEntity());
        JoinColumn joinColumn = (JoinColumn)manyToOneMapping.getRelationship().getJoinColumnStrategy().specifiedJoinColumns().next();
        OrmManyToOneMappingTests.assertEquals((String)"MY_COLUMN", (String)joinColumn.getSpecifiedName());
        OrmManyToOneMappingTests.assertEquals((String)"MY_REFERENCED_COLUMN", (String)joinColumn.getSpecifiedReferencedColumnName());
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)joinColumn.getSpecifiedUnique());
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumn.getSpecifiedNullable());
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumn.getSpecifiedInsertable());
        OrmManyToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumn.getSpecifiedUpdatable());
        OrmManyToOneMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)joinColumn.getColumnDefinition());
        OrmManyToOneMappingTests.assertEquals((String)"MY_TABLE", (String)joinColumn.getSpecifiedTable());
        Cascade cascade = manyToOneMapping.getCascade();
        OrmManyToOneMappingTests.assertTrue((boolean)cascade.isAll());
        OrmManyToOneMappingTests.assertTrue((boolean)cascade.isMerge());
        OrmManyToOneMappingTests.assertTrue((boolean)cascade.isPersist());
        OrmManyToOneMappingTests.assertTrue((boolean)cascade.isRemove());
        OrmManyToOneMappingTests.assertTrue((boolean)cascade.isRefresh());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityManyToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmManyToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        OrmManyToOneMappingTests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)ormPersistentAttribute.getMappingKey());
        OrmManyToOneMappingTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        ormPersistentAttribute.convertToSpecified("manyToOne");
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        OrmManyToOneMappingTests.assertEquals((String)"address", (String)ormManyToOneMapping.getName());
        OrmManyToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormManyToOneMapping.getDefaultFetch());
        OrmManyToOneMappingTests.assertEquals((boolean)true, (boolean)ormManyToOneMapping.isDefaultOptional());
        OrmManyToOneMappingTests.assertEquals((String)"test.Address", (String)ormManyToOneMapping.getDefaultTargetEntity());
        OrmCascade cascade = ormManyToOneMapping.getCascade();
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isAll());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isMerge());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isPersist());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isRemove());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isRefresh());
    }

    public void testSpecifiedMapping() throws Exception {
        this.createTestEntityManyToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.addSpecifiedAttribute("manyToOne", "address");
        OrmManyToOneMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmManyToOneMapping ormManyToOneMapping = (OrmManyToOneMapping)ormPersistentAttribute.getMapping();
        OrmManyToOneMappingTests.assertEquals((String)"address", (String)ormManyToOneMapping.getName());
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedFetch());
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedOptional());
        OrmManyToOneMappingTests.assertNull((Object)ormManyToOneMapping.getSpecifiedTargetEntity());
        OrmManyToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormManyToOneMapping.getFetch());
        OrmManyToOneMappingTests.assertEquals((boolean)true, (boolean)ormManyToOneMapping.isOptional());
        OrmManyToOneMappingTests.assertEquals((String)"test.Address", (String)ormManyToOneMapping.getDefaultTargetEntity());
        OrmManyToOneMappingTests.assertFalse((boolean)ormManyToOneMapping.getRelationship().getJoinColumnStrategy().specifiedJoinColumns().hasNext());
        OrmCascade cascade = ormManyToOneMapping.getCascade();
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isAll());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isMerge());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isPersist());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isRemove());
        OrmManyToOneMappingTests.assertFalse((boolean)cascade.isRefresh());
    }
}

