/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.Cascade;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmCascade;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.orm.OrmMappedByRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.orm.OrmOneToOneMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmOneToOneRelationship;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmPrimaryKeyJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.jpa.core.resource.orm.XmlPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class OrmOneToOneMappingTests
extends ContextModelTestCase {
    public OrmOneToOneMappingTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntityOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.JoinColumn", "javax.persistence.FetchType", "javax.persistence.CascadeType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne(fetch=FetchType.LAZY, optional=false, targetEntity=Address.class, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH})");
                sb.append(CR);
                sb.append("    @JoinColumn(name=\"MY_COLUMN\", referencedColumnName=\"MY_REFERENCED_COLUMN\", unique=true, nullable=false, insertable=false, updatable=false, columnDefinition=\"COLUMN_DEFINITION\", table=\"MY_TABLE\")");
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createTestEntityWithOneToOneMapping() throws Exception {
        this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne").append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmReadOnlyPersistentAttribute each : CollectionTools.iterable((Iterator)ormPersistentType.attributes())) {
            each.convertToSpecified();
        }
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithValidOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String foo;").append(CR);
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmOneToOneMappingTests.assertEquals((String)"oneToOneMapping", (String)ormOneToOneMapping.getName());
        OrmOneToOneMappingTests.assertEquals((String)"oneToOneMapping", (String)oneToOne.getName());
        oneToOne.setName("newName");
        OrmOneToOneMappingTests.assertEquals((String)"newName", (String)ormOneToOneMapping.getName());
        OrmOneToOneMappingTests.assertEquals((String)"newName", (String)oneToOne.getName());
        oneToOne.setName(null);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getName());
        OrmOneToOneMappingTests.assertNull((Object)oneToOne.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmOneToOneMappingTests.assertEquals((String)"oneToOneMapping", (String)ormOneToOneMapping.getName());
        OrmOneToOneMappingTests.assertEquals((String)"oneToOneMapping", (String)oneToOne.getName());
        ormOneToOneMapping.setName("newName");
        OrmOneToOneMappingTests.assertEquals((String)"newName", (String)ormOneToOneMapping.getName());
        OrmOneToOneMappingTests.assertEquals((String)"newName", (String)oneToOne.getName());
        ormOneToOneMapping.setName(null);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getName());
        OrmOneToOneMappingTests.assertNull((Object)oneToOne.getName());
    }

    public void testUpdateSpecifiedTargetEntity() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertNull((Object)oneToOne.getTargetEntity());
        oneToOne.setTargetEntity("newTargetEntity");
        OrmOneToOneMappingTests.assertEquals((String)"newTargetEntity", (String)ormOneToOneMapping.getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertEquals((String)"newTargetEntity", (String)oneToOne.getTargetEntity());
        oneToOne.setTargetEntity(null);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertNull((Object)oneToOne.getTargetEntity());
    }

    public void testModifySpecifiedTargetEntity() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertNull((Object)oneToOne.getTargetEntity());
        ormOneToOneMapping.setSpecifiedTargetEntity("newTargetEntity");
        OrmOneToOneMappingTests.assertEquals((String)"newTargetEntity", (String)ormOneToOneMapping.getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertEquals((String)"newTargetEntity", (String)oneToOne.getTargetEntity());
        ormOneToOneMapping.setSpecifiedTargetEntity(null);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertNull((Object)oneToOne.getTargetEntity());
    }

    public void testUpdateSpecifiedFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedFetch());
        OrmOneToOneMappingTests.assertNull((Object)oneToOneResource.getFetch());
        oneToOneResource.setFetch(org.eclipse.jpt.jpa.core.resource.orm.FetchType.EAGER);
        OrmOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToOneMapping.getSpecifiedFetch());
        OrmOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.EAGER, (Object)oneToOneResource.getFetch());
        oneToOneResource.setFetch(org.eclipse.jpt.jpa.core.resource.orm.FetchType.LAZY);
        OrmOneToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormOneToOneMapping.getSpecifiedFetch());
        OrmOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.LAZY, (Object)oneToOneResource.getFetch());
        oneToOneResource.setFetch(null);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedFetch());
        OrmOneToOneMappingTests.assertNull((Object)oneToOneResource.getFetch());
    }

    public void testModifySpecifiedFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedFetch());
        OrmOneToOneMappingTests.assertNull((Object)oneToOneResource.getFetch());
        ormOneToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        OrmOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.EAGER, (Object)oneToOneResource.getFetch());
        OrmOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToOneMapping.getSpecifiedFetch());
        ormOneToOneMapping.setSpecifiedFetch(FetchType.LAZY);
        OrmOneToOneMappingTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.FetchType.LAZY, (Object)oneToOneResource.getFetch());
        OrmOneToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormOneToOneMapping.getSpecifiedFetch());
        ormOneToOneMapping.setSpecifiedFetch(null);
        OrmOneToOneMappingTests.assertNull((Object)oneToOneResource.getFetch());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedFetch());
    }

    public void testUpdateMappedBy() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmMappedByRelationshipStrategy strategy = ormOneToOneMapping.getRelationship().getMappedByStrategy();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmOneToOneMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmOneToOneMappingTests.assertNull((Object)oneToOne.getMappedBy());
        oneToOne.setMappedBy("newMappedBy");
        OrmOneToOneMappingTests.assertEquals((String)"newMappedBy", (String)strategy.getMappedByAttribute());
        OrmOneToOneMappingTests.assertEquals((String)"newMappedBy", (String)oneToOne.getMappedBy());
        oneToOne.setMappedBy(null);
        OrmOneToOneMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmOneToOneMappingTests.assertNull((Object)oneToOne.getMappedBy());
    }

    public void testModifyMappedBy() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmMappedByRelationshipStrategy strategy = ormOneToOneMapping.getRelationship().getMappedByStrategy();
        XmlOneToOne oneToOne = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmOneToOneMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmOneToOneMappingTests.assertNull((Object)oneToOne.getMappedBy());
        strategy.setMappedByAttribute("newMappedBy");
        OrmOneToOneMappingTests.assertEquals((String)"newMappedBy", (String)strategy.getMappedByAttribute());
        OrmOneToOneMappingTests.assertEquals((String)"newMappedBy", (String)oneToOne.getMappedBy());
        strategy.setMappedByAttribute(null);
        OrmOneToOneMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmOneToOneMappingTests.assertNull((Object)oneToOne.getMappedBy());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmOneToOneMapping contextMapping = (OrmOneToOneMapping)contextAttribute.getMapping();
        OrmOneToOneRelationship rel = contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlOneToOne resourceMapping = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToMappedBy();
        OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToPrimaryKeyJoinColumn();
        OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinColumn();
        OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithOneToOneMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmOneToOneMapping contextMapping = (OrmOneToOneMapping)contextAttribute.getMapping();
        OrmOneToOneRelationship rel = contextMapping.getRelationship();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getXmlTypeMapping();
        XmlOneToOne resourceMapping = (XmlOneToOne)resourceEntity.getAttributes().getOneToOnes().get(0);
        OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceMapping.getPrimaryKeyJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumn());
        this.getJpaProject().synchronizeContextModel();
        OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceMapping.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        this.getJpaProject().synchronizeContextModel();
        OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceMapping.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceMapping.getPrimaryKeyJoinColumns().clear();
        this.getJpaProject().synchronizeContextModel();
        OrmOneToOneMappingTests.assertFalse((boolean)resourceMapping.getJoinColumns().isEmpty());
        OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceMapping.getJoinColumns().clear();
        this.getJpaProject().synchronizeContextModel();
        OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        OrmOneToOneMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsJoinColumn());
        OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceMapping.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getJoinColumns().isEmpty());
        OrmOneToOneMappingTests.assertTrue((boolean)resourceMapping.getPrimaryKeyJoinColumns().isEmpty());
        OrmOneToOneMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmOneToOneMappingTests.assertTrue((boolean)rel.strategyIsJoinColumn());
        OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsPrimaryKeyJoinColumn());
        OrmOneToOneMappingTests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testUpdateSpecifiedOptional() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedOptional());
        OrmOneToOneMappingTests.assertNull((Object)oneToOneResource.getOptional());
        oneToOneResource.setOptional(Boolean.TRUE);
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormOneToOneMapping.getSpecifiedOptional());
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOneResource.getOptional());
        oneToOneResource.setOptional(Boolean.FALSE);
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormOneToOneMapping.getSpecifiedOptional());
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)oneToOneResource.getOptional());
        oneToOneResource.setOptional(null);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedOptional());
        OrmOneToOneMappingTests.assertNull((Object)oneToOneResource.getOptional());
    }

    public void testModifySpecifiedOptional() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedOptional());
        OrmOneToOneMappingTests.assertNull((Object)oneToOneResource.getOptional());
        ormOneToOneMapping.setSpecifiedOptional(Boolean.TRUE);
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)oneToOneResource.getOptional());
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)ormOneToOneMapping.getSpecifiedOptional());
        ormOneToOneMapping.setSpecifiedOptional(Boolean.FALSE);
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)oneToOneResource.getOptional());
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)ormOneToOneMapping.getSpecifiedOptional());
        ormOneToOneMapping.setSpecifiedOptional(null);
        OrmOneToOneMappingTests.assertNull((Object)oneToOneResource.getOptional());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedOptional());
    }

    public void testAddSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmJoinColumnRelationshipStrategy strategy = ormOneToOneMapping.getRelationship().getJoinColumnStrategy();
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmJoinColumn joinColumn = strategy.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(0)).getName());
        OrmJoinColumn joinColumn2 = strategy.addSpecifiedJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(0)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(1)).getName());
        OrmJoinColumn joinColumn3 = strategy.addSpecifiedJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(0)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(1)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(2)).getName());
        ListIterator joinColumns = strategy.specifiedJoinColumns();
        OrmOneToOneMappingTests.assertEquals((Object)joinColumn2, joinColumns.next());
        OrmOneToOneMappingTests.assertEquals((Object)joinColumn3, joinColumns.next());
        OrmOneToOneMappingTests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = strategy.specifiedJoinColumns();
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmJoinColumnRelationshipStrategy strategy = ormOneToOneMapping.getRelationship().getJoinColumnStrategy();
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        strategy.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        strategy.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        strategy.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        OrmOneToOneMappingTests.assertEquals((int)3, (int)oneToOneResource.getJoinColumns().size());
        strategy.removeSpecifiedJoinColumn(0);
        OrmOneToOneMappingTests.assertEquals((int)2, (int)oneToOneResource.getJoinColumns().size());
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(0)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(1)).getName());
        strategy.removeSpecifiedJoinColumn(0);
        OrmOneToOneMappingTests.assertEquals((int)1, (int)oneToOneResource.getJoinColumns().size());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(0)).getName());
        strategy.removeSpecifiedJoinColumn(0);
        OrmOneToOneMappingTests.assertEquals((int)0, (int)oneToOneResource.getJoinColumns().size());
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmJoinColumnRelationshipStrategy strategy = ormOneToOneMapping.getRelationship().getJoinColumnStrategy();
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        strategy.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        strategy.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        strategy.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        OrmOneToOneMappingTests.assertEquals((int)3, (int)oneToOneResource.getJoinColumns().size());
        strategy.moveSpecifiedJoinColumn(2, 0);
        ListIterator joinColumns = strategy.specifiedJoinColumns();
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(0)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(1)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(2)).getName());
        strategy.moveSpecifiedJoinColumn(0, 1);
        joinColumns = strategy.specifiedJoinColumns();
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((OrmJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(0)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(1)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)oneToOneResource.getJoinColumns().get(2)).getName());
    }

    public void testOneToOneMappingNoUnderylingJavaAttribute() throws Exception {
        this.createTestEntityOneToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.addSpecifiedAttribute("oneToOne", "foo");
        OrmOneToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertEquals((String)"foo", (String)ormOneToOneMapping.getName());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedFetch());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedOptional());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToOneMapping.getFetch());
        OrmOneToOneMappingTests.assertEquals((boolean)true, (boolean)ormOneToOneMapping.isOptional());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getTargetEntity());
        OrmOneToOneMappingTests.assertTrue((ormOneToOneMapping.getRelationship().getJoinColumnStrategy().joinColumnsSize() > 0 ? 1 : 0) != 0);
        OrmCascade cascade = ormOneToOneMapping.getCascade();
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isAll());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isMerge());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isPersist());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isRemove());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isRefresh());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityOneToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmOneToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertEquals((String)"address", (String)oneToOneMapping.getName());
        OrmOneToOneMappingTests.assertEquals((Object)FetchType.LAZY, (Object)oneToOneMapping.getSpecifiedFetch());
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)oneToOneMapping.getSpecifiedOptional());
        OrmOneToOneMappingTests.assertEquals((String)"Address", (String)oneToOneMapping.getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertNull((Object)oneToOneMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        JoinColumn joinColumn = (JoinColumn)oneToOneMapping.getRelationship().getJoinColumnStrategy().specifiedJoinColumns().next();
        OrmOneToOneMappingTests.assertEquals((String)"MY_COLUMN", (String)joinColumn.getSpecifiedName());
        OrmOneToOneMappingTests.assertEquals((String)"MY_REFERENCED_COLUMN", (String)joinColumn.getSpecifiedReferencedColumnName());
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.TRUE, (Object)joinColumn.getSpecifiedUnique());
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumn.getSpecifiedNullable());
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumn.getSpecifiedInsertable());
        OrmOneToOneMappingTests.assertEquals((Object)Boolean.FALSE, (Object)joinColumn.getSpecifiedUpdatable());
        OrmOneToOneMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)joinColumn.getColumnDefinition());
        OrmOneToOneMappingTests.assertEquals((String)"MY_TABLE", (String)joinColumn.getSpecifiedTable());
        Cascade cascade = oneToOneMapping.getCascade();
        OrmOneToOneMappingTests.assertTrue((boolean)cascade.isAll());
        OrmOneToOneMappingTests.assertTrue((boolean)cascade.isMerge());
        OrmOneToOneMappingTests.assertTrue((boolean)cascade.isPersist());
        OrmOneToOneMappingTests.assertTrue((boolean)cascade.isRemove());
        OrmOneToOneMappingTests.assertTrue((boolean)cascade.isRefresh());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityOneToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmOneToOneMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        OrmOneToOneMappingTests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)ormPersistentAttribute.getMappingKey());
        OrmOneToOneMappingTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        ormPersistentAttribute.convertToSpecified("oneToOne");
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertEquals((String)"address", (String)ormOneToOneMapping.getName());
        OrmOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToOneMapping.getFetch());
        OrmOneToOneMappingTests.assertEquals((boolean)true, (boolean)ormOneToOneMapping.isOptional());
        OrmOneToOneMappingTests.assertEquals((String)"test.Address", (String)ormOneToOneMapping.getTargetEntity());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        OrmCascade cascade = ormOneToOneMapping.getCascade();
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isAll());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isMerge());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isPersist());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isRemove());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isRefresh());
    }

    public void testSpecifiedMapping() throws Exception {
        this.createTestEntityOneToOneMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        ormPersistentType.addSpecifiedAttribute("oneToOne", "address");
        OrmOneToOneMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertEquals((String)"address", (String)ormOneToOneMapping.getName());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedFetch());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedOptional());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertNull((Object)ormOneToOneMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        OrmOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormOneToOneMapping.getFetch());
        OrmOneToOneMappingTests.assertEquals((boolean)true, (boolean)ormOneToOneMapping.isOptional());
        OrmOneToOneMappingTests.assertTrue((ormOneToOneMapping.getRelationship().getJoinColumnStrategy().joinColumnsSize() > 0 ? 1 : 0) != 0);
        OrmCascade cascade = ormOneToOneMapping.getCascade();
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isAll());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isMerge());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isPersist());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isRemove());
        OrmOneToOneMappingTests.assertFalse((boolean)cascade.isRefresh());
    }

    public void testOneToOneMorphToIdMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOne");
        OneToOneMapping oneToOneMapping = (OneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        oneToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToOneMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToOneMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("mappedBy");
        oneToOneMapping.getCascade().setAll(true);
        oneToOneMapping.getCascade().setMerge(true);
        oneToOneMapping.getCascade().setPersist(true);
        oneToOneMapping.getCascade().setRefresh(true);
        oneToOneMapping.getCascade().setRemove(true);
        JoinColumn joinColumn = oneToOneMapping.getRelationship().getJoinColumnStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        ormPersistentAttribute.setMappingKey("id");
        OrmOneToOneMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToOneMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToOneMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof IdMapping));
        OrmOneToOneMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToOneMorphToVersionMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOne");
        OneToOneMapping oneToOneMapping = (OneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        oneToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToOneMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToOneMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("mappedBy");
        oneToOneMapping.getCascade().setAll(true);
        oneToOneMapping.getCascade().setMerge(true);
        oneToOneMapping.getCascade().setPersist(true);
        oneToOneMapping.getCascade().setRefresh(true);
        oneToOneMapping.getCascade().setRemove(true);
        JoinColumn joinColumn = oneToOneMapping.getRelationship().getJoinColumnStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        ormPersistentAttribute.setMappingKey("version");
        OrmOneToOneMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToOneMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToOneMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof VersionMapping));
        OrmOneToOneMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToOneMorphToTransientMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOne");
        OneToOneMapping oneToOneMapping = (OneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        oneToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToOneMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToOneMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("mappedBy");
        oneToOneMapping.getCascade().setAll(true);
        oneToOneMapping.getCascade().setMerge(true);
        oneToOneMapping.getCascade().setPersist(true);
        oneToOneMapping.getCascade().setRefresh(true);
        oneToOneMapping.getCascade().setRemove(true);
        JoinColumn joinColumn = oneToOneMapping.getRelationship().getJoinColumnStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        ormPersistentAttribute.setMappingKey("transient");
        OrmOneToOneMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToOneMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToOneMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        OrmOneToOneMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToOneMorphToEmbeddedMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOne");
        OneToOneMapping oneToOneMapping = (OneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        oneToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToOneMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToOneMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("mappedBy");
        oneToOneMapping.getCascade().setAll(true);
        oneToOneMapping.getCascade().setMerge(true);
        oneToOneMapping.getCascade().setPersist(true);
        oneToOneMapping.getCascade().setRefresh(true);
        oneToOneMapping.getCascade().setRemove(true);
        JoinColumn joinColumn = oneToOneMapping.getRelationship().getJoinColumnStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        ormPersistentAttribute.setMappingKey("embedded");
        OrmOneToOneMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToOneMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToOneMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedMapping));
        OrmOneToOneMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToOneMorphToEmbeddedIdMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOne");
        OneToOneMapping oneToOneMapping = (OneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        oneToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToOneMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToOneMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("mappedBy");
        oneToOneMapping.getCascade().setAll(true);
        oneToOneMapping.getCascade().setMerge(true);
        oneToOneMapping.getCascade().setPersist(true);
        oneToOneMapping.getCascade().setRefresh(true);
        oneToOneMapping.getCascade().setRemove(true);
        JoinColumn joinColumn = oneToOneMapping.getRelationship().getJoinColumnStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        ormPersistentAttribute.setMappingKey("embeddedId");
        OrmOneToOneMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToOneMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToOneMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        OrmOneToOneMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testOneToOneMorphToManyToManyMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOne");
        OneToOneMapping oneToOneMapping = (OneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        oneToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToOneMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToOneMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("mappedBy");
        oneToOneMapping.getCascade().setAll(true);
        oneToOneMapping.getCascade().setMerge(true);
        oneToOneMapping.getCascade().setPersist(true);
        oneToOneMapping.getCascade().setRefresh(true);
        oneToOneMapping.getCascade().setRemove(true);
        JoinColumn joinColumn = oneToOneMapping.getRelationship().getJoinColumnStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToMany");
        OrmOneToOneMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToOneMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToOneMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToManyMapping));
        OrmOneToOneMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
        OrmOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmOneToOneMappingTests.assertEquals((String)"TargetEntity", (String)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertEquals((String)"mappedBy", (String)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getRelationship().getMappedByStrategy().getMappedByAttribute());
        OrmOneToOneMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmOneToOneMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmOneToOneMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmOneToOneMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmOneToOneMappingTests.assertTrue((boolean)((ManyToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
    }

    public void testOneToOneMorphToOneToManyMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOne");
        OneToOneMapping oneToOneMapping = (OneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        oneToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToOneMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToOneMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("mappedBy");
        oneToOneMapping.getCascade().setAll(true);
        oneToOneMapping.getCascade().setMerge(true);
        oneToOneMapping.getCascade().setPersist(true);
        oneToOneMapping.getCascade().setRefresh(true);
        oneToOneMapping.getCascade().setRemove(true);
        JoinColumn joinColumn = oneToOneMapping.getRelationship().getJoinColumnStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        ormPersistentAttribute.setMappingKey("oneToMany");
        OrmOneToOneMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToOneMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToOneMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToManyMapping));
        OrmOneToOneMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
        OrmOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((OneToManyMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmOneToOneMappingTests.assertEquals((String)"TargetEntity", (String)((OneToManyMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertEquals((String)"mappedBy", (String)((OneToManyMapping)ormPersistentAttribute.getMapping()).getRelationship().getMappedByStrategy().getMappedByAttribute());
        OrmOneToOneMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmOneToOneMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmOneToOneMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmOneToOneMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmOneToOneMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
    }

    public void testOneToOneMorphToManyToOneMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOne");
        OneToOneMapping oneToOneMapping = (OneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        oneToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToOneMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToOneMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("mappedBy");
        oneToOneMapping.getCascade().setAll(true);
        oneToOneMapping.getCascade().setMerge(true);
        oneToOneMapping.getCascade().setPersist(true);
        oneToOneMapping.getCascade().setRefresh(true);
        oneToOneMapping.getCascade().setRemove(true);
        JoinColumn joinColumn = oneToOneMapping.getRelationship().getJoinColumnStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        ormPersistentAttribute.setMappingKey("manyToOne");
        OrmOneToOneMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToOneMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToOneMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        OrmOneToOneMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
        OrmOneToOneMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmOneToOneMappingTests.assertEquals((String)"TargetEntity", (String)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmOneToOneMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmOneToOneMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmOneToOneMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmOneToOneMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmOneToOneMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
        joinColumn = (JoinColumn)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getRelationship().getJoinColumnStrategy().specifiedJoinColumns().next();
        OrmOneToOneMappingTests.assertEquals((String)"name", (String)joinColumn.getName());
        OrmOneToOneMappingTests.assertEquals((String)"referenceName", (String)joinColumn.getReferencedColumnName());
    }

    public void testOneToOneMorphToBasicMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOne");
        OneToOneMapping oneToOneMapping = (OneToOneMapping)ormPersistentAttribute.getMapping();
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        oneToOneMapping.setSpecifiedFetch(FetchType.EAGER);
        oneToOneMapping.setSpecifiedTargetEntity("TargetEntity");
        oneToOneMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("mappedBy");
        oneToOneMapping.getCascade().setAll(true);
        oneToOneMapping.getCascade().setMerge(true);
        oneToOneMapping.getCascade().setPersist(true);
        oneToOneMapping.getCascade().setRefresh(true);
        oneToOneMapping.getCascade().setRemove(true);
        JoinColumn joinColumn = oneToOneMapping.getRelationship().getJoinColumnStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        OrmOneToOneMappingTests.assertFalse((boolean)oneToOneMapping.isDefault());
        ormPersistentAttribute.setMappingKey("basic");
        OrmOneToOneMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmOneToOneMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmOneToOneMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof BasicMapping));
        OrmOneToOneMappingTests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testAddPrimaryKeyJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmPrimaryKeyJoinColumnRelationshipStrategy strategy = ormOneToOneMapping.getRelationship().getPrimaryKeyJoinColumnStrategy();
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        OrmPrimaryKeyJoinColumn joinColumn = strategy.addPrimaryKeyJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmPrimaryKeyJoinColumn joinColumn2 = strategy.addPrimaryKeyJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(1)).getName());
        OrmPrimaryKeyJoinColumn joinColumn3 = strategy.addPrimaryKeyJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(1)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(2)).getName());
        ListIterator joinColumns = strategy.primaryKeyJoinColumns();
        OrmOneToOneMappingTests.assertEquals((Object)joinColumn2, joinColumns.next());
        OrmOneToOneMappingTests.assertEquals((Object)joinColumn3, joinColumns.next());
        OrmOneToOneMappingTests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = strategy.primaryKeyJoinColumns();
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((OrmPrimaryKeyJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((OrmPrimaryKeyJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((OrmPrimaryKeyJoinColumn)joinColumns.next()).getName());
    }

    public void testRemovePrimaryKeyJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmPrimaryKeyJoinColumnRelationshipStrategy strategy = ormOneToOneMapping.getRelationship().getPrimaryKeyJoinColumnStrategy();
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        strategy.addPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        strategy.addPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        strategy.addPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        OrmOneToOneMappingTests.assertEquals((int)3, (int)oneToOneResource.getPrimaryKeyJoinColumns().size());
        strategy.removePrimaryKeyJoinColumn(0);
        OrmOneToOneMappingTests.assertEquals((int)2, (int)oneToOneResource.getPrimaryKeyJoinColumns().size());
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(1)).getName());
        strategy.removePrimaryKeyJoinColumn(0);
        OrmOneToOneMappingTests.assertEquals((int)1, (int)oneToOneResource.getPrimaryKeyJoinColumns().size());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(0)).getName());
        strategy.removePrimaryKeyJoinColumn(0);
        OrmOneToOneMappingTests.assertEquals((int)0, (int)oneToOneResource.getPrimaryKeyJoinColumns().size());
    }

    public void testMovePrimaryKeyJoinColumn() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("oneToOne", "oneToOneMapping");
        OrmOneToOneMapping ormOneToOneMapping = (OrmOneToOneMapping)ormPersistentAttribute.getMapping();
        OrmPrimaryKeyJoinColumnRelationshipStrategy strategy = ormOneToOneMapping.getRelationship().getPrimaryKeyJoinColumnStrategy();
        XmlOneToOne oneToOneResource = (XmlOneToOne)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getOneToOnes().get(0);
        strategy.addPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        strategy.addPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        strategy.addPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        OrmOneToOneMappingTests.assertEquals((int)3, (int)oneToOneResource.getPrimaryKeyJoinColumns().size());
        strategy.movePrimaryKeyJoinColumn(2, 0);
        ListIterator joinColumns = strategy.primaryKeyJoinColumns();
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((OrmPrimaryKeyJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((OrmPrimaryKeyJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((OrmPrimaryKeyJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(1)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(2)).getName());
        strategy.movePrimaryKeyJoinColumn(0, 1);
        joinColumns = strategy.primaryKeyJoinColumns();
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((OrmPrimaryKeyJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((OrmPrimaryKeyJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((OrmPrimaryKeyJoinColumn)joinColumns.next()).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAZ", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"BAR", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(1)).getName());
        OrmOneToOneMappingTests.assertEquals((String)"FOO", (String)((XmlPrimaryKeyJoinColumn)oneToOneResource.getPrimaryKeyJoinColumns().get(2)).getName());
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ormPersistentType.addSpecifiedAttribute("oneToOne", "address");
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        ReadOnlyPersistentAttribute persistentAttribute = (ReadOnlyPersistentAttribute)ormPersistentType.attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().candidateMappedByAttributeNames();
        OrmOneToOneMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        OrmOneToOneMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        OrmOneToOneMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        OrmOneToOneMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        OrmOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().candidateMappedByAttributeNames();
        OrmOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToOneMapping.getRelationship().getMappedByStrategy().candidateMappedByAttributeNames();
        OrmOneToOneMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        OrmOneToOneMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        OrmOneToOneMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        OrmOneToOneMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        OrmOneToOneMappingTests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToOneMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        OrmOneToOneMappingTests.assertNull((Object)stateFooMapping);
    }
}

