/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinColumnRelationship;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.ReadOnlyAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToManyMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OneToManyRelationship2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.OrderColumn2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOneToManyMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOrphanRemovable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaOrphanRemovalHolder2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyClass2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyColumn2_0Annotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.OneToMany2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.MapKeyAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.OneToManyAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericJavaOneToManyMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    public GenericJavaOneToManyMapping2_0Tests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityWithValidOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id", "java.util.Collection"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidOneToManyMappingOrphanRemovalSpecified() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id", "java.util.Collection"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany(orphanRemoval=false)").append(CR);
                sb.append("    private Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidGenericMapOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map<Integer, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToOne");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne").append(CR);
                sb.append("    private AnnotationTestType employee;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestTargetEntityAddressWithElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<State> state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String foo;").append(CR);
                sb.append(CR);
                sb.append("    private String address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithEmbeddableKeyOneToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Map<Address, PropertyInfo> parcels;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEntityPropertyInfo() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PropertyInfo").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private Integer parcelNumber;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private Integer size;").append(CR);
                sb.append(CR);
                sb.append("    private java.math.BigDecimal tax;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PropertyInfo.java", sourceWriter);
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().candidateMappedByAttributeNames();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"employee", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().candidateMappedByAttributeNames();
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().candidateMappedByAttributeNames();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"employee", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    public void testCandidateMappedByAttributeNamesElementCollection() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.createTestTargetEntityAddressWithElementCollection();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().candidateMappedByAttributeNames();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().candidateMappedByAttributeNames();
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToManyMapping.getRelationship().getMappedByStrategy().candidateMappedByAttributeNames();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    private JavaOrphanRemovable2_0 getOrphanRemovalOf(OneToManyMapping2_0 oneToManyMapping) {
        return ((JavaOrphanRemovalHolder2_0)oneToManyMapping).getOrphanRemoval();
    }

    public void testDefaultOneToManyGetDefaultOrphanRemoval() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)this.getOrphanRemovalOf(oneToManyMapping).isDefaultOrphanRemoval());
    }

    public void testSpecifiedOneToManyGetDefaultOrphanRemoval() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)this.getOrphanRemovalOf(oneToManyMapping).isDefaultOrphanRemoval());
    }

    public void testGetOrphanRemoval() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToManyMapping);
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)mappingsOrphanRemoval.isOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)mappingsOrphanRemoval.isOrphanRemoval());
    }

    public void testGetSpecifiedOrphanRemoval() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToManyMapping);
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToMany2_0Annotation oneToMany = (OneToMany2_0Annotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        oneToMany.setOrphanRemoval(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
    }

    public void testGetSpecifiedOrphanRemoval2() throws Exception {
        this.createTestEntityWithValidOneToManyMappingOrphanRemovalSpecified();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToManyMapping);
        GenericJavaOneToManyMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
    }

    public void testSetSpecifiedOrphanRemoval() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToManyMapping);
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToMany2_0Annotation oneToMany = (OneToMany2_0Annotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)oneToMany.getOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(null);
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.OneToMany"));
    }

    public void testSetSpecifiedOrphanRemoval2() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToManyMapping);
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToMany2_0Annotation oneToMany = (OneToMany2_0Annotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)oneToMany.getOrphanRemoval());
        oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(null);
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.OneToMany"));
        oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
    }

    public void testGetSpecifiedOrphanRemovalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToManyMapping);
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToMany2_0Annotation oneToMany = (OneToMany2_0Annotation)attributeResource.getAnnotation("javax.persistence.OneToMany");
        oneToMany.setOrphanRemoval(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        oneToMany.setOrphanRemoval(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        GenericJavaOneToManyMapping2_0Tests.assertSame((Object)oneToManyMapping, (Object)persistentAttribute.getMapping());
        oneToMany.setOrphanRemoval(Boolean.FALSE);
        attributeResource.setPrimaryAnnotation(null, EmptyIterable.instance());
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
    }

    public void testUpdateMapKey() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
        attributeResource.addAnnotation("javax.persistence.MapKey");
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        MapKeyAnnotation mapKey = (MapKeyAnnotation)attributeResource.getAnnotation("javax.persistence.MapKey");
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)mapKey);
        mapKey.setName("myMapKey");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)oneToManyMapping.getSpecifiedMapKey());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)mapKey.getName());
        mapKey.setName(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)mapKey.getName());
        mapKey.setName("myMapKey");
        attributeResource.removeAnnotation("javax.persistence.MapKey");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
    }

    public void testModifyMapKey() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKey"));
        oneToManyMapping.setSpecifiedMapKey("myMapKey");
        MapKeyAnnotation mapKeyAnnotation = (MapKeyAnnotation)attributeResource.getAnnotation("javax.persistence.MapKey");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)oneToManyMapping.getSpecifiedMapKey());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)mapKeyAnnotation.getName());
        oneToManyMapping.setSpecifiedMapKey(null);
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKey());
        mapKeyAnnotation = (MapKeyAnnotation)attributeResource.getAnnotation("javax.persistence.MapKey");
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)mapKeyAnnotation.getName());
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 oneToManyMapping2_0 = (OneToManyMapping2_0)persistentAttribute.getMapping();
        Iterator mapKeyNames = oneToManyMapping2_0.candidateMapKeyNames();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"employee", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 oneToManyMapping2_0 = (OneToManyMapping2_0)persistentAttribute.getMapping();
        Iterator mapKeyNames = oneToManyMapping2_0.candidateMapKeyNames();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        oneToManyMapping2_0.setSpecifiedTargetEntity("Address");
        mapKeyNames = oneToManyMapping2_0.candidateMapKeyNames();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"employee", (String)((String)mapKeyNames.next()));
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)mapKeyNames.hasNext());
        oneToManyMapping2_0.setSpecifiedTargetEntity("String");
        mapKeyNames = oneToManyMapping2_0.candidateMapKeyNames();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
    }

    public void testUpdateMapKeyClass() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKeyClass"));
        attributeResource.addAnnotation("javax.persistence.MapKeyClass");
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKeyClass());
        MapKeyClass2_0Annotation mapKeyClassAnnotation = (MapKeyClass2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyClass");
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)mapKeyClassAnnotation);
        mapKeyClassAnnotation.setValue("myMapKeyClass");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"myMapKeyClass", (String)oneToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"myMapKeyClass", (String)mapKeyClassAnnotation.getValue());
        mapKeyClassAnnotation.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)mapKeyClassAnnotation.getValue());
        mapKeyClassAnnotation.setValue("myMapKeyClass");
        attributeResource.removeAnnotation("javax.persistence.MapKeyClass");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKeyClass"));
    }

    public void testModifyMapKeyClass() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKeyClass"));
        oneToManyMapping.setSpecifiedMapKeyClass("String");
        MapKeyClass2_0Annotation mapKeyClass = (MapKeyClass2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapKeyClass");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"String", (String)oneToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"String", (String)mapKeyClass.getValue());
        oneToManyMapping.setSpecifiedMapKeyClass(null);
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getSpecifiedMapKeyClass());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.MapKeyClass"));
    }

    public void testDefaultMapKeyClass() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"java.lang.Integer", (String)oneToManyMapping.getDefaultMapKeyClass());
        oneToManyMapping.setSpecifiedMapKeyClass("foo");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"java.lang.Integer", (String)oneToManyMapping.getDefaultMapKeyClass());
    }

    public void testDefaultMapKeyClassCollectionType() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getDefaultMapKeyClass());
    }

    public void testMapKeyClass() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"java.lang.Integer", (String)oneToManyMapping.getMapKeyClass());
        oneToManyMapping.setSpecifiedMapKeyClass("foo");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyClass());
        oneToManyMapping.setSpecifiedMapKeyClass(null);
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"java.lang.Integer", (String)oneToManyMapping.getMapKeyClass());
    }

    public void testOrderColumnDefaults() throws Exception {
        this.createTestEntityPrintQueue();
        this.createTestEntityPrintJob();
        this.addXmlClassRef("test.PrintQueue");
        this.addXmlClassRef("test.PrintJob");
        OneToManyMapping oneToManyMapping = (OneToManyMapping)this.getJavaPersistentType().getAttributeNamed("jobs").getMapping();
        Orderable2_0 orderable = (Orderable2_0)oneToManyMapping.getOrderable();
        OrderColumn2_0 orderColumn = orderable.getOrderColumn();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)orderable.isOrderColumnOrdering());
        GenericJavaOneToManyMapping2_0Tests.assertEquals(null, (String)orderColumn.getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"jobs_ORDER", (String)orderColumn.getDefaultName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"PrintJob", (String)orderColumn.getTable());
        orderColumn.setSpecifiedName("FOO");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)orderColumn.getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"jobs_ORDER", (String)orderColumn.getDefaultName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"PrintJob", (String)orderColumn.getTable());
        JavaPersistentType printJobPersistentType = (JavaPersistentType)this.getPersistenceUnit().getPersistentType("test.PrintJob");
        ((Entity)printJobPersistentType.getMapping()).getTable().setSpecifiedName("MY_TABLE");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"MY_TABLE", (String)orderColumn.getTable());
    }

    private void createTestEntityPrintQueue() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OneToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OrderColumn");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintQueue").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany(mappedBy=\"queue\")").append(CR);
                sb.append("    @OrderColumn").append(CR);
                sb.append("    private java.util.List<PrintJob> jobs;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PrintQueue.java", sourceWriter);
    }

    private void createTestEntityPrintJob() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToOne");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintJob").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToOne").append(CR);
                sb.append("    private PrintQueue queue;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "PrintJob.java", sourceWriter);
    }

    public void testGetMapKeyColumnMappedByStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        oneToManyMapping.getRelationship().setStrategyToMappedBy();
        oneToManyMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("employee");
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"Address", (String)oneToManyMapping.getMapKeyColumn().getTable());
        Entity addressEntity = this.getPersistenceUnit().getEntity("test.Address");
        addressEntity.getTable().setSpecifiedName("MY_PRIMARY_TABLE");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"MY_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getTable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getDefaultName());
    }

    public void testGetMapKeyColumnJoinTableStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)oneToManyMapping.getMapKeyColumn().getTable());
        oneToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("MY_PRIMARY_TABLE");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"MY_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getTable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getDefaultName());
    }

    public void testTargetForeignKeyJoinColumnStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        ((JoinColumnRelationship)oneToManyMapping.getRelationship()).setStrategyToJoinColumn();
        JoinColumn joinColumn = (JoinColumn)((JoinColumnRelationship)oneToManyMapping.getRelationship()).getJoinColumnStrategy().specifiedJoinColumns().next();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"addresses_id", (String)joinColumn.getDefaultName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"Address", (String)joinColumn.getDefaultTable());
        Entity addressEntity = this.getPersistenceUnit().getEntity("test.Address");
        addressEntity.getTable().setSpecifiedName("ADDRESS_PRIMARY_TABLE");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)joinColumn.getDefaultTable());
        joinColumn.setSpecifiedName("FOO");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"addresses_id", (String)joinColumn.getDefaultName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)joinColumn.getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)joinColumn.getDefaultTable());
    }

    public void testGetMapKeyColumnJoinColumnStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        ((JoinColumnRelationship)oneToManyMapping.getRelationship()).setStrategyToJoinColumn();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"Address", (String)oneToManyMapping.getMapKeyColumn().getTable());
        Entity addressEntity = this.getPersistenceUnit().getEntity("test.Address");
        addressEntity.getTable().setSpecifiedName("ADDRESS_PRIMARY_TABLE");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getTable());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        MapKeyColumn2_0Annotation column = (MapKeyColumn2_0Annotation)attributeResource.addAnnotation("javax.persistence.MapKeyColumn");
        column.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"foo", (String)oneToManyMapping.getMapKeyColumn().getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)oneToManyMapping.getMapKeyColumn().getDefaultName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)oneToManyMapping.getMapKeyColumn().getDefaultTable());
    }

    public void testOrderColumnDefaultsJoinColumnStrategy() throws Exception {
        this.createTestEntityWithValidGenericMapOneToManyMapping();
        this.createTestTargetEntityAddress();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 oneToManyMapping = (OneToManyMapping2_0)persistentAttribute.getMapping();
        ((JoinColumnRelationship)oneToManyMapping.getRelationship()).setStrategyToJoinColumn();
        ((Orderable2_0)oneToManyMapping.getOrderable()).setOrderColumnOrdering(true);
        OrderColumn2_0 orderColumn = ((Orderable2_0)oneToManyMapping.getOrderable()).getOrderColumn();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)orderColumn.getSpecifiedName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"addresses_ORDER", (String)orderColumn.getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"Address", (String)orderColumn.getTable());
        Entity addressEntity = this.getPersistenceUnit().getEntity("test.Address");
        addressEntity.getTable().setSpecifiedName("ADDRESS_PRIMARY_TABLE");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"ADDRESS_PRIMARY_TABLE", (String)orderColumn.getTable());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)resourceAttribute.getAnnotation("javax.persistence.OneToMany");
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 mapping = (OneToManyMapping2_0)contextAttribute.getMapping();
        OneToManyRelationship2_0 rel = (OneToManyRelationship2_0)mapping.getRelationship();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinColumn();
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToMappedBy();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)annotation.getMappedBy());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        rel.setStrategyToJoinTable();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithValidOneToManyMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        OneToManyAnnotation annotation = (OneToManyAnnotation)resourceAttribute.getAnnotation("javax.persistence.OneToMany");
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToManyMapping2_0 mapping = (OneToManyMapping2_0)contextAttribute.getMapping();
        OneToManyRelationship2_0 rel = (OneToManyRelationship2_0)mapping.getRelationship();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        annotation.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)annotation.getMappedBy());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceAttribute.addAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)annotation.getMappedBy());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        resourceAttribute.addAnnotation("javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)annotation.getMappedBy());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsMappedBy());
        annotation.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceAttribute.removeAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinTable());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
        resourceAttribute.removeAnnotation("javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsJoinColumn());
        GenericJavaOneToManyMapping2_0Tests.assertTrue((boolean)rel.strategyIsJoinTable());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)rel.strategyIsMappedBy());
    }

    public void testMapKeySpecifiedAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddableKeyOneToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        this.addXmlClassRef("test.PropertyInfo");
        JavaOneToManyMapping2_0 oneToManyMapping = (JavaOneToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = oneToManyMapping.getMapKeyAttributeOverrideContainer();
        ListIterator specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedOverrides();
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedOverrides();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("value.BAR");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedOverrides();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.BAZ");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedOverrides();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.BLAH");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedOverrides();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeResource.moveAnnotation(1, 0, "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedOverrides();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedOverrides();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(1, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedOverrides();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BLAH", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedOverrides();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"value.BAR", (String)((JavaAttributeOverride)specifiedMapKeyAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
        attributeResource.removeAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        specifiedMapKeyAttributeOverrides = mapKeyAttributeOverrideContainer.specifiedOverrides();
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedMapKeyAttributeOverrides.hasNext());
    }

    public void testMapKeyValueVirtualAttributeOverrides() throws Exception {
        this.createTestEntityWithEmbeddableKeyOneToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaOneToManyMapping2_0 oneToManyMapping = (JavaOneToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = oneToManyMapping.getMapKeyAttributeOverrideContainer();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"parcels", (String)attributeResource.getName());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.virtualOverridesSize());
        ReadOnlyAttributeOverride defaultAttributeOverride = (ReadOnlyAttributeOverride)mapKeyAttributeOverrideContainer.virtualOverrides().next();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_PropertyInfo", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        Embeddable addressEmbeddable = (Embeddable)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        BasicMapping cityMapping = (BasicMapping)addressEmbeddable.getPersistentType().getAttributeNamed("city").getMapping();
        cityMapping.getColumn().setSpecifiedName("FOO");
        cityMapping.getColumn().setSpecifiedTable("BAR");
        cityMapping.getColumn().setColumnDefinition("COLUMN_DEF");
        cityMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        cityMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        cityMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        cityMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        cityMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"parcels", (String)attributeResource.getName());
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverride"));
        GenericJavaOneToManyMapping2_0Tests.assertNull((Object)attributeResource.getAnnotation("javax.persistence.AttributeOverrides"));
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.virtualOverridesSize());
        defaultAttributeOverride = (ReadOnlyAttributeOverride)mapKeyAttributeOverrideContainer.virtualOverrides().next();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"FOO", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"BAR", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"COLUMN_DEF", (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)5, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)6, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)7, (int)defaultAttributeOverride.getColumn().getScale());
        cityMapping.getColumn().setSpecifiedName(null);
        cityMapping.getColumn().setSpecifiedTable(null);
        cityMapping.getColumn().setColumnDefinition(null);
        cityMapping.getColumn().setSpecifiedInsertable(null);
        cityMapping.getColumn().setSpecifiedUpdatable(null);
        cityMapping.getColumn().setSpecifiedUnique(null);
        cityMapping.getColumn().setSpecifiedNullable(null);
        cityMapping.getColumn().setSpecifiedLength(null);
        cityMapping.getColumn().setSpecifiedPrecision(null);
        cityMapping.getColumn().setSpecifiedScale(null);
        defaultAttributeOverride = (ReadOnlyAttributeOverride)mapKeyAttributeOverrideContainer.virtualOverrides().next();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)defaultAttributeOverride.getColumn().getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_PropertyInfo", (String)defaultAttributeOverride.getColumn().getTable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals(null, (String)defaultAttributeOverride.getColumn().getColumnDefinition());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isInsertable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isUpdatable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)defaultAttributeOverride.getColumn().isUnique());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)defaultAttributeOverride.getColumn().isNullable());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)255, (int)defaultAttributeOverride.getColumn().getLength());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getPrecision());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)0, (int)defaultAttributeOverride.getColumn().getScale());
        AttributeOverrideAnnotation annotation = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        annotation.setName("key.city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.virtualOverridesSize());
    }

    public void testMapKeyValueSpecifiedAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyOneToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaOneToManyMapping2_0 oneToManyMapping = (JavaOneToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = oneToManyMapping.getMapKeyAttributeOverrideContainer();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)0, (int)mapKeyAttributeOverrideContainer.specifiedOverridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.BAR");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("value.FOO2");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.specifiedOverridesSize());
    }

    public void testMapKeyValueAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyOneToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaOneToManyMapping2_0 oneToManyMapping = (JavaOneToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = oneToManyMapping.getMapKeyAttributeOverrideContainer();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.overridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.BAR");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("value.FOO2");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)7, (int)mapKeyAttributeOverrideContainer.overridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)7, (int)mapKeyAttributeOverrideContainer.overridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.state.foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)7, (int)mapKeyAttributeOverrideContainer.overridesSize());
    }

    public void testMapKeyValueVirtualAttributeOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddableKeyOneToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaOneToManyMapping2_0 oneToManyMapping = (JavaOneToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = oneToManyMapping.getMapKeyAttributeOverrideContainer();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.virtualOverridesSize());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        AttributeOverrideAnnotation attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("FOO");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.BAR");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.virtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.city");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)3, (int)mapKeyAttributeOverrideContainer.virtualOverridesSize());
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("key.state.foo");
        attributeOverride = (AttributeOverrideAnnotation)attributeResource.addAnnotation(0, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.setName("size");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)2, (int)mapKeyAttributeOverrideContainer.virtualOverridesSize());
    }

    public void testMapKeyValueAttributeOverrideSetVirtual() throws Exception {
        this.createTestEntityWithEmbeddableKeyOneToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaOneToManyMapping2_0 oneToManyMapping = (JavaOneToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = oneToManyMapping.getMapKeyAttributeOverrideContainer();
        ((JavaVirtualAttributeOverride)mapKeyAttributeOverrideContainer.virtualOverrides().next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)mapKeyAttributeOverrideContainer.virtualOverrides().next()).convertToSpecified();
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        Iterator attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"key.city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"key.state.foo", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        ((JavaAttributeOverride)mapKeyAttributeOverrideContainer.specifiedOverrides().next()).convertToVirtual();
        attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"key.state.foo", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        ((JavaAttributeOverride)mapKeyAttributeOverrideContainer.specifiedOverrides().next()).convertToVirtual();
        attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        ListIterator virtualAttributeOverrides = mapKeyAttributeOverrideContainer.virtualOverrides();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"zip", (String)((JavaVirtualAttributeOverride)virtualAttributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((int)4, (int)mapKeyAttributeOverrideContainer.virtualOverridesSize());
    }

    public void testMapKeyValueMoveSpecifiedAttributeOverride() throws Exception {
        this.createTestEntityWithEmbeddableKeyOneToManyMapping();
        this.createTestEmbeddableAddress();
        this.createTestEmbeddableState();
        this.createTestEntityPropertyInfo();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.PropertyInfo");
        this.addXmlClassRef("test.State");
        JavaOneToManyMapping2_0 oneToManyMapping = (JavaOneToManyMapping2_0)this.getJavaPersistentType().getAttributeNamed("parcels").getMapping();
        JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer = oneToManyMapping.getMapKeyAttributeOverrideContainer();
        ((JavaVirtualAttributeOverride)mapKeyAttributeOverrideContainer.virtualOverrides().next()).convertToSpecified();
        ((JavaVirtualAttributeOverride)mapKeyAttributeOverrideContainer.virtualOverrides().next()).convertToSpecified();
        ListIterator specifiedOverrides = mapKeyAttributeOverrideContainer.specifiedOverrides();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((JavaAttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((JavaAttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedOverrides.hasNext());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        attributeResource.moveAnnotation(1, 0, "javax.persistence.AttributeOverrides");
        this.getJpaProject().synchronizeContextModel();
        Iterator attributeOverrides = attributeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"key.state.foo", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"key.city", (String)((AttributeOverrideAnnotation)attributeOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        specifiedOverrides = mapKeyAttributeOverrideContainer.specifiedOverrides();
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((JavaAttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertEquals((String)"city", (String)((JavaAttributeOverride)specifiedOverrides.next()).getName());
        GenericJavaOneToManyMapping2_0Tests.assertFalse((boolean)specifiedOverrides.hasNext());
    }
}

