/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.jpa2.context.SequenceGenerator2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.SequenceGenerator2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericJavaSequenceGenerator2_0Tests
extends Generic2_0ContextModelTestCase {
    private static final String SEQUENCE_GENERATOR_NAME = "TEST_SEQUENCE_GENERATOR";

    public GenericJavaSequenceGenerator2_0Tests(String name) {
        super(name);
    }

    public void testGetCatalog() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        SequenceGenerator2_0 sequenceGenerator = (SequenceGenerator2_0)idMapping.getGeneratorContainer().getSequenceGenerator();
        GenericJavaSequenceGenerator2_0Tests.assertNull((Object)sequenceGenerator.getCatalog());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        SequenceGenerator2_0Annotation annotation = (SequenceGenerator2_0Annotation)attributeResource.getAnnotation("javax.persistence.SequenceGenerator");
        annotation.setCatalog("testCatalog");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaSequenceGenerator2_0Tests.assertEquals((String)"testCatalog", (String)sequenceGenerator.getCatalog());
        GenericJavaSequenceGenerator2_0Tests.assertEquals((String)"testCatalog", (String)sequenceGenerator.getSpecifiedCatalog());
    }

    public void testGetDefaultCatalog() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        SequenceGenerator2_0 sequenceGenerator = (SequenceGenerator2_0)idMapping.getGeneratorContainer().getSequenceGenerator();
        GenericJavaSequenceGenerator2_0Tests.assertNull((Object)sequenceGenerator.getDefaultCatalog());
        sequenceGenerator.setSpecifiedCatalog("testCatalog");
        GenericJavaSequenceGenerator2_0Tests.assertNull((Object)sequenceGenerator.getDefaultCatalog());
        GenericJavaSequenceGenerator2_0Tests.assertEquals((String)"testCatalog", (String)sequenceGenerator.getSpecifiedCatalog());
    }

    public void testSetSpecifiedCatalog() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        SequenceGenerator2_0 sequenceGenerator = (SequenceGenerator2_0)idMapping.getGeneratorContainer().getSequenceGenerator();
        sequenceGenerator.setSpecifiedCatalog("testCatalog");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        SequenceGenerator2_0Annotation annotation = (SequenceGenerator2_0Annotation)attributeResource.getAnnotation("javax.persistence.SequenceGenerator");
        GenericJavaSequenceGenerator2_0Tests.assertEquals((String)"testCatalog", (String)annotation.getCatalog());
        sequenceGenerator.setSpecifiedCatalog(null);
        GenericJavaSequenceGenerator2_0Tests.assertNull((Object)annotation.getCatalog());
    }

    public void testGetSchema() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        SequenceGenerator2_0 sequenceGenerator = (SequenceGenerator2_0)idMapping.getGeneratorContainer().getSequenceGenerator();
        GenericJavaSequenceGenerator2_0Tests.assertNull((Object)sequenceGenerator.getSchema());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        SequenceGenerator2_0Annotation annotation = (SequenceGenerator2_0Annotation)attributeResource.getAnnotation("javax.persistence.SequenceGenerator");
        annotation.setSchema("testSchema");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaSequenceGenerator2_0Tests.assertEquals((String)"testSchema", (String)sequenceGenerator.getSchema());
        GenericJavaSequenceGenerator2_0Tests.assertEquals((String)"testSchema", (String)sequenceGenerator.getSpecifiedSchema());
    }

    public void testGetDefaultSchema() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        SequenceGenerator2_0 sequenceGenerator = (SequenceGenerator2_0)idMapping.getGeneratorContainer().getSequenceGenerator();
        GenericJavaSequenceGenerator2_0Tests.assertNull((Object)sequenceGenerator.getDefaultSchema());
        sequenceGenerator.setSpecifiedSchema("testSchema");
        GenericJavaSequenceGenerator2_0Tests.assertNull((Object)sequenceGenerator.getDefaultSchema());
        GenericJavaSequenceGenerator2_0Tests.assertEquals((String)"testSchema", (String)sequenceGenerator.getSpecifiedSchema());
    }

    public void testUpdateDefaultSchemaFromPersistenceUnitDefaults() throws Exception {
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.createTestEntityWithSequenceGenerator();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        IdMapping idMapping = (IdMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        SequenceGenerator2_0 sequenceGenerator = (SequenceGenerator2_0)idMapping.getGeneratorContainer().getSequenceGenerator();
        GenericJavaSequenceGenerator2_0Tests.assertNull((Object)sequenceGenerator.getDefaultSchema());
        this.getEntityMappings().getPersistenceUnitMetadata().getPersistenceUnitDefaults().setSpecifiedSchema("FOO");
        GenericJavaSequenceGenerator2_0Tests.assertEquals((String)"FOO", (String)sequenceGenerator.getDefaultSchema());
        this.getEntityMappings().setSpecifiedSchema("BAR");
        GenericJavaSequenceGenerator2_0Tests.assertEquals((String)"BAR", (String)sequenceGenerator.getDefaultSchema());
        ormEntity.getTable().setSpecifiedSchema("XML_SCHEMA");
        GenericJavaSequenceGenerator2_0Tests.assertEquals((String)"BAR", (String)sequenceGenerator.getDefaultSchema());
        this.getEntityMappings().removePersistentType(0);
        this.addXmlClassRef("test.AnnotationTestType");
        idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        sequenceGenerator = (SequenceGenerator2_0)idMapping.getGeneratorContainer().getSequenceGenerator();
        GenericJavaSequenceGenerator2_0Tests.assertEquals((String)"FOO", (String)sequenceGenerator.getDefaultSchema());
    }

    public void testSetSpecifiedSchema() throws Exception {
        this.createTestEntityWithSequenceGenerator();
        this.addXmlClassRef("test.AnnotationTestType");
        IdMapping idMapping = (IdMapping)this.getJavaPersistentType().getAttributeNamed("id").getMapping();
        SequenceGenerator2_0 sequenceGenerator = (SequenceGenerator2_0)idMapping.getGeneratorContainer().getSequenceGenerator();
        sequenceGenerator.setSpecifiedSchema("testSchema");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        SequenceGenerator2_0Annotation annotation = (SequenceGenerator2_0Annotation)attributeResource.getAnnotation("javax.persistence.SequenceGenerator");
        GenericJavaSequenceGenerator2_0Tests.assertEquals((String)"testSchema", (String)annotation.getSchema());
        sequenceGenerator.setSpecifiedSchema(null);
        GenericJavaSequenceGenerator2_0Tests.assertNull((Object)annotation.getSchema());
    }

    protected ICompilationUnit createTestEntityWithSequenceGenerator() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.SequenceGenerator", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@SequenceGenerator(name=\"TEST_SEQUENCE_GENERATOR\")");
            }
        });
    }
}

