/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmIdMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmOneToOneMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.GenericJavaNullAttributeMapping;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericOrmPersistentAttribute2_0Tests
extends Generic2_0ContextModelTestCase {
    public GenericOrmPersistentAttribute2_0Tests(String name) {
        super(name);
    }

    private ICompilationUnit createTestTypeNullAttributeMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityIdMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append("@Column(name=\"FOO\")");
            }
        });
    }

    private ICompilationUnit createTestEntityIdMappingPropertyAccess() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Column"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append("@Column(name=\"FOO\")");
            }
        });
    }

    private ICompilationUnit createTestEntityOneToOneMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne");
                sb.append("    private Address address;");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedFieldPropertySpecified() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "javax.persistence.Id", "javax.persistence.Access", "javax.persistence.AccessType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append("@Access(AccessType.PROPERTY)");
            }

            public void appendNameFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic");
                sb.append("@Access(AccessType.FIELD)");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    public void testMakeSpecified() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        ormPersistentAttribute.convertToSpecified();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormPersistentAttribute.convertToSpecified();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)0, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        ListIterator specifiedAttributes = ormPersistentType.specifiedAttributes();
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"name", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
    }

    public void testMakeSpecifiedWithAccess() throws Exception {
        this.createTestEntityAnnotatedFieldPropertySpecified();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals(null, (Object)ormPersistentAttribute.getJavaPersistentAttribute().getSpecifiedAccess());
        ormPersistentAttribute.convertToSpecified();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertEquals(null, (Object)specifiedOrmPersistentAttribute.getSpecifiedAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)specifiedOrmPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"name", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        ormPersistentAttribute.convertToSpecified();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)0, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        ListIterator specifiedAttributes = ormPersistentType.specifiedAttributes();
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)specifiedOrmPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals(null, (Object)specifiedOrmPersistentAttribute.getSpecifiedAccess());
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"name", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)specifiedOrmPersistentAttribute.getSpecifiedAccess());
    }

    public void testMakeSpecifiedMappingKey() throws Exception {
        this.createTestTypeNullAttributeMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof GenericJavaNullAttributeMapping));
        ormPersistentAttribute.convertToSpecified("oneToOne");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"address", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)(specifiedOrmPersistentAttribute.getMapping() instanceof OrmOneToOneMapping));
        ormPersistentAttribute = (OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next();
        ormPersistentAttribute.convertToSpecified("id");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        ListIterator specifiedAttributes = ormPersistentType.specifiedAttributes();
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)(specifiedOrmPersistentAttribute.getMapping() instanceof OrmIdMapping));
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)specifiedAttributes.next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"address", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
    }

    public void testMakeVirtual() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        ((OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next()).convertToSpecified();
        ((OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next()).convertToSpecified();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)0, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)specifiedOrmPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)specifiedOrmPersistentAttribute.isVirtual());
        specifiedOrmPersistentAttribute.convertToVirtual();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        specifiedOrmPersistentAttribute.convertToVirtual();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)0, (int)ormPersistentType.specifiedAttributesSize());
        ListIterator virtualAttributes = ormPersistentType.virtualAttributes();
        OrmReadOnlyPersistentAttribute virtualAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)virtualAttribute.getName());
        virtualAttribute = (OrmReadOnlyPersistentAttribute)virtualAttributes.next();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"name", (String)virtualAttribute.getName());
    }

    public void testMakeVirtualNoUnderlyingJavaAttribute() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        ((OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next()).convertToSpecified();
        ((OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next()).convertToSpecified();
        ((OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next()).getMapping().setName("noJavaAttribute");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)2, (int)ormPersistentType.specifiedAttributesSize());
        OrmPersistentAttribute specifiedOrmPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        specifiedOrmPersistentAttribute.convertToVirtual();
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)1, (int)ormPersistentType.virtualAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)((OrmReadOnlyPersistentAttribute)ormPersistentType.virtualAttributes().next()).getName());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"name", (String)((OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next()).getName());
    }

    public void testVirtualMappingTypeWhenMetadataComplete() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getMappingKey());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"FOO", (String)((IdMapping)ormPersistentAttribute.getMapping()).getColumn().getName());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMappingKey());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)((BasicMapping)ormPersistentAttribute.getMapping()).getColumn().getName());
    }

    public void testVirtualMappingTypeWhenMetadataComplete2() throws Exception {
        this.createTestEntityOneToOneMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"oneToOne", (String)ormPersistentAttribute.getMappingKey());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"address", (String)ormPersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)ormPersistentAttribute.getMappingKey());
    }

    public void testGetJavaPersistentAttribute() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        JavaResourcePersistentAttribute javaResourcePersistentAttribute = ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute();
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)javaResourcePersistentAttribute.isField());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)javaResourcePersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertEquals(javaPersistentType.getResourcePersistentType().persistableFields().next(), (Object)javaResourcePersistentAttribute);
        ormPersistentAttribute.convertToSpecified();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        ((OrmPersistentAttribute)ormPersistentAttribute).convertToVirtual();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        ormPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        GenericOrmPersistentAttribute2_0Tests.assertNotSame((Object)ormPersistentAttribute, (Object)ormPersistentType.getAttributeNamed("id"));
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        javaResourcePersistentAttribute = ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute();
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)javaResourcePersistentAttribute.isProperty());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)javaResourcePersistentAttribute.getName());
        GenericOrmPersistentAttribute2_0Tests.assertEquals(javaPersistentType.getResourcePersistentType().persistableProperties().next(), (Object)javaResourcePersistentAttribute);
        ormPersistentType.setSpecifiedAccess(null);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        OrmPersistentAttribute ormPersistentAttribute2 = ormPersistentAttribute.convertToSpecified();
        ormPersistentAttribute2.getMapping().setName("id2");
        GenericOrmPersistentAttribute2_0Tests.assertEquals(null, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
        ormPersistentAttribute2.getMapping().setName(null);
        GenericOrmPersistentAttribute2_0Tests.assertEquals(null, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
        ormPersistentAttribute2.getMapping().setName("id");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute2.getJavaPersistentAttribute());
    }

    public void testGetJavaPersistentAttributeMixedAccess() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getOwningPersistentType().getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"basic", (String)ormPersistentAttribute.getMappingKey());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((String)"id", (String)javaPersistentAttribute.getMappingKey());
        ormPersistentAttribute.convertToSpecified();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute().isProperty());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isField());
        ((OrmPersistentAttribute)ormPersistentAttribute).setSpecifiedAccess(AccessType.FIELD);
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute().isField());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isField());
    }

    public void testGetAccess() throws Exception {
        this.createTestEntityIdMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute().isField());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isField());
        ormPersistentAttribute.convertToSpecified();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute().isField());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isField());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getJavaPersistentAttribute().getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isField());
    }

    public void testGetAccessPropertyInJava() throws Exception {
        this.createTestEntityIdMappingPropertyAccess();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute().isProperty());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isProperty());
        ormPersistentAttribute.convertToSpecified();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute().isProperty());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isProperty());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getJavaPersistentAttribute().getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isProperty());
    }

    public void testGetAccessPropertyInJava2() throws Exception {
        this.createTestEntityAnnotatedFieldPropertySpecified();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        JavaPersistentAttribute javaPersistentAttribute = javaPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute().isProperty());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isProperty());
        OrmReadOnlyPersistentAttribute nameOrmPersistentAttribute = ormPersistentType.getAttributeNamed("name");
        JavaPersistentAttribute nameJavaPersistentAttribute = javaPersistentType.getAttributeNamed("name");
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)nameOrmPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)nameOrmPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)nameOrmPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute().isField());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)nameJavaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)nameJavaPersistentAttribute.getResourcePersistentAttribute().isField());
        ormPersistentAttribute.convertToSpecified();
        ormPersistentAttribute = ormPersistentType.getAttributeNamed("id");
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)ormPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute().isProperty());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isProperty());
        nameOrmPersistentAttribute.convertToSpecified();
        nameOrmPersistentAttribute = ormPersistentType.getAttributeNamed("name");
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)nameOrmPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)nameOrmPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)nameOrmPersistentAttribute.getJavaPersistentAttribute().getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)nameOrmPersistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute().isField());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)nameJavaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)nameJavaPersistentAttribute.getResourcePersistentAttribute().isField());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)nameJavaPersistentAttribute, (Object)nameOrmPersistentAttribute.getJavaPersistentAttribute());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)ormPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertNotSame((Object)javaPersistentAttribute, (Object)ormPersistentAttribute.getJavaPersistentAttribute());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)ormPersistentAttribute.getJavaPersistentAttribute().getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)javaPersistentAttribute.getResourcePersistentAttribute().isProperty());
        GenericOrmPersistentAttribute2_0Tests.assertFalse((boolean)nameOrmPersistentAttribute.isVirtual());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)nameOrmPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertNotSame((Object)javaPersistentAttribute, (Object)nameOrmPersistentAttribute.getJavaPersistentAttribute());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)nameOrmPersistentAttribute.getJavaPersistentAttribute().getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)nameJavaPersistentAttribute.getAccess());
        GenericOrmPersistentAttribute2_0Tests.assertTrue((boolean)nameJavaPersistentAttribute.getResourcePersistentAttribute().isField());
    }
}

