/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.Access2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.AccessType;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;

public class Access2_0AnnotationTests
extends JavaResourceModel2_0TestCase {
    public Access2_0AnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestAccessOnType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Access", "javax.persistence.AccessType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Access(AccessType.PROPERTY)");
            }
        });
    }

    private ICompilationUnit createTestAccessOnField() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Access", "javax.persistence.AccessType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Access(AccessType.FIELD)");
            }
        });
    }

    private ICompilationUnit createTestAccessOnProperty() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Access", "javax.persistence.AccessType"});
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Access(AccessType.PROPERTY)");
            }
        });
    }

    public void testGetAccessOnType() throws Exception {
        ICompilationUnit cu = this.createTestAccessOnType();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        Access2_0Annotation access = (Access2_0Annotation)typeResource.getAnnotation("javax.persistence.Access");
        Access2_0AnnotationTests.assertNotNull((Object)access);
        Access2_0AnnotationTests.assertEquals((Object)AccessType.PROPERTY, (Object)access.getValue());
    }

    public void testSetAccessOnType() throws Exception {
        ICompilationUnit cu = this.createTestType();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        Access2_0Annotation access = (Access2_0Annotation)typeResource.getAnnotation("javax.persistence.Access");
        Access2_0AnnotationTests.assertNull((Object)access);
        typeResource.addAnnotation("javax.persistence.Access");
        this.assertSourceContains("@Access", cu);
        access = (Access2_0Annotation)typeResource.getAnnotation("javax.persistence.Access");
        Access2_0AnnotationTests.assertNotNull((Object)access);
        access.setValue(AccessType.FIELD);
        Access2_0AnnotationTests.assertEquals((Object)AccessType.FIELD, (Object)access.getValue());
        this.assertSourceContains("@Access(FIELD)", cu);
        access.setValue(AccessType.PROPERTY);
        Access2_0AnnotationTests.assertEquals((Object)AccessType.PROPERTY, (Object)access.getValue());
        this.assertSourceContains("@Access(PROPERTY)", cu);
        access.setValue(null);
        this.assertSourceDoesNotContain("@Access(", cu);
    }

    public void testGetAccessOnField() throws Exception {
        ICompilationUnit cu = this.createTestAccessOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableFields().next();
        Access2_0Annotation access = (Access2_0Annotation)attributeResource.getAnnotation("javax.persistence.Access");
        Access2_0AnnotationTests.assertNotNull((Object)access);
        Access2_0AnnotationTests.assertEquals((Object)AccessType.FIELD, (Object)access.getValue());
    }

    public void testSetAccessOnField() throws Exception {
        ICompilationUnit cu = this.createTestType();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableFields().next();
        Access2_0Annotation access = (Access2_0Annotation)attributeResource.getAnnotation("javax.persistence.Access");
        Access2_0AnnotationTests.assertNull((Object)access);
        attributeResource.addAnnotation("javax.persistence.Access");
        this.assertSourceContains("@Access", cu);
        access = (Access2_0Annotation)attributeResource.getAnnotation("javax.persistence.Access");
        Access2_0AnnotationTests.assertNotNull((Object)access);
        access.setValue(AccessType.FIELD);
        Access2_0AnnotationTests.assertEquals((Object)AccessType.FIELD, (Object)access.getValue());
        this.assertSourceContains("@Access(FIELD)", cu);
        access.setValue(AccessType.PROPERTY);
        Access2_0AnnotationTests.assertEquals((Object)AccessType.PROPERTY, (Object)access.getValue());
        this.assertSourceContains("@Access(PROPERTY)", cu);
        access.setValue(null);
        this.assertSourceDoesNotContain("@Access(", cu);
    }

    public void testGetAccessOnProperty() throws Exception {
        ICompilationUnit cu = this.createTestAccessOnProperty();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableProperties().next();
        Access2_0Annotation access = (Access2_0Annotation)attributeResource.getAnnotation("javax.persistence.Access");
        Access2_0AnnotationTests.assertNotNull((Object)access);
        Access2_0AnnotationTests.assertEquals((Object)AccessType.PROPERTY, (Object)access.getValue());
    }

    public void testSetAccessOnProperty() throws Exception {
        ICompilationUnit cu = this.createTestType();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableProperties().next();
        Access2_0Annotation access = (Access2_0Annotation)attributeResource.getAnnotation("javax.persistence.Access");
        Access2_0AnnotationTests.assertNull((Object)access);
        attributeResource.addAnnotation("javax.persistence.Access");
        this.assertSourceContains("@Access", cu);
        access = (Access2_0Annotation)attributeResource.getAnnotation("javax.persistence.Access");
        Access2_0AnnotationTests.assertNotNull((Object)access);
        access.setValue(AccessType.FIELD);
        Access2_0AnnotationTests.assertEquals((Object)AccessType.FIELD, (Object)access.getValue());
        this.assertSourceContains("@Access(FIELD)", cu);
        access.setValue(AccessType.PROPERTY);
        Access2_0AnnotationTests.assertEquals((Object)AccessType.PROPERTY, (Object)access.getValue());
        this.assertSourceContains("@Access(PROPERTY)", cu);
        access.setValue(null);
        this.assertSourceDoesNotContain("@Access(", cu);
    }
}

