/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.CollectionTable2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;

public class CollectionTable2_0AnnotationTests
extends JavaResourceModel2_0TestCase {
    private static final String TABLE_NAME = "MY_TABLE";
    private static final String SCHEMA_NAME = "MY_SCHEMA";
    private static final String CATALOG_NAME = "MY_CATALOG";

    public CollectionTable2_0AnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestCollectionTable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.CollectionTable"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@CollectionTable");
            }
        });
    }

    private ICompilationUnit createTestCollectionTableWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.CollectionTable"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@CollectionTable(name = \"MY_TABLE\")");
            }
        });
    }

    private ICompilationUnit createTestCollectionTableWithSchema() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.CollectionTable"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@CollectionTable(schema = \"MY_SCHEMA\")");
            }
        });
    }

    private ICompilationUnit createTestCollectionTableWithCatalog() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.CollectionTable"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@CollectionTable(catalog = \"MY_CATALOG\")");
            }
        });
    }

    private ICompilationUnit createTestCollectionTableWithUniqueConstraints() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.CollectionTable", "javax.persistence.UniqueConstraint"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@CollectionTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"FOO\"}), @UniqueConstraint(columnNames = {\"BAZ\"})})");
            }
        });
    }

    private ICompilationUnit createTestCollectionTableWithJoinColumns() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.CollectionTable", "javax.persistence.JoinColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@CollectionTable(joinColumns = {@JoinColumn(name = \"BAR\"), @JoinColumn})");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTableWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        CollectionTable2_0AnnotationTests.assertNotNull((Object)table);
        CollectionTable2_0AnnotationTests.assertEquals((String)TABLE_NAME, (String)table.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        CollectionTable2_0AnnotationTests.assertNotNull((Object)table);
        CollectionTable2_0AnnotationTests.assertNull((Object)table.getName());
        CollectionTable2_0AnnotationTests.assertNull((Object)table.getCatalog());
        CollectionTable2_0AnnotationTests.assertNull((Object)table.getSchema());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        CollectionTable2_0AnnotationTests.assertNotNull((Object)table);
        CollectionTable2_0AnnotationTests.assertNull((Object)table.getName());
        table.setName("Foo");
        CollectionTable2_0AnnotationTests.assertEquals((String)"Foo", (String)table.getName());
        this.assertSourceContains("@CollectionTable(name = \"Foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTableWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        CollectionTable2_0AnnotationTests.assertEquals((String)TABLE_NAME, (String)table.getName());
        table.setName(null);
        CollectionTable2_0AnnotationTests.assertNull((Object)table.getName());
        this.assertSourceDoesNotContain("@CollectionTable(", cu);
    }

    public void testGetCatalog() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTableWithCatalog();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        CollectionTable2_0AnnotationTests.assertNotNull((Object)table);
        CollectionTable2_0AnnotationTests.assertEquals((String)CATALOG_NAME, (String)table.getCatalog());
    }

    public void testSetCatalog() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        CollectionTable2_0AnnotationTests.assertNotNull((Object)table);
        CollectionTable2_0AnnotationTests.assertNull((Object)table.getCatalog());
        table.setCatalog("Foo");
        CollectionTable2_0AnnotationTests.assertEquals((String)"Foo", (String)table.getCatalog());
        this.assertSourceContains("@CollectionTable(catalog = \"Foo\")", cu);
    }

    public void testSetCatalogNull() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTableWithCatalog();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        CollectionTable2_0AnnotationTests.assertEquals((String)CATALOG_NAME, (String)table.getCatalog());
        table.setCatalog(null);
        CollectionTable2_0AnnotationTests.assertNull((Object)table.getCatalog());
        this.assertSourceDoesNotContain("@CollectionTable(", cu);
    }

    public void testGetSchema() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTableWithSchema();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        CollectionTable2_0AnnotationTests.assertNotNull((Object)table);
        CollectionTable2_0AnnotationTests.assertEquals((String)SCHEMA_NAME, (String)table.getSchema());
    }

    public void testSetSchema() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        CollectionTable2_0AnnotationTests.assertNotNull((Object)table);
        CollectionTable2_0AnnotationTests.assertNull((Object)table.getSchema());
        table.setSchema("Foo");
        CollectionTable2_0AnnotationTests.assertEquals((String)"Foo", (String)table.getSchema());
        this.assertSourceContains("@CollectionTable(schema = \"Foo\")", cu);
    }

    public void testSetSchemaNull() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTableWithSchema();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        CollectionTable2_0AnnotationTests.assertEquals((String)SCHEMA_NAME, (String)table.getSchema());
        table.setSchema(null);
        CollectionTable2_0AnnotationTests.assertNull((Object)table.getSchema());
        this.assertSourceDoesNotContain("@CollectionTable(", cu);
    }

    public void testUniqueConstraints() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        CollectionTable2_0AnnotationTests.assertEquals((int)0, (int)table.uniqueConstraintsSize());
    }

    public void testUniqueConstraints2() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        table.addUniqueConstraint(0);
        table.addUniqueConstraint(1);
        CollectionTable2_0AnnotationTests.assertEquals((int)2, (int)table.uniqueConstraintsSize());
    }

    public void testUniqueConstraints3() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTableWithUniqueConstraints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        CollectionTable2_0AnnotationTests.assertEquals((int)3, (int)table.uniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        table.addUniqueConstraint(0).addColumnName("FOO");
        table.addUniqueConstraint(1);
        table.addUniqueConstraint(0).addColumnName("BAR");
        CollectionTable2_0AnnotationTests.assertEquals((String)"BAR", (String)((String)table.uniqueConstraintAt(0).columnNames().next()));
        CollectionTable2_0AnnotationTests.assertEquals((String)"FOO", (String)((String)table.uniqueConstraintAt(1).columnNames().next()));
        CollectionTable2_0AnnotationTests.assertEquals((int)0, (int)table.uniqueConstraintAt(2).columnNamesSize());
        this.assertSourceContains("@CollectionTable(uniqueConstraints = {@UniqueConstraint(columnNames = \"BAR\"),@UniqueConstraint(columnNames = \"FOO\"), @UniqueConstraint})", cu);
    }

    public void testRemoveUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTableWithUniqueConstraints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        CollectionTable2_0AnnotationTests.assertEquals((String)"BAR", (String)((String)table.uniqueConstraintAt(0).columnNames().next()));
        CollectionTable2_0AnnotationTests.assertEquals((String)"FOO", (String)((String)table.uniqueConstraintAt(1).columnNames().next()));
        CollectionTable2_0AnnotationTests.assertEquals((String)"BAZ", (String)((String)table.uniqueConstraintAt(2).columnNames().next()));
        CollectionTable2_0AnnotationTests.assertEquals((int)3, (int)table.uniqueConstraintsSize());
        table.removeUniqueConstraint(1);
        CollectionTable2_0AnnotationTests.assertEquals((String)"BAR", (String)((String)table.uniqueConstraintAt(0).columnNames().next()));
        CollectionTable2_0AnnotationTests.assertEquals((String)"BAZ", (String)((String)table.uniqueConstraintAt(1).columnNames().next()));
        CollectionTable2_0AnnotationTests.assertEquals((int)2, (int)table.uniqueConstraintsSize());
        this.assertSourceContains("@CollectionTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"BAZ\"})})", cu);
        table.removeUniqueConstraint(0);
        CollectionTable2_0AnnotationTests.assertEquals((String)"BAZ", (String)((String)table.uniqueConstraintAt(0).columnNames().next()));
        CollectionTable2_0AnnotationTests.assertEquals((int)1, (int)table.uniqueConstraintsSize());
        this.assertSourceContains("@CollectionTable(uniqueConstraints = @UniqueConstraint(columnNames = {\"BAZ\"}))", cu);
        table.removeUniqueConstraint(0);
        CollectionTable2_0AnnotationTests.assertEquals((int)0, (int)table.uniqueConstraintsSize());
        this.assertSourceDoesNotContain("@CollectionTable(", cu);
    }

    public void testMoveUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTableWithUniqueConstraints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        this.assertSourceContains("@CollectionTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"FOO\"}), @UniqueConstraint(columnNames = {\"BAZ\"})})", cu);
        table.moveUniqueConstraint(2, 0);
        this.assertSourceContains("@CollectionTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"FOO\"}), @UniqueConstraint(columnNames = {\"BAZ\"}), @UniqueConstraint(columnNames = {\"BAR\"})})", cu);
    }

    public void testMoveUniqueConstraint2() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTableWithUniqueConstraints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        this.assertSourceContains("@CollectionTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"FOO\"}), @UniqueConstraint(columnNames = {\"BAZ\"})})", cu);
        table.moveUniqueConstraint(0, 2);
        this.assertSourceContains("@CollectionTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAZ\"}), @UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"FOO\"})})", cu);
    }

    public void testJoinColumns() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        CollectionTable2_0AnnotationTests.assertEquals((int)0, (int)table.joinColumnsSize());
    }

    public void testJoinColumns2() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        table.addJoinColumn(0);
        table.addJoinColumn(1);
        CollectionTable2_0AnnotationTests.assertEquals((int)2, (int)table.joinColumnsSize());
    }

    public void testJoinColumns3() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTableWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        CollectionTable2_0AnnotationTests.assertEquals((int)2, (int)table.joinColumnsSize());
    }

    public void testAddJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        table.addJoinColumn(0).setName("FOO");
        table.addJoinColumn(1);
        table.addJoinColumn(0).setName("BAR");
        CollectionTable2_0AnnotationTests.assertEquals((String)"BAR", (String)table.joinColumnAt(0).getName());
        CollectionTable2_0AnnotationTests.assertEquals((String)"FOO", (String)table.joinColumnAt(1).getName());
        CollectionTable2_0AnnotationTests.assertNull((Object)table.joinColumnAt(2).getName());
        this.assertSourceContains("@CollectionTable(joinColumns = {@JoinColumn(name = \"BAR\"),@JoinColumn(name = \"FOO\"), @JoinColumn})", cu);
    }

    public void testRemoveJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTableWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        table.addJoinColumn(0).setName("FOO");
        CollectionTable2_0AnnotationTests.assertEquals((String)"FOO", (String)table.joinColumnAt(0).getName());
        CollectionTable2_0AnnotationTests.assertEquals((String)"BAR", (String)table.joinColumnAt(1).getName());
        CollectionTable2_0AnnotationTests.assertNull((Object)table.joinColumnAt(2).getName());
        CollectionTable2_0AnnotationTests.assertEquals((int)3, (int)table.joinColumnsSize());
        table.removeJoinColumn(1);
        CollectionTable2_0AnnotationTests.assertEquals((String)"FOO", (String)table.joinColumnAt(0).getName());
        CollectionTable2_0AnnotationTests.assertNull((Object)table.joinColumnAt(1).getName());
        CollectionTable2_0AnnotationTests.assertEquals((int)2, (int)table.joinColumnsSize());
        this.assertSourceContains("@CollectionTable(joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn})", cu);
        table.removeJoinColumn(0);
        CollectionTable2_0AnnotationTests.assertNull((Object)table.joinColumnAt(0).getName());
        CollectionTable2_0AnnotationTests.assertEquals((int)1, (int)table.joinColumnsSize());
        this.assertSourceContains("@CollectionTable(joinColumns = @JoinColumn)", cu);
        table.removeJoinColumn(0);
        CollectionTable2_0AnnotationTests.assertEquals((int)0, (int)table.joinColumnsSize());
        this.assertSourceDoesNotContain("@CollectionTable(", cu);
    }

    public void testMoveJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTableWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        JoinColumnAnnotation joinColumn = table.joinColumnAt(0);
        joinColumn.setReferencedColumnName("REF_NAME");
        joinColumn.setUnique(Boolean.FALSE);
        joinColumn.setNullable(Boolean.FALSE);
        joinColumn.setInsertable(Boolean.FALSE);
        joinColumn.setUpdatable(Boolean.FALSE);
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setTable("TABLE");
        table.addJoinColumn(0).setName("FOO");
        this.assertSourceContains("@CollectionTable(joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn})", cu);
        table.moveJoinColumn(2, 0);
        CollectionTable2_0AnnotationTests.assertEquals((String)"BAR", (String)table.joinColumnAt(0).getName());
        CollectionTable2_0AnnotationTests.assertNull((Object)table.joinColumnAt(1).getName());
        CollectionTable2_0AnnotationTests.assertEquals((String)"FOO", (String)table.joinColumnAt(2).getName());
        CollectionTable2_0AnnotationTests.assertEquals((int)3, (int)table.joinColumnsSize());
        this.assertSourceContains("@CollectionTable(joinColumns = {@JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn, @JoinColumn(name = \"FOO\")})", cu);
    }

    public void testMoveJoinColumn2() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTableWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        JoinColumnAnnotation joinColumn = table.joinColumnAt(0);
        joinColumn.setReferencedColumnName("REF_NAME");
        joinColumn.setUnique(Boolean.FALSE);
        joinColumn.setNullable(Boolean.FALSE);
        joinColumn.setInsertable(Boolean.FALSE);
        joinColumn.setUpdatable(Boolean.FALSE);
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setTable("TABLE");
        table.addJoinColumn(0).setName("FOO");
        this.assertSourceContains("@CollectionTable(joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn})", cu);
        table.moveJoinColumn(0, 2);
        CollectionTable2_0AnnotationTests.assertNull((Object)table.joinColumnAt(0).getName());
        CollectionTable2_0AnnotationTests.assertEquals((String)"FOO", (String)table.joinColumnAt(1).getName());
        CollectionTable2_0AnnotationTests.assertEquals((String)"BAR", (String)table.joinColumnAt(2).getName());
        CollectionTable2_0AnnotationTests.assertEquals((int)3, (int)table.joinColumnsSize());
        this.assertSourceContains("@CollectionTable(joinColumns = {@JoinColumn, @JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\")})", cu);
    }

    public void testSetJoinColumnName() throws Exception {
        ICompilationUnit cu = this.createTestCollectionTableWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        CollectionTable2_0Annotation table = (CollectionTable2_0Annotation)attributeResource.getAnnotation("javax.persistence.CollectionTable");
        CollectionTable2_0AnnotationTests.assertEquals((int)2, (int)table.joinColumnsSize());
        JoinColumnAnnotation joinColumn = (JoinColumnAnnotation)table.joinColumns().next();
        CollectionTable2_0AnnotationTests.assertEquals((String)"BAR", (String)joinColumn.getName());
        joinColumn.setName("foo");
        CollectionTable2_0AnnotationTests.assertEquals((String)"foo", (String)joinColumn.getName());
        this.assertSourceContains("@CollectionTable(joinColumns = {@JoinColumn(name = \"foo\"), @JoinColumn})", cu);
    }
}

