/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.resource.java.GeneratedValueAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.GenerationType;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class GeneratedValueTests
extends JpaJavaResourceModelTestCase {
    private static final String GENERATOR = "MY_GENERATOR";

    public GeneratedValueTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestGeneratedValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.GeneratedValue", "javax.persistence.GenerationType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@GeneratedValue");
            }
        });
    }

    private ICompilationUnit createTestGeneratedValueWithGenerator() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.GeneratedValue", "javax.persistence.GenerationType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@GeneratedValue(generator = \"MY_GENERATOR\")");
            }
        });
    }

    private ICompilationUnit createTestGeneratedValueWithStrategy() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.GeneratedValue", "javax.persistence.GenerationType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@GeneratedValue(strategy = GenerationType.SEQUENCE)");
            }
        });
    }

    public void testGeneratedValue() throws Exception {
        ICompilationUnit cu = this.createTestGeneratedValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        GeneratedValueAnnotation generatedValue = (GeneratedValueAnnotation)attributeResource.getAnnotation("javax.persistence.GeneratedValue");
        GeneratedValueTests.assertNotNull((Object)generatedValue);
    }

    public void testGetGenerator() throws Exception {
        ICompilationUnit cu = this.createTestGeneratedValueWithGenerator();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        GeneratedValueAnnotation generatedValue = (GeneratedValueAnnotation)attributeResource.getAnnotation("javax.persistence.GeneratedValue");
        GeneratedValueTests.assertEquals((String)GENERATOR, (String)generatedValue.getGenerator());
    }

    public void testSetGenerator() throws Exception {
        ICompilationUnit cu = this.createTestGeneratedValueWithGenerator();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        GeneratedValueAnnotation generatedValue = (GeneratedValueAnnotation)attributeResource.getAnnotation("javax.persistence.GeneratedValue");
        GeneratedValueTests.assertEquals((String)GENERATOR, (String)generatedValue.getGenerator());
        generatedValue.setGenerator("foo");
        GeneratedValueTests.assertEquals((String)"foo", (String)generatedValue.getGenerator());
        this.assertSourceContains("@GeneratedValue(generator = \"foo\")", cu);
        generatedValue.setGenerator(null);
        GeneratedValueTests.assertNull((Object)generatedValue.getGenerator());
        this.assertSourceDoesNotContain("generator", cu);
        this.assertSourceContains("@GeneratedValue", cu);
    }

    public void testGetStrategy() throws Exception {
        ICompilationUnit cu = this.createTestGeneratedValueWithStrategy();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        GeneratedValueAnnotation generatedValue = (GeneratedValueAnnotation)attributeResource.getAnnotation("javax.persistence.GeneratedValue");
        GeneratedValueTests.assertEquals((Object)GenerationType.SEQUENCE, (Object)generatedValue.getStrategy());
    }

    public void testSetStrategy() throws Exception {
        ICompilationUnit cu = this.createTestGeneratedValueWithStrategy();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        GeneratedValueAnnotation generatedValue = (GeneratedValueAnnotation)attributeResource.getAnnotation("javax.persistence.GeneratedValue");
        GeneratedValueTests.assertEquals((Object)GenerationType.SEQUENCE, (Object)generatedValue.getStrategy());
        generatedValue.setStrategy(GenerationType.TABLE);
        GeneratedValueTests.assertEquals((Object)GenerationType.TABLE, (Object)generatedValue.getStrategy());
        this.assertSourceContains("@GeneratedValue(strategy = TABLE)", cu);
        generatedValue.setStrategy(null);
        GeneratedValueTests.assertNull((Object)generatedValue.getStrategy());
        this.assertSourceDoesNotContain("strategy", cu);
        this.assertSourceContains("@GeneratedValue", cu);
    }
}

