/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class PrimaryKeyJoinColumnTests
extends JpaJavaResourceModelTestCase {
    private static final String COLUMN_NAME = "MY_COLUMN";
    private static final String COLUMN_COLUMN_DEFINITION = "COLUMN_DEFINITION";
    private static final String COLUMN_REFERENCED_COLUMN_NAME = "MY_REF_COLUMN_NAME";

    public PrimaryKeyJoinColumnTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestPrimaryKeyJoinColumn() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.PrimaryKeyJoinColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@PrimaryKeyJoinColumn");
            }
        });
    }

    private ICompilationUnit createTestPrimaryKeyJoinColumnWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.PrimaryKeyJoinColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@PrimaryKeyJoinColumn(name = \"MY_COLUMN\")");
            }
        });
    }

    private ICompilationUnit createTestPrimaryKeyJoinColumnWithReferencedColumnName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.PrimaryKeyJoinColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@PrimaryKeyJoinColumn(referencedColumnName = \"MY_REF_COLUMN_NAME\")");
            }
        });
    }

    private ICompilationUnit createTestPrimaryKeyJoinColumnWithColumnDefinition() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.PrimaryKeyJoinColumn"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@PrimaryKeyJoinColumn(columnDefinition = \"COLUMN_DEFINITION\")");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumnWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        PrimaryKeyJoinColumnTests.assertNotNull((Object)column);
        PrimaryKeyJoinColumnTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        PrimaryKeyJoinColumnTests.assertNotNull((Object)column);
        PrimaryKeyJoinColumnTests.assertNull((Object)column.getReferencedColumnName());
        PrimaryKeyJoinColumnTests.assertNull((Object)column.getColumnDefinition());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        PrimaryKeyJoinColumnTests.assertNotNull((Object)column);
        PrimaryKeyJoinColumnTests.assertNull((Object)column.getName());
        column.setName("Foo");
        PrimaryKeyJoinColumnTests.assertEquals((String)"Foo", (String)column.getName());
        this.assertSourceContains("@PrimaryKeyJoinColumn(name = \"Foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumnWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        PrimaryKeyJoinColumnTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
        column.setName(null);
        PrimaryKeyJoinColumnTests.assertNull((Object)column.getName());
        this.assertSourceDoesNotContain("@PrimaryKeyJoinColumn(", cu);
    }

    public void testGetReferencedColumnName() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumnWithReferencedColumnName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        PrimaryKeyJoinColumnTests.assertEquals((String)COLUMN_REFERENCED_COLUMN_NAME, (String)column.getReferencedColumnName());
    }

    public void testSetReferencedColumnName() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        PrimaryKeyJoinColumnTests.assertNotNull((Object)column);
        PrimaryKeyJoinColumnTests.assertNull((Object)column.getReferencedColumnName());
        column.setReferencedColumnName("Foo");
        PrimaryKeyJoinColumnTests.assertEquals((String)"Foo", (String)column.getReferencedColumnName());
        this.assertSourceContains("@PrimaryKeyJoinColumn(referencedColumnName = \"Foo\")", cu);
        column.setReferencedColumnName(null);
        this.assertSourceDoesNotContain("@PrimaryKeyJoinColumn(", cu);
    }

    public void testGetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumnWithColumnDefinition();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        PrimaryKeyJoinColumnTests.assertEquals((String)COLUMN_COLUMN_DEFINITION, (String)column.getColumnDefinition());
    }

    public void testSetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestPrimaryKeyJoinColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        PrimaryKeyJoinColumnTests.assertNotNull((Object)column);
        PrimaryKeyJoinColumnTests.assertNull((Object)column.getColumnDefinition());
        column.setColumnDefinition("Foo");
        PrimaryKeyJoinColumnTests.assertEquals((String)"Foo", (String)column.getColumnDefinition());
        this.assertSourceContains("@PrimaryKeyJoinColumn(columnDefinition = \"Foo\")", cu);
        column.setColumnDefinition(null);
        this.assertSourceDoesNotContain("@PrimaryKeyJoinColumn(", cu);
    }
}

