/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.dbws.eclipselink.core.internal.gen;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jpt.common.core.internal.gen.AbstractJptGenerator;
import org.eclipse.jpt.common.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbwsGenerator
extends AbstractJptGenerator {
    public static String LAUNCH_CONFIG_NAME = "DBWS Gen Run Config";
    public static String DBWS_GEN_PACKAGE_NAME = "org.eclipse.jpt.dbws.eclipselink.core.gen";
    public static String DBWS_GEN_CLASS = String.valueOf(DBWS_GEN_PACKAGE_NAME) + ".Main";
    public static String DBWS_GEN_JAR_PREFIX = String.valueOf(DBWS_GEN_PACKAGE_NAME) + "_";
    private final String builderFileName;
    private final String stageDirName;
    private final String driverJarList;

    public static void generate(IJavaProject javaProject, String builderFileName, String stageDirName, String driverJarList, IProgressMonitor monitor) {
        if (javaProject == null) {
            throw new NullPointerException();
        }
        new DbwsGenerator(javaProject, builderFileName, stageDirName, driverJarList).generate(monitor);
    }

    private DbwsGenerator(IJavaProject javaProject, String builderFileName, String stageDirName, String driverJarList) {
        super(javaProject);
        this.builderFileName = builderFileName;
        this.stageDirName = stageDirName;
        this.driverJarList = driverJarList;
    }

    protected String getMainType() {
        return DBWS_GEN_CLASS;
    }

    protected String getLaunchConfigName() {
        return LAUNCH_CONFIG_NAME;
    }

    protected String getBootstrapJarPrefix() {
        return DBWS_GEN_JAR_PREFIX;
    }

    protected void preGenerate(IProgressMonitor monitor) {
    }

    protected List<String> buildClasspath() throws CoreException {
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.add(this.getBootstrapJarClasspathEntry().getMemento());
        classpath.add(this.getDefaultProjectClasspathEntry().getMemento());
        if (!StringTools.stringIsEmpty((String)this.driverJarList)) {
            classpath.add(this.getJdbcJarClasspathEntry().getMemento());
        }
        classpath.add(this.getSystemLibraryClasspathEntry().getMemento());
        return classpath;
    }

    protected void specifyProgramArguments() {
        StringBuffer programArguments = new StringBuffer();
        programArguments.append(" -builderFile \"");
        programArguments.append(this.builderFileName);
        programArguments.append('\"');
        programArguments.append(" -stageDir \"");
        programArguments.append(this.stageDirName);
        programArguments.append('\"');
        programArguments.append(" -packageAs eclipse");
        this.launchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programArguments.toString());
    }

    private IRuntimeClasspathEntry getJdbcJarClasspathEntry() {
        return DbwsGenerator.getArchiveClasspathEntry((IPath)this.buildJdbcJarPath());
    }

    private IPath buildJdbcJarPath() {
        return new Path(this.driverJarList);
    }
}

