/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.navigator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProviderFactory;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDescription;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiPlugin;
import org.eclipse.jpt.jaxb.ui.platform.JaxbPlatformUi;

public class JaxbNavigatorItemLabelProviderFactory
implements ItemExtendedLabelProviderFactory {
    private final Map<JaxbPlatformDescription, ItemExtendedLabelProviderFactory> delegates = new HashMap<JaxbPlatformDescription, ItemExtendedLabelProviderFactory>();

    public ItemExtendedLabelProvider buildProvider(Object item, ItemExtendedLabelProvider.Manager manager) {
        ItemExtendedLabelProviderFactory delegate = this.getDelegate(item);
        if (delegate != null) {
            return delegate.buildProvider(item, manager);
        }
        return null;
    }

    private ItemExtendedLabelProviderFactory getDelegate(Object element) {
        if (!(element instanceof IAdaptable)) {
            return null;
        }
        JaxbContextNode contextNode = (JaxbContextNode)((IAdaptable)element).getAdapter(JaxbContextNode.class);
        if (contextNode == null) {
            return null;
        }
        JaxbPlatformDescription platformDesc = contextNode.getJaxbProject().getPlatform().getDescription();
        if (this.delegates.containsKey(platformDesc)) {
            return this.delegates.get(platformDesc);
        }
        JaxbPlatformUi platformUi = JptJaxbUiPlugin.getJaxbPlatformUiManager().getJaxbPlatformUi(platformDesc);
        ItemExtendedLabelProviderFactory delegate = platformUi == null ? null : platformUi.getNavigatorUi().getItemLabelProviderFactory();
        this.delegates.put(platformDesc, delegate);
        return delegate;
    }
}

