/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.navigator;

import java.util.HashMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProviderFactory;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDescription;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiPlugin;
import org.eclipse.jpt.jaxb.ui.platform.JaxbPlatformUi;

public class JaxbNavigatorTreeItemContentProviderFactory
implements ItemTreeContentProviderFactory {
    private HashMap<JaxbPlatformDescription, ItemTreeContentProviderFactory> delegates = new HashMap();

    public ItemTreeContentProvider buildProvider(Object item, ItemTreeContentProvider.Manager manager) {
        ItemTreeContentProviderFactory delegate = this.getDelegate(item);
        if (delegate != null) {
            return delegate.buildProvider(item, manager);
        }
        return null;
    }

    private ItemTreeContentProviderFactory getDelegate(Object element) {
        if (!(element instanceof IAdaptable)) {
            return null;
        }
        JaxbContextNode contextNode = (JaxbContextNode)((IAdaptable)element).getAdapter(JaxbContextNode.class);
        if (contextNode == null) {
            return null;
        }
        JaxbPlatformDescription platformDesc = contextNode.getJaxbProject().getPlatform().getDescription();
        if (this.delegates.containsKey(platformDesc)) {
            return this.delegates.get(platformDesc);
        }
        JaxbPlatformUi platformUi = JptJaxbUiPlugin.getJaxbPlatformUiManager().getJaxbPlatformUi(platformDesc);
        ItemTreeContentProviderFactory delegate = platformUi == null ? null : platformUi.getNavigatorUi().getTreeItemContentProviderFactory();
        this.delegates.put(platformDesc, delegate);
        return delegate;
    }
}

