/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.wizards;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jaxb.ui.internal.JptJaxbUiMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ProjectWizardPage
extends WizardPage {
    private IJavaProject javaProject;
    private ProjectGroup projectGroup;

    public static IJavaProject getJavaProjectFromSelection(IStructuredSelection selection) {
        if (selection == null) {
            return null;
        }
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof IJavaProject) {
            return (IJavaProject)firstElement;
        }
        if (firstElement instanceof IResource) {
            IProject project = ((IResource)firstElement).getProject();
            return ProjectWizardPage.getJavaProjectFrom(project);
        }
        if (firstElement instanceof IJavaElement) {
            return ((IJavaElement)firstElement).getJavaProject();
        }
        return null;
    }

    public static IJavaProject getJavaProjectFrom(IProject project) {
        return ((IJavaElement)project.getAdapter(IJavaElement.class)).getJavaProject();
    }

    public ProjectWizardPage() {
        super("Java Project");
        this.setDescription(JptJaxbUiMessages.ClassesGeneratorProjectWizardPage_desc);
    }

    public ProjectWizardPage(IJavaProject javaProject) {
        this();
        this.javaProject = javaProject;
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        this.setControl(this.buildTopLevelControl(parent));
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    private Control buildTopLevelControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        this.projectGroup = new ProjectGroup(composite);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private void setJavaProject(IJavaProject project) {
        this.javaProject = project;
    }

    private void projectChanged() {
        this.setPageComplete(false);
        String projectName = this.projectGroup.getProjectName();
        if (!StringTools.stringIsEmpty((String)projectName)) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            this.setJavaProject(JavaCore.create((IProject)project));
            this.setPageComplete(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProjectGroup {
        private Combo projectCombo;

        private ProjectGroup(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            this.buildLabel(composite, JptJaxbUiMessages.JavaProjectWizardPage_project);
            this.projectCombo = this.buildProjectCombo(composite, this.buildProjectComboSelectionListener());
            this.updateProjectCombo();
            ProjectWizardPage.this.setPageComplete(!StringTools.stringIsEmpty((String)this.getProjectName()));
        }

        private SelectionListener buildProjectComboSelectionListener() {
            return new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent event) {
                    this.widgetSelected(event);
                }

                public void widgetSelected(SelectionEvent event) {
                    ProjectGroup.this.selectedProjectChanged();
                }

                public String toString() {
                    return "JavaProjectWizardPage project combo-box selection listener";
                }
            };
        }

        void selectedProjectChanged() {
            ProjectWizardPage.this.projectChanged();
        }

        protected String getProjectName() {
            return this.projectCombo.getText();
        }

        protected void updateProjectCombo() {
            this.projectCombo.removeAll();
            String[] stringArray = this.getSortedJavaProjectsNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                this.projectCombo.add(name);
                ++n2;
            }
            if (ProjectWizardPage.this.javaProject != null) {
                this.projectCombo.select(this.projectCombo.indexOf(ProjectWizardPage.this.javaProject.getProject().getName()));
            }
        }

        private String[] getSortedJavaProjectsNames() {
            return (String[])ArrayTools.sort((Object[])this.getJavaProjectsNames());
        }

        private String[] getJavaProjectsNames() {
            return (String[])ArrayTools.array((Iterable)new TransformationIterable<IProject, String>(this.getJavaProjects()){

                protected String transform(IProject project) {
                    return project.getName();
                }
            }, (Object[])new String[0]);
        }

        private Iterable<IProject> getJavaProjects() {
            return new FilteringIterable<IProject>((Iterable)CollectionTools.collection(this.getProjects())){

                protected boolean accept(IProject next) {
                    try {
                        return next.hasNature("org.eclipse.jdt.core.javanature");
                    }
                    catch (CoreException coreException) {
                        return false;
                    }
                }
            };
        }

        private Iterator<IProject> getProjects() {
            return new ArrayIterator((Object[])ResourcesPlugin.getWorkspace().getRoot().getProjects());
        }

        private Label buildLabel(Composite parent, String text) {
            Label label = new Label(parent, 16384);
            label.setLayoutData((Object)new GridData());
            label.setText(text);
            return label;
        }

        private Combo buildProjectCombo(Composite parent, SelectionListener listener) {
            Combo projectCombo = new Combo(parent, 8);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            projectCombo.setLayoutData((Object)gridData);
            projectCombo.addSelectionListener(listener);
            return projectCombo;
        }
    }
}

