/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.enablement.jdt.classpath.DriverClasspathContainer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jpt.jpa.db.ConnectionProfileFactory;
import org.eclipse.jpt.jpa.db.internal.DTPConnectionProfileFactory;
import org.osgi.framework.BundleContext;

public class JptJpaDbPlugin
extends Plugin {
    private DTPConnectionProfileFactory connectionProfileFactory;
    private static JptJpaDbPlugin INSTANCE;
    public static final String PLUGIN_ID = "org.eclipse.jpt.jpa.db";

    public static JptJpaDbPlugin instance() {
        return INSTANCE;
    }

    public static ConnectionProfileFactory getConnectionProfileFactory() {
        return INSTANCE.getConnectionProfileFactory_();
    }

    public static void log(String msg) {
        JptJpaDbPlugin.log(msg, null);
    }

    public static void log(Throwable throwable) {
        JptJpaDbPlugin.log(throwable.getLocalizedMessage(), throwable);
    }

    public static void log(String msg, Throwable throwable) {
        JptJpaDbPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, msg, throwable));
    }

    public static void log(IStatus status) {
        INSTANCE.getLog().log(status);
    }

    public JptJpaDbPlugin() {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.connectionProfileFactory != null) {
            this.connectionProfileFactory.stop();
            this.connectionProfileFactory = null;
        }
        INSTANCE = null;
        super.stop(context);
    }

    private synchronized ConnectionProfileFactory getConnectionProfileFactory_() {
        if (this.connectionProfileFactory == null) {
            this.connectionProfileFactory = this.buildConnectionProfileFactory();
            this.connectionProfileFactory.start();
        }
        return this.connectionProfileFactory;
    }

    private DTPConnectionProfileFactory buildConnectionProfileFactory() {
        return DTPConnectionProfileFactory.instance();
    }

    public IClasspathContainer buildDriverClasspathContainerFor(String driverName) {
        return new DriverClasspathContainer(driverName);
    }
}

