/*******************************************************************************
 * Copyright (c) 2008, 2012 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0, which accompanies this distribution
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 * 
 * Contributors:
 *     Oracle - initial API and implementation
 *******************************************************************************/
package org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.customization;

import java.util.Collection;
import org.eclipse.jpt.common.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.Customization;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.Weaving;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.EclipseLinkHelpContextIds;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.swt.widgets.Composite;

/**
 * WeavingComposite
 */
public class WeavingComposite extends Pane<Customization>
{
	/**
	 * Creates a new <code>WeavingComposite</code>.
	 * 
	 * @param parentController
	 *            The parent container of this one
	 * @param parent
	 *            The parent container
	 */
	public WeavingComposite(
					Pane<? extends Customization> parentComposite, 
					Composite parent) {

		super( parentComposite, parent);
	}

	private EnumFormComboViewer<Customization, Weaving> addWeavingCombo(Composite container) {
		return new EnumFormComboViewer<Customization, Weaving>(this, container) {
			@Override
			protected void addPropertyNames(Collection<String> propertyNames) {
				super.addPropertyNames(propertyNames);
				propertyNames.add(Customization.WEAVING_PROPERTY);
			}

			@Override
			protected Weaving[] getChoices() {
				return Weaving.values();
			}

			@Override
			protected Weaving getDefaultValue() {
				return getSubject().getDefaultWeaving();
			}

			@Override
			protected String displayString(Weaving value) {
				switch (value) {
					case true_ :
						return EclipseLinkUiMessages.WeavingComposite_true_;
					case false_ :
						return EclipseLinkUiMessages.WeavingComposite_false_;
					case static_ :
						return EclipseLinkUiMessages.WeavingComposite_static_;
					default :
						throw new IllegalStateException();
				}
			}

			@Override
			protected Weaving getValue() {
				return getSubject().getWeaving();
			}

			@Override
			protected void setValue(Weaving value) {
				getSubject().setWeaving(value);
			}
		};
	}
	
	@Override
	protected void initializeLayout( Composite container) {

		this.addLabeledComposite(
			container,
			EclipseLinkUiMessages.PersistenceXmlCustomizationTab_weavingLabel,
			this.addWeavingCombo( container),
			EclipseLinkHelpContextIds.PERSISTENCE_CUSTOMIZATION
		);
	}

}
