/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.contentassist.ICompletionProposalComputer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJpaXmlCompletionProposalComputer
implements ICompletionProposalComputer {
    private String fErrorMessage = null;
    private ITextViewer fTextViewer = null;

    public List<ICompletionProposal> computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        ICompletionProposal[] props;
        ITextViewer textViewer = context.getViewer();
        int documentPosition = context.getInvocationOffset();
        this.setErrorMessage(null);
        this.fTextViewer = textViewer;
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)documentPosition);
        Node node = (Node)treeNode;
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        IDOMNode xmlnode = (IDOMNode)node;
        ContentAssistRequest contentAssistRequest = null;
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        ITextRegion completionRegion = this.getCompletionRegion(documentPosition, node);
        String matchString = null;
        try {
            matchString = this.getMatchString(sdRegion, completionRegion, documentPosition);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        if (completionRegion == null) {
            if (!(treeNode != null && ((Node)treeNode).getNodeType() != 9 || completionRegion != null || xmlnode != null && xmlnode.getChildNodes() != null && xmlnode.getChildNodes().getLength() != 0)) {
                IStructuredModel sModel = null;
                try {
                    if (textViewer.getDocument() instanceof IStructuredDocument) {
                        sModel = StructuredModelManager.getModelManager().getModelForRead((IStructuredDocument)textViewer.getDocument());
                    }
                    if (sModel != null) {
                        IDOMDocument docNode = ((IDOMModel)sModel).getDocument();
                        contentAssistRequest = new ContentAssistRequest((Node)docNode, (Node)docNode, sdRegion, completionRegion, documentPosition, 0, null);
                        this.addEmptyDocumentProposals(contentAssistRequest, context);
                    }
                }
                finally {
                    if (sModel != null) {
                        sModel.releaseFromRead();
                    }
                }
                if (contentAssistRequest == null) {
                    Logger.logException((Throwable)new IllegalStateException("problem getting model"));
                    return new ArrayList<ICompletionProposal>(0);
                }
                ICompletionProposal[] props2 = contentAssistRequest.getCompletionProposals();
                return props2 != null ? Arrays.asList(props2) : new ArrayList(0);
            }
            Logger.logException((Throwable)new IllegalStateException("completion region was null"));
            this.setErrorMessage(XMLUIMessages.SEVERE_internal_error_occu_UI_);
            contentAssistRequest = new ContentAssistRequest((Node)treeNode, node.getParentNode(), sdRegion, completionRegion, documentPosition, 0, "");
            ICompletionProposal[] props3 = contentAssistRequest.getCompletionProposals();
            return props3 != null ? Arrays.asList(props3) : new ArrayList(0);
        }
        if (xmlnode.getNodeType() == 9 && (completionRegion == null || xmlnode.getChildNodes() == null || xmlnode.getChildNodes().getLength() == 0)) {
            contentAssistRequest = this.computeStartDocumentProposals(matchString, completionRegion, (IDOMNode)treeNode, xmlnode, context);
            ICompletionProposal[] props4 = contentAssistRequest.getCompletionProposals();
            return props4 != null ? Arrays.asList(props4) : new ArrayList(0);
        }
        contentAssistRequest = this.computeCompletionProposals(matchString, completionRegion, (IDOMNode)treeNode, xmlnode, context);
        if (contentAssistRequest == null) {
            contentAssistRequest = new ContentAssistRequest((Node)treeNode, node.getParentNode(), sdRegion, completionRegion, documentPosition, 0, "");
            this.setErrorMessage(XMLUIMessages.Content_Assist_not_availab_UI_);
        }
        if (contentAssistRequest.getProposals().size() == 0 && this.getErrorMessage() == null) {
            this.setErrorMessage(XMLUIMessages.Content_Assist_not_availab_UI_);
        }
        return (props = contentAssistRequest.getCompletionProposals()) != null ? Arrays.asList(props) : new ArrayList(0);
    }

    public List<ICompletionProposal> computeContextInformation(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    protected abstract void addAttributeNameProposals(ContentAssistRequest var1, CompletionProposalInvocationContext var2);

    protected abstract void addAttributeValueProposals(ContentAssistRequest var1, CompletionProposalInvocationContext var2);

    protected abstract void addCommentProposal(ContentAssistRequest var1, CompletionProposalInvocationContext var2);

    protected abstract void addEmptyDocumentProposals(ContentAssistRequest var1, CompletionProposalInvocationContext var2);

    protected abstract void addEndTagNameProposals(ContentAssistRequest var1, CompletionProposalInvocationContext var2);

    protected abstract void addEndTagProposals(ContentAssistRequest var1, CompletionProposalInvocationContext var2);

    protected abstract void addEntityProposals(ContentAssistRequest var1, ITextRegion var2, IDOMNode var3, CompletionProposalInvocationContext var4);

    protected abstract void addEntityProposals(Vector<ICompletionProposal> var1, Properties var2, String var3, int var4, IStructuredDocumentRegion var5, ITextRegion var6, CompletionProposalInvocationContext var7);

    protected abstract void addPCDATAProposal(String var1, ContentAssistRequest var2, CompletionProposalInvocationContext var3);

    protected abstract void addStartDocumentProposals(ContentAssistRequest var1, CompletionProposalInvocationContext var2);

    protected abstract void addTagCloseProposals(ContentAssistRequest var1, CompletionProposalInvocationContext var2);

    protected abstract void addTagInsertionProposals(ContentAssistRequest var1, int var2, CompletionProposalInvocationContext var3);

    protected abstract void addTagNameProposals(ContentAssistRequest var1, int var2, CompletionProposalInvocationContext var3);

    protected void setErrorMessage(String errorMessage) {
        this.fErrorMessage = errorMessage;
    }

    protected ContentAssistRequest computeCompletionProposals(String matchString, ITextRegion completionRegion, IDOMNode treeNode, IDOMNode xmlnode, CompletionProposalInvocationContext context) {
        int documentPosition = context.getInvocationOffset();
        ContentAssistRequest contentAssistRequest = null;
        String regionType = completionRegion.getType();
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        if (xmlnode.getNodeType() == 1 || xmlnode.getNodeType() == 9) {
            if (regionType == "XML_TAG_OPEN") {
                contentAssistRequest = this.computeTagOpenProposals(matchString, completionRegion, treeNode, xmlnode, context);
            } else if (regionType == "XML_TAG_NAME") {
                contentAssistRequest = this.computeTagNameProposals(matchString, completionRegion, treeNode, xmlnode, context);
            } else if (regionType == "XML_TAG_ATTRIBUTE_NAME") {
                contentAssistRequest = this.computeAttributeProposals(matchString, completionRegion, treeNode, xmlnode, context);
            } else if (regionType == "XML_TAG_ATTRIBUTE_EQUALS") {
                contentAssistRequest = this.computeEqualsProposals(matchString, completionRegion, treeNode, xmlnode, context);
            } else if (regionType == "XML_TAG_ATTRIBUTE_VALUE" && documentPosition == sdRegion.getTextEndOffset() && (sdRegion.getText(completionRegion).endsWith("\"") || sdRegion.getText(completionRegion).endsWith("'"))) {
                IDOMNode actualNode = (IDOMNode)xmlnode.getModel().getIndexedRegion(sdRegion.getStartOffset(completionRegion));
                contentAssistRequest = new ContentAssistRequest((Node)actualNode, (Node)actualNode, sdRegion, completionRegion, documentPosition, 0, matchString);
                this.addTagCloseProposals(contentAssistRequest, context);
            } else if (regionType == "XML_TAG_ATTRIBUTE_VALUE") {
                contentAssistRequest = this.computeAttributeValueProposals(matchString, completionRegion, treeNode, xmlnode, context);
            } else if (regionType == "XML_TAG_CLOSE" || regionType == "XML_EMPTY_TAG_CLOSE") {
                contentAssistRequest = this.computeTagCloseProposals(matchString, completionRegion, treeNode, xmlnode, context);
            } else if (regionType == "XML_END_TAG_OPEN") {
                contentAssistRequest = this.computeEndTagOpenProposals(matchString, completionRegion, treeNode, xmlnode, context);
            } else if (regionType == "XML_CONTENT" || regionType == "XML_CHAR_REFERENCE" || regionType == "XML_ENTITY_REFERENCE" || regionType == "XML_PE_REFERENCE") {
                contentAssistRequest = this.computeContentProposals(matchString, completionRegion, treeNode, xmlnode, context);
            } else if (documentPosition == sdRegion.getStartOffset(completionRegion) && (regionType == "XML_DECLARATION_OPEN" || regionType == "XML_PI_OPEN" || regionType == "XML_COMMENT_OPEN" || regionType == "XML_CDATA_OPEN")) {
                contentAssistRequest = new ContentAssistRequest((Node)treeNode, xmlnode.getParentNode(), sdRegion, completionRegion, documentPosition, 0, matchString);
                this.addTagInsertionProposals(contentAssistRequest, this.getElementPosition((Node)treeNode), context);
                this.addStartDocumentProposals(contentAssistRequest, context);
            }
        } else if (this.isCloseRegion(completionRegion)) {
            contentAssistRequest = new ContentAssistRequest((Node)treeNode, xmlnode.getParentNode(), sdRegion, completionRegion, sdRegion.getStartOffset(completionRegion) + completionRegion.getLength(), 0, matchString);
            this.addStartDocumentProposals(contentAssistRequest, context);
            if (documentPosition >= sdRegion.getTextEndOffset(completionRegion)) {
                this.addTagInsertionProposals(contentAssistRequest, this.getElementPosition((Node)treeNode) + 1, context);
            }
        } else if (documentPosition == sdRegion.getStartOffset(completionRegion) && (regionType == "XML_DECLARATION_OPEN" || regionType == "XML_PI_OPEN" || regionType == "XML_COMMENT_OPEN" || regionType == "XML_CDATA_OPEN")) {
            contentAssistRequest = new ContentAssistRequest((Node)treeNode, xmlnode.getParentNode(), sdRegion, completionRegion, documentPosition, 0, matchString);
            this.addTagInsertionProposals(contentAssistRequest, this.getElementPosition((Node)treeNode), context);
            this.addStartDocumentProposals(contentAssistRequest, context);
        }
        return contentAssistRequest;
    }

    protected final ContentAssistRequest computeAttributeProposals(String matchString, ITextRegion completionRegion, IDOMNode nodeAtOffset, IDOMNode node, CompletionProposalInvocationContext context) {
        int documentPosition = context.getInvocationOffset();
        ITextViewer viewer = context.getViewer();
        ContentAssistRequest contentAssistRequest = null;
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        contentAssistRequest = documentPosition <= sdRegion.getStartOffset(completionRegion) && viewer != null && viewer.getSelectedRange().y != sdRegion.getEndOffset(completionRegion) - sdRegion.getStartOffset(completionRegion) ? new ContentAssistRequest((Node)nodeAtOffset, (Node)node, sdRegion, completionRegion, documentPosition, 0, matchString) : new ContentAssistRequest((Node)nodeAtOffset, (Node)node, sdRegion, completionRegion, sdRegion.getStartOffset(completionRegion), completionRegion.getTextLength(), matchString);
        this.addAttributeNameProposals(contentAssistRequest, context);
        contentAssistRequest.setReplacementBeginPosition(documentPosition);
        contentAssistRequest.setReplacementLength(0);
        if (node.getFirstStructuredDocumentRegion() != null && !node.getFirstStructuredDocumentRegion().isEnded()) {
            this.addTagCloseProposals(contentAssistRequest, context);
        }
        return contentAssistRequest;
    }

    protected static int getCursorPositionForProposedText(String proposedText) {
        int cursorAdjustment = proposedText.indexOf("\"\"") + 1;
        if (cursorAdjustment == 0) {
            cursorAdjustment = proposedText.indexOf(62) + 1;
        }
        if (cursorAdjustment == 0) {
            cursorAdjustment = proposedText.length() + 1;
        }
        return cursorAdjustment;
    }

    protected static boolean beginsWith(String aString, String prefix) {
        if (aString == null || prefix == null) {
            return true;
        }
        return aString.toLowerCase().startsWith(prefix.toLowerCase());
    }

    private ContentAssistRequest computeAttributeValueProposals(String matchString, ITextRegion completionRegion, IDOMNode nodeAtOffset, IDOMNode node, CompletionProposalInvocationContext context) {
        int documentPosition = context.getInvocationOffset();
        ContentAssistRequest contentAssistRequest = null;
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        if (documentPosition > sdRegion.getStartOffset(completionRegion) + completionRegion.getTextLength() && sdRegion.getStartOffset(completionRegion) + completionRegion.getTextLength() != sdRegion.getStartOffset(completionRegion) + completionRegion.getLength()) {
            IDOMNode actualNode = (IDOMNode)node.getModel().getIndexedRegion(sdRegion.getStartOffset(completionRegion));
            contentAssistRequest = new ContentAssistRequest((Node)actualNode, (Node)actualNode, sdRegion, completionRegion, documentPosition, 0, matchString);
            this.addAttributeNameProposals(contentAssistRequest, context);
            if (actualNode.getFirstStructuredDocumentRegion() != null && !actualNode.getFirstStructuredDocumentRegion().isEnded()) {
                this.addTagCloseProposals(contentAssistRequest, context);
            }
        } else if (!nodeAtOffset.getFirstStructuredDocumentRegion().isEnded() && documentPosition < sdRegion.getStartOffset(completionRegion)) {
            contentAssistRequest = new ContentAssistRequest((Node)nodeAtOffset, (Node)node, sdRegion, completionRegion, documentPosition, 0, matchString);
            this.addAttributeNameProposals(contentAssistRequest, context);
        } else {
            int replaceLength = completionRegion.getTextLength();
            if (completionRegion instanceof ITextRegionContainer) {
                ITextRegion openRegion = ((ITextRegionContainer)completionRegion).getFirstRegion();
                ITextRegion closeRegion = ((ITextRegionContainer)completionRegion).getLastRegion();
                if (openRegion.getType() != closeRegion.getType()) {
                    replaceLength = openRegion.getTextLength();
                }
            }
            contentAssistRequest = new ContentAssistRequest((Node)nodeAtOffset, (Node)node, sdRegion, completionRegion, sdRegion.getStartOffset(completionRegion), replaceLength, matchString);
            this.addAttributeValueProposals(contentAssistRequest, context);
        }
        return contentAssistRequest;
    }

    private ContentAssistRequest computeContentProposals(String matchString, ITextRegion completionRegion, IDOMNode nodeAtOffset, IDOMNode node, CompletionProposalInvocationContext context) {
        int documentPosition = context.getInvocationOffset();
        ContentAssistRequest contentAssistRequest = null;
        contentAssistRequest = new ContentAssistRequest((Node)nodeAtOffset, (Node)node, this.getStructuredDocumentRegion(documentPosition), completionRegion, documentPosition, 0, matchString);
        if (node != null && node.getNodeType() == 9 && ((Document)node).getDoctype() == null) {
            this.addStartDocumentProposals(contentAssistRequest, context);
        }
        this.addTagInsertionProposals(contentAssistRequest, this.getElementPosition((Node)nodeAtOffset), context);
        if (node.getNodeType() != 9) {
            this.addEndTagProposals(contentAssistRequest, context);
        }
        this.addEntityProposals(contentAssistRequest, completionRegion, node, context);
        return contentAssistRequest;
    }

    private ContentAssistRequest computeEndTagOpenProposals(String matchString, ITextRegion completionRegion, IDOMNode nodeAtOffset, IDOMNode node, CompletionProposalInvocationContext context) {
        int documentPosition = context.getInvocationOffset();
        ContentAssistRequest contentAssistRequest = null;
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        int completionRegionStart = sdRegion.getStartOffset(completionRegion);
        int completionRegionLength = completionRegion.getLength();
        IStructuredDocumentRegion sdRegionAtCompletionOffset = node.getStructuredDocument().getRegionAtCharacterOffset(completionRegionStart + completionRegionLength);
        ITextRegion regionAtEndOfCompletion = sdRegionAtCompletionOffset.getRegionAtCharacterOffset(completionRegionStart + completionRegionLength);
        if (documentPosition != completionRegionStart && regionAtEndOfCompletion != null && regionAtEndOfCompletion.getType() == "XML_TAG_NAME") {
            ITextRegion nameRegion = regionAtEndOfCompletion;
            contentAssistRequest = new ContentAssistRequest((Node)nodeAtOffset, nodeAtOffset.getParentNode(), sdRegion, completionRegion, sdRegion.getStartOffset(nameRegion), nameRegion.getTextLength(), matchString);
        } else {
            contentAssistRequest = nodeAtOffset.getFirstStructuredDocumentRegion() == sdRegion ? new ContentAssistRequest((Node)nodeAtOffset, nodeAtOffset.getParentNode(), sdRegion, completionRegion, documentPosition, 0, matchString) : new ContentAssistRequest((Node)nodeAtOffset, (Node)nodeAtOffset, sdRegion, completionRegion, documentPosition, 0, matchString);
        }
        this.addEndTagProposals(contentAssistRequest, context);
        if (completionRegionStart == documentPosition) {
            this.addTagInsertionProposals(contentAssistRequest, node.getChildNodes().getLength(), context);
        }
        return contentAssistRequest;
    }

    private ContentAssistRequest computeEqualsProposals(String matchString, ITextRegion completionRegion, IDOMNode nodeAtOffset, IDOMNode node, CompletionProposalInvocationContext context) {
        int documentPosition = context.getInvocationOffset();
        ContentAssistRequest contentAssistRequest = null;
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        ITextRegion valueRegion = node.getStartStructuredDocumentRegion().getRegionAtCharacterOffset(sdRegion.getStartOffset(completionRegion) + completionRegion.getLength());
        contentAssistRequest = valueRegion != null && valueRegion.getType() == "XML_TAG_ATTRIBUTE_VALUE" && sdRegion.getStartOffset(valueRegion) <= documentPosition ? new ContentAssistRequest((Node)nodeAtOffset, (Node)node, sdRegion, valueRegion, sdRegion.getStartOffset(valueRegion), valueRegion.getTextLength(), matchString) : new ContentAssistRequest((Node)nodeAtOffset, (Node)node, sdRegion, completionRegion, documentPosition, 0, matchString);
        this.addAttributeValueProposals(contentAssistRequest, context);
        return contentAssistRequest;
    }

    private ContentAssistRequest computeStartDocumentProposals(String matchString, ITextRegion completionRegion, IDOMNode nodeAtOffset, IDOMNode node, CompletionProposalInvocationContext context) {
        int documentPosition = context.getInvocationOffset();
        ContentAssistRequest contentAssistRequest = null;
        contentAssistRequest = new ContentAssistRequest((Node)nodeAtOffset, (Node)node, this.getStructuredDocumentRegion(documentPosition), completionRegion, documentPosition, 0, matchString);
        this.addStartDocumentProposals(contentAssistRequest, context);
        return contentAssistRequest;
    }

    private ContentAssistRequest computeTagCloseProposals(String matchString, ITextRegion completionRegion, IDOMNode nodeAtOffset, IDOMNode node, CompletionProposalInvocationContext context) {
        int documentPosition = context.getInvocationOffset();
        ContentAssistRequest contentAssistRequest = null;
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        if (node.getNodeType() == 9 || documentPosition >= sdRegion.getEndOffset()) {
            if (node == nodeAtOffset && node.getParentNode() != null) {
                node = (IDOMNode)node.getParentNode();
            }
            contentAssistRequest = new ContentAssistRequest((Node)nodeAtOffset, (Node)node, sdRegion, completionRegion, documentPosition, 0, matchString);
            this.addTagInsertionProposals(contentAssistRequest, this.getElementPosition((Node)nodeAtOffset), context);
            if (node.getNodeType() != 9 && node.getEndStructuredDocumentRegion() == null) {
                this.addEndTagProposals(contentAssistRequest, context);
            }
        } else {
            boolean insideTag;
            ITextRegion closeRegion = sdRegion.getLastRegion();
            boolean bl = insideTag = !sdRegion.isEnded() || documentPosition <= sdRegion.getStartOffset(closeRegion);
            if (insideTag) {
                contentAssistRequest = new ContentAssistRequest((Node)nodeAtOffset, (Node)node, sdRegion, completionRegion, documentPosition, 0, matchString);
                if (node.getNodeType() != 9 && node.getEndStructuredDocumentRegion() != null) {
                    this.addTagCloseProposals(contentAssistRequest, context);
                }
                if (sdRegion == nodeAtOffset.getFirstStructuredDocumentRegion()) {
                    contentAssistRequest.setReplacementBeginPosition(documentPosition);
                    contentAssistRequest.setReplacementLength(0);
                    this.addAttributeNameProposals(contentAssistRequest, context);
                }
            }
        }
        return contentAssistRequest;
    }

    private ContentAssistRequest computeTagNameProposals(String matchString, ITextRegion completionRegion, IDOMNode nodeAtOffset, IDOMNode node, CompletionProposalInvocationContext context) {
        int documentPosition = context.getInvocationOffset();
        ContentAssistRequest contentAssistRequest = null;
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        if (sdRegion != nodeAtOffset.getFirstStructuredDocumentRegion()) {
            IDOMNode actualNode = (IDOMNode)node.getModel().getIndexedRegion(sdRegion.getStartOffset(completionRegion));
            if (actualNode != null) {
                if (actualNode.getFirstStructuredDocumentRegion() == sdRegion) {
                    if (documentPosition > sdRegion.getStartOffset(completionRegion) + completionRegion.getLength()) {
                        contentAssistRequest = new ContentAssistRequest((Node)actualNode, (Node)actualNode, sdRegion, completionRegion, documentPosition - matchString.length(), matchString.length(), matchString);
                        if (node.getStructuredDocument().getRegionAtCharacterOffset(sdRegion.getStartOffset(completionRegion) - 1).getRegionAtCharacterOffset(sdRegion.getStartOffset(completionRegion) - 1).getType() == "XML_TAG_OPEN") {
                            this.addAttributeNameProposals(contentAssistRequest, context);
                        }
                        this.addTagCloseProposals(contentAssistRequest, context);
                    } else {
                        contentAssistRequest = new ContentAssistRequest((Node)actualNode, actualNode.getParentNode(), sdRegion, completionRegion, documentPosition - matchString.length(), matchString.length(), matchString);
                        this.addTagNameProposals(contentAssistRequest, this.getElementPosition((Node)actualNode), context);
                    }
                } else {
                    contentAssistRequest = documentPosition >= sdRegion.getStartOffset(completionRegion) + completionRegion.getLength() ? new ContentAssistRequest((Node)actualNode, actualNode.getParentNode(), sdRegion, completionRegion, documentPosition, 0, matchString) : new ContentAssistRequest((Node)actualNode, actualNode.getParentNode(), sdRegion, completionRegion, sdRegion.getStartOffset(completionRegion), completionRegion.getTextLength(), matchString);
                    this.addEndTagNameProposals(contentAssistRequest, context);
                }
            }
        } else if (documentPosition > sdRegion.getStartOffset(completionRegion) + completionRegion.getTextLength()) {
            contentAssistRequest = new ContentAssistRequest((Node)nodeAtOffset, (Node)node, sdRegion, completionRegion, documentPosition - matchString.length(), matchString.length(), matchString);
            this.addAttributeNameProposals(contentAssistRequest, context);
            this.addTagCloseProposals(contentAssistRequest, context);
        } else if (sdRegion.getRegions().get(0).getType() != "XML_END_TAG_OPEN") {
            int replaceLength = documentPosition - sdRegion.getStartOffset(completionRegion);
            contentAssistRequest = new ContentAssistRequest((Node)node, node.getParentNode(), sdRegion, completionRegion, sdRegion.getStartOffset(completionRegion), replaceLength, matchString);
            this.addTagNameProposals(contentAssistRequest, this.getElementPosition((Node)nodeAtOffset), context);
        } else {
            IDOMNode actualNode = (IDOMNode)node.getModel().getIndexedRegion(documentPosition);
            if (actualNode != null) {
                contentAssistRequest = documentPosition >= sdRegion.getStartOffset(completionRegion) + completionRegion.getTextLength() ? new ContentAssistRequest((Node)actualNode, actualNode.getParentNode(), sdRegion, completionRegion, documentPosition, 0, matchString) : new ContentAssistRequest((Node)actualNode, actualNode.getParentNode(), sdRegion, completionRegion, sdRegion.getStartOffset(completionRegion), completionRegion.getTextLength(), matchString);
                this.addEndTagNameProposals(contentAssistRequest, context);
            }
        }
        return contentAssistRequest;
    }

    private ContentAssistRequest computeTagOpenProposals(String matchString, ITextRegion completionRegion, IDOMNode nodeAtOffset, IDOMNode node, CompletionProposalInvocationContext context) {
        int documentPosition = context.getInvocationOffset();
        ContentAssistRequest contentAssistRequest = null;
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        if (sdRegion != nodeAtOffset.getFirstStructuredDocumentRegion() || sdRegion.getPrevious() != null && sdRegion.getPrevious().getLastRegion().getType() == "XML_TAG_OPEN") {
            IDOMNode actualNode = (IDOMNode)node.getModel().getIndexedRegion(sdRegion.getStartOffset(completionRegion));
            if (actualNode != null) {
                if (sdRegion.getFirstRegion().getType() == "XML_END_TAG_OPEN") {
                    contentAssistRequest = new ContentAssistRequest((Node)actualNode, (Node)actualNode, sdRegion, completionRegion, documentPosition, 0, matchString);
                    if (actualNode.hasChildNodes()) {
                        this.addTagNameProposals(contentAssistRequest, this.getElementPosition(actualNode.getLastChild()), context);
                    } else {
                        this.addTagNameProposals(contentAssistRequest, 0, context);
                    }
                } else {
                    contentAssistRequest = new ContentAssistRequest((Node)actualNode, actualNode.getParentNode(), sdRegion, completionRegion, documentPosition, 0, matchString);
                    this.addTagNameProposals(contentAssistRequest, this.getElementPosition((Node)actualNode), context);
                }
                this.addEndTagProposals(contentAssistRequest, context);
            }
        } else if (documentPosition == sdRegion.getStartOffset(completionRegion)) {
            if (node.getNodeType() == 1) {
                contentAssistRequest = new ContentAssistRequest((Node)nodeAtOffset, node.getParentNode(), sdRegion, completionRegion, documentPosition, 0, matchString);
                this.addTagInsertionProposals(contentAssistRequest, this.getElementPosition((Node)nodeAtOffset), context);
                this.addEndTagProposals(contentAssistRequest, context);
            } else if (node.getNodeType() == 9) {
                contentAssistRequest = new ContentAssistRequest((Node)nodeAtOffset, node.getParentNode(), sdRegion, completionRegion, sdRegion.getStartOffset(completionRegion), completionRegion.getTextLength(), matchString);
                this.addStartDocumentProposals(contentAssistRequest, context);
            }
        } else {
            ITextRegion name = this.getNameRegion(node.getStartStructuredDocumentRegion());
            if (name != null && sdRegion.getStartOffset(name) <= documentPosition && sdRegion.getEndOffset(name) >= documentPosition && (sdRegion.getLastRegion().getType() == "XML_TAG_CLOSE" || sdRegion.getLastRegion().getType() == "XML_EMPTY_TAG_CLOSE")) {
                contentAssistRequest = new ContentAssistRequest((Node)node, node.getParentNode(), sdRegion, completionRegion, sdRegion.getStartOffset(name), name.getTextLength(), matchString);
            } else {
                contentAssistRequest = new ContentAssistRequest((Node)nodeAtOffset, nodeAtOffset.getParentNode(), sdRegion, completionRegion, documentPosition, 0, matchString);
                this.addEndTagProposals(contentAssistRequest, context);
                contentAssistRequest.setReplacementBeginPosition(documentPosition);
                contentAssistRequest.setReplacementLength(0);
            }
            this.addTagNameProposals(contentAssistRequest, this.getElementPosition((Node)nodeAtOffset), context);
        }
        return contentAssistRequest;
    }

    private ITextRegion getCompletionRegion(int offset, IStructuredDocumentRegion sdRegion) {
        ITextRegion nextRegion;
        ITextRegion previousRegion;
        ITextRegion region = sdRegion.getRegionAtCharacterOffset(offset);
        if (region == null) {
            return null;
        }
        if (sdRegion.getStartOffset(region) == offset) {
            if (sdRegion.getStartOffset(region) == sdRegion.getStartOffset() && sdRegion.getPrevious() != null && !sdRegion.getPrevious().isEnded()) {
                region = sdRegion.getPrevious().getRegionAtCharacterOffset(offset - 1);
            } else {
                previousRegion = sdRegion.getRegionAtCharacterOffset(offset - 1);
                if (previousRegion != null && previousRegion != region && previousRegion.getTextLength() == previousRegion.getLength()) {
                    region = previousRegion;
                }
            }
        } else if (offset > sdRegion.getStartOffset(region) + region.getTextLength() && (nextRegion = sdRegion.getRegionAtCharacterOffset(sdRegion.getStartOffset(region) + region.getLength())) != null) {
            region = nextRegion;
        }
        if (region != null && region.getType() == "WHITE_SPACE" && (previousRegion = sdRegion.getRegionAtCharacterOffset(sdRegion.getStartOffset(region) - 1)) != null) {
            region = previousRegion;
        }
        return region;
    }

    private ITextRegion getCompletionRegion(int documentPosition, Node domnode) {
        if (domnode == null) {
            return null;
        }
        ITextRegion region = null;
        int offset = documentPosition;
        IStructuredDocumentRegion flatNode = null;
        IDOMNode node = (IDOMNode)domnode;
        if (node.getNodeType() == 9) {
            if (node.getStructuredDocument().getLength() == 0) {
                return null;
            }
            ITextRegion result = node.getStructuredDocument().getRegionAtCharacterOffset(offset).getRegionAtCharacterOffset(offset);
            while (result == null) {
                result = node.getStructuredDocument().getRegionAtCharacterOffset(--offset).getRegionAtCharacterOffset(offset);
            }
            return result;
        }
        IStructuredDocumentRegion startTag = node.getStartStructuredDocumentRegion();
        IStructuredDocumentRegion endTag = node.getEndStructuredDocumentRegion();
        if (startTag != null && startTag.getStartOffset() <= offset && offset < startTag.getStartOffset() + startTag.getLength()) {
            flatNode = startTag;
        } else if (endTag != null && endTag.getStartOffset() <= offset && offset < endTag.getStartOffset() + endTag.getLength()) {
            flatNode = endTag;
        }
        region = flatNode != null ? this.getCompletionRegion(offset, flatNode) : ((flatNode = node.getStructuredDocument().getRegionAtCharacterOffset(offset)).getStartOffset() <= documentPosition && flatNode.getEndOffset() >= documentPosition ? (offset == flatNode.getStartOffset() && flatNode.getPrevious() != null && (flatNode.getRegionAtCharacterOffset(documentPosition) != null && flatNode.getRegionAtCharacterOffset(documentPosition).getType() != "XML_CONTENT" || flatNode.getPrevious().getLastRegion().getType() == "XML_TAG_OPEN" || flatNode.getPrevious().getLastRegion().getType() == "XML_END_TAG_OPEN") ? flatNode.getPrevious().getLastRegion() : (flatNode.getEndOffset() == documentPosition ? flatNode.getLastRegion() : flatNode.getFirstRegion())) : flatNode.getLastRegion());
        return region;
    }

    private int getElementPosition(Node child) {
        Node parent = child.getParentNode();
        if (parent == null) {
            return 0;
        }
        NodeList children = parent.getChildNodes();
        if (children == null) {
            return 0;
        }
        int count = 0;
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i) == child) {
                return count;
            }
            ++count;
            ++i;
        }
        return 0;
    }

    protected String getMatchString(IStructuredDocumentRegion parent, ITextRegion aRegion, int offset) throws BadLocationException {
        if (aRegion == null || this.isCloseRegion(aRegion)) {
            return "";
        }
        String matchString = null;
        String regionType = aRegion.getType();
        if (regionType == "XML_TAG_ATTRIBUTE_EQUALS" || regionType == "XML_TAG_OPEN" || offset > parent.getStartOffset(aRegion) + aRegion.getTextLength()) {
            matchString = "";
        } else if (regionType == "XML_CONTENT" || regionType == "XML_END_TAG_OPEN") {
            int begin = parent.getPrevious().getStartOffset();
            int length = offset - parent.getPrevious().getStart();
            matchString = parent.getParentDocument().get(begin, length);
            if (matchString.length() > 0 && AbstractJpaXmlCompletionProposalComputer.beginsWith(matchString, "<")) {
                matchString = matchString.contains(">") ? parent.getParentDocument().get(begin + matchString.indexOf(62) + 1, length - matchString.indexOf(62) - 1) : "";
            }
            while (matchString.length() > 0 && Character.isWhitespace(matchString.charAt(0))) {
                matchString = matchString.substring(1);
            }
        } else {
            matchString = parent.getText(aRegion).length() > 0 && parent.getStartOffset(aRegion) < offset ? parent.getText(aRegion).substring(0, offset - parent.getStartOffset(aRegion)) : "";
        }
        return matchString;
    }

    private ITextRegion getNameRegion(IStructuredDocumentRegion flatNode) {
        if (flatNode == null) {
            return null;
        }
        for (ITextRegion region : flatNode.getRegions()) {
            if (!this.isNameRegion(region)) continue;
            return region;
        }
        return null;
    }

    private boolean isCloseRegion(ITextRegion region) {
        String type = region.getType();
        return type == "XML_PI_CLOSE" || type == "XML_TAG_CLOSE" || type == "XML_EMPTY_TAG_CLOSE" || type == "XML_CDATA_CLOSE" || type == "XML_COMMENT_CLOSE" || type == "XML_ATTLIST_DECL_CLOSE" || type == "XML_ELEMENT_DECL_CLOSE" || type == "XML_DOCTYPE_DECLARATION_CLOSE" || type == "XML_DECLARATION_CLOSE";
    }

    private boolean isNameRegion(ITextRegion region) {
        String type = region.getType();
        return type == "XML_TAG_NAME" || type == "XML_ELEMENT_DECL_NAME" || type == "XML_DOCTYPE_NAME" || type == "XML_ATTLIST_DECL_NAME";
    }

    private IStructuredDocumentRegion getStructuredDocumentRegion(int pos) {
        return ContentAssistUtils.getStructuredDocumentRegion((ITextViewer)this.fTextViewer, (int)pos);
    }
}

