/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.Collection;
import org.eclipse.jpt.common.ui.internal.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.StringConverter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.ui.internal.details.DiscriminatorColumnComposite;
import org.eclipse.jpt.jpa.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInheritanceComposite<T extends Entity>
extends Pane<T> {
    public AbstractInheritanceComposite(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent, false);
    }

    protected void initializeLayout(Composite container) {
        int groupBoxMargin = this.getGroupBoxMargin();
        Composite subPane = this.addSubPane(container, 0, groupBoxMargin, 0, groupBoxMargin);
        this.addLabeledComposite(subPane, JptUiDetailsMessages.InheritanceComposite_strategy, (Pane)this.addStrategyCombo(subPane), "org.eclipse.jpt.jpa.ui.entity_inheritanceStrategy");
        ModifiablePropertyValueModel<Boolean> dvEnabled = this.buildDiscriminatorValueEnabledHolder();
        Combo discriminatorValueCombo = this.addEditableCombo(subPane, (ListValueModel)this.buildDiscriminatorValueListHolder(), (ModifiablePropertyValueModel)this.buildDiscriminatorValueHolder(), StringConverter.Default.instance(), (PropertyValueModel)dvEnabled);
        Label discriminatorValueLabel = this.addLabel(subPane, JptUiDetailsMessages.InheritanceComposite_discriminatorValue, (PropertyValueModel)dvEnabled);
        this.addLabeledComposite(subPane, (Control)discriminatorValueLabel, (Control)discriminatorValueCombo, null, "org.eclipse.jpt.jpa.ui.entity_inheritanceDiscriminatorValue");
        new DiscriminatorColumnComposite(this, container);
        this.addPrimaryKeyJoinColumnsComposite(this.addSubPane(container, 5));
    }

    protected ModifiablePropertyValueModel<Boolean> buildDiscriminatorValueEnabledHolder() {
        return new PropertyAspectAdapter<Entity, Boolean>(this.getSubjectHolder(), new String[]{"discriminatorValueIsAllowed"}){

            protected Boolean buildValue_() {
                return ((Entity)this.subject).specifiedDiscriminatorValueIsAllowed();
            }
        };
    }

    private ListValueModel<String> buildDefaultDiscriminatorListValueHolder() {
        return new PropertyListValueModelAdapter(this.buildDefaultDiscriminatorValueHolder());
    }

    private ModifiablePropertyValueModel<String> buildDefaultDiscriminatorValueHolder() {
        return new PropertyAspectAdapter<Entity, String>(this.getSubjectHolder(), new String[]{"defaultDiscriminatorValue", "discriminatorValueIsUndefined"}){

            protected String buildValue_() {
                return AbstractInheritanceComposite.this.defaultValue((Entity)this.subject);
            }
        };
    }

    private String defaultValue(Entity subject) {
        String defaultValue = subject.getDefaultDiscriminatorValue();
        if (defaultValue == null && subject.discriminatorValueIsUndefined()) {
            return JptCommonUiMessages.NoneSelected;
        }
        if (defaultValue != null && defaultValue.length() > 0) {
            return NLS.bind((String)JptCommonUiMessages.DefaultWithOneParam, (Object)defaultValue);
        }
        return JptUiDetailsMessages.ProviderDefault;
    }

    private ModifiablePropertyValueModel<String> buildDiscriminatorValueHolder() {
        return new PropertyAspectAdapter<Entity, String>(this.getSubjectHolder(), new String[]{"specifiedDiscriminatorValue"}){

            protected String buildValue_() {
                String value = ((Entity)this.subject).getSpecifiedDiscriminatorValue();
                if (value == null) {
                    return AbstractInheritanceComposite.this.defaultValue((Entity)this.subject);
                }
                return value;
            }

            protected void setValue_(String value) {
                if (AbstractInheritanceComposite.this.defaultValue((Entity)this.subject).equals(value)) {
                    value = null;
                }
                ((Entity)this.subject).setSpecifiedDiscriminatorValue(value);
            }
        };
    }

    private ListValueModel<String> buildDiscriminatorValueListHolder() {
        return this.buildDefaultDiscriminatorListValueHolder();
    }

    private EnumFormComboViewer<Entity, InheritanceType> addStrategyCombo(Composite container) {
        return new EnumFormComboViewer<Entity, InheritanceType>((Pane)this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultInheritanceStrategy");
                propertyNames.add("specifiedInheritanceStrategy");
            }

            protected InheritanceType[] getChoices() {
                return InheritanceType.values();
            }

            protected InheritanceType getDefaultValue() {
                return ((Entity)this.getSubject()).getDefaultInheritanceStrategy();
            }

            protected String displayString(InheritanceType value) {
                switch (value) {
                    case JOINED: {
                        return JptUiDetailsMessages.AbstractInheritanceComposite_joined;
                    }
                    case SINGLE_TABLE: {
                        return JptUiDetailsMessages.AbstractInheritanceComposite_single_table;
                    }
                    case TABLE_PER_CLASS: {
                        return JptUiDetailsMessages.AbstractInheritanceComposite_table_per_class;
                    }
                }
                throw new IllegalStateException();
            }

            protected InheritanceType getValue() {
                return ((Entity)this.getSubject()).getSpecifiedInheritanceStrategy();
            }

            protected void setValue(InheritanceType value) {
                ((Entity)this.getSubject()).setSpecifiedInheritanceStrategy(value);
            }
        };
    }

    protected abstract void addPrimaryKeyJoinColumnsComposite(Composite var1);
}

