/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.util.ControlSwitcher;
import org.eclipse.jpt.common.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.common.ui.internal.utility.swt.SWTTools;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Transformer;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationWritablePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.AssociationOverride;
import org.eclipse.jpt.jpa.core.context.AssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.AttributeOverride;
import org.eclipse.jpt.jpa.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.Override_;
import org.eclipse.jpt.jpa.core.context.ReadOnlyAssociationOverride;
import org.eclipse.jpt.jpa.core.context.ReadOnlyAttributeOverride;
import org.eclipse.jpt.jpa.core.context.ReadOnlyOverride;
import org.eclipse.jpt.jpa.core.context.VirtualAssociationOverride;
import org.eclipse.jpt.jpa.core.context.VirtualAttributeOverride;
import org.eclipse.jpt.jpa.core.context.VirtualOverride;
import org.eclipse.jpt.jpa.ui.internal.details.AssociationOverrideComposite;
import org.eclipse.jpt.jpa.ui.internal.details.AttributeOverrideComposite;
import org.eclipse.jpt.jpa.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOverridesComposite<T extends JpaContextNode>
extends Pane<T> {
    private Pane<ReadOnlyAttributeOverride> attributeOverridePane;
    private Pane<ReadOnlyAssociationOverride> associationOverridePane;
    private ModifiablePropertyValueModel<ReadOnlyOverride> selectedOverrideHolder;
    private ModifiablePropertyValueModel<Boolean> overrideVirtualOverrideHolder;

    protected AbstractOverridesComposite(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent, false);
    }

    protected void initialize() {
        super.initialize();
        this.selectedOverrideHolder = this.buildSelectedOverrideHolder();
    }

    private ModifiablePropertyValueModel<ReadOnlyOverride> buildSelectedOverrideHolder() {
        return new SimplePropertyValueModel();
    }

    protected abstract boolean supportsAssociationOverrides();

    protected void initializeLayout(Composite container) {
        container = this.addTitledGroup(container, JptUiDetailsMessages.OverridesComposite_attributeOverridesGroup);
        this.initializeOverridesList(container);
        int groupBoxMargin = this.getGroupBoxMargin();
        Button overrideCheckBox = this.addCheckBox(this.addSubPane(container, 0, groupBoxMargin, 0, groupBoxMargin), JptUiDetailsMessages.OverridesComposite_overrideDefault, this.getOverrideVirtualOverrideHolder(), null);
        SWTTools.controlVisibleState(this.buildSelectedOverrideBooleanHolder(), (Control[])new Control[]{overrideCheckBox});
        PageBook pageBook = this.addPageBook(container);
        this.initializeOverridePanes(pageBook);
        this.installOverrideControlSwitcher((PropertyValueModel<ReadOnlyOverride>)this.selectedOverrideHolder, pageBook);
    }

    protected void initializeOverridePanes(PageBook pageBook) {
        this.initializeAttributeOverridePane(pageBook);
        if (this.supportsAssociationOverrides()) {
            this.initializeAssociationOverridePane(pageBook);
        }
    }

    private PropertyValueModel<Boolean> buildSelectedOverrideBooleanHolder() {
        return new TransformationPropertyValueModel<ReadOnlyOverride, Boolean>(this.selectedOverrideHolder){

            protected Boolean transform(ReadOnlyOverride value) {
                return value != null;
            }
        };
    }

    private void initializeOverridesList(Composite container) {
        new AddRemoveListPane<T>(this, this.addSubPane(container, 8), this.buildOverridesAdapter(), this.buildOverridesListModel(), this.selectedOverrideHolder, this.buildOverrideLabelProvider(), "org.eclipse.jpt.jpa.ui.entity_attributeOverrides"){

            protected void initializeButtonPane(Composite c, String helpId) {
            }

            protected void updateButtons() {
            }
        };
    }

    protected void initializeAttributeOverridePane(PageBook pageBook) {
        ModifiablePropertyValueModel<ReadOnlyAttributeOverride> attributeOverrideHolder = this.buildAttributeOverrideHolder();
        this.attributeOverridePane = this.buildAttributeOverridePane(pageBook, (PropertyValueModel<ReadOnlyAttributeOverride>)attributeOverrideHolder);
        this.installAttributeOverridePaneEnabler(this.attributeOverridePane, (PropertyValueModel<ReadOnlyAttributeOverride>)attributeOverrideHolder);
    }

    protected Pane<ReadOnlyAttributeOverride> buildAttributeOverridePane(PageBook pageBook, PropertyValueModel<ReadOnlyAttributeOverride> attributeOverrideHolder) {
        return new AttributeOverrideComposite(this, attributeOverrideHolder, (Composite)pageBook);
    }

    private void installAttributeOverridePaneEnabler(Pane<ReadOnlyAttributeOverride> pane, PropertyValueModel<ReadOnlyAttributeOverride> overrideHolder) {
        new PaneEnabler(this.buildOverrideBooleanHolder(overrideHolder), pane);
    }

    private PropertyValueModel<Boolean> buildOverrideBooleanHolder(PropertyValueModel<? extends ReadOnlyOverride> overrideHolder) {
        return new TransformationPropertyValueModel<ReadOnlyOverride, Boolean>(overrideHolder){

            protected Boolean transform_(ReadOnlyOverride v) {
                return !v.isVirtual();
            }
        };
    }

    protected void initializeAssociationOverridePane(PageBook pageBook) {
        ModifiablePropertyValueModel<ReadOnlyAssociationOverride> associationOverrideHolder = this.buildAssociationOverrideHolder();
        this.associationOverridePane = this.buildAssociationOverridePane(pageBook, (PropertyValueModel<ReadOnlyAssociationOverride>)associationOverrideHolder);
        this.installAssociationOverridePaneEnabler(this.associationOverridePane, (PropertyValueModel<ReadOnlyAssociationOverride>)associationOverrideHolder);
    }

    protected Pane<ReadOnlyAssociationOverride> buildAssociationOverridePane(PageBook pageBook, PropertyValueModel<ReadOnlyAssociationOverride> associationOverrideHolder) {
        return new AssociationOverrideComposite(this, associationOverrideHolder, (Composite)pageBook);
    }

    private void installAssociationOverridePaneEnabler(Pane<ReadOnlyAssociationOverride> pane, PropertyValueModel<ReadOnlyAssociationOverride> overrideHolder) {
        new PaneEnabler(this.buildOverrideBooleanHolder(overrideHolder), pane);
    }

    private void installOverrideControlSwitcher(PropertyValueModel<ReadOnlyOverride> overrideHolder, PageBook pageBook) {
        new ControlSwitcher(overrideHolder, this.buildPaneTransformer(), pageBook);
    }

    private ModifiablePropertyValueModel<ReadOnlyAssociationOverride> buildAssociationOverrideHolder() {
        return new TransformationWritablePropertyValueModel<ReadOnlyOverride, ReadOnlyAssociationOverride>(this.selectedOverrideHolder){

            protected ReadOnlyAssociationOverride transform_(ReadOnlyOverride v) {
                return v instanceof ReadOnlyAssociationOverride ? (ReadOnlyAssociationOverride)v : null;
            }
        };
    }

    private ModifiablePropertyValueModel<ReadOnlyAttributeOverride> buildAttributeOverrideHolder() {
        return new TransformationWritablePropertyValueModel<ReadOnlyOverride, ReadOnlyAttributeOverride>(this.selectedOverrideHolder){

            protected ReadOnlyAttributeOverride transform_(ReadOnlyOverride v) {
                return v instanceof ReadOnlyAttributeOverride ? (ReadOnlyAttributeOverride)v : null;
            }
        };
    }

    private ListValueModel<VirtualAssociationOverride> buildDefaultAssociationOverridesListHolder(PropertyValueModel<AssociationOverrideContainer> containerHolder) {
        return new ListAspectAdapter<AssociationOverrideContainer, VirtualAssociationOverride>(containerHolder, new String[]{"virtualOverrides"}){

            protected ListIterable<VirtualAssociationOverride> getListIterable() {
                return new SuperListIterableWrapper(((AssociationOverrideContainer)this.subject).getVirtualOverrides());
            }

            protected int size_() {
                return ((AssociationOverrideContainer)this.subject).getVirtualOverridesSize();
            }
        };
    }

    private ListValueModel<VirtualAttributeOverride> buildDefaultAttributeOverridesListHolder(PropertyValueModel<AttributeOverrideContainer> containerHolder) {
        return new ListAspectAdapter<AttributeOverrideContainer, VirtualAttributeOverride>(containerHolder, new String[]{"virtualOverrides"}){

            protected ListIterable<VirtualAttributeOverride> getListIterable() {
                return new SuperListIterableWrapper(((AttributeOverrideContainer)this.subject).getVirtualOverrides());
            }

            protected int size_() {
                return ((AttributeOverrideContainer)this.subject).getVirtualOverridesSize();
            }
        };
    }

    protected ModifiablePropertyValueModel<Boolean> getOverrideVirtualOverrideHolder() {
        if (this.overrideVirtualOverrideHolder == null) {
            this.overrideVirtualOverrideHolder = this.buildOverrideVirtualOverrideHolder();
        }
        return this.overrideVirtualOverrideHolder;
    }

    private ModifiablePropertyValueModel<Boolean> buildOverrideVirtualOverrideHolder() {
        return new TransformationWritablePropertyValueModel<ReadOnlyOverride, Boolean>(this.selectedOverrideHolder){

            public void setValue(Boolean value) {
                AbstractOverridesComposite.this.updateOverride(value);
            }

            protected Boolean transform_(ReadOnlyOverride v) {
                return !v.isVirtual();
            }
        };
    }

    String buildOverrideDisplayString(ReadOnlyOverride override) {
        String overrideType = override instanceof ReadOnlyAssociationOverride ? JptUiDetailsMessages.OverridesComposite_association : JptUiDetailsMessages.OverridesComposite_attribute;
        String name = override.getName();
        if (StringTools.stringIsEmpty((String)name)) {
            name = JptUiDetailsMessages.OverridesComposite_noName;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append(" (");
        sb.append(overrideType);
        sb.append(") ");
        return sb.toString();
    }

    protected ILabelProvider buildOverrideLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return AbstractOverridesComposite.this.buildOverrideDisplayString((ReadOnlyOverride)element);
            }
        };
    }

    protected AddRemovePane.Adapter buildOverridesAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
            }
        };
    }

    protected ListValueModel<ReadOnlyOverride> buildOverridesListHolder() {
        PropertyValueModel<AttributeOverrideContainer> attributeOverrideContainerHolder = this.buildAttributeOverrideContainerHolder();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.buildSpecifiedAttributeOverridesListHolder(attributeOverrideContainerHolder));
        list.add(this.buildDefaultAttributeOverridesListHolder(attributeOverrideContainerHolder));
        if (this.supportsAssociationOverrides()) {
            PropertyValueModel<AssociationOverrideContainer> associationOverrideContainerHolder = this.buildAssociationOverrideContainerHolder();
            list.add(this.buildSpecifiedAssociationOverridesListHolder(associationOverrideContainerHolder));
            list.add(this.buildDefaultAssociationOverridesListHolder(associationOverrideContainerHolder));
        }
        return new CompositeListValueModel(list);
    }

    protected abstract PropertyValueModel<AttributeOverrideContainer> buildAttributeOverrideContainerHolder();

    protected abstract PropertyValueModel<AssociationOverrideContainer> buildAssociationOverrideContainerHolder();

    private ListValueModel<ReadOnlyOverride> buildOverridesListModel() {
        return new ItemPropertyListValueModelAdapter(this.buildOverridesListHolder(), new String[]{"name"});
    }

    private Transformer<ReadOnlyOverride, Control> buildPaneTransformer() {
        return new Transformer<ReadOnlyOverride, Control>(){

            public Control transform(ReadOnlyOverride override) {
                return AbstractOverridesComposite.this.transformSelectedOverride(override);
            }
        };
    }

    protected Control transformSelectedOverride(ReadOnlyOverride selectedOverride) {
        if (selectedOverride instanceof ReadOnlyAttributeOverride) {
            return this.attributeOverridePane.getControl();
        }
        if (selectedOverride instanceof ReadOnlyAssociationOverride) {
            return this.associationOverridePane.getControl();
        }
        return null;
    }

    private ListValueModel<AssociationOverride> buildSpecifiedAssociationOverridesListHolder(PropertyValueModel<AssociationOverrideContainer> containerHolder) {
        return new ListAspectAdapter<AssociationOverrideContainer, AssociationOverride>(containerHolder, new String[]{"specifiedOverrides"}){

            protected ListIterable<AssociationOverride> getListIterable() {
                return new SuperListIterableWrapper(((AssociationOverrideContainer)this.subject).getSpecifiedOverrides());
            }

            protected int size_() {
                return ((AssociationOverrideContainer)this.subject).getSpecifiedOverridesSize();
            }
        };
    }

    private ListValueModel<AttributeOverride> buildSpecifiedAttributeOverridesListHolder(PropertyValueModel<AttributeOverrideContainer> containerHolder) {
        return new ListAspectAdapter<AttributeOverrideContainer, AttributeOverride>(containerHolder, new String[]{"specifiedOverrides"}){

            protected ListIterable<AttributeOverride> getListIterable() {
                return new SuperListIterableWrapper(((AttributeOverrideContainer)this.subject).getSpecifiedOverrides());
            }

            protected int size_() {
                return ((AttributeOverrideContainer)this.subject).getSpecifiedOverridesSize();
            }
        };
    }

    void updateOverride(boolean convertToSpecified) {
        if (this.isPopulating()) {
            return;
        }
        this.setPopulating(true);
        try {
            ReadOnlyOverride override = (ReadOnlyOverride)this.selectedOverrideHolder.getValue();
            Override_ newOverride = convertToSpecified ? ((VirtualOverride)override).convertToSpecified() : ((Override_)override).convertToVirtual();
            this.selectedOverrideHolder.setValue((Object)newOverride);
        }
        finally {
            this.setPopulating(false);
        }
    }
}

