/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.jpa.core.context.BaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.details.PrimaryKeyJoinColumnDialog;
import org.eclipse.jpt.jpa.ui.internal.details.PrimaryKeyJoinColumnStateObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPrimaryKeyJoinColumnsComposite<T extends Entity>
extends Pane<T> {
    protected ModifiablePropertyValueModel<PrimaryKeyJoinColumn> joinColumnHolder;

    public AbstractPrimaryKeyJoinColumnsComposite(Pane<? extends T> subjectHolder, Composite parent) {
        super(subjectHolder, parent, false);
    }

    void addJoinColumn(PrimaryKeyJoinColumnStateObject stateObject) {
        PrimaryKeyJoinColumn joinColumn = ((Entity)this.getSubject()).addSpecifiedPrimaryKeyJoinColumn();
        stateObject.updateJoinColumn((BaseJoinColumn)joinColumn);
    }

    void addPrimaryKeyJoinColumn() {
        PrimaryKeyJoinColumnDialog dialog = new PrimaryKeyJoinColumnDialog(this.getShell(), (Entity)this.getSubject(), null);
        dialog.setBlockOnOpen(true);
        dialog.open();
        if (dialog.wasConfirmed()) {
            this.addJoinColumn((PrimaryKeyJoinColumnStateObject)dialog.getSubject());
        }
    }

    protected abstract ListValueModel<? extends ReadOnlyPrimaryKeyJoinColumn> buildDefaultJoinColumnsListHolder();

    private ModifiablePropertyValueModel<PrimaryKeyJoinColumn> buildJoinColumnHolder() {
        return new SimplePropertyValueModel();
    }

    String buildJoinColumnLabel(ReadOnlyPrimaryKeyJoinColumn joinColumn) {
        if (joinColumn.isVirtual()) {
            return NLS.bind((String)JptUiDetailsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedName() == null) {
            if (joinColumn.getSpecifiedReferencedColumnName() == null) {
                return NLS.bind((String)JptUiDetailsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsBothDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
            }
            return NLS.bind((String)JptUiDetailsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsFirstDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        if (joinColumn.getSpecifiedReferencedColumnName() == null) {
            return NLS.bind((String)JptUiDetailsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParamsSecDefault, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
        }
        return NLS.bind((String)JptUiDetailsMessages.PrimaryKeyJoinColumnsComposite_mappingBetweenTwoParams, (Object)joinColumn.getName(), (Object)joinColumn.getReferencedColumnName());
    }

    private AddRemovePane.Adapter buildJoinColumnsAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                AbstractPrimaryKeyJoinColumnsComposite.this.addPrimaryKeyJoinColumn();
            }

            public boolean hasOptionalButton() {
                return true;
            }

            public String optionalButtonText() {
                return JptUiDetailsMessages.PrimaryKeyJoinColumnsComposite_edit;
            }

            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                AbstractPrimaryKeyJoinColumnsComposite.this.editPrimaryKeyJoinColumn(listSelectionModel);
            }

            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                int[] selectedIndices = listSelectionModel.selectedIndices();
                Entity entity = (Entity)AbstractPrimaryKeyJoinColumnsComposite.this.getSubject();
                int index = selectedIndices.length;
                while (--index >= 0) {
                    entity.removeSpecifiedPrimaryKeyJoinColumn(selectedIndices[index]);
                }
            }
        };
    }

    private ILabelProvider buildJoinColumnsListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return AbstractPrimaryKeyJoinColumnsComposite.this.buildJoinColumnLabel((ReadOnlyPrimaryKeyJoinColumn)element);
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildOverrideDefaultJoinColumnHolder() {
        return new OverrideDefaultPrimaryKeyJoinColumnHolder();
    }

    private ListValueModel<ReadOnlyPrimaryKeyJoinColumn> buildPrimaryKeyJoinColumnsListHolder() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.buildSpecifiedJoinColumnsListHolder());
        list.add(this.buildDefaultJoinColumnsListHolder());
        return new CompositeListValueModel(list);
    }

    private ListValueModel<ReadOnlyPrimaryKeyJoinColumn> buildPrimaryKeyJoinColumnsListModel() {
        return new ItemPropertyListValueModelAdapter(this.buildPrimaryKeyJoinColumnsListHolder(), new String[]{"specifiedName", "defaultName", "specifiedReferencedColumnName", "defaultReferencedColumnName"});
    }

    ListValueModel<PrimaryKeyJoinColumn> buildSpecifiedJoinColumnsListHolder() {
        return new ListAspectAdapter<Entity, PrimaryKeyJoinColumn>(this.getSubjectHolder(), new String[]{"specifiedPrimaryKeyJoinColumns"}){

            protected ListIterable<PrimaryKeyJoinColumn> getListIterable() {
                return new SuperListIterableWrapper(((Entity)this.subject).getSpecifiedPrimaryKeyJoinColumns());
            }

            protected int size_() {
                return ((Entity)this.subject).getSpecifiedPrimaryKeyJoinColumnsSize();
            }
        };
    }

    void editJoinColumn(PrimaryKeyJoinColumnStateObject stateObject) {
        stateObject.updateJoinColumn((BaseJoinColumn)stateObject.getJoinColumn());
    }

    void editPrimaryKeyJoinColumn(ObjectListSelectionModel listSelectionModel) {
        PrimaryKeyJoinColumn joinColumn = (PrimaryKeyJoinColumn)listSelectionModel.selectedValue();
        PrimaryKeyJoinColumnDialog dialog = new PrimaryKeyJoinColumnDialog(this.getShell(), (Entity)this.getSubject(), joinColumn);
        dialog.setBlockOnOpen(true);
        dialog.open();
        if (dialog.wasConfirmed()) {
            this.editJoinColumn((PrimaryKeyJoinColumnStateObject)dialog.getSubject());
        }
    }

    protected void initialize() {
        super.initialize();
        this.joinColumnHolder = this.buildJoinColumnHolder();
    }

    protected void initializeLayout(Composite container) {
        Group groupPane = this.addTitledGroup(container, JptUiDetailsMessages.PrimaryKeyJoinColumnsComposite_primaryKeyJoinColumn);
        this.addCheckBox(this.addSubPane((Composite)groupPane, 8), JptUiDetailsMessages.PrimaryKeyJoinColumnsComposite_overrideDefaultPrimaryKeyJoinColumns, this.buildOverrideDefaultJoinColumnHolder(), null);
        AddRemoveListPane joinColumnsListPane = new AddRemoveListPane((Pane)this, (Composite)groupPane, this.buildJoinColumnsAdapter(), this.buildPrimaryKeyJoinColumnsListModel(), this.joinColumnHolder, this.buildJoinColumnsListLabelProvider(), "org.eclipse.jpt.jpa.ui.mapping_joinTableJoinColumns");
        this.installJoinColumnsListPaneEnabler((AddRemoveListPane<Entity>)joinColumnsListPane);
    }

    private void installJoinColumnsListPaneEnabler(AddRemoveListPane<Entity> pane) {
        new PaneEnabler(this.buildOverrideDefaultJoinColumnHolder(), pane);
    }

    void updatePrimaryKeyJoinColumns(boolean selected) {
        if (this.isPopulating()) {
            return;
        }
        this.setPopulating(true);
        try {
            if (selected) {
                ((Entity)this.getSubject()).convertDefaultPrimaryKeyJoinColumnsToSpecified();
                this.joinColumnHolder.setValue((Object)((Entity)this.getSubject()).getSpecifiedPrimaryKeyJoinColumn(0));
            } else {
                ((Entity)this.getSubject()).clearSpecifiedPrimaryKeyJoinColumns();
            }
        }
        finally {
            this.setPopulating(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OverrideDefaultPrimaryKeyJoinColumnHolder
    extends ListPropertyValueModelAdapter<Boolean>
    implements ModifiablePropertyValueModel<Boolean> {
        public OverrideDefaultPrimaryKeyJoinColumnHolder() {
            super(AbstractPrimaryKeyJoinColumnsComposite.this.buildSpecifiedJoinColumnsListHolder());
        }

        protected Boolean buildValue() {
            if (this.listModel.size() > 0) {
                return true;
            }
            return false;
        }

        public void setValue(Boolean value) {
            AbstractPrimaryKeyJoinColumnsComposite.this.updatePrimaryKeyJoinColumns(value);
        }
    }
}

