/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ReadOnlyWritablePropertyValueModelWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ValueListAdapter;
import org.eclipse.jpt.common.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.StateChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.BaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinTable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinTable;
import org.eclipse.jpt.jpa.ui.internal.details.InverseJoinColumnInJoinTableDialog;
import org.eclipse.jpt.jpa.ui.internal.details.InverseJoinColumnInJoinTableStateObject;
import org.eclipse.jpt.jpa.ui.internal.details.JoinColumnsComposite;
import org.eclipse.jpt.jpa.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.details.ReferenceTableComposite;
import org.eclipse.jpt.jpa.ui.internal.details.db.CatalogCombo;
import org.eclipse.jpt.jpa.ui.internal.details.db.SchemaCombo;
import org.eclipse.jpt.jpa.ui.internal.details.db.TableCombo;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinTableComposite
extends ReferenceTableComposite<ReadOnlyJoinTable> {
    private Button overrideDefaultInverseJoinColumnsCheckBox;
    private JoinColumnsComposite<ReadOnlyJoinTable> inverseJoinColumnsComposite;

    public JoinTableComposite(Pane<?> parentPane, PropertyValueModel<? extends ReadOnlyJoinTable> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    public JoinTableComposite(PropertyValueModel<? extends ReadOnlyJoinTable> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    @Override
    protected boolean tableIsVirtual(ReadOnlyJoinTable joinTable) {
        return joinTable.getParent().getRelationship().isVirtual();
    }

    protected void initializeLayout(Composite container) {
        int groupBoxMargin = this.getGroupBoxMargin();
        TableCombo tableCombo = this.addTableCombo(container);
        Composite tablePane = this.addPane(container, groupBoxMargin);
        this.addLabeledComposite(tablePane, JptUiDetailsMessages.JoinTableComposite_name, (Control)tableCombo.getControl(), "org.eclipse.jpt.jpa.ui.mapping_joinTableName");
        SchemaCombo schemaCombo = this.addSchemaCombo(container);
        this.addLabeledComposite(tablePane, JptUiDetailsMessages.JoinTableComposite_schema, (Control)schemaCombo.getControl(), "org.eclipse.jpt.jpa.ui.mapping_joinTableSchema");
        CatalogCombo catalogCombo = this.addCatalogCombo(container);
        this.addLabeledComposite(tablePane, JptUiDetailsMessages.JoinTableComposite_catalog, (Control)catalogCombo.getControl(), "org.eclipse.jpt.jpa.ui.mapping_joinTableCatalog");
        Group joinColumnGroupPane = this.addTitledGroup(container, JptUiDetailsMessages.JoinTableComposite_joinColumn);
        this.overrideDefaultJoinColumnsCheckBox = this.addCheckBox(this.addSubPane((Composite)joinColumnGroupPane, 8), JptUiDetailsMessages.JoinTableComposite_overrideDefaultJoinColumns, this.buildOverrideDefaultJoinColumnHolder(), null);
        this.joinColumnsComposite = new JoinColumnsComposite<ReadOnlyJoinTable>(this, (Composite)joinColumnGroupPane, this.buildJoinColumnsEditor());
        this.installJoinColumnsPaneEnabler(this.joinColumnsComposite);
        Group inverseJoinColumnGroupPane = this.addTitledGroup(container, JptUiDetailsMessages.JoinTableComposite_inverseJoinColumn);
        this.overrideDefaultInverseJoinColumnsCheckBox = this.addCheckBox(this.addSubPane((Composite)inverseJoinColumnGroupPane, 8), JptUiDetailsMessages.JoinTableComposite_overrideDefaultInverseJoinColumns, this.buildOverrideDefaultInverseJoinColumnHolder(), null);
        this.inverseJoinColumnsComposite = new JoinColumnsComposite<ReadOnlyJoinTable>(this, (Composite)inverseJoinColumnGroupPane, this.buildInverseJoinColumnsEditor());
        this.installInverseJoinColumnsPaneEnabler(this.inverseJoinColumnsComposite);
    }

    private void installInverseJoinColumnsPaneEnabler(JoinColumnsComposite<ReadOnlyJoinTable> pane) {
        pane.installJoinColumnsPaneEnabler((PropertyValueModel<Boolean>)new InverseJoinColumnPaneEnablerHolder());
    }

    void addInverseJoinColumn(ReadOnlyJoinTable joinTable) {
        InverseJoinColumnInJoinTableDialog dialog = new InverseJoinColumnInJoinTableDialog(this.getShell(), joinTable, null);
        dialog.setBlockOnOpen(true);
        dialog.open();
        if (dialog.wasConfirmed()) {
            this.addInverseJoinColumnFromDialog((InverseJoinColumnInJoinTableStateObject)dialog.getSubject());
        }
    }

    void addInverseJoinColumnFromDialog(InverseJoinColumnInJoinTableStateObject stateObject) {
        JoinTable subject = (JoinTable)this.getSubject();
        int index = subject.getSpecifiedInverseJoinColumnsSize();
        JoinColumn joinColumn = subject.addSpecifiedInverseJoinColumn(index);
        stateObject.updateJoinColumn((BaseJoinColumn)joinColumn);
        this.setSelectedInverseJoinColumn(joinColumn);
    }

    private void setSelectedInverseJoinColumn(JoinColumn joinColumn) {
        this.inverseJoinColumnsComposite.setSelectedJoinColumn(joinColumn);
    }

    private InverseJoinColumnsProvider buildInverseJoinColumnsEditor() {
        return new InverseJoinColumnsProvider();
    }

    private ModifiablePropertyValueModel<Boolean> buildOverrideDefaultInverseJoinColumnHolder() {
        return new OverrideDefaultInverseJoinColumnHolder();
    }

    ListValueModel<ReadOnlyJoinColumn> buildSpecifiedInverseJoinColumnsListHolder() {
        return new ListAspectAdapter<ReadOnlyJoinTable, ReadOnlyJoinColumn>(this.getSubjectHolder(), new String[]{"specifiedInverseJoinColumns"}){

            protected ListIterable<ReadOnlyJoinColumn> getListIterable() {
                return new SuperListIterableWrapper(((ReadOnlyJoinTable)this.subject).getSpecifiedInverseJoinColumns());
            }

            protected int size_() {
                return ((ReadOnlyJoinTable)this.subject).getSpecifiedInverseJoinColumnsSize();
            }
        };
    }

    void editInverseJoinColumn(InverseJoinColumnInJoinTableStateObject stateObject) {
        stateObject.updateJoinColumn((BaseJoinColumn)stateObject.getJoinColumn());
    }

    void editInverseJoinColumn(ReadOnlyJoinColumn joinColumn) {
        InverseJoinColumnInJoinTableDialog dialog = new InverseJoinColumnInJoinTableDialog(this.getShell(), (ReadOnlyJoinTable)this.getSubject(), joinColumn);
        dialog.setBlockOnOpen(true);
        dialog.open();
        if (dialog.wasConfirmed()) {
            this.editInverseJoinColumn((InverseJoinColumnInJoinTableStateObject)dialog.getSubject());
        }
    }

    void updateInverseJoinColumns() {
        if (this.isPopulating()) {
            return;
        }
        JoinTable joinTable = (JoinTable)this.getSubject();
        if (joinTable == null) {
            return;
        }
        boolean selected = this.overrideDefaultInverseJoinColumnsCheckBox.getSelection();
        this.setPopulating(true);
        try {
            if (selected) {
                joinTable.convertDefaultInverseJoinColumnToSpecified();
                this.setSelectedInverseJoinColumn(joinTable.getSpecifiedInverseJoinColumn(0));
            } else {
                joinTable.clearSpecifiedInverseJoinColumns();
            }
        }
        finally {
            this.setPopulating(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InverseJoinColumnPaneEnablerHolder
    extends TransformationPropertyValueModel<ReadOnlyJoinTable, Boolean> {
        private StateChangeListener stateListener;

        public InverseJoinColumnPaneEnablerHolder() {
            super((PropertyValueModel)new ValueListAdapter((ModifiablePropertyValueModel)new ReadOnlyWritablePropertyValueModelWrapper(JoinTableComposite.this.getSubjectHolder()), new String[]{"specifiedInverseJoinColumns"}));
            this.stateListener = new StateListener();
        }

        void wrappedValueStateChanged() {
            Object old = this.value;
            this.value = this.transform((ReadOnlyJoinTable)this.valueModel.getValue());
            this.firePropertyChanged("value", old, this.value);
        }

        protected Boolean transform(ReadOnlyJoinTable table) {
            return table == null ? Boolean.FALSE : (Boolean)super.transform((Object)table);
        }

        protected Boolean transform_(ReadOnlyJoinTable table) {
            boolean virtual = JoinTableComposite.this.tableIsVirtual(table);
            return !virtual && table.getSpecifiedInverseJoinColumnsSize() > 0;
        }

        protected void engageModel() {
            super.engageModel();
            this.valueModel.addStateChangeListener(this.stateListener);
        }

        protected void disengageModel() {
            this.valueModel.removeStateChangeListener(this.stateListener);
            super.disengageModel();
        }

        class StateListener
        extends StateChangeAdapter {
            StateListener() {
            }

            public void stateChanged(StateChangeEvent event) {
                InverseJoinColumnPaneEnablerHolder.this.wrappedValueStateChanged();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InverseJoinColumnsProvider
    implements JoinColumnsComposite.JoinColumnsEditor<ReadOnlyJoinTable> {
        InverseJoinColumnsProvider() {
        }

        @Override
        public void addJoinColumn(ReadOnlyJoinTable subject) {
            JoinTableComposite.this.addInverseJoinColumn(subject);
        }

        @Override
        public ReadOnlyJoinColumn getDefaultJoinColumn(ReadOnlyJoinTable subject) {
            return subject.getDefaultInverseJoinColumn();
        }

        @Override
        public String getDefaultPropertyName() {
            return "defaultInverseJoinColumn";
        }

        @Override
        public void editJoinColumn(ReadOnlyJoinTable subject, ReadOnlyJoinColumn joinColumn) {
            JoinTableComposite.this.editInverseJoinColumn(joinColumn);
        }

        @Override
        public boolean hasSpecifiedJoinColumns(ReadOnlyJoinTable subject) {
            return subject.hasSpecifiedInverseJoinColumns();
        }

        @Override
        public void removeJoinColumns(ReadOnlyJoinTable subject, int[] selectedIndices) {
            int index = selectedIndices.length;
            while (index-- > 0) {
                ((JoinTable)subject).removeSpecifiedInverseJoinColumn(selectedIndices[index]);
            }
        }

        @Override
        public ListIterable<ReadOnlyJoinColumn> getSpecifiedJoinColumns(ReadOnlyJoinTable subject) {
            return new SuperListIterableWrapper(subject.getSpecifiedInverseJoinColumns());
        }

        @Override
        public int getSpecifiedJoinColumnsSize(ReadOnlyJoinTable subject) {
            return subject.getSpecifiedInverseJoinColumnsSize();
        }

        @Override
        public String getSpecifiedJoinColumnsListPropertyName() {
            return "specifiedInverseJoinColumns";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OverrideDefaultInverseJoinColumnHolder
    extends ListPropertyValueModelAdapter<Boolean>
    implements ModifiablePropertyValueModel<Boolean> {
        public OverrideDefaultInverseJoinColumnHolder() {
            super(JoinTableComposite.this.buildSpecifiedInverseJoinColumnsListHolder());
        }

        protected Boolean buildValue() {
            return this.listModel.size() > 0;
        }

        public void setValue(Boolean value) {
            JoinTableComposite.this.updateInverseJoinColumns();
        }
    }
}

