/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details.orm;

import java.util.ArrayList;
import org.eclipse.jpt.common.ui.internal.widgets.DialogPane;
import org.eclipse.jpt.common.ui.internal.widgets.ValidatingDialog;
import org.eclipse.jpt.common.utility.internal.StringConverter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticListValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.internal.details.orm.AddGeneratorStateObject;
import org.eclipse.jpt.jpa.ui.internal.details.orm.JptUiDetailsOrmMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddGeneratorDialog
extends ValidatingDialog<AddGeneratorStateObject> {
    public static final String SEQUENCE_GENERATOR = "sequenceGenerator";
    public static final String TABLE_GENERATOR = "tableGenerator";
    private PersistenceUnit pUnit;

    public AddGeneratorDialog(Shell parent, PersistenceUnit pUnit) {
        super(parent);
        this.pUnit = pUnit;
    }

    protected AddGeneratorStateObject buildStateObject() {
        return new AddGeneratorStateObject(this.pUnit);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getTitle());
    }

    protected String getTitle() {
        return JptUiDetailsOrmMessages.AddGeneratorDialog_title;
    }

    protected String getDescriptionTitle() {
        return JptUiDetailsOrmMessages.AddGeneratorDialog_descriptionTitle;
    }

    protected String getDescription() {
        return JptUiDetailsOrmMessages.AddGeneratorDialog_description;
    }

    protected DialogPane<AddGeneratorStateObject> buildLayout(Composite container) {
        return new GeneratorDialogPane(container);
    }

    public void create() {
        super.create();
        GeneratorDialogPane pane = (GeneratorDialogPane)this.getPane();
        pane.selectAll();
        this.getButton(0).setEnabled(false);
    }

    public String getName() {
        return ((AddGeneratorStateObject)this.getSubject()).getName();
    }

    public String getGeneratorType() {
        return ((AddGeneratorStateObject)this.getSubject()).getGeneratorType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GeneratorDialogPane
    extends DialogPane<AddGeneratorStateObject> {
        private Text nameText;

        GeneratorDialogPane(Composite parent) {
            super(AddGeneratorDialog.this.getSubjectHolder(), parent);
        }

        protected void initializeLayout(Composite container) {
            this.nameText = this.addLabeledText(container, JptUiDetailsOrmMessages.AddGeneratorDialog_name, this.buildNameHolder());
            this.addLabeledCombo(container, JptUiDetailsOrmMessages.AddGeneratorDialog_generatorType, this.buildGeneratorTypeListHolder(), this.buildGeneratorTypeHolder(), this.buildStringConverter(), null);
        }

        protected ListValueModel<String> buildGeneratorTypeListHolder() {
            ArrayList<String> generatorTypes = new ArrayList<String>();
            generatorTypes.add(AddGeneratorDialog.TABLE_GENERATOR);
            generatorTypes.add(AddGeneratorDialog.SEQUENCE_GENERATOR);
            return new StaticListValueModel(generatorTypes);
        }

        private StringConverter<String> buildStringConverter() {
            return new StringConverter<String>(){

                public String convertToString(String value) {
                    if (value == AddGeneratorDialog.TABLE_GENERATOR) {
                        return JptUiDetailsOrmMessages.AddGeneratorDialog_tableGenerator;
                    }
                    if (value == AddGeneratorDialog.SEQUENCE_GENERATOR) {
                        return JptUiDetailsOrmMessages.AddGeneratorDialog_sequenceGenerator;
                    }
                    return value;
                }
            };
        }

        private ModifiablePropertyValueModel<String> buildNameHolder() {
            return new PropertyAspectAdapter<AddGeneratorStateObject, String>(this.getSubjectHolder(), new String[]{"nameProperty"}){

                protected String buildValue_() {
                    return ((AddGeneratorStateObject)((Object)this.subject)).getName();
                }

                protected void setValue_(String value) {
                    ((AddGeneratorStateObject)((Object)this.subject)).setName(value);
                }
            };
        }

        private ModifiablePropertyValueModel<String> buildGeneratorTypeHolder() {
            return new PropertyAspectAdapter<AddGeneratorStateObject, String>(this.getSubjectHolder(), new String[]{"generatorTypeProperty"}){

                protected String buildValue_() {
                    return ((AddGeneratorStateObject)((Object)this.subject)).getGeneratorType();
                }

                protected void setValue_(String value) {
                    ((AddGeneratorStateObject)((Object)this.subject)).setGeneratorType(value);
                }
            };
        }

        void selectAll() {
            this.nameText.selectAll();
        }
    }
}

