/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.navigator;

import java.util.HashMap;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProviderFactory;
import org.eclipse.jpt.common.ui.jface.ItemTreeStateProviderFactoryProvider;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.jpt.jpa.ui.JpaRootContextNodeModel;
import org.eclipse.jpt.jpa.ui.internal.navigator.RootContextNodeModelItemContentProvider;

public class JpaNavigatorItemContentProviderFactory
implements ItemTreeContentProviderFactory {
    private HashMap<JpaPlatform, ItemTreeContentProviderFactory> delegates = new HashMap();

    public ItemTreeContentProvider buildProvider(Object item, ItemTreeContentProvider.Manager manager) {
        if (item instanceof JpaRootContextNodeModel) {
            return this.buildRootContextNodeModelProvider((JpaRootContextNodeModel)item, manager);
        }
        ItemTreeContentProviderFactory delegate = this.getDelegate(item);
        return delegate == null ? null : delegate.buildProvider(item, manager);
    }

    protected ItemTreeContentProvider buildRootContextNodeModelProvider(JpaRootContextNodeModel item, ItemTreeContentProvider.Manager manager) {
        return new RootContextNodeModelItemContentProvider(item, manager);
    }

    private ItemTreeContentProviderFactory getDelegate(Object element) {
        return element instanceof JpaContextNode ? this.getDelegate((JpaContextNode)element) : null;
    }

    private synchronized ItemTreeContentProviderFactory getDelegate(JpaContextNode contextNode) {
        JpaPlatform jpaPlatform = contextNode.getJpaProject().getJpaPlatform();
        ItemTreeContentProviderFactory delegate = this.delegates.get(jpaPlatform);
        if (delegate == null && !this.delegates.containsKey(jpaPlatform)) {
            delegate = this.buildDelegate(jpaPlatform);
            this.delegates.put(jpaPlatform, delegate);
        }
        return delegate;
    }

    private ItemTreeContentProviderFactory buildDelegate(JpaPlatform jpaPlatform) {
        JpaPlatformUi platformUI = (JpaPlatformUi)jpaPlatform.getAdapter(JpaPlatformUi.class);
        if (platformUI == null) {
            return null;
        }
        ItemTreeStateProviderFactoryProvider factoryProvider = platformUI.getNavigatorFactoryProvider();
        return factoryProvider == null ? null : factoryProvider.getItemContentProviderFactory();
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this);
    }
}

