/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.navigator;

import java.util.HashMap;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProviderFactory;
import org.eclipse.jpt.common.ui.jface.ItemLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeStateProviderFactoryProvider;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.jpt.jpa.ui.JpaRootContextNodeModel;
import org.eclipse.jpt.jpa.ui.internal.navigator.RootContextNodeModelItemLabelProvider;

public class JpaNavigatorItemLabelProviderFactory
implements ItemExtendedLabelProviderFactory {
    private final HashMap<JpaPlatform, ItemExtendedLabelProviderFactory> delegates = new HashMap();

    public ItemExtendedLabelProvider buildProvider(Object item, ItemExtendedLabelProvider.Manager manager) {
        if (item instanceof JpaRootContextNodeModel) {
            return this.buildRootContextNodeModelProvider((JpaRootContextNodeModel)item, manager);
        }
        ItemExtendedLabelProviderFactory delegate = this.getDelegate(item);
        return delegate == null ? null : delegate.buildProvider(item, manager);
    }

    protected ItemExtendedLabelProvider buildRootContextNodeModelProvider(JpaRootContextNodeModel item, ItemExtendedLabelProvider.Manager manager) {
        return new RootContextNodeModelItemLabelProvider(item, (ItemLabelProvider.Manager)manager);
    }

    private ItemExtendedLabelProviderFactory getDelegate(Object item) {
        return item instanceof JpaContextNode ? this.getDelegate((JpaContextNode)item) : null;
    }

    private synchronized ItemExtendedLabelProviderFactory getDelegate(JpaContextNode item) {
        JpaPlatform jpaPlatform = item.getJpaProject().getJpaPlatform();
        ItemExtendedLabelProviderFactory delegate = this.delegates.get(jpaPlatform);
        if (delegate == null && !this.delegates.containsKey(jpaPlatform)) {
            delegate = this.buildDelegate(jpaPlatform);
            this.delegates.put(jpaPlatform, delegate);
        }
        return delegate;
    }

    private ItemExtendedLabelProviderFactory buildDelegate(JpaPlatform jpaPlatform) {
        JpaPlatformUi platformUI = (JpaPlatformUi)jpaPlatform.getAdapter(JpaPlatformUi.class);
        if (platformUI == null) {
            return null;
        }
        ItemTreeStateProviderFactoryProvider factoryProvider = platformUI.getNavigatorFactoryProvider();
        return factoryProvider == null ? null : factoryProvider.getItemLabelProviderFactory();
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this);
    }
}

