/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.platform.generic;

import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.ui.internal.jface.StaticItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProviderFactory;
import org.eclipse.jpt.common.ui.jface.ItemLabelProvider;
import org.eclipse.jpt.jpa.core.JpaNode;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JarFile;
import org.eclipse.jpt.jpa.core.context.orm.OrmXml;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.platform.generic.PersistenceUnitItemLabelProvider;
import org.eclipse.jpt.jpa.ui.internal.platform.generic.PersistentAttributeItemLabelProvider;
import org.eclipse.jpt.jpa.ui.internal.platform.generic.PersistentTypeItemLabelProvider;

public class GenericNavigatorItemLabelProviderFactory
implements ItemExtendedLabelProviderFactory {
    private static final ItemExtendedLabelProviderFactory INSTANCE = new GenericNavigatorItemLabelProviderFactory();

    public static ItemExtendedLabelProviderFactory instance() {
        return INSTANCE;
    }

    protected GenericNavigatorItemLabelProviderFactory() {
    }

    public ItemExtendedLabelProvider buildProvider(Object item, ItemExtendedLabelProvider.Manager manager) {
        if (item instanceof PersistenceXml) {
            return this.buildPersistenceXmlProvider((PersistenceXml)item, manager);
        }
        if (item instanceof PersistenceUnit) {
            return this.buildPersistenceUnitProvider((PersistenceUnit)item, manager);
        }
        if (item instanceof OrmXml) {
            return this.buildOrmXmlProvider((OrmXml)item, manager);
        }
        if (item instanceof PersistentType) {
            return this.buildPersistentTypeProvider((PersistentType)item, manager);
        }
        if (item instanceof ReadOnlyPersistentAttribute) {
            return this.buildPersistentAttributeProvider((ReadOnlyPersistentAttribute)item, manager);
        }
        if (item instanceof JarFile) {
            return this.buildJarFileProvider((JarFile)item, manager);
        }
        return null;
    }

    protected ItemExtendedLabelProvider buildPersistenceXmlProvider(PersistenceXml item, ItemExtendedLabelProvider.Manager manager) {
        return this.buildResourceItemLabelProvider((JpaNode)item);
    }

    protected ItemExtendedLabelProvider buildPersistenceUnitProvider(PersistenceUnit item, ItemExtendedLabelProvider.Manager manager) {
        return new PersistenceUnitItemLabelProvider(item, (ItemLabelProvider.Manager)manager);
    }

    protected ItemExtendedLabelProvider buildOrmXmlProvider(OrmXml item, ItemExtendedLabelProvider.Manager manager) {
        return this.buildResourceItemLabelProvider((JpaNode)item);
    }

    protected ItemExtendedLabelProvider buildPersistentTypeProvider(PersistentType item, ItemExtendedLabelProvider.Manager manager) {
        return new PersistentTypeItemLabelProvider(item, (ItemLabelProvider.Manager)manager);
    }

    protected ItemExtendedLabelProvider buildPersistentAttributeProvider(ReadOnlyPersistentAttribute item, ItemExtendedLabelProvider.Manager manager) {
        return new PersistentAttributeItemLabelProvider(item, (ItemLabelProvider.Manager)manager);
    }

    protected ItemExtendedLabelProvider buildJarFileProvider(JarFile item, ItemExtendedLabelProvider.Manager manager) {
        return this.buildResourceItemLabelProvider((JpaNode)item, "full/obj16/jpa-jar-file");
    }

    protected ItemExtendedLabelProvider buildResourceItemLabelProvider(JpaNode node) {
        return this.buildResourceItemLabelProvider(node.getResource());
    }

    protected ItemExtendedLabelProvider buildResourceItemLabelProvider(JpaNode node, String imageKey) {
        return this.buildResourceItemLabelProvider(node.getResource(), imageKey);
    }

    protected ItemExtendedLabelProvider buildResourceItemLabelProvider(IResource resource) {
        return this.buildResourceItemLabelProvider(resource, "full/obj16/jpa-file");
    }

    protected ItemExtendedLabelProvider buildResourceItemLabelProvider(IResource resource, String imageKey) {
        return new StaticItemExtendedLabelProvider(JptJpaUiPlugin.getImage(imageKey), resource.getName(), this.buildResourceDescription(resource));
    }

    protected String buildResourceDescription(IResource resource) {
        StringBuilder sb = new StringBuilder();
        sb.append(resource.getName());
        sb.append(" - ");
        sb.append(resource.getParent().getFullPath().makeRelative());
        return sb.toString();
    }
}

