/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.platform.generic;

import org.eclipse.jpt.common.ui.internal.jface.AbstractItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemLabelProvider;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.model.value.CompositePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitItemLabelProvider
extends AbstractItemExtendedLabelProvider<PersistenceUnit> {
    protected final Image image = this.buildImage();

    public PersistenceUnitItemLabelProvider(PersistenceUnit persistenceUnit, ItemLabelProvider.Manager manager) {
        super((Object)persistenceUnit, manager);
    }

    public Image getImage() {
        return this.image;
    }

    protected Image buildImage() {
        return JptJpaUiPlugin.getImage("full/obj16/persistence-unit");
    }

    protected PropertyValueModel<String> buildTextModel() {
        return new TextModel((PersistenceUnit)this.item);
    }

    protected PropertyValueModel<String> buildDescriptionModel() {
        return new DescriptionModel((PersistenceUnit)this.item);
    }

    public static PropertyValueModel<String> buildQuotedComponentDescriptionModel(JpaContextNode node, PropertyValueModel<String> nodeTextModel) {
        return PersistenceUnitItemLabelProvider.buildComponentDescriptionModel(node, true, nodeTextModel);
    }

    public static PropertyValueModel<String> buildNonQuotedComponentDescriptionModel(JpaContextNode node, PropertyValueModel<String> ... nodeTextModels) {
        return PersistenceUnitItemLabelProvider.buildComponentDescriptionModel(node, false, nodeTextModels);
    }

    protected static PropertyValueModel<String> buildComponentDescriptionModel(JpaContextNode node, boolean quote, PropertyValueModel<String> ... nodeTextModel) {
        return new ComponentDescriptionModel(nodeTextModel, (PropertyValueModel<String>)new TextModel(node.getPersistenceUnit()), node.getResource().getFullPath().makeRelative().toString(), quote);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ComponentDescriptionModel
    extends CompositePropertyValueModel<String, Object> {
        protected final PropertyValueModel<String>[] nodeTextModels;
        protected final PropertyValueModel<String> persistenceUnitNameModel;
        protected final String path;
        protected final boolean quote;

        ComponentDescriptionModel(PropertyValueModel<String> nodeTextModel, PropertyValueModel<String> persistenceUnitNameModel, String path, boolean quote) {
            this(new PropertyValueModel[]{nodeTextModel}, persistenceUnitNameModel, path, quote);
        }

        ComponentDescriptionModel(PropertyValueModel<String>[] nodeTextModels, PropertyValueModel<String> persistenceUnitNameModel, String path, boolean quote) {
            super((PropertyValueModel[])ArrayTools.add((Object[])nodeTextModels, persistenceUnitNameModel));
            if (nodeTextModels.length < 1) {
                throw new IllegalArgumentException();
            }
            this.nodeTextModels = nodeTextModels;
            this.persistenceUnitNameModel = persistenceUnitNameModel;
            this.path = path;
            this.quote = quote;
        }

        protected String buildValue() {
            StringBuilder sb = new StringBuilder();
            sb.append((String)this.persistenceUnitNameModel.getValue());
            sb.append('/');
            if (this.quote) {
                sb.append('\"');
            }
            sb.append((String)this.nodeTextModels[0].getValue());
            int i = 1;
            while (i < this.nodeTextModels.length) {
                sb.append('/');
                sb.append((String)this.nodeTextModels[i].getValue());
                ++i;
            }
            if (this.quote) {
                sb.append('\"');
            }
            sb.append(" - ");
            sb.append(this.path);
            return sb.toString();
        }
    }

    protected static class DescriptionModel
    extends TextModel {
        public DescriptionModel(PersistenceUnit subject) {
            super(subject);
        }

        protected String buildValue_() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.buildValue_());
            sb.append(" - ");
            sb.append(((PersistenceUnit)this.subject).getResource().getFullPath().makeRelative());
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TextModel
    extends PropertyAspectAdapter<PersistenceUnit, String> {
        public TextModel(PersistenceUnit subject) {
            super("name", (Model)subject);
        }

        protected String buildValue_() {
            return ((PersistenceUnit)this.subject).getName();
        }
    }
}

