/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.structure;

import org.eclipse.jpt.common.ui.internal.jface.StaticItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProviderFactory;
import org.eclipse.jpt.common.ui.jface.ItemLabelProvider;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.JarFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.jpt.jpa.ui.internal.platform.generic.ClassRefItemLabelProvider;
import org.eclipse.jpt.jpa.ui.internal.platform.generic.JarFileRefItemLabelProvider;
import org.eclipse.jpt.jpa.ui.internal.platform.generic.MappingFileRefItemLabelProvider;
import org.eclipse.jpt.jpa.ui.internal.platform.generic.PersistenceUnitItemLabelProvider;

public class PersistenceStructureItemLabelProviderFactory
implements ItemExtendedLabelProviderFactory {
    private static final ItemExtendedLabelProviderFactory INSTANCE = new PersistenceStructureItemLabelProviderFactory();

    public static ItemExtendedLabelProviderFactory instance() {
        return INSTANCE;
    }

    protected PersistenceStructureItemLabelProviderFactory() {
    }

    public ItemExtendedLabelProvider buildProvider(Object item, ItemExtendedLabelProvider.Manager manager) {
        if (item instanceof Persistence) {
            return this.buildPersistenceProvider((Persistence)item, manager);
        }
        if (item instanceof PersistenceUnit) {
            return this.buildPersistenceUnitProvider((PersistenceUnit)item, manager);
        }
        if (item instanceof MappingFileRef) {
            return this.buildMappingFileRefProvider((MappingFileRef)item, manager);
        }
        if (item instanceof ClassRef) {
            return this.buildClassRefProvider((ClassRef)item, manager);
        }
        if (item instanceof JarFileRef) {
            return this.buildJarFileRefProvider((JarFileRef)item, manager);
        }
        return null;
    }

    protected ItemExtendedLabelProvider buildPersistenceProvider(Persistence item, ItemExtendedLabelProvider.Manager manager) {
        return new StaticItemExtendedLabelProvider(JptJpaUiPlugin.getImage("full/obj16/persistence"), JptUiMessages.PersistenceItemLabelProviderFactory_persistenceLabel, this.buildPersistenceDescription(item));
    }

    protected String buildPersistenceDescription(Persistence item) {
        StringBuilder sb = new StringBuilder();
        sb.append(JptUiMessages.PersistenceItemLabelProviderFactory_persistenceLabel);
        sb.append(" - ");
        sb.append(item.getResource().getFullPath().makeRelative());
        return sb.toString();
    }

    protected ItemExtendedLabelProvider buildPersistenceUnitProvider(PersistenceUnit item, ItemExtendedLabelProvider.Manager manager) {
        return new PersistenceUnitItemLabelProvider(item, (ItemLabelProvider.Manager)manager);
    }

    protected ItemExtendedLabelProvider buildMappingFileRefProvider(MappingFileRef item, ItemExtendedLabelProvider.Manager manager) {
        return new MappingFileRefItemLabelProvider(item, (ItemLabelProvider.Manager)manager);
    }

    protected ItemExtendedLabelProvider buildClassRefProvider(ClassRef item, ItemExtendedLabelProvider.Manager manager) {
        return new ClassRefItemLabelProvider(item, (ItemLabelProvider.Manager)manager);
    }

    protected ItemExtendedLabelProvider buildJarFileRefProvider(JarFileRef item, ItemExtendedLabelProvider.Manager manager) {
        return new JarFileRefItemLabelProvider(item, (ItemLabelProvider.Manager)manager);
    }

    public String toString() {
        return StringTools.buildSingletonToString((Object)this);
    }
}

