/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.views;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.ui.internal.jface.AbstractSelectionProvider;
import org.eclipse.jpt.common.ui.internal.jface.ItemTreeStateProviderManager;
import org.eclipse.jpt.common.ui.internal.jface.SelectionChangedAdapter;
import org.eclipse.jpt.common.ui.internal.jface.SimpleMessageTreeContent;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.ui.jface.ItemTreeStateProviderFactoryProvider;
import org.eclipse.jpt.common.ui.jface.TreeStateProvider;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.jpt.jpa.ui.internal.views.JpaStructureView;
import org.eclipse.jpt.jpa.ui.selection.JpaEditorManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.navigator.IDescriptionProvider;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaStructurePage
extends Page {
    private final JpaStructureView structureView;
    private final JpaEditorManager editorManager;
    private final PropertyChangeListener jpaFileListener = new JpaFileListener();
    private final PropertyChangeListener jpaSelectionListener = new JpaSelectionListener();
    private final SelectionProvider selectionProvider = new SelectionProvider();
    private Composite control;
    private TreeViewer treeViewer;
    private final ISelectionChangedListener treePostSelectionListener = new TreePostSelectionChangedListener();

    public JpaStructurePage(JpaStructureView structureView, JpaEditorManager editorManager) {
        this.structureView = structureView;
        this.editorManager = editorManager;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this.selectionProvider);
    }

    public void createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new FillLayout());
        this.treeViewer = new TreeViewer(this.control, 770);
        this.treeViewer.setAutoExpandLevel(2);
        this.setTreeViewerJpaFile(this.getEditorJpaFile());
        this.engageListeners();
        this.initializeContextMenu();
    }

    private void engageListeners() {
        this.getEditorJpaFileModel().addPropertyChangeListener("value", this.jpaFileListener);
        this.getEditorJpaSelectionModel().addPropertyChangeListener("value", this.jpaSelectionListener);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.selectionProvider);
        this.treeViewer.addPostSelectionChangedListener(this.treePostSelectionListener);
    }

    public void dispose() {
        this.disengageListeners();
        super.dispose();
    }

    private void disengageListeners() {
        this.treeViewer.removePostSelectionChangedListener(this.treePostSelectionListener);
        this.treeViewer.removeSelectionChangedListener((ISelectionChangedListener)this.selectionProvider);
        this.getEditorJpaSelectionModel().removePropertyChangeListener("value", this.jpaSelectionListener);
        this.getEditorJpaFileModel().removePropertyChangeListener("value", this.jpaFileListener);
    }

    private void initializeContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)new MenuListener());
        Tree tree = this.treeViewer.getTree();
        tree.setMenu(menuManager.createContextMenu((Control)tree));
        this.structureView.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.treeViewer);
    }

    private JpaFile getEditorJpaFile() {
        return (JpaFile)this.getEditorJpaFileModel().getValue();
    }

    private PropertyValueModel<JpaFile> getEditorJpaFileModel() {
        return this.editorManager.getJpaFileModel();
    }

    void setTreeViewerInput(JpaFile jpaFile) {
        this.execute(new SetTreeViewerInputRunnable(jpaFile));
    }

    void setTreeViewerInput_(JpaFile jpaFile) {
        if (this.treeViewer.getControl().isDisposed()) {
            return;
        }
        this.treeViewer.setInput(null);
        this.setTreeViewerJpaFile(jpaFile);
    }

    private void setTreeViewerJpaFile(JpaFile jpaFile) {
        if (jpaFile == null || jpaFile.getResourceModel().getResourceType() == null) {
            this.setTreeViewerMessage(JptUiMessages.JpaStructureView_structureNotAvailable);
        } else {
            ItemTreeStateProviderFactoryProvider factoryProvider = this.getFactoryProvider(jpaFile);
            if (factoryProvider == null) {
                this.setTreeViewerMessage(this.buildMissingStructureProviderMessage(jpaFile));
            } else {
                this.setTreeViewerJpaFile(jpaFile, factoryProvider);
                this.setTreeViewerJpaSelection_(this.getEditorJpaSelection());
            }
        }
    }

    private ItemTreeStateProviderFactoryProvider getFactoryProvider(JpaFile jpaFile) {
        return this.getPlatformUi(jpaFile).getStructureViewFactoryProvider(jpaFile);
    }

    private JpaPlatformUi getPlatformUi(JpaFile jpaFile) {
        return (JpaPlatformUi)jpaFile.getJpaProject().getJpaPlatform().getAdapter(JpaPlatformUi.class);
    }

    private String buildMissingStructureProviderMessage(JpaFile jpaFile) {
        JptResourceType resourceType = jpaFile.getResourceModel().getResourceType();
        String contentType = resourceType.getContentType().getName();
        String version = resourceType.getVersion();
        return NLS.bind((String)JptUiMessages.JpaStructureView_structureProviderNotAvailable, (Object)contentType, (Object)version);
    }

    private void setTreeViewerJpaFile(JpaFile jpaFile, ItemTreeStateProviderFactoryProvider factoryProvider) {
        TreeStateProvider provider = this.buildStateProvider(factoryProvider);
        this.treeViewer.setContentProvider((IContentProvider)provider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.treeViewer.setInput((Object)jpaFile);
    }

    private TreeStateProvider buildStateProvider(ItemTreeStateProviderFactoryProvider factoryProvider) {
        return new ItemTreeStateProviderManager(factoryProvider.getItemContentProviderFactory(), factoryProvider.getItemLabelProviderFactory());
    }

    private void setTreeViewerMessage(String message) {
        this.treeViewer.setContentProvider((IContentProvider)SimpleMessageTreeContent.contentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)SimpleMessageTreeContent.labelProvider());
        this.treeViewer.setInput((Object)new SimpleMessageTreeContent(message));
    }

    private JpaStructureNode getEditorJpaSelection() {
        return (JpaStructureNode)this.getEditorJpaSelectionModel().getValue();
    }

    private void setEditorJpaSelection(JpaStructureNode selection) {
        this.getEditorJpaSelectionModel().setValue((Object)selection);
    }

    private ModifiablePropertyValueModel<JpaStructureNode> getEditorJpaSelectionModel() {
        return this.editorManager.getJpaSelectionModel();
    }

    void setTreeViewerJpaSelection(JpaStructureNode selection) {
        this.execute(new SetTreeViewerSelectionRunnable(selection));
    }

    void setTreeViewerJpaSelection_(JpaStructureNode selection) {
        if (selection != this.getTreeViewerJpaSelection()) {
            this.setTreeViewerSelection((ISelection)(selection == null ? null : new StructuredSelection((Object)selection)));
        }
    }

    void setTreeViewerSelection(ISelection selection) {
        if (this.treeViewer != null) {
            this.treeViewer.setSelection(selection, true);
        }
    }

    private JpaStructureNode getTreeViewerJpaSelection() {
        return this.convertToJpaSelection_(this.getTreeViewerSelection());
    }

    IStructuredSelection getTreeViewerSelection() {
        return this.treeViewer == null ? TreeSelection.EMPTY : this.filterSelection((IStructuredSelection)((ITreeSelection)this.treeViewer.getSelection()));
    }

    IStructuredSelection filterSelection(IStructuredSelection selection) {
        return selection.size() > 0 && selection.getFirstElement() instanceof JpaStructureNode ? selection : TreeSelection.EMPTY;
    }

    private JpaStructureNode convertToJpaSelection(IStructuredSelection selection) {
        return this.convertToJpaSelection_(this.filterSelection(selection));
    }

    private JpaStructureNode convertToJpaSelection_(IStructuredSelection filteredSelection) {
        return filteredSelection.size() != 1 ? null : (JpaStructureNode)filteredSelection.getFirstElement();
    }

    void treePostSelectionChanged(ISelection selection) {
        this.setEditorJpaSelection(this.convertToJpaSelection(selection));
        this.updateStatusLine(selection);
    }

    private JpaStructureNode convertToJpaSelection(ISelection selection) {
        return selection instanceof IStructuredSelection ? this.convertToJpaSelection((IStructuredSelection)selection) : null;
    }

    private void updateStatusLine(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.updateStatusLine((IStructuredSelection)selection);
        } else {
            this.getStatusLineManager().setMessage("");
        }
    }

    private void updateStatusLine(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            this.getStatusLineManager().setMessage("");
        } else if (selection.size() > 1) {
            Integer size = selection.size();
            String msg = NLS.bind((String)JptUiMessages.JpaStructureView_numItemsSelected, (Object)size);
            this.getStatusLineManager().setMessage(msg);
        } else {
            Object first = selection.getFirstElement();
            ILabelProvider labelProvider = (ILabelProvider)this.treeViewer.getLabelProvider();
            Image image = labelProvider.getImage(first);
            String msg = labelProvider.getText(first);
            if (first instanceof JpaStructureNode) {
                msg = ((IDescriptionProvider)labelProvider).getDescription(first);
            }
            this.getStatusLineManager().setMessage(image, msg);
        }
    }

    private IStatusLineManager getStatusLineManager() {
        return this.getSite().getActionBars().getStatusLineManager();
    }

    public Control getControl() {
        return this.control;
    }

    public void setFocus() {
        this.control.setFocus();
    }

    private void execute(Runnable runnable) {
        SWTUtil.execute((Display)this.getSite().getShell().getDisplay(), (Runnable)runnable);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)((Object)this), (Object)this.getEditorJpaFile());
    }

    class JpaFileListener
    extends PropertyChangeAdapter {
        JpaFileListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            JpaStructurePage.this.setTreeViewerInput((JpaFile)event.getNewValue());
        }
    }

    class JpaSelectionListener
    extends PropertyChangeAdapter {
        JpaSelectionListener() {
        }

        public void propertyChanged(PropertyChangeEvent event) {
            JpaStructurePage.this.setTreeViewerJpaSelection((JpaStructureNode)event.getNewValue());
        }
    }

    class MenuListener
    implements IMenuListener {
        MenuListener() {
        }

        public void menuAboutToShow(IMenuManager menuManager) {
            menuManager.add((IContributionItem)new Separator("additions"));
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    class SelectionProvider
    extends AbstractSelectionProvider
    implements ISelectionChangedListener {
        SelectionProvider() {
        }

        public ISelection getSelection() {
            return JpaStructurePage.this.getTreeViewerSelection();
        }

        public void setSelection(ISelection selection) {
            JpaStructurePage.this.setTreeViewerSelection(selection);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.fireSelectionChanged(this.filterSelection(event.getSelection()));
        }

        private ISelection filterSelection(ISelection selection) {
            return selection instanceof IStructuredSelection ? JpaStructurePage.this.filterSelection((IStructuredSelection)selection) : selection;
        }
    }

    class SetTreeViewerInputRunnable
    implements Runnable {
        private final JpaFile jpaFile;

        SetTreeViewerInputRunnable(JpaFile jpaFile) {
            this.jpaFile = jpaFile;
        }

        public void run() {
            JpaStructurePage.this.setTreeViewerInput_(this.jpaFile);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)this.jpaFile);
        }
    }

    class SetTreeViewerSelectionRunnable
    implements Runnable {
        private final JpaStructureNode selection;

        SetTreeViewerSelectionRunnable(JpaStructureNode selection) {
            this.selection = selection;
        }

        public void run() {
            JpaStructurePage.this.setTreeViewerJpaSelection_(this.selection);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)this.selection);
        }
    }

    class TreePostSelectionChangedListener
    extends SelectionChangedAdapter {
        TreePostSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            JpaStructurePage.this.treePostSelectionChanged(event.getSelection());
        }
    }
}

