/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.views;

import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.jpt.jpa.ui.internal.views.JpaStructurePage;
import org.eclipse.jpt.jpa.ui.selection.JpaEditorManager;
import org.eclipse.jpt.jpa.ui.selection.JpaViewManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public class JpaStructureView
extends PageBookView {
    private volatile Manager manager;

    public void createPartControl(Composite parent) {
        this.manager = this.buildManager();
        super.createPartControl(parent);
    }

    private Manager buildManager() {
        return new Manager(this.getPageManager());
    }

    private JpaViewManager.PageManager getPageManager() {
        return (JpaViewManager.PageManager)this.getAdapter(JpaViewManager.PageManager.class);
    }

    protected IPage createDefaultPage(PageBook book) {
        DefaultPage page = new DefaultPage();
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        return page;
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        return page == null ? null : page.getActiveEditor();
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        super.partBroughtToTop(part);
        this.partActivated(part);
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof IEditorPart;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        IEditorPart editor = (IEditorPart)part;
        JpaEditorManager editorManager = this.manager.getEditorManager(editor);
        if (editorManager == null) {
            return null;
        }
        JpaStructurePage page = new JpaStructurePage(this, editorManager);
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)this.getPageBook());
        return new PageBookView.PageRec((IWorkbenchPart)editor, (IPage)page);
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        JpaStructurePage page = (JpaStructurePage)pageRecord.page;
        page.dispose();
        pageRecord.dispose();
    }

    public void dispose() {
        super.dispose();
        if (this.manager != null) {
            this.manager.dispose();
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)((Object)this));
    }

    static class DefaultPage
    extends Page {
        private Composite composite;

        DefaultPage() {
        }

        public void createControl(Composite parent) {
            this.composite = new Composite(parent, 0);
            this.composite.setLayout((Layout)new FillLayout());
            Label label = new Label(this.composite, 16576);
            label.setText(JptUiMessages.JpaStructureView_structureNotAvailable);
        }

        public Control getControl() {
            return this.composite;
        }

        public void setFocus() {
            this.composite.setFocus();
        }
    }

    class Manager
    implements JpaViewManager {
        private final JpaViewManager.PageManager pageManager;

        Manager(JpaViewManager.PageManager pageManager) {
            if (pageManager == null) {
                throw new NullPointerException();
            }
            this.pageManager = pageManager;
            this.pageManager.addViewManager(this);
        }

        public IViewPart getView() {
            return JpaStructureView.this;
        }

        JpaEditorManager getEditorManager(IEditorPart editor) {
            return this.pageManager.getEditorManager(editor);
        }

        void dispose() {
            this.pageManager.removeViewManager(this);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

