/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards;

import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.jpa.core.internal.facet.JpaFacetInstallDataModelProperties;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.JptJpaDbPlugin;
import org.eclipse.jpt.jpa.db.ui.internal.DTPUiTools;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.jpt.jpa.ui.internal.wizards.JpaFacetActionPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;

public class JpaFacetInstallPage
extends JpaFacetActionPage
implements JpaFacetInstallDataModelProperties {
    public JpaFacetInstallPage() {
        super("jpt.jpa.facet.install.page");
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = super.createTopLevelComposite(parent);
        this.getHelpSystem().setHelp((Control)composite, "org.eclipse.jpt.jpa.ui.dialog_newJPAProjectFacet");
        return composite;
    }

    protected void addSubComposites(Composite composite) {
        new JpaFacetActionPage.PlatformGroup(composite);
        new JpaFacetActionPage.ClasspathConfigGroup(composite);
        new ConnectionGroup(composite);
        new JpaFacetActionPage.PersistentClassManagementGroup(composite);
        new OrmXmlGroup(composite);
    }

    protected String[] getValidationPropertyNames() {
        Object[] validationPropertyNames = super.getValidationPropertyNames();
        return (String[])ArrayTools.addAll((Object[])validationPropertyNames, (Object[])new String[]{"JpaFacetInstallDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH", "JpaFacetInstallDataModelProperties.DB_DRIVER_NAME"});
    }

    protected final class ConnectionGroup {
        private final Combo connectionCombo;
        private Link connectionLink;
        private Link connectLink;
        private final Button addDriverLibraryButton;
        private final Label driverLibraryLabel;
        private final Combo driverLibraryCombo;
        private final Button overrideDefaultCatalogButton;
        private final Label defaultCatalogLabel;
        private final Combo defaultCatalogCombo;
        private final Button overrideDefaultSchemaButton;
        private final Label defaultSchemaLabel;
        private final Combo defaultSchemaCombo;

        public ConnectionGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setText(JptUiMessages.JpaFacetWizardPage_connectionLabel);
            group.setLayout((Layout)new GridLayout(3, false));
            group.setLayoutData((Object)new GridData(768));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, "org.eclipse.jpt.jpa.ui.dialog_addJavaPersistence_database");
            this.connectionCombo = JpaFacetInstallPage.this.createCombo((Composite)group, 3, true);
            JpaFacetInstallPage.this.synchHelper.synchCombo(this.connectionCombo, "JpaFacetDataModelProperties.CONNECTION", null);
            this.connectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionGroup.this.updateConnectionStatus();
                }
            });
            this.connectionLink = new Link((Composite)group, 0);
            GridData data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            this.connectionLink.setLayoutData((Object)data);
            this.connectionLink.setText(JptUiMessages.JpaFacetWizardPage_connectionLink);
            this.connectionLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionGroup.this.openNewConnectionWizard();
                }
            });
            this.connectLink = new Link((Composite)group, 0);
            data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            this.connectLink.setLayoutData((Object)data);
            this.connectLink.setText(JptUiMessages.JpaFacetWizardPage_connectLink);
            this.connectLink.setEnabled(false);
            this.connectLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionGroup.this.openConnectionProfile();
                }
            });
            this.addDriverLibraryButton = JpaFacetInstallPage.this.createButton((Composite)group, 3, JptUiMessages.JpaFacetWizardPage_addDriverLibraryLabel, 32);
            this.addDriverLibraryButton.setSelection(false);
            JpaFacetInstallPage.this.synchHelper.synchCheckbox(this.addDriverLibraryButton, "JpaFacetInstallDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH", null);
            this.driverLibraryLabel = new Label((Composite)group, 16384);
            this.driverLibraryLabel.setText(JptUiMessages.JpaFacetWizardPage_driverLibraryLabel);
            GridData gd = new GridData();
            gd.horizontalSpan = 1;
            this.driverLibraryLabel.setLayoutData((Object)gd);
            this.driverLibraryCombo = JpaFacetInstallPage.this.createCombo((Composite)group, 1, true);
            JpaFacetInstallPage.this.synchHelper.synchCombo(this.driverLibraryCombo, "JpaFacetInstallDataModelProperties.DB_DRIVER_NAME", new Control[]{this.driverLibraryLabel});
            this.overrideDefaultCatalogButton = JpaFacetInstallPage.this.createButton((Composite)group, 3, JptUiMessages.JpaFacetWizardPage_overrideDefaultCatalogLabel, 32);
            this.overrideDefaultCatalogButton.setSelection(false);
            JpaFacetInstallPage.this.synchHelper.synchCheckbox(this.overrideDefaultCatalogButton, "JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_CATALOG", null);
            this.defaultCatalogLabel = new Label((Composite)group, 16384);
            this.defaultCatalogLabel.setText(JptUiMessages.JpaFacetWizardPage_defaultCatalogLabel);
            gd = new GridData();
            gd.horizontalSpan = 1;
            this.defaultCatalogLabel.setLayoutData((Object)gd);
            this.defaultCatalogCombo = JpaFacetInstallPage.this.createCombo((Composite)group, 1, true);
            JpaFacetInstallPage.this.synchHelper.synchCombo(this.defaultCatalogCombo, "JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_CATALOG", new Control[]{this.defaultCatalogLabel});
            this.overrideDefaultSchemaButton = JpaFacetInstallPage.this.createButton((Composite)group, 3, JptUiMessages.JpaFacetWizardPage_overrideDefaultSchemaLabel, 32);
            this.overrideDefaultSchemaButton.setSelection(false);
            JpaFacetInstallPage.this.synchHelper.synchCheckbox(this.overrideDefaultSchemaButton, "JpaFacetDataModelProperties.USER_WANTS_TO_OVERRIDE_DEFAULT_SCHEMA", null);
            this.defaultSchemaLabel = new Label((Composite)group, 16384);
            this.defaultSchemaLabel.setText(JptUiMessages.JpaFacetWizardPage_defaultSchemaLabel);
            gd = new GridData();
            gd.horizontalSpan = 1;
            this.defaultSchemaLabel.setLayoutData((Object)gd);
            this.defaultSchemaCombo = JpaFacetInstallPage.this.createCombo((Composite)group, 1, true);
            JpaFacetInstallPage.this.synchHelper.synchCombo(this.defaultSchemaCombo, "JpaFacetDataModelProperties.USER_OVERRIDE_DEFAULT_SCHEMA", new Control[]{this.defaultSchemaLabel});
        }

        private void openNewConnectionWizard() {
            String connectionName = DTPUiTools.createNewConnectionProfile();
            if (connectionName != null) {
                JpaFacetInstallPage.this.model.setProperty("JpaFacetDataModelProperties.CONNECTION", (Object)connectionName);
                this.updateConnectionStatus();
            }
        }

        private void openConnectionProfile() {
            ConnectionProfile cp = this.getConnectionProfile();
            if (cp != null) {
                cp.connect();
                JpaFacetInstallPage.this.model.setBooleanProperty("JpaFacetDataModelProperties.CONNECTION_ACTIVE", cp.isActive());
                this.updateConnectionStatus();
            }
        }

        private void updateConnectionStatus() {
            ConnectionProfile cp = this.getConnectionProfile();
            this.updateConnectLink(cp);
            this.addDriverLibraryButton.setEnabled(cp != null);
        }

        private ConnectionProfile getConnectionProfile() {
            return JptJpaDbPlugin.getConnectionProfileFactory().buildConnectionProfile(JpaFacetInstallPage.this.model.getStringProperty("JpaFacetDataModelProperties.CONNECTION"));
        }

        private void updateConnectLink(ConnectionProfile cp) {
            this.connectLink.setEnabled(cp != null && cp.isDisconnected());
            if (cp != null && cp.isConnected()) {
                this.updateConnectLinkText(JptUiMessages.JpaFacetWizardPage_connectedText);
            } else {
                this.updateConnectLinkText(JptUiMessages.JpaFacetWizardPage_connectLink);
            }
        }

        private void updateConnectLinkText(String text) {
            this.connectLink.setText(text);
            SWTUtil.reflow((Composite)this.connectLink.getParent());
        }
    }

    protected final class OrmXmlGroup {
        private final Button createOrmXmlButton;

        public OrmXmlGroup(Composite composite) {
            Composite group = new Composite(composite, 0);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(768));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, "org.eclipse.jpt.jpa.ui.dialog_createORM");
            this.createOrmXmlButton = new Button(group, 32);
            this.createOrmXmlButton.setText(JptUiMessages.JpaFacetWizardPage_createOrmXmlButton);
            JpaFacetInstallPage.this.synchHelper.synchCheckbox(this.createOrmXmlButton, "JpaFacetInstallDataModelProperties.CREATE_ORM_XML", null);
        }
    }
}

