/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.jpt.jpa.ui.internal.wizards.JpaMakePersistentWizardPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaMakePersistentWizard
extends Wizard {
    public static final String HELP_CONTEXT_ID = "org.eclipse.jpt.jpa.ui.GenerateEntitiesFromSchemaWizard";
    final JpaProject jpaProject;
    final List<IType> selectedTypes;
    private JpaMakePersistentWizardPage makePersistentWizardPage;
    protected final ResourceManager resourceManager;

    public JpaMakePersistentWizard(JpaProject jpaProject, List<IType> selectedTypes) {
        this.jpaProject = jpaProject;
        this.selectedTypes = selectedTypes;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.setWindowTitle(JptUiMessages.JpaMakePersistentWizardPage_title);
        this.setDefaultPageImageDescriptor(JptJpaUiPlugin.getImageDescriptor("full/wizban/new_entity_wizban"));
    }

    public void addPages() {
        this.setForcePreviousAndNextButtons(true);
        this.makePersistentWizardPage = new JpaMakePersistentWizardPage(this.jpaProject, this.selectedTypes, HELP_CONTEXT_ID);
        this.addPage((IWizardPage)this.makePersistentWizardPage);
    }

    public boolean performFinish() {
        try {
            this.makePersistentWizardPage.performFinish();
        }
        catch (InvocationTargetException e) {
            JptJpaUiPlugin.log(e);
        }
        return true;
    }

    protected PersistenceUnit getPersistenceUnit(JpaProject jpaProject) {
        Persistence persistence;
        PersistenceXml persistenceXml = jpaProject.getRootContextNode().getPersistenceXml();
        if (persistenceXml != null && (persistence = persistenceXml.getPersistence()) != null && persistence.getPersistenceUnitsSize() > 0) {
            return (PersistenceUnit)persistence.getPersistenceUnits().iterator().next();
        }
        return null;
    }

    public void dispose() {
        this.resourceManager.dispose();
        super.dispose();
    }
}

