/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.gen;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.ui.internal.util.TableLayoutComposite;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.gen.internal.ORMGenCustomizer;
import org.eclipse.jpt.jpa.ui.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.ImageRepository;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.DatabaseGroup;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.GenerateEntitiesFromSchemaWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.JptUiEntityGenMessages;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.PromptJPAProjectWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TablesSelectorWizardPage
extends WizardPage {
    private static final int TABLE_COLUMN_INDEX = 0;
    private JpaProject jpaProject;
    private Schema schema;
    private ORMGenCustomizer customizer;
    private boolean updatePersistenceXml = true;
    private boolean isDynamic;
    private DatabaseGroup databaseGroup;
    private CheckboxTableViewer tableTable;
    private Button updatePersistenceXmlCheckBox;
    private Button refreshTablesButton;
    private Button selectAllButton;
    private Button deselectAllButton;
    private WorkspaceJob fetchTablesJob;
    protected final ResourceManager resourceManager;

    public TablesSelectorWizardPage(JpaProject jpaProject, ResourceManager resourceManager, boolean isDynamic) {
        super("TablesSelectorWizardPage");
        this.jpaProject = jpaProject;
        this.resourceManager = resourceManager;
        this.schema = jpaProject.getDefaultDbSchema();
        this.isDynamic = isDynamic;
        this.setTitle(JptUiEntityGenMessages.GenerateEntitiesWizard_tableSelectPage_selectTable);
        this.setMessage(JptUiEntityGenMessages.GenerateEntitiesWizard_tableSelectPage_chooseEntityTable);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.setPageComplete(true);
        this.setControl((Control)this.buildTopLevelControl(parent));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.doStatusUpdate();
        this.updateButtons();
    }

    public void dispose() {
        if (this.databaseGroup != null) {
            this.databaseGroup.dispose();
        }
        super.dispose();
    }

    public final void performHelp() {
        this.getHelpSystem().displayHelp("org.eclipse.jpt.jpa.ui.GenerateEntitiesFromSchemaWizard");
    }

    protected final IWorkbenchHelpSystem getHelpSystem() {
        return PlatformUI.getWorkbench().getHelpSystem();
    }

    public IWizardPage getPreviousPage() {
        IWizardPage previousPage = super.getPreviousPage();
        if (previousPage instanceof PromptJPAProjectWizardPage) {
            return previousPage.getPreviousPage();
        }
        return previousPage;
    }

    private Composite buildTopLevelControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.getHelpSystem().setHelp((Control)composite, "org.eclipse.jpt.jpa.ui.dialog_selectTablesPage");
        this.databaseGroup = this.createDatabaseGroup(composite, 400);
        this.createTablesSelectionControl(composite, nColumns);
        if (!this.isDynamic) {
            this.updatePersistenceXmlCheckBox = this.buildUpdatePersistenceXmlCheckBox(composite);
            this.fillColumns((Control)this.updatePersistenceXmlCheckBox, 3);
        }
        new Label(composite, 0);
        this.buildRestoreDefaultsButton(composite);
        this.updateSelectionState(this.databaseGroup.getSelectedSchema());
        this.getHelpSystem().setHelp(this.tableTable.getControl(), "org.eclipse.jpt.jpa.ui.dialog_generateEntities_tables");
        return composite;
    }

    private void createTablesSelectionControl(Composite parent, int columns) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        Label tableLabel = new Label(parent, 0);
        tableLabel.setLayoutData((Object)gridData);
        tableLabel.setText(JptUiEntityGenMessages.GenerateEntitiesWizard_tableSelectPage_tables);
        TableLayoutComposite layout = new TableLayoutComposite(parent, 0);
        this.addColumnLayoutData(layout);
        this.tableTable = this.buildCheckboxTableViewer(this.buildTable((Composite)layout));
        this.createButtonComposite(parent);
        this.initTablesSelectionControl(this.possibleTables());
    }

    private void createButtonComposite(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout buttonLayout = new GridLayout(1, false);
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)buttonLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        buttonComposite.setLayoutData((Object)data);
        this.selectAllButton = this.buildSelectAllButton(buttonComposite);
        this.deselectAllButton = this.buildDeselectAllButton(buttonComposite);
        this.refreshTablesButton = this.buildRefreshTablesButton(buttonComposite);
    }

    private DatabaseGroup createDatabaseGroup(Composite parent, int widthHint) {
        DatabaseGroup dbGroup = new DatabaseGroup(this.getContainer(), this.jpaProject, parent, this.resourceManager, widthHint);
        class DatabasePageListener
        implements DatabaseGroup.Listener {
            DatabasePageListener() {
            }

            public void selectedConnectionProfileChanged(ConnectionProfile connectionProfile) {
                TablesSelectorWizardPage.this.jpaProject.getDataSource().setConnectionProfileName(connectionProfile.getName());
            }

            public void selectedSchemaChanged(Schema schema) {
                if (schema == null) {
                    TablesSelectorWizardPage.this.updateTablesListViewer(Collections.EMPTY_LIST);
                } else {
                    TablesSelectorWizardPage.this.jpaProject.setUserOverrideDefaultSchema(schema.getIdentifier());
                    TablesSelectorWizardPage.this.setSchema(schema);
                    TablesSelectorWizardPage.this.updateButtons();
                    TablesSelectorWizardPage.this.updateSelectionState(schema);
                }
                TablesSelectorWizardPage.this.doStatusUpdate();
            }
        }
        dbGroup.addListener(new DatabasePageListener());
        dbGroup.init();
        return dbGroup;
    }

    private Schema getSchema() {
        return this.schema;
    }

    private void setSchema(Schema s) {
        this.schema = s;
    }

    private boolean connectionIsActive() {
        return this.databaseGroup.connectionIsActive();
    }

    private Collection<org.eclipse.jpt.jpa.db.Table> getTables(Schema schema) {
        if (this.fetchTablesJobIsRunning()) {
            return Collections.emptyList();
        }
        return CollectionTools.collection((Iterable)schema.getTables());
    }

    private Collection<org.eclipse.jpt.jpa.db.Table> possibleTables() {
        Schema schema = this.getSchema();
        if (schema != null && schema.getName() != null) {
            return this.getTables(schema);
        }
        return Collections.emptyList();
    }

    private void updateButtons() {
        if (this.selectAllButton != null) {
            this.selectAllButton.setEnabled(this.connectionIsActive());
        }
        if (this.refreshTablesButton != null) {
            this.refreshTablesButton.setEnabled(this.connectionIsActive());
        }
        if (this.deselectAllButton != null) {
            this.deselectAllButton.setEnabled(this.connectionIsActive());
        }
    }

    private boolean updatePersistenceXml() {
        return this.updatePersistenceXml;
    }

    private void setShouldUpdatePersistenceXml(boolean updatePersistenceXml) {
        this.updatePersistenceXml = updatePersistenceXml;
        this.doStatusUpdate();
    }

    private void restoreUpdatePersistenceXmlDefault() {
        this.updatePersistenceXmlCheckBox.setSelection(true);
        this.setShouldUpdatePersistenceXml(true);
    }

    private void selectAllTables() {
        this.tableTable.setAllChecked(true);
        this.doStatusUpdate();
    }

    private void deselectAllTables() {
        this.tableTable.setAllChecked(false);
        this.doStatusUpdate();
    }

    private void refreshTables() {
        this.schema.refresh();
        this.updateSelectionState(this.databaseGroup.getSelectedSchema());
    }

    private void initTablesSelectionControl(Collection<org.eclipse.jpt.jpa.db.Table> possibleTables) {
        this.tableTable.setInput(possibleTables);
    }

    private Table buildTable(Composite parent) {
        Table table = new Table(parent, 68388);
        TableColumn tableNameColumn = new TableColumn(table, 0, 0);
        tableNameColumn.setText(JptUiEntityGenMessages.GenerateEntitiesWizard_tableSelectPage_tableColumn);
        tableNameColumn.setResizable(true);
        table.addKeyListener((KeyListener)this.buildTableKeyListener());
        GridData gridData = new GridData(1808);
        gridData.heightHint = SWTUtil.getTableHeightHint((Table)table, (int)20);
        gridData.widthHint = 250;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        Color backgroundColor = new Color((Device)Display.getDefault(), 255, 0, 0);
        parent.setLayoutData((Object)gridData);
        parent.setBackground(backgroundColor);
        backgroundColor.dispose();
        return table;
    }

    private CheckboxTableViewer buildCheckboxTableViewer(Table parent) {
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(parent);
        tableViewer.setUseHashlookup(true);
        tableViewer.setLabelProvider(this.buildTableTableLabelProvider());
        tableViewer.setContentProvider(this.buildTableTableContentProvider());
        tableViewer.setSorter(this.buildTableViewerSorter());
        tableViewer.addPostSelectionChangedListener(this.buildTableSelectionChangedListener());
        return tableViewer;
    }

    private ViewerSorter buildTableViewerSorter() {
        return new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((org.eclipse.jpt.jpa.db.Table)e1).getName().compareTo(((org.eclipse.jpt.jpa.db.Table)e2).getName());
            }
        };
    }

    private Button buildUpdatePersistenceXmlCheckBox(Composite parent) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(JptUiEntityGenMessages.GenerateEntitiesWizard_tableSelectPage_updatePersistenceXml);
        checkBox.setSelection(this.updatePersistenceXml());
        checkBox.addSelectionListener(this.buildUpdatePersistenceXmlSelectionListener());
        return checkBox;
    }

    private Button buildRestoreDefaultsButton(Composite parent) {
        Button button = new Button(parent, 8);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 0x1000008;
        button.setLayoutData((Object)gridData);
        button.setText(JptUiEntityGenMessages.GenerateEntitiesWizard_tableSelectPage_Restore_Defaults);
        button.addSelectionListener(this.buildRestoreDefaultsSelectionListener());
        return button;
    }

    private Button buildSelectAllButton(Composite parent) {
        Button button = this.buildSelectionButton(parent, JptUiMessages.General_selectAll, ImageRepository.getSelectAllButtonImage(this.resourceManager));
        button.addSelectionListener(this.buildSelectAllSelectionListener());
        return button;
    }

    private Button buildDeselectAllButton(Composite parent) {
        Button button = this.buildSelectionButton(parent, JptUiMessages.General_deselectAll, ImageRepository.getDeselectAllButtonImage(this.resourceManager));
        button.addSelectionListener(this.buildDeselectAllSelectionListener());
        return button;
    }

    private Button buildRefreshTablesButton(Composite parent) {
        Button button = this.buildSelectionButton(parent, JptUiMessages.General_refresh, ImageRepository.getRefreshButtonImage(this.resourceManager));
        button.addSelectionListener(this.buildRefreshTablesSelectionListener());
        return button;
    }

    private Button buildSelectionButton(Composite parent, String toolTipText, Image buttonImage) {
        Button button = new Button(parent, 8);
        button.setToolTipText(toolTipText);
        button.setImage(buttonImage);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        button.setLayoutData((Object)gridData);
        return button;
    }

    private void addColumnLayoutData(TableLayoutComposite layout) {
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
    }

    private void fillColumns(Control c, int columns) {
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = columns;
        layoutData.verticalAlignment = 4;
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = false;
        c.setLayoutData((Object)layoutData);
    }

    private IBaseLabelProvider buildTableTableLabelProvider() {
        return new TableTableLabelProvider();
    }

    private IContentProvider buildTableTableContentProvider() {
        return new TableTableContentProvider();
    }

    private void handleTablesListSelectionChanged(SelectionChangedEvent event) {
        this.doStatusUpdate();
    }

    private KeyAdapter buildTableKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B && e.stateMask == 0) {
                    TablesSelectorWizardPage.this.editEntityNameIfPossible();
                    e.doit = false;
                }
            }
        };
    }

    private ISelectionChangedListener buildTableSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TablesSelectorWizardPage.this.handleTablesListSelectionChanged(event);
            }
        };
    }

    private SelectionListener buildUpdatePersistenceXmlSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TablesSelectorWizardPage.this.setShouldUpdatePersistenceXml(TablesSelectorWizardPage.this.updatePersistenceXmlCheckBox.getSelection());
            }
        };
    }

    private SelectionListener buildRestoreDefaultsSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (TablesSelectorWizardPage.this.customizer != null && TablesSelectorWizardPage.this.customizer.getFile() != null) {
                    if (TablesSelectorWizardPage.this.customizer.getFile().exists()) {
                        TablesSelectorWizardPage.this.customizer.getFile().delete();
                    }
                    TablesSelectorWizardPage.this.deselectAllTables();
                    TablesSelectorWizardPage.this.restoreUpdatePersistenceXmlDefault();
                }
            }
        };
    }

    private SelectionListener buildSelectAllSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TablesSelectorWizardPage.this.selectAllTables();
            }
        };
    }

    private SelectionListener buildDeselectAllSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TablesSelectorWizardPage.this.deselectAllTables();
            }
        };
    }

    private SelectionListener buildRefreshTablesSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TablesSelectorWizardPage.this.refreshTables();
            }
        };
    }

    private void editEntityNameIfPossible() {
        Object[] selected = ((IStructuredSelection)this.tableTable.getSelection()).toArray();
        if (selected.length != 1) {
            return;
        }
    }

    private Collection<org.eclipse.jpt.jpa.db.Table> getSelectedTables() {
        ArrayList<org.eclipse.jpt.jpa.db.Table> selectedTables = new ArrayList<org.eclipse.jpt.jpa.db.Table>();
        Object[] objectArray = this.tableTable.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedTable = objectArray[n2];
            selectedTables.add((org.eclipse.jpt.jpa.db.Table)selectedTable);
            ++n2;
        }
        return selectedTables;
    }

    private boolean hasTablesSelected() {
        return this.tableTable != null ? this.getSelectedTables().size() > 0 : false;
    }

    private void updateTablesListViewer(Collection<org.eclipse.jpt.jpa.db.Table> possibleTables) {
        if (this.tableTable != null) {
            this.initTablesSelectionControl(possibleTables);
        }
    }

    private boolean tableInitialized() {
        return this.tableTable != null && this.tableTable.getTable().getItemCount() > 0;
    }

    private boolean fetchTablesJobIsRunning() {
        return this.fetchTablesJob != null;
    }

    private WorkspaceJob buildFetchTablesJob(final Schema schema) {
        final ArrayList tables = new ArrayList();
        WorkspaceJob workspaceJob = new WorkspaceJob(JptUiEntityGenMessages.GenerateEntitiesWizard_tableSelectPage_getTables_jobName){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)JptUiEntityGenMessages.GenerateEntitiesWizard_tableSelectPage_getTables_taskName, (int)75);
                try {
                    try {
                        subMonitor.beginTask(schema.getContainer().getName(), 100);
                        subMonitor.subTask(NLS.bind((String)JptUiEntityGenMessages.GenerateEntitiesWizard_tableSelectPage_getTables_subTaskName, (Object)schema.getName()));
                        subMonitor.worked(20);
                        tables.addAll(CollectionTools.collection((Iterable)schema.getTables()));
                        subMonitor.worked(95);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        subMonitor.done();
                        return iStatus;
                    }
                }
                finally {
                    subMonitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        workspaceJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                SWTUtil.asyncExec((Runnable)new Runnable(){

                    public void run() {
                        TablesSelectorWizardPage.this.updateTablesListViewer(tables);
                    }
                });
                event.getJob().removeJobChangeListener((IJobChangeListener)this);
                TablesSelectorWizardPage.this.fetchTablesJob = null;
            }
        });
        return workspaceJob;
    }

    private void doStatusUpdate() {
        if (!this.hasTablesSelected()) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(JptUiEntityGenMessages.GenerateEntitiesWizard_tableSelectPage_statusUpdate_taskName, 10);
                        Collection ret = TablesSelectorWizardPage.this.getSelectedTables();
                        ArrayList<String> tableNames = new ArrayList<String>();
                        for (org.eclipse.jpt.jpa.db.Table t : ret) {
                            tableNames.add(t.getName());
                        }
                        Schema schema = TablesSelectorWizardPage.this.getSchema();
                        if (schema == null) {
                            return;
                        }
                        TablesSelectorWizardPage.this.customizer.setSchema(schema);
                        TablesSelectorWizardPage.this.customizer.setTableNames(tableNames);
                        TablesSelectorWizardPage.this.customizer.setUpdatePersistenceXml(TablesSelectorWizardPage.this.updatePersistenceXml);
                        monitor.done();
                    }
                });
            }
            catch (Exception e) {
                JptJpaUiPlugin.log(e);
            }
        }
    }

    private void updateSelectionState(Schema schema) {
        if (schema == null) {
            return;
        }
        this.jpaProject.setUserOverrideDefaultSchema(schema.getIdentifier());
        if (!this.fetchTablesJobIsRunning() && !this.tableInitialized()) {
            this.fetchTablesJob = this.buildFetchTablesJob(schema);
            this.fetchTablesJob.schedule();
        } else {
            this.updateTablesListViewer(this.getTables(schema));
        }
        GenerateEntitiesFromSchemaWizard wizard = (GenerateEntitiesFromSchemaWizard)this.getWizard();
        this.customizer = wizard.createORMGenCustomizer(schema);
        if (this.tableTable != null && this.customizer != null) {
            this.restoreWizardState();
        }
        this.doStatusUpdate();
    }

    private boolean restoreWizardState() {
        List preSelectedTableNames;
        boolean pageComplete = false;
        if (this.updatePersistenceXmlCheckBox != null) {
            this.updatePersistenceXmlCheckBox.setSelection(this.customizer.updatePersistenceXml());
        }
        if ((preSelectedTableNames = this.customizer.getTableNames()) != null && preSelectedTableNames.size() > 0) {
            HashSet<String> set = new HashSet<String>();
            for (String s : preSelectedTableNames) {
                set.add(s);
            }
            TableItem[] items = this.tableTable.getTable().getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                org.eclipse.jpt.jpa.db.Table element = (org.eclipse.jpt.jpa.db.Table)item.getData();
                if (element != null) {
                    boolean check = set.contains(element.getName());
                    if (item.getChecked() != check) {
                        item.setChecked(check);
                        pageComplete = true;
                    }
                }
                ++i;
            }
        }
        return pageComplete;
    }

    private class TableTableContentProvider
    implements IStructuredContentProvider {
        TableTableContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }
    }

    private class TableTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableTableLabelProvider() {
        }

        public String getText(Object element) {
            return ((org.eclipse.jpt.jpa.db.Table)element).getName();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return ((org.eclipse.jpt.jpa.db.Table)element).getName();
                }
            }
            throw new IllegalArgumentException("invalid column index: " + columnIndex);
        }
    }
}

